/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.attdata.impl.AttRecordSummaryPrintServiceImpl;
import kd.wtc.wtis.business.attdata.service.IAttRecordPrintService;
import kd.wtc.wtis.business.web.helper.BizDataFailStatusEnum;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.enums.AttDataTypeEnum;
import kd.wtc.wtis.enums.AttFileBaseStatusEnum;
import kd.wtc.wtis.enums.IntegrStatusEnum;
import kd.wtc.wtis.enums.WithDrawResultEnum;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AttRecordPushPrintServiceImpl
implements IAttRecordPrintService {
    private static final Log LOG = LogFactory.getLog(AttRecordSummaryPrintServiceImpl.class);
    private static final String PRINT_DATA = WTCAppContextHelper.getProjectParams().getString("kd.wtc.wtis.fromplugin.web.integration.attdatadetaillist.printdata", "");

    @Override
    public boolean suppose(String matchStr) {
        return WTCStringUtils.equals((String)matchStr, (String)"1");
    }

    @Override
    public void print(File file, List<String> nameList, List<Long> attItemIdList, IFormView formView) {
        Throwable throwable;
        Throwable throwable2;
        File resultFile = this.createTempFile();
        this.writeEmpty(file);
        try {
            throwable2 = null;
            try (SXSSFWorkbook wb = new SXSSFWorkbook();){
                throwable = null;
                try (FileOutputStream out = new FileOutputStream(resultFile);){
                    long startTime = System.currentTimeMillis();
                    SXSSFSheet sheet = wb.createSheet();
                    long dataDealEndTime = System.currentTimeMillis();
                    LOG.info("AttDataDetList.afterExportFile.getAttFileItemCountValues cost time:{}", (Object)(dataDealEndTime - startTime));
                    this.builtSheet(wb, (Sheet)sheet, attItemIdList, formView);
                    long endPackageTime = System.currentTimeMillis();
                    LOG.info("AttDataDetList.afterExportFile.packageItemValue2Excel cost time:{}", (Object)(endPackageTime - dataDealEndTime));
                    wb.write((OutputStream)out);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable out) {
                throwable2 = out;
                throw out;
            }
        }
        catch (Exception exception) {
            LOG.warn(" AttDataList_export_file_warn:{}", (Object)exception.getMessage());
        }
        if (resultFile != null) {
            try {
                throwable2 = null;
                try (FileChannel fileChannel = FileChannel.open(Paths.get(file.toURI()), StandardOpenOption.WRITE);){
                    throwable = null;
                    try (FileChannel tempFileChannel = FileChannel.open(Paths.get(resultFile.toURI()), StandardOpenOption.READ);){
                        tempFileChannel.transferTo(0L, tempFileChannel.size(), fileChannel);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (Exception exception) {
                LOG.warn("fileChannel copy file_warn:{}", (Object)exception.getMessage());
            }
        }
    }

    @Override
    public void setFileName(BeforeExportFileEvent env, String taskNumber) {
        env.setFileName(IntegrationKDString.exportPushName((String)taskNumber));
    }

    private File createTempFile() {
        File resultFile = null;
        try {
            resultFile = File.createTempFile("temp", "xlsx", null);
        }
        catch (IOException e) {
            LOG.warn(" create temp file warn ", (Throwable)e);
        }
        return resultFile;
    }

    private void writeEmpty(File file) {
        try (FileWriter out = new FileWriter(file);){
            out.write("");
        }
        catch (Exception exception) {
            LOG.warn("writeempty_warn:{}", (Object)exception.getMessage());
        }
    }

    private void builtSheet(SXSSFWorkbook wb, Sheet sheet, List<Long> attItemIds, IFormView iFormView) {
        CellStyle topRowCellStyle = wb.createCellStyle();
        this.setTopCellStype(topRowCellStyle);
        this.builtTopRow(sheet, topRowCellStyle);
        this.getDetailData(attItemIds, wb, sheet, iFormView);
    }

    private void setTopCellStype(CellStyle topCellStyle) {
        topCellStyle.setFillBackgroundColor(IndexedColors.AUTOMATIC.getIndex());
        topCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        topCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        topCellStyle.setLocked(true);
        topCellStyle.setAlignment(HorizontalAlignment.GENERAL);
        topCellStyle.setBorderBottom(BorderStyle.NONE);
        topCellStyle.setBorderLeft(BorderStyle.NONE);
        topCellStyle.setBorderRight(BorderStyle.NONE);
        topCellStyle.setBorderTop(BorderStyle.NONE);
        topCellStyle.setBottomBorderColor((short)8);
        topCellStyle.setIndention((short)0);
        topCellStyle.setLeftBorderColor((short)8);
        topCellStyle.setQuotePrefixed(false);
        topCellStyle.setRightBorderColor((short)8);
        topCellStyle.setRotation((short)0);
        topCellStyle.setShrinkToFit(false);
        topCellStyle.setTopBorderColor((short)8);
        topCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        topCellStyle.setWrapText(false);
    }

    private void createCellByType(Object value, Cell cell, CellStyle dateCellStyle) {
        if (value instanceof Date) {
            cell.setCellStyle(dateCellStyle);
            cell.setCellValue((Date)value);
        } else if (value instanceof Double || value instanceof Float) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value != null) {
            cell.setCellValue(value.toString());
        }
    }

    private void builtTopRow(Sheet sheet, CellStyle topCellStyle) {
        Map<String, Tuple<String, String>> KEY_MAP = this.getKeyMap();
        Row topRow = sheet.createRow(0);
        for (Map.Entry<String, Tuple<String, String>> entry : KEY_MAP.entrySet()) {
            String title = (String)entry.getValue().getValue();
            int cellNum = Integer.parseInt((String)entry.getValue().getKey());
            Cell valueCell = topRow.createCell(cellNum, CellType.STRING);
            valueCell.setCellValue(title);
            valueCell.setCellStyle(topCellStyle);
        }
        KEY_MAP.forEach((key, value) -> sheet.setColumnWidth(Integer.parseInt((String)value.getKey()), 5000));
        sheet.setColumnWidth(Integer.parseInt((String)KEY_MAP.get("abnreason").getKey()), 10000);
        sheet.setColumnWidth(Integer.parseInt((String)KEY_MAP.get("withdrawexinfo").getKey()), 10000);
    }

    private void getDetailData(List<Long> attItemIds, SXSSFWorkbook wb, Sheet sheet, IFormView iFormView) {
        List ids = (List)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("exportidlist"), List.class);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        HRBaseServiceHelper attDataDetServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter taskdetail = new QFilter("id", "in", (Object)ids);
        DynamicObject[] detailObject = attDataDetServiceHelper.queryOriginalArray("withdrawresult,withdrawexinfo,id", new QFilter[]{taskdetail});
        Map<Object, Object> deatilMap = Maps.newHashMapWithExpectedSize((int)16);
        if (detailObject != null && detailObject.length != 0) {
            deatilMap = Arrays.asList(detailObject).stream().collect(Collectors.groupingBy(ob -> ob.getLong("id")));
        }
        int maxValue = 1000;
        int size = ids.size();
        int num = 0;
        for (int index = 0; index < size; index += maxValue) {
            int end = index + maxValue;
            int limit = maxValue;
            if (end > size) {
                limit = maxValue - (end - size);
            }
            List<Long> detailIds = ids.stream().skip(index).limit(limit).collect(Collectors.toList());
            num = this.getPayAttDataInfo(detailIds, attItemIds, num, wb, sheet, deatilMap);
        }
    }

    private int getPayAttDataInfo(List<Long> detailIds, List<Long> attItemIds, int index, SXSSFWorkbook wb, Sheet sheet, Map<Long, List<DynamicObject>> deatilMap) {
        Map<String, Tuple<String, String>> KEY_MAP = this.getKeyMap();
        QFilter qFilter = new QFilter("taskdetail", "in", detailIds);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = HRAuthService.getInstance().getDataRule(Long.valueOf(currUserId), "wtis", "wtis_payattdatainfo", "attfile.org", "47150e89000000ac", Collections.emptyMap());
        qFilter.and(dataQFilter);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
        HashSet queryPoop = Sets.newHashSetWithExpectedSize((int)16);
        queryPoop.add("attperiodentry.name");
        queryPoop.addAll(KEY_MAP.keySet());
        queryPoop.add("taskdetail.id");
        queryPoop.remove("withdrawresult");
        queryPoop.remove("withdrawexinfo");
        DynamicObject[] queryDynObj = hrBaseServiceHelper.query(String.join((CharSequence)",", queryPoop), new QFilter[]{qFilter});
        if (queryDynObj == null || queryDynObj.length == 0) {
            return 0;
        }
        CellStyle dateCellStyle = wb.createCellStyle();
        CreationHelper createHelper = wb.getCreationHelper();
        dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd"));
        for (DynamicObject dynamicObject : queryDynObj) {
            Long attitemId = dynamicObject.getLong("attitem.id");
            if (!attItemIds.contains(attitemId)) continue;
            Long taskDetailId = dynamicObject.getLong("taskdetail.id");
            List<DynamicObject> detailObjectList = WTCCollections.isNotEmpty(deatilMap) ? deatilMap.get(taskDetailId) : Collections.EMPTY_LIST;
            Row row = sheet.createRow(index + 1);
            for (Map.Entry<String, Tuple<String, String>> entry : KEY_MAP.entrySet()) {
                String title = entry.getKey();
                int cellNum = Integer.parseInt((String)KEY_MAP.get(title).getKey());
                Cell cell = row.createCell(cellNum);
                Object value = this.getColumnValue(title, dynamicObject, detailObjectList);
                this.createCellByType(value, cell, dateCellStyle);
            }
            ++index;
        }
        return index;
    }

    private Object getColumnValue(String title, DynamicObject dynamicObject, List<DynamicObject> detailObjectList) {
        Object value = null;
        switch (title) {
            case "integrstatus": {
                value = IntegrStatusEnum.getDesc((String)dynamicObject.getString(title));
                break;
            }
            case "withdrawresult": {
                DynamicObject detail;
                if (!WTCCollections.isNotEmpty(detailObjectList) || (detail = detailObjectList.get(0)) == null) break;
                value = WithDrawResultEnum.getDesc((String)detail.getString("withdrawresult"));
                break;
            }
            case "withdrawexinfo": {
                value = this.getWithDrawReason(detailObjectList);
                break;
            }
            case "datasource": {
                value = AttDataTypeEnum.getDesc((String)dynamicObject.getString(title));
                break;
            }
            case "abnreason": {
                String attPeriodEntryName = dynamicObject.getString("attperiodentry.name");
                value = BizDataFailStatusEnum.getDesc(dynamicObject.getString(title), attPeriodEntryName);
                break;
            }
            case "attfile.usablestatus": {
                value = AttFileBaseStatusEnum.getDesc((String)dynamicObject.getString(title));
                break;
            }
            default: {
                value = dynamicObject.get(title);
            }
        }
        return value;
    }

    private Object getWithDrawReason(List<DynamicObject> detailObjectList) {
        String value = null;
        if (WTCCollections.isNotEmpty(detailObjectList)) {
            DynamicObject detail = detailObjectList.get(0);
            if (detail == null) {
                return value;
            }
            String withDrawReason = detail.getString("withdrawexinfo");
            if (WTCStringUtils.isEmpty((String)withDrawReason)) {
                return value;
            }
            String[] splits = WTCStringUtils.split((String)withDrawReason, (String)",");
            ArrayList reasonValueList = Lists.newArrayListWithExpectedSize((int)16);
            for (String str : splits) {
                reasonValueList.add(BizDataFailStatusEnum.getDesc(str) + WTCSymbolMultiLanguageUtil.getStopSymbol());
            }
            value = WTCStringUtils.join((List)reasonValueList, (String)"\r\n");
        }
        return value;
    }

    private Map<String, Tuple<String, String>> getKeyMap() {
        HashMap KEY_MAP = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)PRINT_DATA)) {
            KEY_MAP.put("integrstatus", new Tuple((Object)"0", (Object)ResManager.loadKDString((String)"\u63a8\u9001\u72b6\u6001", (String)"AttDataDetailList_0", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.number", new Tuple((Object)"1", (Object)ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"AttDataDetailList_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.attperson.number", new Tuple((Object)"2", (Object)ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AttDataDetailList_2", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.attperson.name", new Tuple((Object)"3", (Object)ResManager.loadKDString((String)"\u59d3\u540d", (String)"AttDataDetailList_3", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("datasource", new Tuple((Object)"4", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90", (String)"AttDataDetailList_4", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("owndate", new Tuple((Object)"5", (Object)ResManager.loadKDString((String)"\u5f52\u5c5e\u65e5\u671f", (String)"AttDataDetailList_5", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("perperiodbegindate", new Tuple((Object)"6", (Object)ResManager.loadKDString((String)"\u6c47\u603b\u5f00\u59cb\u65e5\u671f", (String)"AttDataDetailList_6", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("perperiodenddate", new Tuple((Object)"7", (Object)ResManager.loadKDString((String)"\u6c47\u603b\u7ed3\u675f\u65e5\u671f", (String)"AttDataDetailList_7", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attitem.name", new Tuple((Object)"8", (Object)ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"AttDataDetailList_8", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("valuestr", new Tuple((Object)"9", (Object)ResManager.loadKDString((String)"\u9879\u76ee\u503c", (String)"AttDataDetailList_9", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.adminorg.name", new Tuple((Object)"10", (Object)ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AttDataDetailList_10", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.org.name", new Tuple((Object)"11", (Object)ResManager.loadKDString((String)"\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7", (String)"AttDataDetailList_11", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.affiliateadminorg.name", new Tuple((Object)"12", (Object)ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"AttDataDetailList_12", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.dependency.name", new Tuple((Object)"13", (Object)ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"AttDataDetailList_13", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.dependencytype.name", new Tuple((Object)"14", (Object)ResManager.loadKDString((String)"\u5c5e\u5730\u5458\u5de5\u7c7b\u522b", (String)"AttDataDetailList_14", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.empgroup.name", new Tuple((Object)"15", (Object)ResManager.loadKDString((String)"\u8003\u52e4\u4eba\u5458\u7ec4", (String)"AttDataDetailList_15", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.workplace.name", new Tuple((Object)"16", (Object)ResManager.loadKDString((String)"\u8003\u52e4\u5730\u70b9", (String)"AttDataDetailList_16", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.position.name", new Tuple((Object)"17", (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"AttDataDetailList_17", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("attfile.usablestatus", new Tuple((Object)"18", (Object)ResManager.loadKDString((String)"\u6863\u6848\u72b6\u6001", (String)"AttDataDetailList_19", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("abnreason", new Tuple((Object)"19", (Object)ResManager.loadKDString((String)"\u5f02\u5e38\u539f\u56e0", (String)"AttDataDetailList_18", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("withdrawresult", new Tuple((Object)"20", (Object)ResManager.loadKDString((String)"\u64a4\u56de\u7ed3\u679c", (String)"AttDataDetailList_21", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
            KEY_MAP.put("withdrawexinfo", new Tuple((Object)"21", (Object)ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\u539f\u56e0", (String)"AttDataDetailList_22", (String)"wtc-wtis-fromplugin", (Object[])new Object[0])));
        } else {
            KEY_MAP.putAll((Map)JSON.parseObject((String)PRINT_DATA, (TypeReference)new TypeReference<Map<String, Tuple<String, String>>>(){}, (Feature[])new Feature[0]));
        }
        return KEY_MAP;
    }
}

