/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.business.attdata.service.IAttRecordService;
import kd.wtc.wtis.common.model.AttDetailsDto;
import kd.wtc.wtis.enums.AttDataTypeEnum;

public class AttRecordServiceImpl
implements IAttRecordService {
    private static final String SELECTS_RECORD_DETAIL = "id,attmain,  attitemid, valuelong as value, attitemid.dataaccuracy as dataaccuracy, attitemid.precisiontail as precisiontail ";
    private static final String SELECTS_RECORD_BASE = "id as attmain,personid, owndate,perperiodenddate,   perperiodbegindate, attfilevid,   attfileid ";
    private static final String SELECTS_TOTAL_DETAIL = "id,  attmain,  valuelong as value, attitemid,   attitemid.dataaccuracy as dataaccuracy, attitemid.precisiontail as precisiontail";
    private static final String SELECTS_TOTAL_BASE = "id as attmain,personid,  attperattperiodpk,  perperiodenddate,   perperiodbegindate, attfilevid,  attfileid  ";
    private Set<Long> attFileBoIds;
    private List<Long> attItemsIds;
    private Long periodId;
    private Date periodStartDate;
    private Date periodEndDate;

    public AttRecordServiceImpl(Set<Long> attFileBoIds, List<Long> attItemsIds, Long periodId, Date periodStartDate, Date periodEndDate) {
        this.attFileBoIds = attFileBoIds;
        this.attItemsIds = attItemsIds;
        this.periodId = periodId;
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
    }

    @Override
    public List<AttDetailsDto> getAttRecordData() {
        return this.queryAttRecordData();
    }

    @Override
    public List<AttDetailsDto> getAttPeriodSumData() {
        return this.queryAttTotalData();
    }

    public List<AttDetailsDto> queryAttRecordData() {
        HRBaseServiceHelper mainServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        QFilter[] baseQFilter = this.genAttRecordBaseFilter().toArray(new QFilter[0]);
        DataSet dataSetBase = mainServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet_main", SELECTS_RECORD_BASE, baseQFilter);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        DataSet copy = dataSetBase.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("attmain"));
        }
        List<QFilter> detailFilter = this.genAttRecordDetailFilter();
        detailFilter.add(new QFilter("attmain", "in", (Object)ids));
        HRBaseServiceHelper detailServiceHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        DataSet dataSetDetail = detailServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet_detail", SELECTS_RECORD_DETAIL, detailFilter.toArray(new QFilter[0]));
        JoinDataSet join = dataSetBase.join(dataSetDetail);
        join.on("attmain", "attmain");
        ArrayList<String> leftList = new ArrayList<String>(Arrays.asList(this.getRowMetaStr(dataSetBase).split(",")));
        ArrayList<String> rightList = new ArrayList<String>(Arrays.asList(this.getRowMetaStr(dataSetDetail).split(",")));
        rightList.removeAll(leftList);
        join.select(leftList.toArray(new String[0]), rightList.toArray(new String[0]));
        return this.transferData(join.finish(), false);
    }

    private List<AttDetailsDto> queryAttTotalData() {
        HRBaseServiceHelper mainServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        QFilter[] baseQFilter = this.genAttTotalBaseFilter().toArray(new QFilter[0]);
        DataSet dataSetBase = mainServiceHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal_main", SELECTS_TOTAL_BASE, baseQFilter);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        DataSet copy = dataSetBase.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("attmain"));
        }
        List<QFilter> detailFilter = this.genAttTotalDetailFilter();
        detailFilter.add(new QFilter("attmain", "in", (Object)ids));
        HRBaseServiceHelper detailServiceHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        DataSet dataSetDetail = detailServiceHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal_detail", SELECTS_TOTAL_DETAIL, detailFilter.toArray(new QFilter[0]));
        JoinDataSet join = dataSetBase.join(dataSetDetail);
        join.on("attmain", "attmain");
        ArrayList<String> leftList = new ArrayList<String>(Arrays.asList(this.getRowMetaStr(dataSetBase).split(",")));
        ArrayList<String> rightList = new ArrayList<String>(Arrays.asList(this.getRowMetaStr(dataSetDetail).split(",")));
        rightList.removeAll(leftList);
        join.select(leftList.toArray(new String[0]), rightList.toArray(new String[0]));
        return this.transferData(join.finish(), true);
    }

    private List<AttDetailsDto> transferData(DataSet recordSet, boolean isSum) {
        ArrayList respModelList = Lists.newArrayListWithExpectedSize((int)100);
        while (recordSet.hasNext()) {
            Row rs = recordSet.next();
            AttDetailsDto attDetailsDto = new AttDetailsDto();
            attDetailsDto.setAttFileBoId(rs.getLong("attfileid"));
            attDetailsDto.setAttFileId(rs.getLong("attfilevid"));
            attDetailsDto.setAttItemId(rs.getLong("attitemid"));
            attDetailsDto.setValue(rs.getBigDecimal("value"));
            attDetailsDto.setDataAccuracy(rs.getInteger("dataaccuracy"));
            attDetailsDto.setPrecisionTail(rs.getString("precisiontail"));
            if (isSum) {
                attDetailsDto.setSumBeginDate(rs.getDate("perperiodbegindate"));
                attDetailsDto.setSumEndDate(rs.getDate("perperiodenddate"));
                attDetailsDto.setDataType(AttDataTypeEnum.ATT_PERIOD_SUM.getCode());
                attDetailsDto.setAttPerAttPeriodPk(rs.getLong("attperattperiodpk"));
            } else {
                attDetailsDto.setOwnDate(rs.getDate("owndate"));
                attDetailsDto.setDataType(AttDataTypeEnum.ATT_RECORD.getCode());
            }
            respModelList.add(attDetailsDto);
        }
        return respModelList;
    }

    private String getRowMetaStr(DataSet dataSet) {
        return dataSet.getRowMeta().toString().replace("RowMeta[", "").replace("]", "").replace(" ", "");
    }

    private List<QFilter> genAttRecordDetailFilter() {
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("attitemid", "in", this.getAttItemsIds()), new QFilter("owndate", ">=", (Object)this.getPeriodStartDate()), new QFilter("owndate", "<=", (Object)this.getPeriodEndDate())});
    }

    private List<QFilter> genAttRecordBaseFilter() {
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("perattperiodid", "=", (Object)this.getPeriodId()), new QFilter("attfileid", "in", this.getAttFileBoIds()), new QFilter("owndate", ">=", (Object)this.getPeriodStartDate()), new QFilter("owndate", "<=", (Object)this.getPeriodEndDate())});
    }

    private List<QFilter> genAttTotalDetailFilter() {
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("attitemid", "in", this.getAttItemsIds()), new QFilter("perattperiodid", "=", (Object)this.getPeriodId())});
    }

    private List<QFilter> genAttTotalBaseFilter() {
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("perattperiodid", "=", (Object)this.getPeriodId()), new QFilter("attfileid", "in", this.getAttFileBoIds())});
    }

    public Set<Long> getAttFileBoIds() {
        return this.attFileBoIds;
    }

    public List<Long> getAttItemsIds() {
        return this.attItemsIds;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public Date getPeriodStartDate() {
        return this.periodStartDate;
    }

    public Date getPeriodEndDate() {
        return this.periodEndDate;
    }
}

