/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.business.attdata.service.IAttRecordPrintService;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AttRecordSummaryPrintServiceImpl
implements IAttRecordPrintService {
    private static final Log LOG = LogFactory.getLog(AttRecordSummaryPrintServiceImpl.class);

    @Override
    public boolean suppose(String matchStr) {
        return WTCStringUtils.isEmpty((String)matchStr);
    }

    @Override
    public void print(File file, List<String> nameList, List<Long> attItemIdList, IFormView formView) {
        Throwable throwable;
        Throwable throwable2;
        List<List<String>> rowList = this.getExcelDate(file);
        File resultFile = this.createTempFile();
        this.writeEmpty(file);
        try {
            throwable2 = null;
            try (SXSSFWorkbook wb = new SXSSFWorkbook();){
                throwable = null;
                try (FileOutputStream out = new FileOutputStream(resultFile);){
                    long startTime = System.currentTimeMillis();
                    long dataDealEndTime = System.currentTimeMillis();
                    LOG.info("AttDataDetList.afterExportFile.getAttFileItemCountValues cost time:{}", (Object)(dataDealEndTime - startTime));
                    Map<String, List<String>> attFileItemCountValues = this.getAttFileItemCountValues(attItemIdList, formView);
                    this.packageItemValue2Excel(wb, nameList, attFileItemCountValues, rowList);
                    long endPackageTime = System.currentTimeMillis();
                    LOG.info("AttDataDetList.afterExportFile.packageItemValue2Excel cost time:{}", (Object)(endPackageTime - dataDealEndTime));
                    wb.write((OutputStream)out);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable out) {
                throwable2 = out;
                throw out;
            }
        }
        catch (Exception exception) {
            LOG.warn(" AttDataList_export_file_warn:{}", (Object)exception.getMessage());
        }
        if (resultFile != null) {
            try {
                throwable2 = null;
                try (FileChannel fileChannel = FileChannel.open(Paths.get(file.toURI()), StandardOpenOption.WRITE);){
                    throwable = null;
                    try (FileChannel tempFileChannel = FileChannel.open(Paths.get(resultFile.toURI()), StandardOpenOption.READ);){
                        tempFileChannel.transferTo(0L, tempFileChannel.size(), fileChannel);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (Exception exception) {
                LOG.warn("fileChannel copy file_warn:{}", (Object)exception.getMessage());
            }
        }
    }

    private List<List<String>> getExcelDate(File file) {
        ArrayList rowList = Lists.newArrayListWithExpectedSize((int)100);
        try (FileInputStream fis = new FileInputStream(file);
             SXSSFWorkbook wb = new SXSSFWorkbook(new XSSFWorkbook((InputStream)fis));){
            XSSFSheet sheet = wb.getXSSFWorkbook().getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            for (int rowIndex = 0; rowIndex <= lastRowNum; ++rowIndex) {
                ArrayList cellList = Lists.newArrayListWithExpectedSize((int)100);
                Row row = sheet.getRow(rowIndex);
                int lastCellNum = row.getLastCellNum();
                for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
                    Cell object = row.getCell(cellIndex, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    cellList.add(object == null ? "" : row.getCell(cellIndex, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL).getStringCellValue());
                }
                rowList.add(cellList);
            }
        }
        catch (Exception exception) {
            LOG.warn(" read export file warn:{}", (Object)exception.getMessage());
        }
        return rowList;
    }

    @Override
    public void setFileName(BeforeExportFileEvent env, String taskNumber) {
        env.setFileName(IntegrationKDString.exportName((String)taskNumber));
    }

    private File createTempFile() {
        File resultFile = null;
        try {
            resultFile = File.createTempFile("temp", "xlsx", null);
        }
        catch (IOException e) {
            LOG.warn(" create temp file warn ", (Throwable)e);
        }
        return resultFile;
    }

    private void writeEmpty(File file) {
        try (FileWriter out = new FileWriter(file);){
            out.write("");
        }
        catch (Exception exception) {
            LOG.warn("writeempty_warn:{}", (Object)exception.getMessage());
        }
    }

    private Map<String, List<String>> getAttFileItemCountValues(List<Long> attItemIds, IFormView formView) {
        List ids = (List)SerializationUtils.fromJsonString((String)formView.getPageCache().get("exportidlist"), List.class);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] attFileDyns = helper.query("attfileboid,attfile,generstatus", new QFilter[]{new QFilter("id", "in", (Object)ids)});
        List successData = Arrays.stream(attFileDyns).filter(dyn -> HRStringUtils.equals((String)dyn.getString("generstatus"), (String)"1")).collect(Collectors.toList());
        if (successData.isEmpty()) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)successData.size());
        int maxValue = 5000;
        int size = successData.size();
        for (int index = 0; index < size; index += maxValue) {
            List<DynamicObject> consumerList;
            Map<String, List<String>> numberToAttItem;
            int end = index + maxValue;
            int limit = maxValue;
            if (end > size) {
                limit = maxValue - (end - size);
            }
            if ((numberToAttItem = this.getNumberToAttItem(consumerList = successData.stream().skip(index).limit(limit).collect(Collectors.toList()), attItemIds, formView)).isEmpty()) continue;
            result.putAll(numberToAttItem);
        }
        return result;
    }

    private Map<String, List<String>> getNumberToAttItem(List<DynamicObject> sucessfulData, List<Long> attItemIds, IFormView iFormView) {
        Map<Long, String> id2Numbers = sucessfulData.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attfileboid.boid"), Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getString("attfileboid.number") : null)));
        ArrayList<Long> values = new ArrayList<Long>(id2Numbers.keySet());
        FormShowParameter formShowParameter = iFormView.getFormShowParameter();
        List detailIds = (List)formShowParameter.getCustomParam("detailIds");
        QFilter qFilter = new QFilter("taskdetail", "in", (Object)detailIds);
        qFilter.and(new QFilter("attfilebase", "in", values));
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = HRAuthService.getInstance().getDataRule(Long.valueOf(currUserId), "wtis", "wtis_payattdatainfo", "attfile.org", "47150e89000000ac", Collections.emptyMap());
        qFilter.and(dataQFilter);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
        DynamicObject[] queryDynObj = hrBaseServiceHelper.query("attfilebase,attfile,attitem,value,valuestr", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> id2Attitems = Arrays.stream(queryDynObj).collect(Collectors.groupingBy(dyn -> dyn.getLong("attfilebase.boid")));
        HashMap res = Maps.newHashMapWithExpectedSize((int)values.size());
        for (int i = 0; i < values.size(); ++i) {
            List<DynamicObject> attfiles = id2Attitems.get(values.get(i));
            if (attfiles == null) continue;
            Map<Long, List<DynamicObject>> attItem2File = attfiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attitem.id")));
            ArrayList itemValues = new ArrayList();
            attItemIds.forEach(id -> {
                List files = (List)attItem2File.get(id);
                if (files != null) {
                    BigDecimal attItemValue = files.stream().filter(file2 -> file2.getLong("attitem.id") == id.longValue()).map(file1 -> file1.getBigDecimal("valuestr")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    itemValues.add(String.valueOf(attItemValue));
                } else {
                    itemValues.add("-");
                }
            });
            res.put(id2Numbers.get(values.get(i)), itemValues);
        }
        return res;
    }

    private void packageItemValue2Excel(SXSSFWorkbook wb, List<String> names, Map<String, List<String>> attFileItemCountValues, List<List<String>> rowList) {
        List<String> title = rowList.get(0);
        title.addAll(names);
        SXSSFSheet sheet = wb.createSheet();
        CellStyle topRowCellStyle = wb.createCellStyle();
        this.setTopCellStype(topRowCellStyle);
        int rowNum = 0;
        for (List<String> valueList : rowList) {
            Row row;
            if (rowNum == 0) {
                row = sheet.createRow(rowNum);
                int valueListNum = 0;
                for (String value : valueList) {
                    Cell cell = row.createCell(valueListNum);
                    cell.setCellStyle(topRowCellStyle);
                    cell.setCellValue(value);
                    sheet.setColumnWidth(valueListNum, 5000);
                    ++valueListNum;
                }
            } else {
                row = sheet.createRow(rowNum);
                String attFileNumber = valueList.get(3);
                List<String> doubles = attFileItemCountValues.get(attFileNumber);
                if (doubles != null) {
                    for (String value : doubles) {
                        valueList.add(value);
                    }
                } else {
                    valueList.add("-");
                }
                int valueListNum = 0;
                for (String value : valueList) {
                    Cell cell = row.createCell(valueListNum);
                    cell.setCellValue(value);
                    ++valueListNum;
                }
            }
            ++rowNum;
        }
    }

    private void setTopCellStype(CellStyle topRowCellStyle) {
        topRowCellStyle.setFillBackgroundColor(IndexedColors.AUTOMATIC.getIndex());
        topRowCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        topRowCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        topRowCellStyle.setLocked(true);
        topRowCellStyle.setAlignment(HorizontalAlignment.GENERAL);
        topRowCellStyle.setBorderBottom(BorderStyle.NONE);
        topRowCellStyle.setBorderLeft(BorderStyle.NONE);
        topRowCellStyle.setBorderRight(BorderStyle.NONE);
        topRowCellStyle.setBorderTop(BorderStyle.NONE);
        topRowCellStyle.setBottomBorderColor((short)8);
        topRowCellStyle.setIndention((short)0);
        topRowCellStyle.setLeftBorderColor((short)8);
        topRowCellStyle.setQuotePrefixed(false);
        topRowCellStyle.setRightBorderColor((short)8);
        topRowCellStyle.setRotation((short)0);
        topRowCellStyle.setShrinkToFit(false);
        topRowCellStyle.setTopBorderColor((short)8);
        topRowCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        topRowCellStyle.setWrapText(false);
    }
}

