/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtis.business.attdata.service.IQTDataService;
import kd.wtc.wtis.common.model.AttDetailsDto;
import kd.wtc.wtis.enums.AttDataTypeEnum;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;

public class QTDataServiceImpl
implements IQTDataService {
    private static final Log log = LogFactory.getLog(QTDataServiceImpl.class);
    public static final String ATT_FILE_SHARD_TASK_PROPERTY = String.join((CharSequence)",", "id", "boid", "atttag.attendstatus");
    private Set<Long> attFileBoIds;
    private List<Long> attItemsIds;
    private Date periodStartDate;
    private Date periodEndDate;
    private static final int batchSize = 50000;

    public QTDataServiceImpl(Set<Long> attFileBoIds, List<Long> attItemsIds, Date periodStartDate, Date periodEndDate) {
        this.attFileBoIds = attFileBoIds;
        this.attItemsIds = attItemsIds;
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
    }

    private static AttDetailsDto parseLine2DepartItem(DynamicObject line, DynamicObject file, DynamicObject item) {
        AttDetailsDto dto = new AttDetailsDto();
        dto.setAttFileId(Long.valueOf(line.getLong("attfileid.id")));
        dto.setAttFileBoId(Long.valueOf(line.getLong("attfilebo.id")));
        dto.setAttendStatus(file.getString("atttag.attendstatus"));
        dto.setAttItemId(Long.valueOf(line.getLong("departvalueid.attitemvid.id")));
        dto.setValue(line.getBigDecimal("departvalueid.attitemvalue"));
        dto.setDataAccuracy(Integer.valueOf(item.getInt("dataaccuracy")));
        dto.setPrecisionTail(item.getString("precisiontail"));
        dto.setDataType(AttDataTypeEnum.QT_RECORD.getCode());
        dto.setOwnDate(line.getDate("departvalueid.vestday"));
        return dto;
    }

    private static AttDetailsDto parseLine2CarryDownItem(DynamicObject line, DynamicObject file, DynamicObject item) {
        AttDetailsDto dto = new AttDetailsDto();
        dto.setAttFileId(Long.valueOf(line.getLong("attfileid.id")));
        dto.setAttFileBoId(Long.valueOf(line.getLong("attfilebo.id")));
        dto.setAttendStatus(file.getString("atttag.attendstatus"));
        dto.setAttItemId(Long.valueOf(line.getLong("cdedvalueid.attitemvid.id")));
        dto.setValue(line.getBigDecimal("cdedvalueid.attitemvalue"));
        dto.setDataAccuracy(Integer.valueOf(item.getInt("dataaccuracy")));
        dto.setPrecisionTail(item.getString("precisiontail"));
        dto.setDataType(AttDataTypeEnum.QT_RECORD.getCode());
        dto.setOwnDate(line.getDate("cdedvalueid.vestday"));
        return dto;
    }

    private static Map<Long, Long> genItemVidToBoIdMap(Set<Long> attItemBoIdSet) {
        DynamicObject[] attItemArr;
        HashMap<Long, Long> attItemMap = new HashMap<Long, Long>(16);
        HRBaseServiceHelper attItemDao = new HRBaseServiceHelper("wtbd_attitem");
        QFilter qFilter = new QFilter("boid", "in", attItemBoIdSet);
        for (DynamicObject attItem : attItemArr = attItemDao.query("id,boid", qFilter.toArray())) {
            attItemMap.put(attItem.getLong("id"), attItem.getLong("boid"));
        }
        return attItemMap;
    }

    @Override
    public List<AttDetailsDto> getQtDataInfo() {
        Map<Long, Long> itemVidToBoIdMap = QTDataServiceImpl.genItemVidToBoIdMap(new HashSet<Long>(this.attItemsIds));
        DynamicObject[] arr = this.queryLineDetailAdjust(itemVidToBoIdMap);
        if (arr.length == 0) {
            return new ArrayList<AttDetailsDto>(16);
        }
        HashSet<Long> fileVidSet = new HashSet<Long>(16);
        HashSet<Long> attItemIdSet = new HashSet<Long>(16);
        for (DynamicObject line : arr) {
            fileVidSet.add(line.getLong("attfileid.id"));
            attItemIdSet.add(line.getLong("departvalueid.attitemvid.id"));
            attItemIdSet.add(line.getLong("cdedvalueid.attitemvid.id"));
        }
        Map<Long, DynamicObject> fileMap = QTDataServiceImpl.queryFile(new ArrayList<Object>(fileVidSet));
        Map<Long, DynamicObject> itemMap = this.queryItem(attItemIdSet);
        fileVidSet = null;
        attItemIdSet = null;
        ArrayList<AttDetailsDto> res = new ArrayList<AttDetailsDto>(16);
        for (DynamicObject line : arr) {
            DynamicObject carryDownItem;
            DynamicObject file = fileMap.get(line.getLong("attfileid.id"));
            if (file == null) {
                log.warn("QTDataServiceImpl getQtDateInfo detected error data, can't find attFile BY VID:{} for qtDetail", (Object)line.getLong("attfileid.id"));
                continue;
            }
            DynamicObject departItem = itemMap.get(line.getLong("departvalueid.attitemvid.id"));
            if (departItem != null) {
                res.add(QTDataServiceImpl.parseLine2DepartItem(line, file, departItem));
            }
            if ((carryDownItem = itemMap.get(line.getLong("cdedvalueid.attitemvid.id"))) == null) continue;
            res.add(QTDataServiceImpl.parseLine2CarryDownItem(line, file, carryDownItem));
        }
        res.stream().forEach(ele -> {
            Long boId = (Long)itemVidToBoIdMap.get(ele.getAttItemId());
            if (boId != null) {
                ele.setAttItemId(boId);
            }
        });
        return res;
    }

    private static Map<Long, DynamicObject> queryFile(List<Object> fileVidSet) {
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>(fileVidSet.size());
        List files = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(ATT_FILE_SHARD_TASK_PROPERTY, fileVidSet);
        for (DynamicObject file : files) {
            res.put(file.getLong("id"), file);
        }
        return res;
    }

    private Map<Long, DynamicObject> queryItem(Collection<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_attitem");
        DynamicObject[] arr = helper.loadDynamicObjectArray(ids.toArray(new Object[0]));
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>(arr.length);
        for (DynamicObject item : arr) {
            res.put(item.getLong("id"), item);
        }
        return res;
    }

    private DynamicObject[] queryLineDetailAdjust(Map<Long, Long> itemVidToBoIdMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbs_taskpara");
        ArrayList<String> categoryList = new ArrayList<String>(16);
        categoryList.add("wtis_attqtdataquery1");
        categoryList.add("wtis_attqtdataquery2");
        DynamicObject[] query = helper.query("category", new QFilter("category", "in", categoryList).toArray());
        if (query.length == 1) {
            return this.queryLineDetailFromDataSetReversal(itemVidToBoIdMap);
        }
        if (query.length == 2) {
            return this.queryLineDetail(itemVidToBoIdMap);
        }
        return this.queryLineDetailFromDataSet(itemVidToBoIdMap);
    }

    private DynamicObject[] queryLineDetail(Map<Long, Long> itemVidToBoIdMap) {
        QFilter boFilter = new QFilter("attfilebo", "in", this.attFileBoIds);
        QFilter departFilter = new QFilter("departvalueid.attitemvid.id", "in", itemVidToBoIdMap.keySet()).and(DateRange.range((Date)this.periodStartDate, (Date)this.periodEndDate).getFilterIntersectionLCRC("departvalueid.vestday", "departvalueid.vestday"));
        QFilter carryDownFilter = new QFilter("cdedvalueid.attitemvid.id", "in", itemVidToBoIdMap.keySet()).and(DateRange.range((Date)this.periodStartDate, (Date)this.periodEndDate).getFilterIntersectionLCRC("cdedvalueid.vestday", "cdedvalueid.vestday"));
        QFilter itemFilter = departFilter.or(carryDownFilter);
        QFilter effectFilter = new QFilter("busstatus", "=", (Object)"0");
        QFilter filter = boFilter.and(itemFilter).and(effectFilter);
        return QTLineDetailDBService.lineDetailDao.loadDynamicObjectArray(filter.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] queryLineDetailFromDataSetReversal(Map<Long, Long> itemVidToBoIdMap) {
        HRBaseServiceHelper itemDetailDao = new HRBaseServiceHelper("wtte_quotadetail");
        HashSet<Long> needQueryLineIdSet = new HashSet<Long>(16);
        try (DataSet itemDataSet = null;){
            QFilter itemDetailIdFilter = new QFilter("attfileid", "in", this.attFileBoIds);
            QFilter itemVidFilter = new QFilter("attitemvid", "in", itemVidToBoIdMap.keySet());
            QFilter dateRangeFilter = DateRange.range((Date)this.periodStartDate, (Date)this.periodEndDate).getFilterIntersectionLCRC("vestday", "vestday");
            itemDataSet = itemDetailDao.queryDataSet("QTDataServiceImpl-queryLineDetailFromDataSetReversal", "id", new QFilter[]{itemDetailIdFilter, itemVidFilter, dateRangeFilter});
            HashSet<Long> itemDetailIdSet = new HashSet<Long>(16);
            while (itemDataSet.hasNext()) {
                Row itemDetail = itemDataSet.next();
                itemDetailIdSet.add(itemDetail.getLong("id"));
                if (itemDetailIdSet.size() < 50000) continue;
                this.diveLineDetail(needQueryLineIdSet, itemDetailIdSet);
            }
            if (!itemDetailIdSet.isEmpty()) {
                this.diveLineDetail(needQueryLineIdSet, itemDetailIdSet);
            }
        }
        if (needQueryLineIdSet.isEmpty()) {
            return new DynamicObject[0];
        }
        String selectKey = "id,attfileid.id,attfilebo.id,departvalueid.attitemvid.id,departvalueid.attitemvalue,departvalueid.vestday,cdedvalueid.attitemvid.id,cdedvalueid.attitemvalue,cdedvalueid.vestday";
        return QTLineDetailDBService.lineDetailDao.query(selectKey, new QFilter("id", "in", needQueryLineIdSet).toArray());
    }

    private void diveLineDetail(Set<Long> needQueryLineIdSet, Set<Long> itemDetailIdSet) {
        DynamicObject[] lineArr;
        QFilter itemExistFilter = new QFilter("departvalueid", "in", itemDetailIdSet).or("cdedvalueid", "in", itemDetailIdSet);
        QFilter effectFilter = new QFilter("busstatus", "=", (Object)"0");
        for (DynamicObject line : lineArr = QTLineDetailDBService.lineDetailDao.query("id", itemExistFilter.and(effectFilter).toArray())) {
            needQueryLineIdSet.add(line.getLong("id"));
        }
        itemDetailIdSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] queryLineDetailFromDataSet(Map<Long, Long> itemVidToBoIdMap) {
        HRBaseServiceHelper itemDetailDao = new HRBaseServiceHelper("wtte_quotadetail");
        HashSet<Long> needQueryLineIdSet = new HashSet<Long>(16);
        try (DataSet lineDetailDataSet = null;){
            QFilter boFilter = new QFilter("attfilebo", "in", this.attFileBoIds);
            QFilter itemExistFilter = new QFilter("departvalueid", "!=", (Object)0L).or("cdedvalueid", "!=", (Object)0L);
            QFilter effectFilter = new QFilter("busstatus", "=", (Object)"0");
            lineDetailDataSet = QTLineDetailDBService.lineDetailDao.queryDataSet("QTDataServiceImpl-queryLineDetailFromDataSet", "id,departvalueid,cdedvalueid", boFilter.and(itemExistFilter).and(effectFilter).toArray());
            HashMap<Long, Long> itemDetailId2LineIdMap = new HashMap<Long, Long>(16);
            while (lineDetailDataSet.hasNext()) {
                Long carryDownedValueId;
                Row line = lineDetailDataSet.next();
                Long lineId = line.getLong("id");
                Long departValueId = line.getLong("departvalueid");
                if (departValueId != null && departValueId != 0L) {
                    itemDetailId2LineIdMap.put(departValueId, lineId);
                }
                if ((carryDownedValueId = line.getLong("cdedvalueid")) != null && carryDownedValueId != 0L) {
                    itemDetailId2LineIdMap.put(carryDownedValueId, lineId);
                }
                if (itemDetailId2LineIdMap.size() < 50000) continue;
                this.diveItemDetail(itemVidToBoIdMap, itemDetailDao, needQueryLineIdSet, itemDetailId2LineIdMap);
            }
            if (!itemDetailId2LineIdMap.isEmpty()) {
                this.diveItemDetail(itemVidToBoIdMap, itemDetailDao, needQueryLineIdSet, itemDetailId2LineIdMap);
            }
        }
        if (needQueryLineIdSet.isEmpty()) {
            return new DynamicObject[0];
        }
        String selectKey = "id,attfileid.id,attfilebo.id,departvalueid.attitemvid.id,departvalueid.attitemvalue,departvalueid.vestday,cdedvalueid.attitemvid.id,cdedvalueid.attitemvalue,cdedvalueid.vestday";
        return QTLineDetailDBService.lineDetailDao.query(selectKey, new QFilter("id", "in", needQueryLineIdSet).toArray());
    }

    private void diveItemDetail(Map<Long, Long> itemVidToBoIdMap, HRBaseServiceHelper itemDetailDao, Set<Long> needQueryLineIdSet, Map<Long, Long> itemDetailId2LineIdMap) {
        DynamicObject[] itemDetailDynArr;
        QFilter itemDetailIdFilter = new QFilter("id", "in", itemDetailId2LineIdMap.keySet());
        QFilter itemVidFilter = new QFilter("attitemvid", "in", itemVidToBoIdMap.keySet());
        QFilter dateRangeFilter = DateRange.range((Date)this.periodStartDate, (Date)this.periodEndDate).getFilterIntersectionLCRC("vestday", "vestday");
        for (DynamicObject itemDetail : itemDetailDynArr = itemDetailDao.query("id", new QFilter[]{itemDetailIdFilter, itemVidFilter, dateRangeFilter})) {
            needQueryLineIdSet.add(itemDetailId2LineIdMap.get(itemDetail.getLong("id")));
        }
        itemDetailId2LineIdMap.clear();
    }
}

