/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodAndStateInfo;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.wtteinfo.AttStateInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.attdata.service.IAttDataGenService;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.common.model.AttDetailsDto;
import kd.wtc.wtis.enums.AttDataTypeEnum;

public abstract class AbsAttDataGenService
implements IAttDataGenService {
    private Map<Long, DynamicObject> attFileAuthMap;
    private List<DynamicObject> attFileAuthList;
    private Map<Long, PerAttPeriodAndStateInfo> perAttPeriodInfoMap;

    protected Map<Long, PerAttPeriodAndStateInfo> getPerAttPeriodInfoMap() {
        if (null == this.perAttPeriodInfoMap) {
            this.perAttPeriodInfoMap = this.queryPerAttPeriodInfoMap();
        }
        return this.perAttPeriodInfoMap;
    }

    protected List<DynamicObject> getAuthAttFileList() {
        if (null == this.attFileAuthList) {
            this.attFileAuthList = this.queryAuthAttFile();
        }
        return this.attFileAuthList;
    }

    protected Set<Long> getDiscardAttFileBoIds() {
        List<DynamicObject> authAttFileList = this.getAuthAttFileList();
        return authAttFileList.stream().filter(attFile -> !WTCStringUtils.equals((String)attFile.getString("usablestatus"), (String)"0")).map(attFile -> attFile.getLong("boid")).collect(Collectors.toSet());
    }

    protected Map<Long, DynamicObject> getAuthAttFileMap() {
        if (null == this.attFileAuthMap) {
            List<DynamicObject> authAttFileList = this.getAuthAttFileList();
            this.attFileAuthMap = authAttFileList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), Function.identity(), (key1, key2) -> key1));
        }
        return this.attFileAuthMap;
    }

    private List<DynamicObject> queryAuthAttFile() {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam(false);
        attFileQueryParam.setSetBoIds(this.getAttFileBoIds());
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setOrgAuthCheck(true);
        attFileQueryParam.setAppId("wtis");
        attFileQueryParam.setFormId("wtis_payattdatainfo");
        attFileQueryParam.setPermField("attfile");
        attFileQueryParam.setStartDate(this.getPeriodStartDate());
        attFileQueryParam.setEndDate(this.getPeriodEndDate());
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        List attFileDyList = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        if (WTCCollections.isNotEmpty((Collection)attFileDyList)) {
            return attFileDyList;
        }
        return Collections.emptyList();
    }

    protected Date getAttFileStartDate(Long attFileVid) {
        DynamicObject attFileInfo = this.getAuthAttFileMap().get(attFileVid);
        if (null == attFileInfo) {
            return this.getPeriodStartDate();
        }
        return attFileInfo.getDate("bsed");
    }

    protected Date getAttFileEndDate(Long attFileVid) {
        DynamicObject attFileInfo = this.getAuthAttFileMap().get(attFileVid);
        if (null == attFileInfo) {
            return this.getPeriodEndDate();
        }
        return WTCDateUtils.getMinDate((Date)attFileInfo.getDate("bsled"), (Date)attFileInfo.getDate("enddate"));
    }

    protected Set<Long> getAuthAttFileBoIds() {
        List<DynamicObject> authAttFileList = this.getAuthAttFileList();
        return authAttFileList.stream().filter(attFile -> WTCStringUtils.equals((String)attFile.getString("usablestatus"), (String)"0")).map(attFile -> attFile.getLong("boid")).collect(Collectors.toSet());
    }

    private Map<Long, PerAttPeriodAndStateInfo> queryPerAttPeriodInfoMap() {
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttFileBoIdSet(this.getAttFileBoIds());
        queryParam.setPeriodIdSet((Set)Sets.newHashSet((Object[])new Long[]{this.getPeriodId()}));
        List listInfo = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodAndStateInfo(queryParam);
        if (WTCCollections.isNotEmpty((Collection)listInfo)) {
            return listInfo.stream().collect(Collectors.toMap(PerAttPeriodAndStateInfo::getAttFileBoID, Function.identity(), (v1, v2) -> v1));
        }
        return Collections.emptyMap();
    }

    protected PerAttPeriodAndStateInfo getPeriodAndStateInfo(Long attFileBoId) {
        return this.getPerAttPeriodInfoMap().get(attFileBoId);
    }

    protected AttStateInfo getTargetPerAttPeriod(List<AttStateInfo> perAttPeriods, Date targetDate) {
        if (WTCCollections.isEmpty(perAttPeriods)) {
            return null;
        }
        for (AttStateInfo attStateInfo : perAttPeriods) {
            PerAttPeriod perAttPeriod = attStateInfo.getPerAttPeriod();
            if (targetDate.getTime() < perAttPeriod.getPerAttBeginDate().getTime() || targetDate.getTime() > perAttPeriod.getPerAttEndDate().getTime()) continue;
            return attStateInfo;
        }
        return null;
    }

    protected AttStateInfo getTargetPerAttPeriod(List<AttStateInfo> perAttPeriods, Long perAttPeriodId) {
        if (WTCCollections.isEmpty(perAttPeriods)) {
            return null;
        }
        for (AttStateInfo attStateInfo : perAttPeriods) {
            PerAttPeriod perAttPeriod = attStateInfo.getPerAttPeriod();
            if (!perAttPeriod.getPrimaryId().equals(perAttPeriodId)) continue;
            return attStateInfo;
        }
        return null;
    }

    protected Long getAttFileId(String key) {
        return Long.valueOf(key.split("-")[0]);
    }

    public abstract Set<Long> getAttFileBoIds();

    public abstract Long getPeriodId();

    public abstract String getAttPeriodName();

    public abstract String getAttItemName();

    public abstract Date getPeriodStartDate();

    public abstract Date getPeriodEndDate();

    protected String allSealError() {
        return IntegrationKDString.allSealError((String)this.getAttPeriodName());
    }

    protected String sealError() {
        return this.allSealError();
    }

    protected String notResultError() {
        return IntegrationKDString.notResultError((String)this.getAttPeriodName());
    }

    protected String attFileDiscardError() {
        return IntegrationKDString.attFileDiscard();
    }

    protected String stopPeriodError() {
        return IntegrationKDString.stopPeriodError((String)this.getAttPeriodName());
    }

    protected String overlapError() {
        return IntegrationKDString.overlapError((String)this.getAttPeriodName(), (String)this.getAttItemName());
    }

    protected BigDecimal scale(BigDecimal sumVal, Integer dataAccuracy, String precisionTail) {
        int precision;
        switch (precisionTail) {
            case "1": {
                precision = 4;
                break;
            }
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
            default: {
                precision = 4;
            }
        }
        return sumVal.setScale((int)dataAccuracy, precision);
    }

    protected List<AttDetailsDto> attFileVIdSumValue(List<AttDetailsDto> attDetails) {
        Map<String, List<AttDetailsDto>> detailGroupMap = attDetails.stream().collect(Collectors.groupingBy(AttDetailsDto::attRecordGroupKey));
        ArrayList sumAttDetail = Lists.newArrayListWithExpectedSize((int)detailGroupMap.size());
        for (Map.Entry<String, List<AttDetailsDto>> entry : detailGroupMap.entrySet()) {
            Long attFileId = this.getAttFileId(entry.getKey());
            List<AttDetailsDto> value = entry.getValue();
            Optional<Date> ownDateOp = value.stream().map(AttDetailsDto::getStorageDate).filter(Objects::nonNull).max(Comparator.comparing(Date::getTime));
            Date storageDate = null;
            if (ownDateOp.isPresent()) {
                storageDate = ownDateOp.get();
            }
            BigDecimal sumVal = BigDecimal.ZERO;
            AttDetailsDto attDetailsDto = value.get(0);
            for (AttDetailsDto dto : value) {
                sumVal = sumVal.add(dto.getValue());
            }
            sumVal = this.scale(sumVal, attDetailsDto.getDataAccuracy(), attDetailsDto.getPrecisionTail());
            attDetailsDto.setValue(sumVal);
            attDetailsDto.setOwnDate(null);
            if (AttDataTypeEnum.QT_RECORD.getCode().equals(attDetailsDto.getDataType())) {
                attDetailsDto.setDataType(AttDataTypeEnum.QT_RECORD_SUM.getCode());
            } else if (AttDataTypeEnum.ATT_RECORD.getCode().equals(attDetailsDto.getDataType())) {
                attDetailsDto.setDataType(AttDataTypeEnum.ATT_RECORD_SUM.getCode());
            }
            Date sumBeginDate = WTCDateUtils.getMaxDate((Date)this.getPeriodStartDate(), (Date)this.getAttFileStartDate(attFileId));
            attDetailsDto.setSumBeginDate(sumBeginDate);
            Date sumEndDate = WTCDateUtils.getMinDate((Date)this.getPeriodEndDate(), (Date)this.getAttFileEndDate(attFileId));
            attDetailsDto.setSumEndDate(sumEndDate);
            attDetailsDto.setStorageDate(storageDate);
            sumAttDetail.add(attDetailsDto);
        }
        return sumAttDetail;
    }

    protected List<AttDetailsDto> periodSumValue(List<AttDetailsDto> attDetails) {
        Map<String, List<AttDetailsDto>> detailGroupMap = attDetails.stream().collect(Collectors.groupingBy(AttDetailsDto::attPeriodSumGroupKey));
        ArrayList sumAttDetail = Lists.newArrayListWithExpectedSize((int)detailGroupMap.size());
        for (Map.Entry<String, List<AttDetailsDto>> entry : detailGroupMap.entrySet()) {
            List<AttDetailsDto> value = entry.getValue();
            AttDetailsDto attDetailsDto = value.get(0);
            BigDecimal sumVal = BigDecimal.ZERO;
            for (AttDetailsDto dto : value) {
                sumVal = sumVal.add(dto.getValue());
            }
            sumVal = this.scale(sumVal, attDetailsDto.getDataAccuracy(), attDetailsDto.getPrecisionTail());
            attDetailsDto.setValue(sumVal);
            attDetailsDto.setOwnDate(null);
            if (AttDataTypeEnum.QT_RECORD.getCode().equals(attDetailsDto.getDataType())) {
                attDetailsDto.setDataType(AttDataTypeEnum.QT_PERIOD_SUM.getCode());
            } else if (AttDataTypeEnum.ATT_PERIOD_SUM.getCode().equals(attDetailsDto.getDataType())) {
                attDetailsDto.setDataType(AttDataTypeEnum.ATT_PERIOD_SUM.getCode());
            }
            sumAttDetail.add(attDetailsDto);
        }
        return sumAttDetail;
    }
}

