/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;

public class IntegrationService {
    public static final int TIME_OUT = 6000;
    public static final String CUS_FAILMAP = "failMap";
    private static IntegrationService service = new IntegrationService();

    private IntegrationService() {
    }

    public static IntegrationService getInstance() {
        return service;
    }

    public void openResultView(String data, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtis_withdrawproresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("data", (Object)data);
        view.showForm(showParameter);
    }

    public List<String> trans(JSONObject json, Map<String, List<Long>> map, List<Long> sumAttFileIdList) {
        ArrayList numberList = Lists.newArrayListWithCapacity((int)16);
        if (json != null) {
            Set entries = json.entrySet();
            for (Map.Entry next : entries) {
                JSONArray value;
                String taskNumber = (String)next.getKey();
                if (HRStringUtils.isEmpty((String)taskNumber)) continue;
                numberList.add(taskNumber);
                ArrayList attFileList = map.get(taskNumber);
                if (attFileList == null) {
                    attFileList = Lists.newArrayListWithExpectedSize((int)16);
                }
                if ((value = (JSONArray)next.getValue()) != null) {
                    for (Long attFileId : value) {
                        attFileList.add(attFileId);
                        sumAttFileIdList.add(attFileId);
                    }
                }
                map.put(taskNumber, attFileList);
            }
        }
        return numberList;
    }

    public List<Long> getCacheList() {
        String cacheKey;
        DistributeSessionlessCache cache = WTCCacheUtils.getCache();
        String cacheValue = (String)cache.get(cacheKey = WTCCacheUtils.getKey((String)"wtis", (String)"attdataintegrate_cache"));
        List cacheList = HRStringUtils.isEmpty((String)cacheValue) ? Lists.newArrayListWithExpectedSize((int)0) : JSONObject.parseArray((String)cacheValue, Long.class);
        return cacheList;
    }

    public void refreshCache(List<Long> cacheList) {
        DistributeSessionlessCache cache = WTCCacheUtils.getCache();
        String cacheKey = WTCCacheUtils.getKey((String)"wtis", (String)"attdataintegrate_cache");
        cache.put(cacheKey, (Object)JSONObject.toJSONString(cacheList));
    }

    public void dispatch(Map<String, Object> params, AbstractFormPlugin abstractListPlugin) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("wtis");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName((String)params.get(AttDataIntegrateConstants.TITLE_NAME));
        jobInfo.setCaption((String)params.get(AttDataIntegrateConstants.TITLE_NAME));
        jobInfo.setId(String.valueOf(params.get(AttDataIntegrateConstants.TASK_ID)));
        jobInfo.setTaskClassname((String)params.get(AttDataIntegrateConstants.TASK_CLASS_NAME));
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setParams(params);
        if (null == abstractListPlugin) {
            ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)abstractListPlugin, (String)params.get(AttDataIntegrateConstants.ACTION_ID));
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setClickClassName((String)params.get(AttDataIntegrateConstants.CLICK_CLASS_NAME));
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setTimeout(6000);
        IFormView iFormView = abstractListPlugin.getView();
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)iFormView);
    }
}

