/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.task;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataService;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataIntegrateHelper;
import kd.wtc.wtis.business.web.helper.BizDataFailStatusEnum;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.enums.IntegrStatusEnum;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttDataPushTask
extends AbstractTask {
    private static final int ATTDATA_WITH_DRAW_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtis.business.attdata.task.AttDataPushTask.push.size", 1000);
    private static HRBaseServiceHelper attDataDetServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
    private static HRBaseServiceHelper attDataInfoServiceHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
    private static HRBaseServiceHelper attPeriodServiceHelper = new HRBaseServiceHelper("wtp_attperiodentry");
    private static final Log LOG = LogFactory.getLog(PunchCardDataService.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, IntegrationKDString.pushIng(), null);
        LinkedHashSet attfileBidSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        this.dealWithPush(params, attfileBidSet, result);
        this.feedbackCustomdata(result);
    }

    private void dealWithPush(Map<String, Object> params, Set<Long> attfileBidSet, Map<String, Object> result) {
        Long pushTimeMillis = System.currentTimeMillis();
        Date pushDate = HRDateTimeUtils.getNowDateTime();
        Long taskId = Long.parseLong((String)params.get("taskId"));
        Long currentUserId = ((Number)params.get("currentUserId")).longValue();
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        filter.and(new QFilter("generstatus", "=", (Object)AttDataIntegrateConstants.GENSTATU_ONE));
        DynamicObject[] attDataDets = attDataDetServiceHelper.query("integrdown,id,attfileboid.id,attfileboid.usablestatus,integrstatus,integrexinfo", filter.toArray());
        if (attDataDets == null || attDataDets.length == 0) {
            LOG.info("attDataDets is null");
            this.setResult(result, 0, 0, params);
            return;
        }
        String attFileErrIdSetStr = (String)params.get("attFileErrIdSetStr");
        HashSet attfileBidErrSet = attFileErrIdSetStr == null ? Sets.newHashSetWithExpectedSize((int)16) : Arrays.asList(attFileErrIdSetStr.split(",")).stream().map(ob -> Long.parseLong(ob)).collect(Collectors.toSet());
        attfileBidSet.addAll(attfileBidErrSet);
        String taskVersion = (String)params.get("taskVersion");
        List<DynamicObject> attDataDetList = Arrays.asList(attDataDets);
        if (!this.dealFailTask(attDataDetList, attfileBidSet, taskId, params, pushTimeMillis, pushDate, taskVersion)) {
            this.setResult(result, attDataDets.length - attfileBidSet.size(), attDataDets.length, params);
            return;
        }
        AttDataIntegrateHelper.getInstance().attDataIntegratePush(taskVersion, attDataDets.length - attfileBidSet.size(), currentUserId, pushTimeMillis, (String)params.get(AttDataIntegrateConstants.INTEGRATIONRULE_DATASOURCE));
        this.feedbackProgress(100, IntegrationKDString.pushIng(), null);
        this.setResult(result, attDataDets.length - attfileBidSet.size(), attfileBidSet.size(), params);
    }

    private void setResult(Map<String, Object> result, int successAttfileBidSize, int errorAttfileBidSize, Map<String, Object> params) {
        result.put("successAttfileBidSize", successAttfileBidSize);
        result.put("errorAttfileBidSize", errorAttfileBidSize);
        result.put("version", params.get("taskVersion"));
    }

    private boolean isExistSpecal(String matchValue, String orginValue) {
        return StringUtils.contains((CharSequence)orginValue, (CharSequence)matchValue);
    }

    private boolean dealFailTask(List<DynamicObject> attDataDets, Set<Long> attfileBidSet, Long taskId, Map<String, Object> params, Long pushTimeMillis, Date pushDate, String taskVersion) {
        String specialSet = (String)params.get("specialSet");
        Set fileBoIds = attDataDets.stream().map(ob -> ob.getLong("attfileboid.id")).collect(Collectors.toSet());
        Set discardAttFileBoIds = attDataDets.stream().filter(attFile -> !WTCStringUtils.equals((String)"0", (String)attFile.getString("attfileboid.usablestatus"))).map(attFile -> attFile.getLong("attfileboid.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("number", "=", (Object)taskVersion);
        int size = fileBoIds.size();
        boolean isExistSpecalStatus = false;
        HashSet failTaskIdSet = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList failInfoList = Lists.newArrayListWithExpectedSize((int)size);
        if (this.isExistSpecal(AttDataIntegrateConstants.SPECIAL_SET_C, specialSet)) {
            isExistSpecalStatus = true;
        }
        for (int index = 0; index < size; index += ATTDATA_WITH_DRAW_SIZE) {
            int end = index + ATTDATA_WITH_DRAW_SIZE;
            int limit = ATTDATA_WITH_DRAW_SIZE;
            if (end > size) {
                limit = ATTDATA_WITH_DRAW_SIZE - (end - size);
            }
            List failInfoLimitList = fileBoIds.stream().skip(index).limit(limit).collect(Collectors.toList());
            qFilter.and(new QFilter("attfilebase", "in", failInfoLimitList));
            DynamicObject[] queryDynObj = attDataInfoServiceHelper.queryOriginalArray("id,value,number,attfilebase,perperiodenddate,taskdetail,integrstatus,abnreason,attperiodentry", new QFilter[]{qFilter});
            if (queryDynObj == null || queryDynObj.length == 0) {
                attfileBidSet.addAll(discardAttFileBoIds);
                continue;
            }
            List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList(failInfoLimitList));
            HashMap<Long, AttStateInfoBO> attStateInfoBOMap = new HashMap<Long, AttStateInfoBO>(attStateInfoBOS.size());
            for (AttStateInfoBO attStateInfoBO : attStateInfoBOS) {
                attStateInfoBOMap.put(attStateInfoBO.getFileBoid(), attStateInfoBO);
            }
            HashSet failStorageToAttfileIdSet = Sets.newHashSetWithExpectedSize((int)16);
            HashMap attfileValue = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject dynamicObject : queryDynObj) {
                Long attfileBid = dynamicObject.getLong("attfilebase");
                if (discardAttFileBoIds.contains(attfileBid)) {
                    dynamicObject.set("abnreason", (Object)BizDataFailStatusEnum.FAILSTATUS_9004.getCode());
                    dynamicObject.set("integrstatus", (Object)IntegrStatusEnum.NON.getCode());
                    failTaskIdSet.add(dynamicObject.getLong("taskdetail"));
                    failInfoList.add(dynamicObject);
                    continue;
                }
                BigDecimal sumValue = attfileValue.getOrDefault(attfileBid, BigDecimal.ZERO).add(dynamicObject.getBigDecimal("value"));
                attfileValue.put(attfileBid, sumValue);
                if (!this.setStopTime(dynamicObject, attfileBidSet, failTaskIdSet, failInfoList) || !isExistSpecalStatus) continue;
                this.setStopStatus(dynamicObject, failStorageToAttfileIdSet, failTaskIdSet, failInfoList, attStateInfoBOMap);
            }
            attfileBidSet.addAll(failStorageToAttfileIdSet);
            attfileBidSet.addAll(discardAttFileBoIds);
            String pushType = (String)params.get("pushType");
            this.feedbackProgress(BigDecimal.valueOf(end).divide(BigDecimal.valueOf(size), 2, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L)).intValue(), IntegrationKDString.withDrawDataIng(), null);
            this.setElseReson(specialSet, attfileBidSet, queryDynObj, failTaskIdSet, failInfoList, pushType, attfileValue);
        }
        return this.saveData(attDataDets, failTaskIdSet, attfileBidSet, failInfoList, taskId, pushTimeMillis, pushDate);
    }

    private void setElseReson(String specialSet, Set<Long> attfileBidSet, DynamicObject[] queryDynObj, Set<Long> failTaskIdSet, List<DynamicObject> failInfoList, String pushType, Map<Long, BigDecimal> attfileValue) {
        boolean isExistSpecalAttitem = false;
        if (this.isExistSpecal(AttDataIntegrateConstants.SPECIAL_SET_A, specialSet)) {
            isExistSpecalAttitem = true;
        }
        for (DynamicObject dynamicObject : queryDynObj) {
            String code = dynamicObject.getString("abnreason");
            if (!HRStringUtils.isEmpty((String)code)) continue;
            Long attfileBid = dynamicObject.getLong("attfilebase");
            BigDecimal sumValue = attfileValue.getOrDefault(attfileBid, BigDecimal.ZERO);
            if (isExistSpecalAttitem && sumValue.compareTo(BigDecimal.ZERO) == 0) {
                dynamicObject.set("abnreason", (Object)BizDataFailStatusEnum.FAILSTATUS_9003.getCode());
                dynamicObject.set("integrstatus", (Object)IntegrStatusEnum.NON.getCode());
                failTaskIdSet.add(dynamicObject.getLong("taskdetail"));
                attfileBidSet.add(attfileBid);
                failInfoList.add(dynamicObject);
            }
            this.setNotSelfReason(attfileBidSet, dynamicObject, failTaskIdSet, failInfoList, pushType);
        }
    }

    private void setNotSelfReason(Set<Long> attfileBidSet, DynamicObject dynamicObject, Set<Long> failTaskIdSet, List<DynamicObject> failInfoList, String pushType) {
        String code;
        if (HRStringUtils.equals((String)pushType, (String)"2") && !WTCCollections.isEmpty(attfileBidSet) && HRStringUtils.isEmpty((String)(code = dynamicObject.getString("abnreason")))) {
            Long attfileBid = dynamicObject.getLong("attfilebase");
            dynamicObject.set("abnreason", (Object)BizDataFailStatusEnum.FAILSTATUS_9002.getCode());
            dynamicObject.set("integrstatus", (Object)IntegrStatusEnum.NON.getCode());
            failTaskIdSet.add(dynamicObject.getLong("taskdetail"));
            attfileBidSet.add(attfileBid);
            failInfoList.add(dynamicObject);
        }
    }

    private boolean setStopStatus(DynamicObject dynamicObject, Set<Long> failStorageToAttfileIdSet, Set<Long> failTaskIdSet, List<DynamicObject> failInfoList, Map<Long, AttStateInfoBO> attStateInfoBOMap) {
        Date storageTo;
        Long attfileBid = dynamicObject.getLong("attfilebase");
        AttStateInfoBO attStateInfoBO = attStateInfoBOMap.get(attfileBid);
        Date perPeriodEndDate = dynamicObject.getDate("perperiodenddate");
        if (attStateInfoBO != null && (storageTo = attStateInfoBO.getStorageTo()) != null && perPeriodEndDate != null && perPeriodEndDate.compareTo(storageTo) > 0) {
            dynamicObject.set("abnreason", (Object)BizDataFailStatusEnum.FAILSTATUS_9000.getCode());
            dynamicObject.set("integrstatus", (Object)IntegrStatusEnum.NON.getCode());
            failTaskIdSet.add(dynamicObject.getLong("taskdetail"));
            failStorageToAttfileIdSet.add(attfileBid);
            failInfoList.add(dynamicObject);
            return false;
        }
        return true;
    }

    private boolean setStopTime(DynamicObject dynamicObject, Set<Long> attfileBidSet, Set<Long> failTaskIdSet, List<DynamicObject> failInfoList) {
        Long attfileBid = dynamicObject.getLong("attfilebase");
        if (attfileBidSet.contains(attfileBid)) {
            dynamicObject.set("abnreason", (Object)BizDataFailStatusEnum.FAILSTATUS_9001.getCode());
            dynamicObject.set("integrstatus", (Object)IntegrStatusEnum.NON.getCode());
            failTaskIdSet.add(dynamicObject.getLong("taskdetail"));
            failInfoList.add(dynamicObject);
            return false;
        }
        return true;
    }

    private boolean saveData(List<DynamicObject> attDataDets, Set<Long> failTaskIdSet, Set<Long> attfileBidSet, List<DynamicObject> failInfoList, Long taskId, Long pushTimeMillis, Date pushDate) {
        if (!WTCCollections.isEmpty(attfileBidSet)) {
            QFilter attPeriodFilter;
            DynamicObject[] attPeriodServiceObj;
            Map<Long, List<DynamicObject>> dataInfoMap = failInfoList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("taskdetail")));
            List<DynamicObject> filterDyList = attDataDets.stream().filter(ob -> failTaskIdSet.contains(ob.getLong("id")) || attfileBidSet.contains(ob.getLong("attfileboid.id"))).collect(Collectors.toList());
            HashMap periodMap = Maps.newHashMapWithExpectedSize((int)failInfoList.size());
            if (WTCCollections.isNotEmpty(failInfoList) && (attPeriodServiceObj = attPeriodServiceHelper.queryOriginalArray("id,name", new QFilter[]{attPeriodFilter = new QFilter("id", "in", failInfoList.stream().map(ob -> ob.getLong("attperiodentry")).collect(Collectors.toList()))})) != null && attPeriodServiceObj.length != 0) {
                periodMap.putAll(Arrays.stream(attPeriodServiceObj).collect(Collectors.toMap(ob -> ob.getLong("id"), entry -> entry.getString("name"))));
            }
            for (DynamicObject dynamicObject : filterDyList) {
                dynamicObject.set("integrstatus", (Object)IntegrStatusEnum.NON.getCode());
                dynamicObject.set(AttDataIntegrateConstants.INTEGR_DOWN, (Object)false);
                List<DynamicObject> listDataInfo = dataInfoMap.get(dynamicObject.getLong("id"));
                if (WTCCollections.isNotEmpty(listDataInfo)) {
                    DynamicObject dataInfo = listDataInfo.get(0);
                    String desc = BizDataFailStatusEnum.getDesc(dataInfo.getString("abnreason"), (String)periodMap.get(dataInfo.getLong("attperiodentry")));
                    dynamicObject.set(AttDataIntegrateConstants.INTEGR_EX_INFO, (Object)desc);
                    continue;
                }
                dynamicObject.set(AttDataIntegrateConstants.INTEGR_EX_INFO, (Object)BizDataFailStatusEnum.FAILSTATUS_9004.getDesc());
            }
            this.updateAttDataInfo(failInfoList);
            attDataDetServiceHelper.update(filterDyList.toArray(new DynamicObject[0]));
            if (attDataDets.size() <= attfileBidSet.size()) {
                LOG.info("all attfile is error");
                AttDataGenerateHelper.updateAttDataIntegrate(taskId, pushTimeMillis, pushDate);
                return false;
            }
        }
        return true;
    }

    private void updateAttDataInfo(List<DynamicObject> failInfoList) {
        int maxValue = 10000;
        int size = failInfoList.size();
        for (int index = 0; index < size; index += maxValue) {
            int end = index + maxValue;
            int limit = maxValue;
            if (end > size) {
                limit = maxValue - (end - size);
            }
            List<DynamicObject> failInfoLimitList = failInfoList.stream().skip(index).limit(limit).collect(Collectors.toList());
            this.segmentedUpdateAttDataInfo(failInfoLimitList);
        }
    }

    private void segmentedUpdateAttDataInfo(List<DynamicObject> failInfoList) {
        DynamicObject[] queryDynObj;
        Map<Long, List<DynamicObject>> failInfoMap = failInfoList.stream().collect(Collectors.groupingBy(ob -> ob.getLong("id")));
        for (DynamicObject dynamicObject : queryDynObj = attDataInfoServiceHelper.query("id,integrstatus,abnreason", new QFilter[]{new QFilter("id", "in", failInfoMap.keySet())})) {
            DynamicObject newFailInfo;
            List<DynamicObject> dynamicObjectList = failInfoMap.get(dynamicObject.get("id"));
            if (WTCCollections.isEmpty(dynamicObjectList) || (newFailInfo = dynamicObjectList.get(0)) == null) continue;
            dynamicObject.set("integrstatus", newFailInfo.get("integrstatus"));
            dynamicObject.set("abnreason", newFailInfo.get("abnreason"));
        }
        attDataInfoServiceHelper.update(queryDynObj);
    }
}

