/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.attdata.task;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.business.attdata.service.IntegrationService;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataService;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataIntegrateHelper;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;

public class WithDrawAttDataTask
extends AbstractTask {
    private static final int ATTDATA_WITH_DRAW_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtis.business.attdata.task.WithDrawAttDataTask.withdraw.size", 500);
    private static final Log LOG = LogFactory.getLog(PunchCardDataService.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, IntegrationKDString.pushIng(), null);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        this.dealWithDrawWith(params, result);
        this.feedbackCustomdata(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithDrawWith(Map<String, Object> params, Map<String, Object> result) {
        String attDataNumber = (String)params.get("version");
        Long taskId = Long.parseLong((String)params.get(AttDataIntegrateConstants.TASK_ID));
        List<Long> successFileIds = this.getIntegrateSuccessFile(params);
        if (CollectionUtils.isEmpty(successFileIds)) {
            this.removeTaskCache(taskId);
            return;
        }
        int size = successFileIds.size();
        String sessionId = UUID.randomUUID().toString();
        ArrayList successFileId = Lists.newArrayListWithExpectedSize((int)successFileIds.size());
        ArrayList failFileId = Lists.newArrayListWithExpectedSize((int)successFileIds.size());
        try {
            for (int index = 0; index < size; index += ATTDATA_WITH_DRAW_SIZE) {
                int end = index + ATTDATA_WITH_DRAW_SIZE;
                int limit = ATTDATA_WITH_DRAW_SIZE;
                if (end > size) {
                    limit = ATTDATA_WITH_DRAW_SIZE - (end - size);
                } else {
                    this.feedbackProgress(BigDecimal.valueOf(end).divide(BigDecimal.valueOf(size), 2, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L)).intValue(), IntegrationKDString.withDrawDataIng(), null);
                }
                List<Long> attfileList = successFileIds.stream().skip(index).limit(limit).collect(Collectors.toList());
                Map<String, List<Long>> recallAttRecordMap = AttDataIntegrateHelper.getInstance().recallAttRecord(attDataNumber, attfileList, taskId, sessionId);
                if (WTCCollections.isEmpty(recallAttRecordMap)) continue;
                List<Long> batchSuccessFileId = recallAttRecordMap.get(AttDataIntegrateConstants.SUCCESSFILE_IDS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AttDataIntegrateList afterDoOperation successFileId:{}", (Object)SerializationUtils.toJsonString(batchSuccessFileId));
                }
                if (!CollectionUtils.isEmpty(batchSuccessFileId)) {
                    successFileId.addAll(batchSuccessFileId);
                }
                List<Long> batchfailFileId = recallAttRecordMap.get(AttDataIntegrateConstants.ERRORFILE_IDS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AttDataIntegrateList_afterDoOperation_failFileId:{}", (Object)SerializationUtils.toJsonString(batchfailFileId));
                }
                if (CollectionUtils.isEmpty(batchfailFileId)) continue;
                failFileId.addAll(batchfailFileId);
            }
            AttDataGenerateHelper.updateAttDataIntegrate(taskId);
            this.feedbackProgress(100, IntegrationKDString.pushIng(), null);
            this.setResult(result, successFileId.size(), failFileId.size(), params);
            HRBaseServiceHelper subTaskHelper = new HRBaseServiceHelper(AttDataIntegrateConstants.PAGE_WTIS_WITHDRAWTASK);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AttDataIntegrateConstants.PAGE_WTIS_WITHDRAWTASK));
            dynamicObject.set("id", params.get(AttDataIntegrateConstants.SUBTASKID));
            dynamicObject.set("succeedattfile", (Object)successFileId.size());
            dynamicObject.set("failedattfile", (Object)failFileId.size());
            dynamicObject.set("taskId", (Object)taskId);
            subTaskHelper.save(new DynamicObject[]{dynamicObject});
        }
        catch (Exception e) {
            LOG.warn("withdraw error", (Throwable)e);
        }
        finally {
            this.removeTaskCache(taskId);
        }
    }

    private void removeTaskCache(Long taskId) {
        List<Long> cacheList = IntegrationService.getInstance().getCacheList();
        cacheList.remove(taskId);
        IntegrationService.getInstance().refreshCache(cacheList);
    }

    private List<Long> getIntegrateSuccessFile(Map<String, Object> params) {
        Object attfileSelectObject = params.get(AttDataIntegrateConstants.ATTFILE\uff3fLIST\uff3fSTR);
        if (attfileSelectObject == null) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.fromJsonString((String)((String)attfileSelectObject), List.class);
    }

    private void setResult(Map<String, Object> result, int successAttfileBidSize, int errorAttfileBidSize, Map<String, Object> params) {
        result.put(AttDataIntegrateConstants.SUCCESS, successAttfileBidSize);
        result.put(AttDataIntegrateConstants.ERROR, errorAttfileBidSize);
        result.put("version", params.get("version"));
        result.put(AttDataIntegrateConstants.SUBTASKID, params.get(AttDataIntegrateConstants.SUBTASKID));
    }
}

