/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.coordination;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIReviseLogServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtis.business.coordination.PersonInfoReviseLogService;
import kd.wtc.wtis.enums.ReviseEventStatusEnum;
import kd.wtc.wtis.enums.ReviseHandlingStatusEnum;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.enums.coordination.TaskCreateStatusEnum;

public class MessageAccessor {
    private static final Log logger = LogFactory.getLog(MessageAccessor.class);

    public HRMServiceResult accessExecute(DynamicObject messageDy) {
        if (logger.isInfoEnabled()) {
            logger.info("MessageAccessor accessExecute  msgContent {}", (Object)messageDy.getString("msgcontent"));
        }
        String msgSubNo = messageDy.getString("msgsubno");
        if (CoordinationHelper.getInstance().isReviseEvent(msgSubNo)) {
            try {
                this.personInfoRevise(messageDy);
            }
            catch (Exception exception) {
                if (logger.isInfoEnabled()) {
                    logger.info("personInfoReviseEvent failed {}", (Object)exception);
                }
                return HRMServiceResult.fail((String)exception.getMessage());
            }
            return HRMServiceResult.success();
        }
        Long msgCenterBoId = messageDy.getLong("msgcenterbo_id");
        if (msgCenterBoId.equals(0L)) {
            msgCenterBoId = messageDy.getLong("msgcenterbo");
        }
        DynamicObject logDynamicObject = null;
        try {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_coordinationlog");
            logDynamicObject = hrBaseServiceHelper.loadDynamicObject(new QFilter("msgcenterbo", "=", (Object)msgCenterBoId));
            if (logDynamicObject == null) {
                logDynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)messageDy, (DynamicObject)logDynamicObject);
                logDynamicObject.set("taskcreatestatus", (Object)TaskCreateStatusEnum.TOBE_CREATE.getCode());
                hrBaseServiceHelper.saveOne(logDynamicObject);
            }
            DynamicObject finalLogDynamicObject = logDynamicObject;
            CoordinationHelper.THREAD_POOL.execute(() -> CoordinationHelper.getInstance().createExecute(finalLogDynamicObject, false));
            return HRMServiceResult.success();
        }
        catch (KDBizException ex) {
            this.saveExceptionLog(logDynamicObject, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            this.saveExceptionLog(logDynamicObject, ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    private void personInfoRevise(DynamicObject messageDy) {
        String msgContentStr = messageDy.getString("msgcontent");
        if (!WTCStringUtils.isEmpty((String)msgContentStr)) {
            Map map;
            if (logger.isInfoEnabled()) {
                logger.info("kd.wtc.wtis.business.coordination.MessageAccessor.personInfoRevise start.");
            }
            if (WTCCollections.isEmpty((Map)(map = (Map)SerializationUtils.deSerializeFromBase64((String)msgContentStr)))) {
                return;
            }
            String entityNumber = (String)map.get("entityNumber");
            List reviserecordList = (List)map.get("reviserecordList");
            Map resultMap = (Map)WTCServiceHelper.invokeHRService((String)"hspm", (String)"IReviseRecordService", (String)"queryAndCompareReviseLog", (Object[])new Object[]{entityNumber, reviserecordList});
            if (WTCCollections.isEmpty((Map)resultMap)) {
                return;
            }
            Map entityLogDataMap = (Map)resultMap.get("data");
            if (WTCCollections.isEmpty((Map)entityLogDataMap)) {
                return;
            }
            List entityLogDyList = HRPIReviseLogServiceHelper.generateReviseLogDynList((String)"wtis_personreviselog", (Map)entityLogDataMap);
            DynamicObject entityLogDy = (DynamicObject)entityLogDyList.get(0);
            if (entityLogDy == null) {
                return;
            }
            Date nowDate = new Date();
            Date userDate = WTCInteDateUtil.getUserDate((Date)nowDate);
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"wtis_personreviselog", (DynamicObject)entityLogDy, null, (int)entityLogDyList.size());
            for (int i = 0; i < entityLogDyList.size(); ++i) {
                DynamicObject dynamicObject2 = (DynamicObject)entityLogDyList.get(i);
                dynamicObject2.set("msgreceivedate", (Object)userDate);
                dynamicObject2.set("eventstatus", (Object)ReviseEventStatusEnum.SUCCESS.getCode());
                dynamicObject2.set("msgcenter", messageDy.get("msgcenterbo"));
                dynamicObject2.set("handlingstatus", (Object)ReviseHandlingStatusEnum.PROCESSING.getCode());
                if (batchNumber == null) continue;
                dynamicObject2.set("number", (Object)batchNumber[i]);
            }
            PersonInfoReviseLogService.getInstance().synAttPersonAndUpdatePersonInfoReviseLog(entityLogDyList);
            entityLogDyList.forEach(dynamicObject -> dynamicObject.set("msgcontent", (Object)msgContentStr));
            entityLogDyList.forEach(dynamicObject -> dynamicObject.set("reviseinfotype", (Object)dynamicObject.getString("revisenumber")));
            if (logger.isInfoEnabled()) {
                logger.info("kd.wtc.wtis.business.coordination.MessageAccessor.personInfoRevise size:{}", (Object)entityLogDyList.size());
            }
            HRPIReviseLogServiceHelper.saveReviseLogDyn((List)entityLogDyList);
        }
    }

    private void saveExceptionLog(DynamicObject logDynamicObject, Exception ex) {
        if (logDynamicObject != null) {
            logDynamicObject.set("taskcreatestatus", (Object)TaskCreateStatusEnum.FAIL.getCode());
            logDynamicObject.set("taskcreatefailcause", (Object)ex.getMessage());
            String failCause = logDynamicObject.getString("taskcreatefailcause");
            if (WTCStringUtils.isNotEmpty((String)failCause) && failCause.length() > 500) {
                failCause = failCause.substring(0, 500);
                logDynamicObject.set("taskcreatefailcause", (Object)failCause);
            }
            CoordinationHelper.getInstance().saveLog(logDynamicObject);
        }
    }
}

