/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.coordination;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.enums.ReviseEventStatusEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class PersonInfoReviseLogService {
    private static final Log logger = LogFactory.getLog(PersonInfoReviseLogService.class);
    private static final PersonInfoReviseLogService INS = (PersonInfoReviseLogService)WTCAppContextHelper.getBean(PersonInfoReviseLogService.class);

    public static PersonInfoReviseLogService getInstance() {
        return INS;
    }

    private void reviseSynAttPerson(List<DynamicObject> entityLogDyList) {
        List personList = entityLogDyList.stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"person")).collect(Collectors.toList());
        List empPosOrgRelList = entityLogDyList.stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"empposorgrel")).collect(Collectors.toList());
        HashMap warnInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap customMap = Maps.newHashMapWithExpectedSize((int)16);
        customMap.put("ignorecheckrel", Boolean.TRUE);
        AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonDataCustom(personList, empPosOrgRelList, (Map)warnInfoMap, (Map)customMap);
        if (WTCCollections.isNotEmpty((Map)warnInfoMap)) {
            for (DynamicObject dynamicObject2 : entityLogDyList) {
                dynamicObject2.set("failmsg", (Object)AttFileKDString.personInfoEx());
                dynamicObject2.set("eventstatus", (Object)ReviseEventStatusEnum.FAIL.getCode());
            }
        } else {
            AttendPersonSynService.getInstance().updateAttPerson(attendPersonCurrResult);
        }
        Set deleteRelIdSet = entityLogDyList.stream().filter(d -> "1".equals(d.getString("revisetype")) && "hrpi_empposorgrel".equals(d.getString("revisenumber"))).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"empposorgrel")).collect(Collectors.toSet());
        if (WTCCollections.isNotEmpty(deleteRelIdSet)) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_depempjob");
            DynamicObject[] query = hrBaseServiceHelper.query("id,datastatus", new QFilter[]{new QFilter("id", "in", deleteRelIdSet)});
            Arrays.stream(query).forEach(dynamicObject -> dynamicObject.set("datastatus", (Object)"-1"));
            hrBaseServiceHelper.updateDatas(query);
        }
    }

    public void synAttPersonAndUpdatePersonInfoReviseLog(List<DynamicObject> entityLogDyList) {
        try {
            this.reviseSynAttPerson(entityLogDyList);
            for (DynamicObject dynamicObject : entityLogDyList) {
                dynamicObject.set("eventstatus", (Object)ReviseEventStatusEnum.SUCCESS.getCode());
                dynamicObject.set("failmsg", (Object)"");
            }
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn("reviseSynAttPerson failed", (Throwable)exception);
            }
            for (DynamicObject dynamicObject : entityLogDyList) {
                dynamicObject.set("failmsg", (Object)AttFileKDString.personSynEx());
                dynamicObject.set("eventstatus", (Object)ReviseEventStatusEnum.FAIL.getCode());
            }
        }
    }
}

