/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.punchcarddata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.business.punchcarddata.WTISSystemParamQueryUtil;

public class PunchCardDataHelper {
    private static final Log LOG = LogFactory.getLog(PunchCardDataHelper.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtis_punchcarddata");
    private final int MAX_NUMBER = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtis.punchcard.queryIdSize", 300000);

    public static PunchCardDataHelper getInstance() {
        return (PunchCardDataHelper)WTCAppContextHelper.getBean(PunchCardDataHelper.class);
    }

    public DynamicObject[] getSynTaskData(Date curDate) {
        ArrayList statusList = Lists.newArrayListWithExpectedSize((int)2);
        statusList.add("0");
        statusList.add("1");
        QFilter statusQFilter = new QFilter("status", "in", (Object)statusList);
        QFilter modifyTimeQFilter = new QFilter("modifytime", "<", (Object)curDate);
        QFilter timesQFilter = new QFilter("times", "<", (Object)WTISSystemParamQueryUtil.getMaxSynTime());
        return HELPER.query("id", new QFilter[]{statusQFilter, modifyTimeQFilter, timesQFilter}, "modifytime asc", this.MAX_NUMBER);
    }

    public static DynamicObject[] getDataByBatchNumber(String batchNumber) {
        return HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("batchnumber", "=", (Object)batchNumber)});
    }

    public static DynamicObject[] getDataByIdList(List<Long> idList) {
        return HELPER.loadDynamicObjectArray((Object[])idList.toArray(new Long[0]));
    }

    public static void saveData(DynamicObject[] punchCardData) {
        LOG.info("PunchCardDataHelper.saveData punchCardData={}", (Object)punchCardData.length);
        HELPER.save(punchCardData);
    }

    public static DynamicObject[] getDeleteData() {
        int month = WTISSystemParamQueryUtil.getArchivePolicy();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -month);
        QFilter creatTimeQFilter = new QFilter("createtime", "<", (Object)calendar.getTime());
        QFilter timesQFilter = new QFilter("times", ">=", (Object)WTISSystemParamQueryUtil.getMaxSynTime());
        QFilter failQStatusFilter = new QFilter("status", "=", (Object)"1");
        QFilter failQFilter = timesQFilter.and(failQStatusFilter);
        QFilter successQFilter = new QFilter("status", "=", (Object)"2");
        QFilter statusFilter = successQFilter.or(failQFilter);
        return HELPER.query("id", new QFilter[]{creatTimeQFilter.and(statusFilter)});
    }

    public static void deleteByPkIds(List<Long> ids) {
        if (WTCCollections.isNotEmpty(ids)) {
            HELPER.delete(ids.toArray());
        }
    }
}

