/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.punchcarddata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.sign.SignCardDTO;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataHelper;
import kd.wtc.wtis.business.punchcarddata.PunchCardEquipmentHelper;

public class PunchCardDataService {
    private static final Log LOG = LogFactory.getLog(PunchCardDataService.class);
    private static final String SYSTEM_TYPE = "wtc-wtis-business";
    static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    static final int ENGINE_POOL_SIZE = DEFAULT_POOL_SIZE * 2;
    static final String ENGINE_POOL_NAME = "ExecPunchCardPool";
    private static final ExecutorService EXECUTOR_SERVICE;
    private final int MAX_NUMBER = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtis.punchcard.batchSize", 2000);

    public static PunchCardDataService getInstance() {
        return (PunchCardDataService)WTCAppContextHelper.getBean(PunchCardDataService.class);
    }

    public void dealWithTask() {
        Date curDate = new Date();
        LOG.info("PunchCardDataService.dealWithTask start, curDate={}", (Object)curDate);
        DynamicObject[] synTaskData = PunchCardDataHelper.getInstance().getSynTaskData(curDate);
        List idList = Arrays.stream(synTaskData).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (idList.isEmpty()) {
            LOG.info("PunchCardDataService.dealWithTask  idList.isEmpty()");
            return;
        }
        LOG.info("PunchCardDataService.dealWithTask idList={}", (Object)idList.size());
        List partition = Lists.partition(idList, (int)this.MAX_NUMBER);
        for (List list : partition) {
            EXECUTOR_SERVICE.execute(() -> {
                LOG.info("dealWithTask.dealWithTask subtask start");
                DynamicObject[] taskData = PunchCardDataHelper.getDataByIdList(list);
                PunchCardDataService.dealWithData(taskData);
                LOG.info("dealWithTask.dealWithTask subtask end");
            });
        }
    }

    public static void dealWithData(DynamicObject[] punchCardData) {
        LOG.info("PunchCardDataService.dealWithData start");
        HashMap numberMap = Maps.newHashMapWithExpectedSize((int)punchCardData.length);
        HashMap cardMap = Maps.newHashMapWithExpectedSize((int)punchCardData.length);
        Map<String, DynamicObject> equipmentMap = PunchCardDataService.getInfo(punchCardData, numberMap, cardMap);
        Date modifyTime = new Date();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)punchCardData.length);
        ArrayList successDynList = Lists.newArrayListWithExpectedSize((int)punchCardData.length);
        try {
            for (DynamicObject dy2 : punchCardData) {
                SignCardDTO signCard = PunchCardDataService.checkData(dy2, modifyTime, equipmentMap, numberMap, cardMap);
                if (signCard == null) continue;
                list.add(signCard);
                successDynList.add(dy2);
            }
            if (!CollectionUtils.isEmpty((Collection)list)) {
                LOG.info("sync punchcarddata to signcard start");
                Map result = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtpd", (String)"ISignCardService", (String)"batchImportSignCards", (Object[])new Object[]{list});
                if (!CollectionUtils.isEmpty((Map)result)) {
                    Set ids = result.keySet();
                    successDynList.stream().forEach(dy -> {
                        if (ids.contains(dy.getLong("id"))) {
                            PunchCardDataService.setFailDy(dy, (String)result.get(dy.getLong("id")), modifyTime);
                        } else {
                            PunchCardDataService.setSuccessDy(dy, modifyTime);
                        }
                    });
                } else {
                    successDynList.stream().forEach(dy -> PunchCardDataService.setSuccessDy(dy, modifyTime));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("PunchCardDataService_sync_punchcarddata_to_signcard error", (Throwable)ex);
            PunchCardDataService.dealWithSyncError(punchCardData, modifyTime);
        }
        PunchCardDataHelper.saveData(punchCardData);
    }

    private static void dealWithSyncError(DynamicObject[] punchCardData, Date modifyTime) {
        for (DynamicObject dy : punchCardData) {
            if (!HRStringUtils.equals((String)"0", (String)dy.getString("status"))) continue;
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PunchCardDataService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
        }
    }

    private static Map<String, DynamicObject> getInfo(DynamicObject[] punchCardData, Map<String, List<DynamicObject>> numberMap, Map<String, List<DynamicObject>> cardMap) {
        QFilter status;
        QFilter qFilter;
        DynamicObject[] cardDyArr;
        HashSet equipNumberSet = Sets.newHashSetWithExpectedSize((int)punchCardData.length);
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)punchCardData.length);
        HashSet cardSet = Sets.newHashSetWithExpectedSize((int)punchCardData.length);
        for (DynamicObject dy : punchCardData) {
            DynamicObject[] card;
            equipNumberSet.add(dy.getString("equipnumber"));
            String number = dy.getString("number");
            if (HRStringUtils.isNotEmpty((String)number)) {
                numberSet.add(number);
            }
            if (!HRStringUtils.isNotEmpty((String)(card = dy.getString("card")))) continue;
            cardSet.add(dy.getString("card"));
        }
        Map<String, DynamicObject> equipmentMap = PunchCardEquipmentHelper.getEquipmentList(equipNumberSet);
        HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper("wtp_attendperson");
        DynamicObject[] attPersonDys = attPersonHelper.query("id,number", new QFilter[]{new QFilter("number", "in", (Object)numberSet)});
        HashSet attPersonIdSet = Sets.newHashSetWithExpectedSize((int)attPersonDys.length);
        HashMap numberIdMap = Maps.newHashMapWithExpectedSize((int)attPersonDys.length);
        for (DynamicObject dy : attPersonDys) {
            attPersonIdSet.add(dy.getLong("id"));
            numberIdMap.put(dy.getLong("id"), dy.getString("number"));
        }
        HRBaseServiceHelper cardHelper = new HRBaseServiceHelper("wtp_cardschedule");
        if (!attPersonIdSet.isEmpty()) {
            PunchCardDataService.getAttFileInfoByNumber(numberMap, attPersonIdSet, numberIdMap);
        }
        if ((cardDyArr = cardHelper.loadDynamicObjectArray(new QFilter[]{qFilter = new QFilter("card", "in", (Object)cardSet), status = new QFilter("datastatus", "in", Arrays.asList("0", "1", "2"))})) == null || cardDyArr.length == 0) {
            return equipmentMap;
        }
        PunchCardDataService.getAttFileInfoByCard(cardMap, cardDyArr);
        return equipmentMap;
    }

    private static void getAttFileInfoByCard(Map<String, List<DynamicObject>> cardMap, DynamicObject[] cardDyArr) {
        HashMap idAndCardMap = Maps.newHashMapWithExpectedSize((int)cardDyArr.length);
        HashSet attFileIdSet = Sets.newHashSetWithExpectedSize((int)cardDyArr.length);
        for (DynamicObject dy : cardDyArr) {
            long id = dy.getLong("attfileid.id");
            idAndCardMap.put(id, dy.getString("card"));
            attFileIdSet.add(id);
        }
        AttFileQueryParam cardAttFileQueryParam = new AttFileQueryParam();
        cardAttFileQueryParam.setBeCurrent(Boolean.FALSE);
        cardAttFileQueryParam.setAuthCheck(Boolean.FALSE);
        cardAttFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        cardAttFileQueryParam.setSetBoIds((Set)attFileIdSet);
        List attFileDyByCard = AttFileQueryServiceImpl.getInstance().queryAttFiles(cardAttFileQueryParam);
        for (DynamicObject dy : attFileDyByCard) {
            String card = (String)idAndCardMap.get(dy.getLong("boid"));
            if (!HRStringUtils.isNotEmpty((String)card)) continue;
            ArrayList list = cardMap.get(card);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)16);
            }
            list.add(dy);
            cardMap.put(card, list);
        }
    }

    private static void getAttFileInfoByNumber(Map<String, List<DynamicObject>> numberMap, Set<Long> attPersonIdSet, Map<Long, String> numberIdMap) {
        AttFileQueryParam numberAttFileQueryParam = new AttFileQueryParam();
        numberAttFileQueryParam.setBeCurrent(Boolean.FALSE);
        numberAttFileQueryParam.setAuthCheck(Boolean.FALSE);
        numberAttFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        numberAttFileQueryParam.setPersonSetIds(attPersonIdSet);
        List attFileDyByNumber = AttFileQueryServiceImpl.getInstance().queryAttFiles(numberAttFileQueryParam);
        for (DynamicObject dy : attFileDyByNumber) {
            long attPersonId = dy.getLong("attperson.id");
            String number = numberIdMap.get(attPersonId);
            if (HRStringUtils.isEmpty((String)number)) continue;
            ArrayList list = numberMap.get(number);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)16);
            }
            list.add(dy);
            numberMap.put(number, list);
        }
    }

    private static SignCardDTO checkData(DynamicObject dy, Date modifyTime, Map<String, DynamicObject> equipmentMap, Map<String, List<DynamicObject>> numberMap, Map<String, List<DynamicObject>> cardMap) {
        String equipNumber = dy.getString("equipnumber");
        DynamicObject equipDy = equipmentMap.get(equipNumber);
        String signSource = dy.getString("signsource");
        if (HRObjectUtils.isEmpty((Object)equipDy)) {
            String msg = ResManager.loadKDString((String)"\u6253\u5361\u6570\u636e\u7684\u8bc6\u522b\u7801\u4e0e\u7cfb\u7edf\u6253\u5361\u8bbe\u5907\u7684\u8bc6\u522b\u7801\u4e0d\u5339\u914d\u3002", (String)"PunchCardDataService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        String dateStr = dy.getString("punchcarddate");
        String timeStr = dy.getString("punchcardtime");
        Date punchCardDate = WTCDateUtils.str2Date((String)(dateStr.substring(0, 11) + " " + timeStr), null);
        if (punchCardDate == null) {
            String msg = ResManager.loadKDString((String)"\u6253\u5361\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38\u3002", (String)"PunchCardDataService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        SignCardDTO signCard = new SignCardDTO();
        DynamicObject matchAttFileDy = PunchCardDataService.getMatchAttFile(dy, numberMap, cardMap, punchCardDate, modifyTime, signCard);
        if (matchAttFileDy == null) {
            if (!"1".equals(dy.getString("status"))) {
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u6253\u5361\u65e5\u671f\u5bf9\u5e94\u7684\u6863\u6848\u3002", (String)"PunchCardDataService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                PunchCardDataService.setFailDy(dy, msg, modifyTime);
            }
            return null;
        }
        String usableStatus = matchAttFileDy.getString("usablestatus");
        if (HRStringUtils.equalsIgnoreCase((String)"-1", (String)usableStatus)) {
            String msg = ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5df2\u5e9f\u5f03\u3002", (String)"PunchCardDataService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        signCard.setId(Long.valueOf(dy.getLong("id")));
        signCard.setAttPersonId(Long.valueOf(matchAttFileDy.getLong("attperson.id")));
        signCard.setAttFileBoId(Long.valueOf(matchAttFileDy.getLong("boid")));
        signCard.setAttFileId(Long.valueOf(matchAttFileDy.getLong("id")));
        signCard.setOrgId(Long.valueOf(matchAttFileDy.getLong("org.id")));
        PunchCardDataService.dealWithTimeZone(dy, equipDy, punchCardDate, signCard);
        signCard.setSource(Long.valueOf(equipDy.getLong("signsource.id")));
        signCard.setDeviceId(Long.valueOf(equipDy.getLong("id")));
        signCard.setAccessTag(dy.getString("accesstag"));
        signCard.setPresetBiz1(dy.getString("presetbiz1"));
        signCard.setPresetBiz2(dy.getString("presetbiz2"));
        return signCard;
    }

    private static void dealWithTimeZone(DynamicObject dy, DynamicObject equipDy, Date punchCardDate, SignCardDTO signCard) {
        DynamicObject punchCardTimeZone = dy.getDynamicObject("timezone");
        DynamicObject equipTimeZone = equipDy.getDynamicObject("timezone");
        int equTimeDif = equipTimeZone.getInt("timedif");
        if (HRObjectUtils.isEmpty((Object)punchCardTimeZone)) {
            signCard.setTimeZoneId(Long.valueOf(equipTimeZone.getLong("id")));
            signCard.setTimeDiff(equTimeDif);
            signCard.setSignDateTime(punchCardDate);
            return;
        }
        int dataTimeDif = punchCardTimeZone.getInt("timedif");
        int dif = equTimeDif - dataTimeDif;
        Date date = WTCDateUtils.add((Date)punchCardDate, (int)11, (int)dif);
        signCard.setTimeZoneId(Long.valueOf(equipTimeZone.getLong("id")));
        signCard.setTimeDiff(equTimeDif);
        signCard.setSignDateTime(date);
    }

    private static DynamicObject getMatchAttFile(DynamicObject dy, Map<String, List<DynamicObject>> numberMap, Map<String, List<DynamicObject>> cardMap, Date date, Date modifyTime, SignCardDTO signCard) {
        DynamicObject dynamicObject;
        String number = dy.getString("number");
        List<DynamicObject> numberList = numberMap.get(number);
        if (numberList != null && (dynamicObject = PunchCardDataService.dealWithBsEdTime(numberList, date)) != null) {
            return dynamicObject;
        }
        String card = dy.getString("card");
        if (WTCStringUtils.isEmpty((String)card)) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u6253\u5361\u65e5\u671f\u5bf9\u5e94\u7684\u6863\u6848\u3002", (String)"PunchCardDataService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        return PunchCardDataService.dealWithAttFileByCard(dy, date, modifyTime, signCard, cardMap);
    }

    private static DynamicObject dealWithBsEdTime(List<DynamicObject> attFileList, Date punchCardDate) {
        Comparator timeComparator = (dy1, dy2) -> dy2.getDate("bsed").compareTo(dy1.getDate("bsed"));
        Collections.sort(attFileList, timeComparator);
        for (DynamicObject dy : attFileList) {
            Date bsEd = dy.getDate("bsed");
            if (punchCardDate.compareTo(bsEd) < 0) continue;
            return dy;
        }
        return null;
    }

    private static DynamicObject dealWithAttFileByCard(DynamicObject dy, Date date, Date modifyTime, SignCardDTO signCard, Map<String, List<DynamicObject>> cardMap) {
        String card = dy.getString("card");
        List<DynamicObject> cardList = cardMap.get(card);
        if (cardList == null) {
            String msg = ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u4e2d\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u8003\u52e4\u5361\u53f7\u3002", (String)"PunchCardDataService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        Set personCount = cardList.stream().map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet());
        if (personCount.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u7684\u8003\u52e4\u5361\u53f7\u3002", (String)"PunchCardDataService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        DynamicObject dynamicObject = PunchCardDataService.dealWithBsEdTime(cardList, date);
        if (null == dynamicObject) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u6253\u5361\u65e5\u671f\u5bf9\u5e94\u7684\u6863\u6848\u3002", (String)"PunchCardDataService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            PunchCardDataService.setFailDy(dy, msg, modifyTime);
            return null;
        }
        signCard.setAttCard(dy.getString("card"));
        return dynamicObject;
    }

    private static void setFailDy(DynamicObject dy, String reason, Date modifyTime) {
        dy.set("times", (Object)(dy.getInt("times") + 1));
        dy.set("status", (Object)"1");
        dy.set("reason", (Object)reason);
        dy.set("modifytime", (Object)modifyTime);
    }

    private static void setSuccessDy(DynamicObject dy, Date modifyTime) {
        dy.set("times", (Object)(dy.getInt("times") + 1));
        dy.set("status", (Object)"2");
        dy.set("reason", (Object)"");
        dy.set("modifytime", (Object)modifyTime);
    }

    static {
        try {
            EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)ENGINE_POOL_NAME, (int)ENGINE_POOL_SIZE);
        }
        catch (Exception e) {
            throw new WTCException((Throwable)e, ResManager.loadKDString((String)"\u6253\u5361\u6570\u636e\u540c\u6b65\u7ebf\u7a0b\u6c60\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"PunchCardDataService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }
}

