/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.punchcarddata.sync;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.api.client.HttpMethod;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.predata.inte.PreDataTimeZone;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataHelper;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataService;
import kd.wtc.wtis.business.punchcarddata.sync.PunchCardSyncService;
import kd.wtc.wtis.business.punchcarddata.sync.PunchCardSyncThreadPoolExecutor;
import kd.wtc.wtis.common.kdstring.PunchCardKDString;
import kd.wtc.wtis.common.model.punchcard.YzjAttendanceVo;
import kd.wtc.wtis.constants.punchcarddata.PunchCardSynConstants;
import kd.wtc.wtis.utils.PunchCardUtil;
import org.apache.http.entity.ContentType;

public class YzjPunchCardSyncService
extends PunchCardSyncService
implements PunchCardSynConstants {
    private static final Log LOG = LogFactory.getLog(YzjPunchCardSyncService.class);
    public static final String YZJ_URL_PREFIX_PUBLIC = "https://yunzhijia.com";
    public static final String ACCESS_TOKEN_KEY = "yzjAccessToken";
    public static final String TASK_LATEST_KEY = "taskRunLatest";

    @Override
    public void pullPunchCard(Map<String, Object> taskReqMap) {
        LOG.info("SyncYzjPunchCardTask,pullPunchCard start");
        String errMsg = this.verifyTaskRequest(taskReqMap);
        if (!HRStringUtils.isEmpty((String)errMsg)) {
            LOG.info("SyncYzjPunchCardTask,taskReqMap error[{}]", (Object)errMsg);
            throw new KDBizException(errMsg);
        }
        this.warpTaskRequest(taskReqMap);
        Object start = taskReqMap.get("startDate");
        Object end = taskReqMap.get("endDate");
        String eid = this.getEid(taskReqMap);
        if (HRStringUtils.isEmpty((String)eid)) {
            LOG.info("SyncYzjPunchCardTask,gain eid error");
            throw new KDBizException(PunchCardKDString.getEidErrTips());
        }
        String yzjUrlPrefix = this.getUrlPrefix(taskReqMap);
        if (HRStringUtils.isEmpty((String)yzjUrlPrefix)) {
            LOG.info("SyncYzjPunchCardTask,gain yzjUrlPrefix error");
            throw new KDBizException(PunchCardKDString.getUrlPrefixErrTips());
        }
        int size = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.yzj.pull.max.size", 200);
        int openIdSize = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.yzj.pull.max.openid.size", 50);
        HRBaseServiceHelper sysUser = new HRBaseServiceHelper("bos_user");
        QFilter eidFilter = new QFilter("eid", "=", (Object)Long.valueOf(eid));
        DynamicObject[] userDataArr = sysUser.query("id,useropenid", new QFilter[]{eidFilter});
        if (null == userDataArr || userDataArr.length == 0) {
            return;
        }
        HashMap<String, Long> openIdMap = new HashMap<String, Long>(userDataArr.length);
        ArrayList<String> openIds = new ArrayList<String>(userDataArr.length);
        for (DynamicObject userData : userDataArr) {
            openIdMap.put(userData.getString("useropenid"), userData.getLong("id"));
            openIds.add(userData.getString("useropenid"));
        }
        List openIdList = Lists.partition(openIds, (int)openIdSize);
        try {
            String accessToken = this.getAccessToken(taskReqMap, yzjUrlPrefix, false);
            String attendUrlStr = this.getAttendanceUrl(yzjUrlPrefix, accessToken);
            for (List subOpenIds : openIdList) {
                boolean hasNext = true;
                int index = 1;
                String subOpenIdStr = String.join((CharSequence)",", subOpenIds);
                String param = "eid=" + URLEncoder.encode(eid, "UTF-8") + "&workDateFrom=" + URLEncoder.encode((String)start, "UTF-8") + "&workDateTo=" + URLEncoder.encode((String)end, "UTF-8") + "&limit=" + URLEncoder.encode(String.valueOf(size), "UTF-8") + "&openIds=" + URLEncoder.encode(subOpenIdStr, "UTF-8");
                while (hasNext) {
                    boolean isLast;
                    if (HRStringUtils.isEmpty((String)accessToken)) {
                        LOG.warn("SyncYzjPunchCardTask,get accessToken error.");
                        hasNext = false;
                        continue;
                    }
                    ApiRequest syncRequest = new ApiRequest(HttpMethod.POST, attendUrlStr);
                    syncRequest.setContentType(ContentType.APPLICATION_FORM_URLENCODED);
                    String urlParam = param + "&start=" + URLEncoder.encode(String.valueOf(index), "UTF-8");
                    syncRequest.setPostData(urlParam);
                    Map<String, Object> map = this.pullYzjPunchCards(syncRequest, attendUrlStr, size, openIdMap);
                    boolean isError = (Boolean)map.get("error");
                    if (isError && null != map.get("errorCode")) {
                        if ((Integer)map.get("errorCode") == 0x989811) {
                            LOG.info("SyncYzjPunchCardTask,accessToken expire,start refresh");
                            accessToken = this.getAccessToken(taskReqMap, yzjUrlPrefix, true);
                            attendUrlStr = this.getAttendanceUrl(yzjUrlPrefix, accessToken);
                        }
                        LOG.info("SyncYzjPunchCardTask,pullPunchCard error,reTry start");
                        map = this.pullYzjPunchCards(syncRequest, attendUrlStr, size, openIdMap);
                    }
                    boolean bl = isLast = null == map.get("last") || (Boolean)map.get("last") != false;
                    if (isError || isLast) {
                        LOG.info("SyncYzjPunchCardTask,pullPunchCard end");
                        hasNext = false;
                        if (!isLast || !LocalDate.now().isEqual(Objects.requireNonNull(WTCDateUtils.toLocalDate((Date)WTCDateUtils.str2Date((String)((String)end), (String)"yyyy-MM-dd"))))) continue;
                        String cacheKey = WTCCacheUtils.getKey((String)"wtis", (String)TASK_LATEST_KEY);
                        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
                        redis.put(cacheKey, (Object)LocalDate.now().toString());
                        continue;
                    }
                    ++index;
                }
            }
        }
        catch (UnsupportedEncodingException exception) {
            LOG.warn("SyncYzjPunchCardTask,get pullPunchCard error.", (Throwable)exception);
        }
    }

    @Override
    public String getAccessToken(Map<String, Object> taskReqMap, String yzjUrlPrefix, boolean refresh) {
        String cacheKey;
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String accessToken = (String)redis.get(cacheKey = WTCCacheUtils.getKey((String)"wtis", (String)ACCESS_TOKEN_KEY));
        if (HRStringUtils.isNotEmpty((String)accessToken) && !refresh) {
            return accessToken;
        }
        String eid = this.getEid(taskReqMap);
        String attSecret = this.getAttSecret(taskReqMap);
        if (HRStringUtils.isEmpty((String)attSecret)) {
            LOG.warn("\u4e91\u4e4b\u5bb6\u79fb\u52a8\u7b7e\u5230\u6570\u636e\u540c\u6b65,\u83b7\u53d6\u7b7e\u5230\u6570\u636e\u5bc6\u94a5\u5931\u8d25");
            throw new KDBizException(PunchCardKDString.getAttSecretErrTips());
        }
        String accessTokenUrl = this.getAccessTokenUrl(yzjUrlPrefix);
        ApiRequest tokenRequest = new ApiRequest(HttpMethod.POST, accessTokenUrl);
        tokenRequest.setContentType(ContentType.APPLICATION_JSON);
        HashMap<String, Object> tokenParam = new HashMap<String, Object>(8);
        tokenParam.put("eid", eid);
        tokenParam.put("secret", attSecret);
        tokenParam.put("timestamp", new Date().getTime());
        tokenParam.put("scope", "resGroupSecret");
        tokenRequest.setPostData(tokenParam);
        ApiResult apiResult = ApiClientFactory.getInternal().execute(tokenRequest);
        if (!apiResult.isOk()) {
            String errorMsg = PunchCardKDString.getUrlTips((String)accessTokenUrl);
            LOG.warn(errorMsg);
            throw new KDBizException(errorMsg);
        }
        Object json = JSON.parseObject((String)apiResult.getData(), Object.class);
        if (json instanceof Map) {
            Map resultMap = (Map)json;
            if (!resultMap.get("errorCode").equals(0)) {
                String errorMsg = PunchCardKDString.postRequestTips((String)accessTokenUrl, (String)resultMap.get("description").toString());
                LOG.warn(errorMsg);
                throw new KDBizException(errorMsg);
            }
            Map data = (Map)resultMap.get("data");
            redis.put(cacheKey, (Object)data.get("accessToken").toString(), 3600, TimeUnit.SECONDS);
            return data.get("accessToken").toString();
        }
        return null;
    }

    @Override
    public String getAccessTokenUrl(String yzjUrlPrefix) {
        return yzjUrlPrefix + "/gateway/oauth2/token/getAccessToken";
    }

    private Map<String, Object> pullYzjPunchCards(ApiRequest syncRequest, String urlStr, int size, Map<String, Long> openIdMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        ApiClient.Option option = new ApiClient.Option();
        option.readTimeout = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.yzj.pull.read.timeout", 600000);
        option.connectTimeout = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.yzj.pull.connect.timeout", 120000);
        long startTime = System.currentTimeMillis();
        ApiClient client = ApiClientFactory.getInternal((ApiClient.Option)option);
        ApiResult apiResult = client.execute(syncRequest);
        long endTime = System.currentTimeMillis();
        LOG.info("SyncYzjPunchCardTask,pullYzjPunchCards,cost={}ms", (Object)(endTime - startTime));
        if (!apiResult.isOk()) {
            String errorMsg = PunchCardKDString.getUrlTips((String)urlStr);
            LOG.warn(errorMsg + ",data={},postData={}", (Object)apiResult.getData(), (Object)syncRequest.getPostData());
            result.put("error", true);
            return result;
        }
        Object json = JSON.parseObject((String)apiResult.getData(), Object.class);
        if (!(json instanceof Map)) {
            String errorMsg = PunchCardKDString.pullPunchCardTips((String)urlStr);
            LOG.warn(errorMsg + ",data={},postData={}", (Object)apiResult.getData(), (Object)syncRequest.getPostData());
            result.put("error", true);
            return result;
        }
        Map resultMap = (Map)json;
        if (!resultMap.get("errorCode").equals(200)) {
            String errorMsg = PunchCardKDString.pullPunchCardTips((String)urlStr);
            LOG.warn(errorMsg + ",errCode={},errMsg={},postData={},traceId={}", new Object[]{resultMap.get("errorCode"), resultMap.get("error"), syncRequest.getPostData(), resultMap.get("traceId")});
            result.put("error", true);
            result.put("errorCode", resultMap.get("errorCode"));
            return result;
        }
        List data = (List)resultMap.get("data");
        result.put("error", false);
        if (HRCollUtil.isEmpty((Collection)data) || data.size() < size) {
            result.put("last", true);
        } else {
            result.put("last", false);
        }
        LOG.info("SyncYzjPunchCardTask,get yzjPunchCard success,start syncPunchCards,size={}", (Object)(HRCollUtil.isEmpty((Collection)data) ? 0 : data.size()));
        this.syncPunchCards(data, openIdMap);
        return result;
    }

    public void syncPunchCards(List<Map<String, Object>> data, Map<String, Long> openIdMap) {
        if (HRCollUtil.isEmpty(data)) {
            return;
        }
        List<Map<String, Object>> punchCardList = this.verifyPunchCards(data);
        if (HRCollUtil.isEmpty(punchCardList)) {
            LOG.info("SyncYzjPunchCardTask,get yzjPunchCard success,punchCardList is empty");
            return;
        }
        List<Object> voList = this.translatePunchCardData(punchCardList);
        if (HRCollUtil.isEmpty(voList = voList.stream().filter(vo -> null != openIdMap.get(vo.getOpenId())).collect(Collectors.toList()))) {
            LOG.info("SyncYzjPunchCardTask,get yzjPunchCard success,YzjAttendanceVoList is empty");
            return;
        }
        HashSet<Long> userIds = new HashSet<Long>(voList.size());
        for (YzjAttendanceVo yzjAttendanceVo : voList) {
            long userId = openIdMap.get(yzjAttendanceVo.getOpenId());
            userIds.add(userId);
        }
        this.savePunchCards(voList, userIds, openIdMap);
    }

    private void savePunchCards(List<YzjAttendanceVo> voList, Set<Long> userIds, Map<String, Long> openIdMap) {
        HashSet<Long> personIds = new HashSet<Long>(userIds.size());
        ArrayList<Long> userIdList = new ArrayList<Long>(userIds);
        HashMap<Long, Long> userIdMap = new HashMap<Long, Long>(userIds.size());
        Map userInfo = HRPIMServiceImpl.getInstance().queryPersonInfoByUserIds(userIdList);
        if (userInfo != null && ((Boolean)userInfo.get("success")).booleanValue() && userInfo.get("data") != null) {
            Map userData = (Map)userInfo.get("data");
            for (Long userId : userIds) {
                Map data = (Map)userData.get(userId);
                if (data == null) continue;
                personIds.add((Long)data.get("person"));
                userIdMap.put(userId, (Long)data.get("person"));
            }
        }
        String queryFields = "id,boid,number,attperson.id,bsed,bsled,startdate,enddate,personnum";
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setProperties(queryFields);
        queryParam.setAttStatus(null);
        queryParam.setAttPersonSetIds(personIds);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        Set<Long> attFileBoIds = attFileList.stream().map(attFile -> attFile.getLong("boid")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> attFileMap = attFileList.stream().collect(Collectors.groupingBy(attFile -> attFile.getLong("attperson.id")));
        if (HRMapUtils.isEmpty(attFileMap)) {
            return;
        }
        String batchNumber = PunchCardUtil.getBatchNumber();
        List<DynamicObject> punchCardDys = this.genPunchCardDys(voList, attFileMap, userIdMap, openIdMap, attFileBoIds, batchNumber);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_punchcarddata");
        helper.save(punchCardDys.toArray(new DynamicObject[0]));
        try {
            long l1 = System.currentTimeMillis();
            PunchCardSyncThreadPoolExecutor.execute(() -> this.syncCardRecord(batchNumber));
            long l2 = System.currentTimeMillis();
            LOG.info("SyncYzjPunchCardTask,sync_cardData_{}ms", (Object)(l2 - l1));
        }
        catch (Exception e) {
            LOG.warn("SyncYzjPunchCardTask,sync_cardData_error ", (Throwable)e);
        }
    }

    @Override
    public void syncCardRecord(String batchNumber) {
        try {
            long l1 = System.currentTimeMillis();
            DynamicObject[] punchCardDys = PunchCardDataHelper.getDataByBatchNumber(batchNumber);
            if (null == punchCardDys || punchCardDys.length == 0) {
                return;
            }
            PunchCardDataService.dealWithData(punchCardDys);
            long l2 = System.currentTimeMillis();
            LOG.info("SyncYzjPunchCardTask,sync_cardData\uff1a{}", (Object)(l2 - l1));
        }
        catch (Exception e) {
            LOG.warn("SyncYzjPunchCardTask,sync_cardData_error", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        catch (Throwable thr) {
            LOG.warn("SyncYzjPunchCardTask,sync_cardData_thr", thr);
            throw new KDBizException(thr, new ErrorCode("", thr.getMessage()), new Object[0]);
        }
    }

    private List<DynamicObject> genPunchCardDys(List<YzjAttendanceVo> dataList, Map<Long, List<DynamicObject>> attFileMap, Map<Long, Long> userIdMap, Map<String, Long> openIdMap, Set<Long> attFileBoIds, String batchNumber) {
        AttFileScheduleQueryParam param = new AttFileScheduleQueryParam();
        param.setFileBoIdSet(attFileBoIds);
        Map attCardMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, param);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_punchcarddata");
        ArrayList<DynamicObject> punchCardDys = new ArrayList<DynamicObject>(dataList.size());
        Long uid = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        for (YzjAttendanceVo vo : dataList) {
            Date punchTime = new Date(vo.getTime());
            DynamicObject attFileDy = this.getAttFileDy(vo, attFileMap, userIdMap, openIdMap);
            if (null == attFileDy) continue;
            DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
            dynamicObject.set("number", (Object)attFileDy.getString("personnum"));
            String attCard = this.getAttCard(attFileDy.getLong("boid"), attCardMap, punchTime);
            dynamicObject.set("card", (Object)attCard);
            dynamicObject.set("punchcarddate", (Object)WTCDateUtils.str2Date((String)vo.getDay(), (String)"yyyy-MM-dd"));
            dynamicObject.set("punchcardtime", (Object)WTCDateUtils.date2Str((Date)punchTime, (String)"HH:mm:ss"));
            dynamicObject.set("timezone", (Object)PreDataTimeZone.PD_TIME_ZONE_BEIJING_ID);
            dynamicObject.set("equipment", (Object)PunchCardKDString.YzjDefaultTips());
            dynamicObject.set("equipnumber", (Object)"1010_S");
            dynamicObject.set("signsourcename", (Object)PunchCardKDString.YzjTips());
            dynamicObject.set("place", (Object)(vo.getPosition().length() > 200 ? vo.getPosition().substring(0, 200) : vo.getPosition()));
            dynamicObject.set("status", (Object)"0");
            dynamicObject.set("times", (Object)0);
            dynamicObject.set("dataid", (Object)vo.getClockId());
            dynamicObject.set("batchnumber", (Object)batchNumber);
            dynamicObject.set("signsource", (Object)"1");
            dynamicObject.set("creator", (Object)uid);
            dynamicObject.set("modifier", (Object)uid);
            dynamicObject.set("createtime", (Object)currDate);
            dynamicObject.set("modifytime", (Object)currDate);
            punchCardDys.add(dynamicObject);
        }
        return punchCardDys;
    }

    private String getAttCard(long boId, Map<Long, List<DynamicObject>> attCardMap, Date punchTime) {
        List<DynamicObject> cardEntry = attCardMap.get(boId);
        if (null == cardEntry) {
            return null;
        }
        for (DynamicObject attCard : cardEntry) {
            if (attCard.getDate("bsed") == null || attCard.getDate("bsed").compareTo(punchTime) > 0 || attCard.getDate("bsled") == null || attCard.getDate("bsled").compareTo(punchTime) < 0) continue;
            return attCard.getString(AttFileScheduleEnum.CARD.getKey());
        }
        return null;
    }

    private DynamicObject getAttFileDy(YzjAttendanceVo vo, Map<Long, List<DynamicObject>> attFileMap, Map<Long, Long> userIdMap, Map<String, Long> openIdMap) {
        long userId = openIdMap.get(vo.getOpenId());
        if (HRMapUtils.isEmpty(userIdMap) || null == userIdMap.get(userId)) {
            LOG.info("SyncYzjPunchCardTask,according openID[{}] and userID[{}] not found personID", (Object)vo.getOpenId(), (Object)userId);
            return null;
        }
        long personId = userIdMap.get(userId);
        List<DynamicObject> attFileDys = attFileMap.get(personId);
        Date punchTime = new Date(vo.getTime());
        for (DynamicObject attFileDy : attFileDys) {
            Date startDate = attFileDy.getDate("startdate");
            Date endDate = attFileDy.getDate("enddate");
            if (startDate.after(punchTime) || endDate.before(punchTime)) continue;
            return attFileDy;
        }
        return null;
    }

    private List<YzjAttendanceVo> translatePunchCardData(List<Map<String, Object>> data) {
        ArrayList<YzjAttendanceVo> list = new ArrayList<YzjAttendanceVo>(data.size());
        for (Map<String, Object> map : data) {
            Map approveResult;
            YzjAttendanceVo vo = new YzjAttendanceVo();
            vo.setClockId((String)map.get("clockId"));
            vo.setDay((String)map.get("day"));
            vo.setOpenId((String)map.get("openId"));
            vo.setTime(((Long)map.get("time")).longValue());
            vo.setClockInSource((Integer)map.get("clockInSource"));
            vo.setClockInType((String)map.get("clockInType"));
            if (7 == (Integer)map.get("clockInSource") && !HRMapUtils.isEmpty((Map)(approveResult = (Map)map.get("approveResult")))) {
                vo.setApproveStatus((String)approveResult.get("approveStatus"));
            }
            vo.setPositionResult((String)map.get("positionResult"));
            vo.setPosition((String)map.get("position"));
            list.add(vo);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> verifyPunchCards(List<Map<String, Object>> data) {
        return this.filterRepeatedData(data);
    }

    private List<Map<String, Object>> filterRepeatedData(List<Map<String, Object>> data) {
        Set externalIds = data.stream().map(map -> (String)map.get("clockId")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_punchcarddata");
        QFilter equipNoQFilter = new QFilter("equipnumber", "=", (Object)"1010_S");
        QFilter externalQFilter = new QFilter("dataid", "in", externalIds);
        DynamicObject[] result = helper.query("dataid", new QFilter[]{equipNoQFilter, externalQFilter});
        Set existIds = Arrays.stream(result).map(dy -> dy.getString("dataid")).collect(Collectors.toSet());
        LOG.info("SyncYzjPunchCardTask,RepeatedData size[{}]", (Object)existIds.size());
        return data.stream().filter(map -> !existIds.contains((String)map.get("clockId"))).collect(Collectors.toList());
    }

    @Override
    public String getUrlPrefix(Map<String, Object> taskReqMap) {
        String yzjUrl = (String)taskReqMap.get("url");
        YzjConfig yzjConfig = YzjConfigServiceHelper.getConfig();
        if (null != yzjConfig && yzjConfig.getDeploymentMode() == 1) {
            yzjUrl = YZJ_URL_PREFIX_PUBLIC;
        }
        if (HRStringUtils.isEmpty((String)yzjUrl)) {
            LOG.info("SyncYzjPunchCardTask,cannot gain yzjUrl from sys 3rd param,try to gain from private cloud");
            yzjUrl = null != yzjConfig ? yzjConfig.getUrl() : "";
        }
        return yzjUrl;
    }

    @Override
    public String getEid(Map<String, Object> taskReqMap) {
        YzjConfig yzjConfig = YzjConfigServiceHelper.getConfig();
        String eid = yzjConfig.getEid();
        if (HRStringUtils.isEmpty((String)eid)) {
            LOG.info("SyncYzjPunchCardTask,cannot gain eid from sys app param,try to gain from app task param");
            eid = (String)taskReqMap.get("eid");
        }
        return eid;
    }

    @Override
    public String getAttSecret(Map<String, Object> taskReqMap) {
        String attSecret = SystemParamQueryUtil.getPunchCardAttSecret();
        if (HRStringUtils.isEmpty((String)attSecret)) {
            LOG.info("SyncYzjPunchCardTask,cannot gain yzjUrl from sys app param,try to gain from task param");
            attSecret = (String)taskReqMap.get("secret");
        }
        return attSecret;
    }

    @Override
    public String getAttendanceUrl(String yzjUrlPrefix, String accessToken) {
        String attendanceUrl = yzjUrlPrefix + "/gateway/attendance-data/v1/clockIn/list?accessToken=%s";
        return String.format(attendanceUrl, accessToken);
    }

    @Override
    public String verifyTaskRequest(Map<String, Object> taskReqMap) {
        String start = (String)taskReqMap.get("startDate");
        String end = (String)taskReqMap.get("endDate");
        if (HRStringUtils.isEmpty((String)start) && !HRStringUtils.isEmpty((String)end) || !HRStringUtils.isEmpty((String)start) && HRStringUtils.isEmpty((String)end)) {
            return PunchCardKDString.dateErrTips();
        }
        if (!HRStringUtils.isEmpty((String)start) && !HRStringUtils.isEmpty((String)end)) {
            Date startDate = WTCDateUtils.str2Date((String)start, (String)"yyyy-MM-dd");
            Date endDate = WTCDateUtils.str2Date((String)end, (String)"yyyy-MM-dd");
            if (null == startDate || null == endDate) {
                return PunchCardKDString.dateFormatErrTips();
            }
            if (startDate.after(endDate)) {
                return PunchCardKDString.dateRangeErrTips();
            }
            int dateRange = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.yzj.dateRange.max", 5);
            if (WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) > dateRange) {
                return PunchCardKDString.dateRangeMaxErrTips((int)dateRange);
            }
        }
        return null;
    }

    @Override
    public void warpTaskRequest(Map<String, Object> taskReqMap) {
        String start = (String)taskReqMap.get("startDate");
        String end = (String)taskReqMap.get("endDate");
        if (!HRStringUtils.isEmpty((String)start) || !HRStringUtils.isEmpty((String)end)) {
            return;
        }
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String cacheKey = WTCCacheUtils.getKey((String)"wtis", (String)TASK_LATEST_KEY);
        String taskRunLast = (String)redis.get(cacheKey);
        LocalDate now = LocalDate.now();
        if (HRStringUtils.isEmpty((String)taskRunLast)) {
            taskReqMap.put("startDate", now.minusDays(1L).toString());
            taskReqMap.put("endDate", now.toString());
        } else {
            Date taskRunLastDate = WTCDateUtils.str2Date((String)taskRunLast, (String)"yyyy-MM-dd");
            if (null != taskRunLastDate && now.isEqual(WTCDateUtils.toLocalDate((Date)taskRunLastDate))) {
                taskReqMap.put("startDate", now.toString());
                taskReqMap.put("endDate", now.toString());
            }
        }
    }
}

