/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.punchcarddata.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataHelper;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataService;

public class SyncPunchCardDataTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PunchCardDataService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        PunchCardDataService punchCardDataService = PunchCardDataService.getInstance();
        punchCardDataService.dealWithTask();
        this.deleteData();
    }

    private void deleteData() {
        try {
            DynamicObject[] deleteData = PunchCardDataHelper.getDeleteData();
            if (null != deleteData && deleteData.length > 0) {
                List<Long> ids = Arrays.asList(deleteData).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                PunchCardDataHelper.deleteByPkIds(ids);
                LOG.warn("SyncPunchCardDataTask_delete_cardDate_size_{}", (Object)ids.size());
            }
        }
        catch (Exception e) {
            LOG.warn("SyncPunchCardDataTask_delete_cardDate_error_", (Throwable)e);
        }
    }
}

