/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.timingtask.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtbs.task.DispatchTaskResp;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtis.business.timingtask.gen.GenTaskErrorCode;
import kd.wtc.wtis.business.timingtask.gen.GenTaskRespImpl;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbsGenTimingTask
extends AbstractTask {
    protected static final Log log = LogFactory.getLog(AbsGenTimingTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.executeRetTaskId(requestContext, map);
    }

    protected DispatchTaskResp executeRetTaskId(RequestContext requestContext, Map<String, Object> map) {
        List<DynamicObject> attFileBos;
        DispatchTaskResp attSumTaskResp = this.beforeGenTask(requestContext, map);
        if (!attSumTaskResp.isSuccess()) {
            return attSumTaskResp;
        }
        ArrayList<DynamicObject> attFiles = new ArrayList<DynamicObject>(10);
        List<DynamicObject> adminAttFile = this.getAttFileByAdminOrgId(map);
        if (WTCCollections.isNotEmpty(adminAttFile)) {
            attFiles.addAll(adminAttFile);
        }
        if (WTCCollections.isNotEmpty(attFileBos = this.getAttFileByIds(map))) {
            attFiles.addAll(attFileBos);
        }
        if (WTCCollections.isEmpty(attFiles)) {
            return new GenTaskRespImpl(GenTaskErrorCode.ERROR_CODE_003);
        }
        int allPersonNum = (int)attFiles.stream().map(dyn -> dyn.getLong("attperson.id")).distinct().count();
        WTCTaskRequestStd request = this.getEvaluateRequest(requestContext, map);
        List personInfoList = HRAuthUtil.getAuthFieldByAttFileDynBatch(attFiles);
        request.setDetail(personInfoList);
        List subTaskDispatchReqList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)request);
        this.updateTaskInfo(map, allPersonNum, request.getTaskId());
        JobInfo mainTaskExecutorJobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo((WTCTaskRequest)request, (List)subTaskDispatchReqList);
        log.info("{} all ready to execute WTCMainTaskExecutor={}.", (Object)this.getClassName(), (Object)mainTaskExecutorJobInfo.getTaskClassname());
        ScheduleServiceHelper.dispatch((JobInfo)mainTaskExecutorJobInfo);
        return new GenTaskRespImpl(request.getTaskId());
    }

    protected DispatchTaskResp beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        return new GenTaskRespImpl();
    }

    protected String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getTaskVersion() {
        return CodeRuleServiceHelper.getNumber((String)"wtis_payatttask", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtis_payatttask"), null);
    }

    protected List<DynamicObject> getAttFileByAdminOrgId(Map<String, Object> map) {
        List<Long> adminOrgList = this.getAdminOrg(map);
        List<Long> excludeAttFileBoIds = this.excludeAttFileBoIds(map);
        if (CollectionUtils.isEmpty(adminOrgList)) {
            return Collections.emptyList();
        }
        List adminOrgAllSubList = Lists.newArrayListWithExpectedSize((int)10);
        if (!CollectionUtils.isEmpty(adminOrgList)) {
            adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        }
        if (CollectionUtils.isEmpty((Collection)adminOrgAllSubList)) {
            log.info("AttDataAddHelper.queryAttFilesByOrgRange is empty");
            return Collections.emptyList();
        }
        DynamicObject periodDyn = this.getAttPeriodDy(map);
        if (null == periodDyn) {
            log.info("AttDataAddHelper.periodDyn is empty");
            return Collections.emptyList();
        }
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setStartDate(periodDyn.getDate("begindate"));
        param.setEndDate(periodDyn.getDate("enddate"));
        if (WTCCollections.isNotEmpty(excludeAttFileBoIds)) {
            param.setBoDelSetIds(new HashSet<Long>(excludeAttFileBoIds));
        }
        param.setProperties(AttFileQueryParam.usuallyProperties + "," + "org" + "," + "usablestatus");
        Set adminAllOrgIds = adminOrgAllSubList.stream().map(adminOrg -> (Long)adminOrg.get("orgId")).collect(Collectors.toSet());
        param.setAffiliateAdminOrgSetIds(adminAllOrgIds);
        param.setAttStatus(AttStatusEnum.ATT_NORMAL);
        param.setBeCurrent(Boolean.FALSE);
        param.setOrgAuthCheck(Boolean.TRUE.booleanValue());
        param.setAppId("wtis");
        param.setFormId("wtis_payattdatainfo");
        param.setPermField("attfile");
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        return this.filterNewAttFile(attFiles);
    }

    protected List<DynamicObject> getAttFileByIds(Map<String, Object> map) {
        List<Long> attFileIds = this.getAttFileIds(map);
        if (WTCCollections.isEmpty(attFileIds)) {
            return Collections.emptyList();
        }
        DynamicObject periodDyn = this.getAttPeriodDy(map);
        AttFileQueryParam param = new AttFileQueryParam();
        param.setStartDate(periodDyn.getDate("begindate"));
        param.setEndDate(periodDyn.getDate("enddate"));
        param.setProperties(AttFileQueryParam.usuallyProperties + "," + "org" + "," + "usablestatus");
        param.setAuthCheck(Boolean.FALSE);
        param.setSetBoIds(new HashSet<Long>(attFileIds));
        param.setAttStatus(null);
        param.setBeCurrent(Boolean.FALSE);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        return this.filterNewAttFile(attFiles);
    }

    private List<DynamicObject> filterNewAttFile(List<DynamicObject> attFiles) {
        if (WTCCollections.isEmpty(attFiles)) {
            log.info("AttDataAddHelper.filterNewAttFile is empty");
            return Collections.emptyList();
        }
        Map attFileMaps = attFiles.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity(), (dyn1, dyn2) -> dyn1.getDate("bsed").getTime() >= dyn2.getDate("bsed").getTime() ? dyn1 : dyn2));
        return new ArrayList<DynamicObject>(attFileMaps.values());
    }

    public void updateTaskInfo(Map<String, Object> params, int allPersonNum, long taskId) {
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject dynamicObject = taskHelper.loadSingle((Object)taskId);
        dynamicObject.set("attperiodentry", (Object)this.getAttPeriod(params));
        dynamicObject.set("integrationrule", (Object)this.getAttGenRule(params));
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("org", (Object)this.getOrgId(params));
        dynamicObject.set("integratestatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_A);
        dynamicObject.set(AttDataIntegrateConstants.GENSTATUS, (Object)AttDataIntegrateConstants.RUNNING);
        dynamicObject.set("totalopnum", (Object)allPersonNum);
        taskHelper.updateOne(dynamicObject);
    }

    private WTCTaskRequestStd getEvaluateRequest(RequestContext context, Map<String, Object> map) {
        WTCTaskRequestStd taskRequest = new WTCTaskRequestStd();
        taskRequest.setVersion(this.getTaskVersion());
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
        paramMap.put("name", ResManager.loadKDString((String)"\u751f\u6210\u63a8\u9001\u6570\u636e", (String)"AttDataTaskProcessService_0", (String)"wtc-wtis-business", (Object[])new Object[0]));
        long orgId = this.getOrgId(map);
        if (0L != orgId) {
            RequestContext.get().setOrgId(orgId);
        }
        if (0L == (orgId = WTCBizDataPermissionServiceImpl.getInstance().getUserHasPerOrgId("wtis_payatttask", AppMetadataCache.getAppInfo((String)"wtte").getId()))) {
            orgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        }
        paramMap.put("orgid", orgId);
        map.put("orgid", orgId);
        taskRequest.setParams((Map)paramMap);
        taskRequest.setStartDate(new Date());
        taskRequest.setEndDate(new Date());
        taskRequest.setTaskId(IDService.get().genLongId());
        taskRequest.setTrial(false);
        taskRequest.setSource(WTCSource.MANUAL.code);
        taskRequest.setCreatorId(context.getCurrUserId() == 0L ? 1L : context.getCurrUserId());
        taskRequest.setCategory("wtis_payatt");
        taskRequest.setAppId("wtis");
        return taskRequest;
    }

    protected long getOrgId(Map<String, Object> paramMap) {
        Object orgId = paramMap.get("orgid");
        if (null != orgId) {
            return (Long)orgId;
        }
        return 0L;
    }

    protected List<Long> getAdminOrg(Map<String, Object> map) {
        Object adminOrg = map.get("ADMIN_ORG_ID_LIST");
        if (null == adminOrg) {
            return Collections.emptyList();
        }
        return (List)adminOrg;
    }

    protected List<Long> excludeAttFileBoIds(Map<String, Object> map) {
        Object excludeIds = map.get("EXCLUDE_FILE_LIST");
        if (null == excludeIds) {
            return Collections.emptyList();
        }
        return (List)excludeIds;
    }

    protected Long getAttPeriod(Map<String, Object> map) {
        Object period = map.get("attperiodId");
        if (null == period) {
            return null;
        }
        return (Long)period;
    }

    protected Long getAttGenRule(Map<String, Object> map) {
        Object genRule = map.get("attgenerateruleId");
        if (null == genRule) {
            return null;
        }
        return (Long)genRule;
    }

    protected List<Long> getAttFileIds(Map<String, Object> map) {
        Object attFileIds = map.get("personentity");
        if (null == attFileIds) {
            return Collections.emptyList();
        }
        return (List)attFileIds;
    }

    protected DynamicObject getAttPeriodDy(Map<String, Object> map) {
        Long attPeriod = this.getAttPeriod(map);
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        return periodHelper.loadSingle((Object)attPeriod);
    }

    protected DynamicObject getGenRuleDy(Map<String, Object> map) {
        Long ruleId = this.getAttGenRule(map);
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("wtis_integrationrule");
        return periodHelper.loadSingle((Object)ruleId);
    }
}

