/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.timingtask.gen;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.sdk.wtc.wtbs.task.DispatchTaskResp;
import kd.sdk.wtc.wtis.business.task.AttSumTaskReq;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtis.business.timingtask.gen.AbsGenTimingTask;
import kd.wtc.wtis.business.timingtask.gen.GenTaskErrorCode;
import kd.wtc.wtis.business.timingtask.gen.GenTaskRespImpl;

public class GenTaskGenerator
extends AbsGenTimingTask {
    private Map<String, Object> paramMap;

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (WTCCollections.isNotEmpty(map)) {
            try {
                this.execute(this.buildReqParam(map));
            }
            catch (Exception e) {
                throw new WTCException((Throwable)e);
            }
        }
    }

    private AttSumTaskReq buildReqParam(Map<String, Object> map) throws ParseException {
        Map orgIdMap;
        Object orgIdInfo;
        Map genRuleObj;
        Object genRule;
        Map planObj;
        Object attPeriod;
        Object excludeFile;
        Object adminOrg;
        AttSumTaskReq req = new AttSumTaskReq();
        if (null != map.get("personentity")) {
            req.setAttFileBoIds(JSONObject.parseArray((String)map.get("personentity").toString(), Long.class));
        }
        if (null != (adminOrg = map.get("ADMIN_ORG_ID_LIST"))) {
            req.setAdminOrgIds(JSONObject.parseArray((String)map.get("ADMIN_ORG_ID_LIST").toString(), Long.class));
        }
        if (null != (excludeFile = map.get("EXCLUDE_FILE_LIST"))) {
            req.setExtantFileBoIds(JSONObject.parseArray((String)map.get("EXCLUDE_FILE_LIST").toString(), Long.class));
        }
        if (null != (attPeriod = map.get("attperiodId")) && WTCStringUtils.isNotEmpty((String)attPeriod.toString()) && null != (planObj = (Map)JSONObject.parseObject((String)attPeriod.toString(), Map.class)) && null != planObj.get("id")) {
            req.setAttPeriodId(Long.parseLong(planObj.get("id").toString()));
        }
        if (null != (genRule = map.get("attgenerateruleId")) && WTCStringUtils.isNotEmpty((String)genRule.toString()) && null != (genRuleObj = (Map)JSONObject.parseObject((String)genRule.toString(), Map.class)) && null != genRuleObj.get("id")) {
            req.setGenRuleId(Long.parseLong(genRuleObj.get("id").toString()));
        }
        if (null != (orgIdInfo = map.get("orgid")) && WTCStringUtils.isNotEmpty((String)orgIdInfo.toString()) && null != (orgIdMap = (Map)JSONObject.parseObject((String)orgIdInfo.toString(), Map.class)) && null != orgIdMap.get("id")) {
            req.setOrg(Long.valueOf(Long.parseLong(orgIdMap.get("id").toString())));
        }
        return req;
    }

    private void init(AttSumTaskReq req) {
        this.paramMap = Maps.newHashMapWithExpectedSize((int)16);
        this.paramMap.put("ADMIN_ORG_ID_LIST", req.getAdminOrgIds());
        this.paramMap.put("EXCLUDE_FILE_LIST", req.getExtantFileBoIds());
        this.paramMap.put("attperiodId", req.getAttPeriodId());
        this.paramMap.put("attgenerateruleId", req.getGenRuleId());
        this.paramMap.put("personentity", req.getAttFileBoIds());
        this.paramMap.put("orgid", req.getOrg());
    }

    public DispatchTaskResp execute(AttSumTaskReq req) {
        try {
            this.init(req);
            DispatchTaskResp tieTaskResp = super.executeRetTaskId(RequestContext.get(), this.paramMap);
            log.info("TieTaskGenerator_execute_result_{}", (Object)tieTaskResp);
            return tieTaskResp;
        }
        catch (KDException e) {
            log.warn("TieTaskGenerator.execute.error", (Throwable)e);
            return new GenTaskRespImpl(e.getMessage());
        }
        catch (Exception e) {
            log.warn("TieTaskGenerator.execute.error", (Throwable)e);
            return new GenTaskRespImpl(GenTaskErrorCode.ERROR_CODE_000);
        }
    }

    @Override
    protected DispatchTaskResp beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        Long attPeriod = this.getAttPeriod(map);
        if (null == attPeriod || 0L == attPeriod) {
            return new GenTaskRespImpl(GenTaskErrorCode.ERROR_CODE_001);
        }
        DynamicObject attPeriodDy = this.getAttPeriodDy(map);
        if (null == attPeriodDy) {
            return new GenTaskRespImpl(GenTaskErrorCode.ERROR_CODE_001);
        }
        Long attGenRule = this.getAttGenRule(map);
        if (null == attGenRule || 0L == attGenRule) {
            return new GenTaskRespImpl(GenTaskErrorCode.ERROR_CODE_002);
        }
        DynamicObject ruleDy = this.getGenRuleDy(map);
        if (null == ruleDy) {
            return new GenTaskRespImpl(GenTaskErrorCode.ERROR_CODE_002);
        }
        return new GenTaskRespImpl();
    }

    @Override
    protected String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

