/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.attdataintegrate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class AttDataAddHelper {
    private static final Log logger = LogFactory.getLog(AttDataAddHelper.class);

    public static List<DynamicObject> getAttDataAddFiles(Map<String, Object> params, List<Long> attFileIds, List<Long> allPersonIds) {
        List<DynamicObject> OrgRangeList = AttDataAddHelper.queryAttFilesByOrgRange(params, allPersonIds);
        List<DynamicObject> PersonRangeList = AttDataAddHelper.queryAttFilesByPersonRange(attFileIds, allPersonIds);
        return AttDataAddHelper.remDuplicateAttFiles(OrgRangeList, PersonRangeList);
    }

    public static List<DynamicObject> queryAttFilesByOrgRange(Map<String, Object> params, List<Long> allPersonIds) {
        Object id;
        HRBaseServiceHelper periodHelper;
        DynamicObject periodDyn;
        List<Object> attFiles = new ArrayList<DynamicObject>(16);
        List orgList = (List)params.get("ORG_ID_LIST");
        List adminOrgList = (List)params.get("ADMIN_ORG_ID_LIST");
        if (CollectionUtils.isEmpty((Collection)orgList) && CollectionUtils.isEmpty((Collection)adminOrgList)) {
            return attFiles;
        }
        List excludeSet = (List)params.get("EXCLUDE_FILE_LIST");
        List orgAllSubList = Lists.newArrayListWithExpectedSize((int)10);
        List adminOrgAllSubList = Lists.newArrayListWithExpectedSize((int)10);
        Set<Object> excludeBoSet = new HashSet(10);
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            orgAllSubList = OrgServiceHelper.getAllSubordinateOrgs((String)"26", (List)orgList, (boolean)true);
        }
        if (!CollectionUtils.isEmpty((Collection)adminOrgList)) {
            adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        }
        if (CollectionUtils.isEmpty((Collection)orgAllSubList) && CollectionUtils.isEmpty((Collection)adminOrgAllSubList)) {
            logger.info("AttDataAddHelper.queryAttFilesByOrgRange is empty");
            return attFiles;
        }
        List boList = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("boid", new ArrayList(excludeSet));
        if (!CollectionUtils.isEmpty((Collection)boList)) {
            excludeBoSet = boList.stream().map(item -> item.getLong("boid")).collect(Collectors.toSet());
        }
        if (null == (periodDyn = (periodHelper = new HRBaseServiceHelper("wtp_attperiodentry")).loadSingle(id = params.get("attperiodId")))) {
            logger.info("AttDataAddHelper.periodDyn is empty");
            return attFiles;
        }
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setStartDate(periodDyn.getDate("begindate"));
        param.setEndDate(periodDyn.getDate("enddate"));
        param.setBoDelSetIds(excludeBoSet);
        param.setProperties(AttFileQueryParam.usuallyProperties + "," + "org" + "," + "usablestatus");
        if (!CollectionUtils.isEmpty((Collection)orgAllSubList)) {
            param.setOrgSetIds(new HashSet(orgAllSubList));
        }
        if (!CollectionUtils.isEmpty((Collection)adminOrgAllSubList)) {
            for (Map map : adminOrgAllSubList) {
                adminOrgList.add((Long)map.get("orgId"));
            }
            param.setAffiliateAdminOrgSetIds(new HashSet(adminOrgList));
        }
        param.setAuthCheck(Boolean.FALSE);
        param.setAttStatus(AttStatusEnum.ATT_NORMAL);
        param.setBeCurrent(Boolean.FALSE);
        logger.info("AttDataAddHelper.queryAttFilesByOrgRange,request = {}", (Object)JSON.toJSONString((Object)param));
        List allFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles((AttFileQueryParam)param);
        allPersonIds.addAll(allFiles.stream().map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet()));
        param.setOrgAuthCheck(Boolean.TRUE.booleanValue());
        param.setAppId("wtis");
        param.setFormId("wtis_payattdatainfo");
        param.setPermField("attfile");
        attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        if (WTCCollections.isNotEmpty(attFiles)) {
            Map attFileMaps = attFiles.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity(), (dyn1, dyn2) -> dyn1.getDate("bsed").getTime() >= dyn2.getDate("bsed").getTime() ? dyn1 : dyn2));
            attFiles = new ArrayList(attFileMaps.values());
        }
        logger.info("AttDataAddHelper.queryAttFilesByOrgRange,responseSize = {}", (Object)attFiles.size());
        return attFiles;
    }

    public static List<DynamicObject> queryAttFilesByPersonRange(List<Long> attFileIds, List<Long> allPersonIds) {
        List<Object> attFiles = new ArrayList<DynamicObject>(16);
        if (WTCCollections.isNotEmpty(attFileIds)) {
            AttFileQueryParam param = new AttFileQueryParam();
            param.setqFilter(new QFilter("id", "in", attFileIds));
            param.setProperties(AttFileQueryParam.usuallyProperties + "," + "org" + "," + "usablestatus");
            param.setAuthCheck(Boolean.FALSE);
            param.setAttStatus(null);
            attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
            allPersonIds.addAll(attFiles.stream().map(dyn -> dyn.getLong("attperson.id")).collect(Collectors.toSet()));
        }
        return attFiles;
    }

    public static List<DynamicObject> remDuplicateAttFiles(List<DynamicObject> OrgRangeList, List<DynamicObject> PersonRangeList) {
        HashMap<String, DynamicObject> attFilesMap = new HashMap<String, DynamicObject>(OrgRangeList.size());
        for (DynamicObject orgRange : OrgRangeList) {
            attFilesMap.put(orgRange.getString("boid"), orgRange);
        }
        for (DynamicObject personRange : PersonRangeList) {
            attFilesMap.put(personRange.getString("boid"), personRange);
        }
        ArrayList<DynamicObject> attFilesList = new ArrayList<DynamicObject>(attFilesMap.size());
        for (Map.Entry entry : attFilesMap.entrySet()) {
            attFilesList.add((DynamicObject)entry.getValue());
        }
        return attFilesList;
    }
}

