/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.attdataintegrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Transactional;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.wtc.wtis.business.attdata.BeforeSavePayAttDataInfoEvent;
import kd.sdk.wtc.wtis.business.attdata.PayAttDataInfoExtPlugin;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.common.model.AttDetailsDto;
import kd.wtc.wtis.common.model.AttFileGroupDto;
import kd.wtc.wtis.enums.WithDrawStauteEnum;

public class AttDataGenerateHelper {
    private static HRBaseServiceHelper taskDetailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
    private static HRBaseServiceHelper attDataGenerateServiceHelper = new HRBaseServiceHelper("wtis_payatttask");
    private static HRBaseServiceHelper attDataDetServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
    private static HRBaseServiceHelper payAttDataInfoHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
    private static final Log logger = LogFactory.getLog(AttDataGenerateHelper.class);

    private static Map<Long, List<DynamicObject>> attFileSort(List<DynamicObject> attFileList, String attFileSource) {
        HashMap<Long, List<DynamicObject>> attPersonMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject attFile : attFileList) {
            long attPersonId = 0L;
            if ("A".equals(attFileSource)) {
                attPersonId = attFile.getLong("attperson.id");
            } else if ("C".equals(attFileSource)) {
                attPersonId = attFile.getLong("attperson");
            }
            List<DynamicObject> attFileByPerson = attPersonMap.get(attPersonId) == null ? new ArrayList(10) : (List)attPersonMap.get(attPersonId);
            attFileByPerson.add(attFile);
            attPersonMap.put(attPersonId, attFileByPerson);
        }
        return attPersonMap;
    }

    public static DynamicObject updateAttDataGenerate(DynamicObject attDataGenerate, Map<Long, List<DynamicObject>> attPersonMap, WTCCalSubTaskEntity subTask) {
        int genSuccessNumCount = 0;
        int genSuccessFlag = 0;
        int genFailNumCount = 0;
        boolean isGenFail = false;
        Set<Map.Entry<Long, List<DynamicObject>>> attPersonEntries = attPersonMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> attPersonEntry : attPersonEntries) {
            List<DynamicObject> attFileByPerson = attPersonEntry.getValue();
            for (DynamicObject attFile : attFileByPerson) {
                String generStatus = attFile.getString("generstatus");
                if ("0".equals(generStatus)) {
                    isGenFail = true;
                    continue;
                }
                if (!"1".equals(generStatus)) continue;
                ++genSuccessFlag;
            }
            if (isGenFail) {
                ++genFailNumCount;
            }
            if (!isGenFail && genSuccessFlag > 0) {
                ++genSuccessNumCount;
            }
            isGenFail = false;
            genSuccessFlag = 0;
        }
        int allGenExNum = attDataGenerate.getInt("totalattperson");
        attDataGenerate.set("runattperson", (Object)(genSuccessNumCount + genFailNumCount));
        attDataGenerate.set("succeedattperson", (Object)genSuccessNumCount);
        attDataGenerate.set("failedattperson", (Object)genFailNumCount);
        attDataGenerate.set("notrunattperson", (Object)(allGenExNum - genSuccessNumCount - genFailNumCount));
        AttDataGenerateHelper.setAttFileNum(attPersonMap, attDataGenerate, subTask);
        subTask.setSucceedAttPerson(genSuccessNumCount);
        subTask.setFailedAttPerson(genFailNumCount);
        subTask.setRunAttPerson(subTask.getSucceedAttPerson() + subTask.getFailedAttPerson());
        subTask.setNotRunAttPerson(allGenExNum - genSuccessNumCount - genFailNumCount);
        boolean success = WTCTaskStateTransfer.transferToSpecialStateSub((Long)subTask.getId(), (Long)subTask.getTaskId(), (WTCSubTaskEntity)subTask, (String)"wtis_payatt");
        if (!success) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u72b6\u6001\u5f02\u5e38\u3002", (String)"TieExporterStdImpl_8", (String)"wtc-wtis-business", (Object[])new Object[0]));
        }
        return attDataGenerate;
    }

    private static void setAttFileNum(Map<Long, List<DynamicObject>> attPersonMap, DynamicObject attDataGenerate, WTCCalSubTaskEntity subTask) {
        HashMap<Long, List<DynamicObject>> boid2Files = new HashMap<Long, List<DynamicObject>>();
        Collection<List<DynamicObject>> values = attPersonMap.values();
        for (List<DynamicObject> value : values) {
            Map<Long, List<DynamicObject>> boid2PartFiles = value.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("attfileboid.id")));
            boid2Files.putAll(boid2PartFiles);
        }
        int genSuccessNumCount = 0;
        int genSuccessFlag = 0;
        int genFailNumCount = 0;
        boolean isGenFail = false;
        Set entries = boid2Files.entrySet();
        for (Map.Entry entry : entries) {
            List attFileByPerson = (List)entry.getValue();
            for (DynamicObject attFile : attFileByPerson) {
                String generStatus = attFile.getString("generstatus");
                if ("0".equals(generStatus)) {
                    isGenFail = true;
                    continue;
                }
                if (!"1".equals(generStatus)) continue;
                ++genSuccessFlag;
            }
            if (isGenFail) {
                ++genFailNumCount;
            }
            if (!isGenFail && genSuccessFlag > 0) {
                ++genSuccessNumCount;
            }
            isGenFail = false;
            genSuccessFlag = 0;
        }
        int allGenExNum = attDataGenerate.getInt("totalattfile");
        subTask.setSucceedAttFile(genSuccessNumCount);
        subTask.setFailedAttFile(genFailNumCount);
        subTask.setRunAttFile(subTask.getSucceedAttFile() + subTask.getFailedAttFile());
        subTask.setNotRunAttFile(allGenExNum - genSuccessNumCount - genFailNumCount);
    }

    public static void updateAllAttDataGenerates(List<DynamicObject> detailDyns, DynamicObject subTaskDyn, WTCCalSubTaskEntity subTask) {
        Map<Long, List<DynamicObject>> attPersonMap = AttDataGenerateHelper.attFileSort(detailDyns, "A");
        AttDataGenerateHelper.updateAttDataGenerate(subTaskDyn, attPersonMap, subTask);
    }

    public static void updateAttDataStatus(List<String> numberList, String status) {
        DynamicObject[] attDataGenerates;
        QFilter filter = new QFilter("number", "in", numberList);
        for (DynamicObject attDataGenerate : attDataGenerates = attDataGenerateServiceHelper.loadDynamicObjectArray(filter.toArray())) {
            attDataGenerate.set("status", (Object)status);
        }
        attDataGenerateServiceHelper.update(attDataGenerates);
    }

    public static void updateAttDataStatus(String status, Long taskId) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject attDataGenerate = attDataGenerateServiceHelper.loadDynamicObject(filter);
        attDataGenerate.set("taskstatus", (Object)status);
        attDataGenerate.set(AttDataIntegrateConstants.GENSTATUS, (Object)AttDataIntegrateConstants.ERROR);
        attDataGenerateServiceHelper.updateOne(attDataGenerate);
    }

    public static void updateAttDataIntegrate(Long taskId) {
        AttDataGenerateHelper.updateAttDataIntegrate(taskId, null, null);
    }

    public static void updateAttDataIntegrate(Long taskId, Long pushTimeMillis, Date pushDate) {
        DynamicObject attDataGenerate = AttDataGenerateHelper.builtAttDataGenerate(taskId, pushTimeMillis, pushDate);
        if (attDataGenerate == null) {
            return;
        }
        attDataGenerateServiceHelper.updateOne(attDataGenerate);
    }

    private static DynamicObject builtAttDataGenerate(Long taskId, Long pushTimeMillis, Date pushDate) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject attDataGenerate = attDataGenerateServiceHelper.loadDynamicObject(filter);
        QFilter attDataFilter = new QFilter("taskid", "=", (Object)taskId);
        attDataFilter.and(new QFilter("generstatus", "=", (Object)"1"));
        DynamicObject[] attDataDets = attDataDetServiceHelper.queryOriginalArray("integrstatus,attperson", attDataFilter.toArray());
        ArrayList<DynamicObject> attDataDetList = new ArrayList<DynamicObject>(10);
        Collections.addAll(attDataDetList, attDataDets);
        Map<Long, List<DynamicObject>> attPersonMap = AttDataGenerateHelper.attFileSort(attDataDetList, "C");
        int inSuccessNumCount = 0;
        int inSuccessFlag = 0;
        int inFailNumCount = 0;
        boolean isInFail = false;
        boolean isInEct = false;
        int inWithDrawNumCount = 0;
        int inWithDrawNumFlag = 0;
        int notInNum = 0;
        Set<Map.Entry<Long, List<DynamicObject>>> attPersonEntries = attPersonMap.entrySet();
        boolean existPushIngStatue = false;
        for (Map.Entry<Long, List<DynamicObject>> attPersonEntry : attPersonEntries) {
            List<DynamicObject> attFileByPerson = attPersonEntry.getValue();
            for (DynamicObject attFile : attFileByPerson) {
                String integrStatus = attFile.getString("integrstatus");
                if (WTCStringUtils.equals((String)integrStatus, (String)"0") || WTCStringUtils.equals((String)integrStatus, (String)"1")) {
                    existPushIngStatue = true;
                }
                if ("3".equals(integrStatus)) {
                    isInFail = true;
                } else if ("2".equals(integrStatus) || "4".equals(integrStatus)) {
                    ++inSuccessFlag;
                } else if ("6".equals(integrStatus)) {
                    isInEct = true;
                }
                if (!"5".equals(integrStatus)) continue;
                ++inWithDrawNumFlag;
            }
            if (isInFail) {
                ++inFailNumCount;
            }
            if (isInEct) {
                ++notInNum;
            }
            if (inSuccessFlag == attFileByPerson.size()) {
                ++inSuccessNumCount;
            }
            if (inWithDrawNumFlag == attFileByPerson.size()) {
                ++inWithDrawNumCount;
            }
            isInFail = false;
            isInEct = false;
            inSuccessFlag = 0;
            inWithDrawNumFlag = 0;
        }
        int allInExNum = attDataGenerate.getInt("allinexnum");
        attDataGenerate.set("inexnum", (Object)(inSuccessNumCount + inFailNumCount));
        attDataGenerate.set("insuccessnum", (Object)inSuccessNumCount);
        attDataGenerate.set("infailnum", (Object)inFailNumCount);
        attDataGenerate.set("inwithdrawnum", (Object)inWithDrawNumCount);
        attDataGenerate.set("notinexnum", (Object)notInNum);
        if (pushDate != null) {
            attDataGenerate.set(AttDataIntegrateConstants.LAST_PUSH_TIME, (Object)pushDate);
        }
        if (inWithDrawNumCount != 0) {
            if (inSuccessNumCount == 0) {
                attDataGenerate.set("withdrawstatus", (Object)WithDrawStauteEnum.ALL.getCode());
            } else {
                attDataGenerate.set("withdrawstatus", (Object)WithDrawStauteEnum.PARTIALLY.getCode());
            }
        } else {
            attDataGenerate.set("withdrawstatus", (Object)" ");
        }
        if (!existPushIngStatue) {
            attDataGenerate.set("integratestatus", (Object)"C");
            attDataGenerate.set(AttDataIntegrateConstants.INTEGRATEBUSSTATUS, (Object)SeeAttDataHelper.getInstance().getStatusByNums(inSuccessNumCount, inFailNumCount + notInNum, 0));
            Long pushTime = pushTimeMillis;
            if (pushTime == null) {
                pushTime = attDataGenerate.getLong("inconsumetime");
            }
            if (pushTime > System.currentTimeMillis() - 86400000L) {
                attDataGenerate.set("inconsumetime", (Object)(System.currentTimeMillis() - pushTime));
            }
        }
        return attDataGenerate;
    }

    public static void showDetailPage(Map<String, Object> paramHashMap, String formId, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        if ("wtis_seeattcreatedata".equals(formId)) {
            showParameter.setCaption(IntegrationKDString.seeCreateDate((String)((String)paramHashMap.get("version"))));
        } else if ("wtis_seeattintegrdata".equals(formId)) {
            showParameter.setCaption(IntegrationKDString.seeIntDate((String)((String)paramHashMap.get("version"))));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(paramHashMap);
        if (paramHashMap.get("id") != null) {
            showParameter.setPageId(view.getPageId() + paramHashMap.get("id"));
        }
        view.showForm(showParameter);
    }

    public static DynamicObject[] getAttFileIdByFilter(Long taskId, QFilter filter) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("taskid", "=", (Object)taskId));
        if (null != filter) {
            qFilters.add(filter);
        }
        return attDataDetServiceHelper.loadDynamicObjectArray(qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] getGenerateAttDataByNumber(String number) {
        QFilter filter = new QFilter("number", "in", (Object)number);
        return attDataGenerateServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    @Transactional
    public static List<DynamicObject> generateAttDetailDataNew(DynamicObject taskDyn, List<AttFileGroupDto> attFileGroupDtos, BeforeSavePayAttDataInfoEvent extPlugin, Map<Long, Long> attFileBoId2DetailId, Long subTaskId, Long orgid, String attPeriodName) {
        DynamicObject[] taskDetails;
        ArrayList attFileVersionDoList = new ArrayList(attFileGroupDtos.size());
        String version = taskDyn.getString("version");
        Long integrationrule = taskDyn.getLong("integrationrule.id");
        Long attperiodentry = taskDyn.getLong("attperiodentry.id");
        List<Long> attFileIds = attFileGroupDtos.stream().map(AttFileGroupDto::getAttfileid).collect(Collectors.toList());
        List<Long> existAttFileIdList = AttDataGenerateHelper.loadAttEditionDetData(integrationrule, attperiodentry, attFileIds);
        logger.info("AttDataGenerate existAttFileIdList : {}", existAttFileIdList);
        ArrayList<Long> needFailId = new ArrayList<Long>(attFileGroupDtos.size());
        HashMap<Long, String> notExcuteId2Msg = new HashMap<Long, String>(attFileGroupDtos.size());
        for (AttFileGroupDto attFile : attFileGroupDtos) {
            List attDetails = attFile.getAttDetails();
            int index = 0;
            if (WTCCollections.isNotEmpty((Collection)attDetails)) {
                ArrayList<DynamicObject> attFileVersionCheckList = new ArrayList<DynamicObject>(attDetails.size());
                if (2 == attFile.getStatus()) {
                    notExcuteId2Msg.put(attFileBoId2DetailId.get(attFile.getAttfileid()), attFile.getMsg());
                    continue;
                }
                long[] ids = AttDataGenerateHelper.getIds(attDetails);
                for (AttDetailsDto attDetail : attDetails) {
                    if (existAttFileIdList.contains(attFile.getAttfileid())) {
                        needFailId.add(attFileBoId2DetailId.get(attFile.getAttfileid()));
                        continue;
                    }
                    DynamicObject attFileDetailData = payAttDataInfoHelper.generateEmptyDynamicObject();
                    Long id = ids[index++];
                    attFileDetailData.set("taskdetail", (Object)attFileBoId2DetailId.get(attFile.getAttfileid()));
                    AttDataGenerateHelper.packageAttFileDetailData(version, integrationrule, attperiodentry, attFile, attDetail, attFileDetailData, id);
                    attFileVersionCheckList.add(attFileDetailData);
                }
                if (attFileVersionCheckList.isEmpty()) continue;
                attFileVersionDoList.addAll(attFileVersionCheckList);
                continue;
            }
            if (2 == attFile.getStatus()) {
                notExcuteId2Msg.put(attFileBoId2DetailId.get(attFile.getAttfileid()), attFile.getMsg());
                continue;
            }
            notExcuteId2Msg.put(attFileBoId2DetailId.get(attFile.getAttfileid()), IntegrationKDString.notResultError((String)attPeriodName));
        }
        Set<Long> discardEpRelBoIds = AttDataGenerateHelper.getDiscardEpRelBoIds(attFileBoId2DetailId.keySet(), taskDyn);
        Set discardDetailIds = discardEpRelBoIds.stream().map(attFileBoId2DetailId::get).collect(Collectors.toSet());
        try {
            for (DynamicObject taskDetail : taskDetails = taskDetailHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("subtaskid", "=", (Object)subTaskId)})) {
                if (needFailId.contains(taskDetail.getLong("id"))) {
                    taskDetail.set("taskdetailstate", (Object)WTCTaskDetailStatus.NOT_ACCOUNT.getCode());
                    taskDetail.set("exinfo", (Object)ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u751f\u6210", (String)"AttDataGenerateHelper_3", (String)"wtc-wtis-business", (Object[])new Object[0]));
                    taskDetail.set("generstatus", (Object)AttDataIntegrateConstants.GENSTATU_TWO);
                    taskDetail.set(AttDataIntegrateConstants.INTEGR_DOWN, (Object)Boolean.FALSE);
                } else if (notExcuteId2Msg.get(taskDetail.getLong("id")) != null) {
                    taskDetail.set("taskdetailstate", (Object)WTCTaskDetailStatus.NOT_ACCOUNT.getCode());
                    taskDetail.set("exinfo", notExcuteId2Msg.get(taskDetail.getLong("id")));
                    taskDetail.set("generstatus", (Object)AttDataIntegrateConstants.GENSTATU_TWO);
                    taskDetail.set(AttDataIntegrateConstants.INTEGR_DOWN, (Object)Boolean.FALSE);
                } else {
                    taskDetail.set("taskdetailstate", (Object)WTCTaskDetailStatus.SUCCESS.getCode());
                    taskDetail.set("generstatus", (Object)AttDataIntegrateConstants.GENSTATU_ONE);
                    taskDetail.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_ZERO);
                    if (discardDetailIds.contains(taskDetail.getLong("id"))) {
                        taskDetail.set("exinfo", (Object)IntegrationKDString.discardEmpPosRel());
                    }
                    taskDetail.set(AttDataIntegrateConstants.INTEGR_DOWN, (Object)Boolean.TRUE);
                }
                taskDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
                taskDetail.set("org", (Object)orgid);
            }
            if (!attFileVersionDoList.isEmpty()) {
                extPlugin.setPayAttDataInfoList(Collections.unmodifiableList(attFileVersionDoList));
                AttDataGenerateHelper.beforeSavePayAttDataInfo(extPlugin);
                List payAttDataInfoList = extPlugin.getPayAttDataInfoList();
                if (WTCCollections.isNotEmpty((Collection)payAttDataInfoList)) {
                    payAttDataInfoHelper.save(payAttDataInfoList.toArray(new DynamicObject[0]));
                }
            }
            taskDetailHelper.update(taskDetails);
        }
        catch (Exception e) {
            logger.error("AttDataGenerate Fail Numbers : {}", (Object)version, (Object)e);
            throw e;
        }
        return Arrays.asList(taskDetails);
    }

    public static void packageAttFileDetailData(String number, Long integrationrule, Long attperiodentry, AttFileGroupDto attFile, AttDetailsDto attDetail, DynamicObject attFileDetailData, Long id) {
        attFileDetailData.set("id", (Object)id);
        attFileDetailData.set("number", (Object)number);
        attFileDetailData.set("integrationrule", (Object)integrationrule);
        attFileDetailData.set("attperiodentry", (Object)attperiodentry);
        attFileDetailData.set("datatype", (Object)0);
        attFileDetailData.set("generstatus", (Object)attFile.getStatus());
        attFileDetailData.set("attfilebase", (Object)attFile.getAttfileid());
        attFileDetailData.set("attfile", (Object)attDetail.getAttFileId());
        attFileDetailData.set("idcode", (Object)("WTC_" + id));
        attFileDetailData.set("attitem", (Object)attDetail.getAttItemId());
        attFileDetailData.set("value", (Object)attDetail.getValue());
        attFileDetailData.set("valuestr", (Object)attDetail.getValue().toPlainString());
        attFileDetailData.set("perperiodbegindate", (Object)attDetail.getSumBeginDate());
        attFileDetailData.set("perperiodenddate", (Object)attDetail.getSumEndDate());
        attFileDetailData.set("perperiodenddate", (Object)attDetail.getSumEndDate());
        attFileDetailData.set("owndate", (Object)attDetail.getOwnDate());
        attFileDetailData.set("datasource", (Object)attDetail.getDataType());
        attFileDetailData.set("sealopertime", (Object)attDetail.getStorageDate());
        attFileDetailData.set("settleinfo", (Object)attDetail.getSettleInfoId());
        attFileDetailData.set("creator", (Object)RequestContext.get().getCurrUserId());
    }

    public static List<Long> loadAttEditionDetData(Long integrationrule, Long attperiodentry, List<Long> attFileIds) {
        QFilter q1 = new QFilter("integrationrule.id", "=", (Object)integrationrule);
        QFilter q2 = new QFilter("attperiodentry.id", "=", (Object)attperiodentry);
        QFilter q3 = new QFilter("attfilebase.boid", "in", attFileIds);
        QFilter q4 = new QFilter("generstatus", "=", (Object)"1");
        QFilter q5 = new QFilter("integrstatus", "!=", (Object)"3").and("integrstatus", "!=", (Object)"5").and("integrstatus", "!=", (Object)"4");
        DynamicObject[] existList = payAttDataInfoHelper.loadDynamicObjectArray(new QFilter[]{q1, q2, q3, q4, q5});
        return Arrays.stream(existList).map(obj -> obj.getLong("attfilebase.id")).collect(Collectors.toList());
    }

    private static long[] getIds(List<AttDetailsDto> attDetails) {
        return ORM.create().genLongIds("wtis_atteditiondet", attDetails.size());
    }

    public static void deleteAttEditionDetByNumber(Long taskId) {
        Map<Long, List<Long>> detailIdsByTaskIds = SeeAttDataHelper.getInstance().getDetailIdsByTaskIds(Collections.singletonList(taskId));
        Set<Long> detailIds = detailIdsByTaskIds.keySet();
        QFilter deleteFilterTaskDetailData = new QFilter("taskdetail", "in", detailIds);
        payAttDataInfoHelper.deleteByFilter(deleteFilterTaskDetailData.toArray());
    }

    public static void rollBackDataByNumber(Long taskId) {
        AttDataGenerateHelper.deleteAttEditionDetByNumber(taskId);
        logger.info("AttDataGenerate deleteAttEditionDetByNumber version : {}", (Object)taskId);
        AttDataGenerateHelper.updateAttDataStatus(WTCTaskStatus.ALL_FINISHED.getCode(), taskId);
    }

    public static void updateAttDataIntegrateState(String attDataNumber, String state, Long pushTimeMillis) {
        QFilter filter = new QFilter("version", "=", (Object)attDataNumber);
        DynamicObject attDataGenerate = attDataGenerateServiceHelper.loadDynamicObject(filter);
        attDataGenerate.set("integratestatus", (Object)state);
        if (pushTimeMillis == null) {
            attDataGenerate.set("inconsumetime", (Object)System.currentTimeMillis());
        } else {
            attDataGenerate.set("inconsumetime", (Object)pushTimeMillis);
        }
        attDataGenerate.set(AttDataIntegrateConstants.LAST_PUSH_TIME, (Object)HRDateTimeUtils.getNowDateTime());
        attDataGenerate.set(AttDataIntegrateConstants.INTEGRATEBUSSTATUS, (Object)AttDataIntegrateConstants.RUNNING);
        attDataGenerateServiceHelper.updateOne(attDataGenerate);
    }

    public static List<Long> checkPermission(List<Long> attFileIds) {
        AttFileF7QueryParam param = new AttFileF7QueryParam(false);
        param.setOrgAuthCheck(true);
        param.setAppId("wtis");
        param.setFormId("wtis_payattdatainfo");
        param.setPermField("attfile");
        param.setSetBoIds(new HashSet<Long>(attFileIds));
        param.setProperties("id,boid");
        param.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        return attFiles.stream().map(dynamicObject -> dynamicObject.getLong("boid")).collect(Collectors.toList());
    }

    public static boolean hasOpPerm(String formId, String permItemId, Object pkId) {
        String bizAppNumber;
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)userId, (String)(bizAppNumber = FormMetadataCache.getFormConfig((String)formId).getAppId()), (String)formId, (String)permItemId);
        if (hasPerm && pkId != null) {
            QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", pkId)};
            hasPerm = PermissionServiceHelper.matchDataRule((long)userId, (String)bizAppNumber, (String)formId, (String)permItemId, (QFilter[])qfilters);
        }
        return hasPerm;
    }

    private static void beforeSavePayAttDataInfo(BeforeSavePayAttDataInfoEvent event) {
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(PayAttDataInfoExtPlugin.class, (String)AttDataIntegrateConstants.ATT_DATA_EX);
        pluginProxy.invokeReplace(instance -> instance.beforeSavePayAttDataInfo(event));
    }

    private static Set<Long> getDiscardEpRelBoIds(Set<Long> attFileBoIds, DynamicObject taskDyn) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam(false);
        attFileQueryParam.setSetBoIds(attFileBoIds);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setOrgAuthCheck(false);
        attFileQueryParam.setStartDate(taskDyn.getDate("attperiodentry.begindate"));
        attFileQueryParam.setEndDate(taskDyn.getDate("attperiodentry.enddate"));
        attFileQueryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{"id", "empposorgrel.datastatus", "boid"}));
        List attFileDyList = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        if (WTCCollections.isNotEmpty((Collection)attFileDyList)) {
            return attFileDyList.stream().filter(dyn -> "-1".equals(dyn.getString("empposorgrel.datastatus"))).map(dyn -> dyn.getLong("boid")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

