/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.attdataintegrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.helper.BizDataFailStatusEnum;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.enums.WithDrawResultEnum;

public class AttDataIntegrateHelper {
    private static final Log LOGGER = LogFactory.getLog(AttDataIntegrateHelper.class);
    private final HRBaseServiceHelper ATTDATA_TASKDETAIL_HELPER = new HRBaseServiceHelper("wtis_payatttaskdetail");
    private final HRBaseServiceHelper ATTDATA_DATAINFO_HELPER = new HRBaseServiceHelper("wtis_payattdatainfo");
    private static final String SYSNOTICE = "sysnotice";

    public static AttDataIntegrateHelper getInstance() {
        return Instance.INSTANCE;
    }

    public Map<String, List<Long>> recallAttRecord(String version, List<Long> attfile, Long taskId, String sessionId) {
        if (WTCStringUtils.isEmpty((String)version) || WTCCollections.isEmpty(attfile)) {
            return null;
        }
        HashMap<String, Object> recallRequest = new HashMap<String, Object>(16);
        recallRequest.put("version", version);
        recallRequest.put(AttDataIntegrateConstants.ATTFILE, attfile);
        recallRequest.put(AttDataIntegrateConstants.SESSION_ID, sessionId);
        LOGGER.info("AttDataGenerate recallAttRecord recallRequest :{}", recallRequest);
        long startTime = System.currentTimeMillis();
        Map recallResponse = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)AttDataIntegrateConstants.HSAS, (String)AttDataIntegrateConstants.IATTINTEG_SERVICE, (String)"batchWithdrawAttBizData", (Object[])new Object[]{recallRequest});
        long endTime = System.currentTimeMillis();
        LOGGER.debug("AttDataGenerate batchWithdrawAttBizData cost time:{}", (Object)(endTime - startTime));
        if (recallResponse == null) {
            LOGGER.debug("AttDataGenerate recallAttRecord recallResponse is null");
            return null;
        }
        LOGGER.info("AttDataGenerate recallAttRecord recallResponse :{}", (Object)recallResponse);
        Map data = (Map)recallResponse.get(AttDataIntegrateConstants.DATA);
        if (CollectionUtils.isEmpty((Map)data)) {
            return Collections.emptyMap();
        }
        List successfileid = (List)data.get(AttDataIntegrateConstants.SUCCESSFILE_IDS);
        if (WTCCollections.isEmpty((Collection)successfileid)) {
            successfileid = Lists.newArrayListWithExpectedSize((int)attfile.size());
        }
        List failFileList = (List)data.get("errorinfo");
        HashMap failMap = Maps.newHashMapWithExpectedSize((int)attfile.size());
        if (!CollectionUtils.isEmpty((Collection)failFileList)) {
            failMap = Maps.newHashMapWithExpectedSize((int)failFileList.size());
            for (Map entry : failFileList) {
                if (WTCCollections.isEmpty((Map)entry)) continue;
                List attFiles = failMap.computeIfAbsent((Long)entry.get("attfileid"), key -> new ArrayList());
                List errorCodes = (List)entry.get("errorcodes");
                if (CollectionUtils.isEmpty((Collection)errorCodes)) continue;
                attFiles.addAll(errorCodes);
            }
        }
        ArrayList taskDetailUpdateList = Lists.newArrayListWithExpectedSize((int)attfile.size());
        ArrayList taskDataInfoUpdateList = Lists.newArrayListWithExpectedSize((int)attfile.size());
        this.setWithDrawRecordState(taskId, successfileid, failMap, taskDetailUpdateList);
        this.setRecordStateEditiondet(version, successfileid, AttDataIntegrateConstants.INTEGRATESTATU_FIVE, taskDataInfoUpdateList);
        this.saveTaskDetail(taskDetailUpdateList);
        this.saveTaskDataInfo(taskDataInfoUpdateList);
        HashMap recallMap = Maps.newHashMapWithExpectedSize((int)16);
        recallMap.put(AttDataIntegrateConstants.SUCCESSFILE_IDS, successfileid);
        recallMap.put(AttDataIntegrateConstants.ERRORFILE_IDS, Lists.newArrayList(failMap.keySet()));
        LOGGER.debug("AttDataGenerate recallAttRecord cost time:{}", (Object)(System.currentTimeMillis() - endTime));
        return recallMap;
    }

    public void attDataIntegratePush(String version, int fileQuantity, long creatorId, Long pushTimeMillis, String dataType) {
        LOGGER.info("AttDataGenerate attDataIntegratePush version:{}, fileQuantity:{}, creatorId:{},dataType:{}", new Object[]{version, fileQuantity, creatorId, dataType});
        AttDataGenerateHelper.updateAttDataIntegrateState(version, "B", pushTimeMillis);
        HashMap<String, Object> publisherMap = new HashMap<String, Object>();
        publisherMap.put("version", version);
        publisherMap.put("fileQuantity", fileQuantity);
        publisherMap.put("creatorId", creatorId);
        publisherMap.put("dataType", dataType);
        Map resMap = (Map)WTCServiceHelper.invokeBizService((String)"swc", (String)AttDataIntegrateConstants.HSAS, (String)AttDataIntegrateConstants.IATTINTEG_SERVICE, (String)"pushAttData", (Object[])new Object[]{publisherMap});
        this.setGlobalAttRecordState(resMap, version);
    }

    private void setGlobalAttRecordState(Map<String, Object> recordState, String version) {
        if (recordState == null) {
            LOGGER.info("AttDataGenerate SalaryIntegrationService setGlobalAttRecordState recordState is null");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttDataGenerate SalaryIntegrationService setGlobalAttRecordState recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        }
        if (WTCStringUtils.isEmpty((String)version)) {
            return;
        }
        Boolean status = (Boolean)recordState.get("success");
        if (status != null && !status.booleanValue()) {
            String reasonCode = (String)recordState.get("errorCode");
            Long taskId = SeeAttDataHelper.getInstance().getTaskIdByVersion(version);
            this.setGlobalRecordFailStateWithId(reasonCode, taskId, version);
            AttDataGenerateHelper.updateAttDataIntegrate(taskId);
        }
    }

    public void sendGenerateMessage(DynamicObject[] dynamicObjects) {
    }

    private String getVersions(DynamicObject[] dynamicObjects) {
        List versions = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getString("version")).collect(Collectors.toList());
        return String.join((CharSequence)",", versions);
    }

    public int getPropertyCount(DynamicObject[] dynamicObjects, String property) {
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getInt(property)).reduce(0, Integer::sum);
    }

    public void setRecordState(Long taskId, List<Long> fileId, String integerStatus, List<DynamicObject> taskDetailUpdateList) {
        DynamicObject[] taskDetails;
        if (taskId == 0L || WTCCollections.isEmpty(fileId)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("AttDataGenerate setRecordState taskId:{}, fileId:{}, integerStatus:{}", new Object[]{taskId, SerializationUtils.toJsonString(fileId), integerStatus});
        }
        QFilter qFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter qFilter2 = new QFilter("attfileboid", "in", fileId);
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2};
        for (DynamicObject taskDetail : taskDetails = this.ATTDATA_TASKDETAIL_HELPER.query(WTCStringUtils.joinOnComma((String[])new String[]{"id", "integrstatus"}), filters)) {
            taskDetail.set("integrstatus", (Object)integerStatus);
            taskDetailUpdateList.add(taskDetail);
        }
    }

    private void setWithDrawRecordState(Long taskId, List<Long> successfileId, Map<Long, List<String>> failfileMap, List<DynamicObject> taskDetailUpdateList) {
        DynamicObject[] taskDetailList;
        ArrayList allAttfileIds;
        if (taskId == 0L || WTCCollections.isEmpty(successfileId) && WTCCollections.isEmpty(failfileMap)) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("AttDataGenerate setRecordState taskId:{}, successfileId:{}, failfileId:{}", new Object[]{taskId, SerializationUtils.toJsonString(successfileId), failfileMap});
        }
        if (!CollectionUtils.isEmpty(failfileMap)) {
            allAttfileIds = Lists.newArrayListWithExpectedSize((int)(successfileId.size() + failfileMap.size()));
            allAttfileIds.addAll(failfileMap.keySet());
            allAttfileIds.addAll(successfileId);
        } else {
            allAttfileIds = Lists.newArrayListWithExpectedSize((int)successfileId.size());
            allAttfileIds.addAll(successfileId);
        }
        QFilter qFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter qFilter2 = new QFilter("attfileboid", "in", (Object)allAttfileIds);
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2};
        DynamicObject[] taskDetails = this.ATTDATA_TASKDETAIL_HELPER.queryOriginalArray(WTCStringUtils.joinOnComma((String[])new String[]{"id", "attfileboid"}), filters);
        if (taskDetails == null || taskDetails.length == 0) {
            return;
        }
        Map<Long, Long> detailMap = Arrays.stream(taskDetails).collect(Collectors.toMap(ob -> ob.getLong("id"), entry -> entry.getLong("attfileboid")));
        for (DynamicObject taskDetail : taskDetailList = this.ATTDATA_TASKDETAIL_HELPER.query(WTCStringUtils.joinOnComma((String[])new String[]{"id", "integrstatus", "withdrawresult", "withdrawexinfo"}), filters)) {
            Long attfileBid = detailMap.get(taskDetail.get("id"));
            List<String> errorMsgList = failfileMap.get(attfileBid);
            if (!CollectionUtils.isEmpty(errorMsgList)) {
                taskDetail.set("withdrawresult", (Object)WithDrawResultEnum.FAIL.getCode());
                taskDetail.set("withdrawexinfo", (Object)WTCStringUtils.join(errorMsgList, (String)","));
            } else {
                taskDetail.set("withdrawresult", (Object)WithDrawResultEnum.SUCCESS.getCode());
                taskDetail.set("withdrawexinfo", (Object)" ");
                taskDetail.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_FIVE);
            }
            taskDetailUpdateList.add(taskDetail);
        }
    }

    public void setRecordState(Long taskId, String integrstatus) {
        DynamicObject[] atteditiondet;
        if (taskId == 0L) {
            return;
        }
        LOGGER.info("AttDataGenerate setRecordState version:{}, integrstatus:{}", (Object)taskId, (Object)integrstatus);
        QFilter qFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{qFilter1};
        for (DynamicObject dynamicObject : atteditiondet = this.ATTDATA_TASKDETAIL_HELPER.loadDynamicObjectArray(filters)) {
            dynamicObject.set("integrstatus", (Object)integrstatus);
        }
        this.ATTDATA_TASKDETAIL_HELPER.save(atteditiondet);
    }

    public void setRecordStateEditiondet(String version, List<Long> attFileBoId, String integerStatus, List<DynamicObject> taskDataInfoUpdateList) {
        DynamicObject[] dataInfos;
        if (version == null || WTCCollections.isEmpty(attFileBoId)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AttDataGenerate setRecordStateEditiondet version:{}, boid:{}, integrstatus:{}", new Object[]{version, SerializationUtils.toJsonString(attFileBoId), integerStatus});
        }
        QFilter qFilter1 = new QFilter("number", "=", (Object)version);
        QFilter qFilter2 = new QFilter("attfilebase", "in", attFileBoId);
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2};
        String select = WTCStringUtils.joinOnComma((String[])new String[]{"id", "integrstatus", "abnreason"});
        for (DynamicObject dynamicObject : dataInfos = this.ATTDATA_DATAINFO_HELPER.query(select, filters)) {
            dynamicObject.set("integrstatus", (Object)integerStatus);
            if (HRStringUtils.equals((String)integerStatus, (String)AttDataIntegrateConstants.INTEGRATESTATU_FOUR)) {
                dynamicObject.set("abnreason", (Object)BizDataFailStatusEnum.FAILSTATUS_3050.getCode());
            }
            taskDataInfoUpdateList.add(dynamicObject);
        }
    }

    public void setRecordStateWithId(List<Map<String, Object>> errorInfo, Long taskId, List<DynamicObject> taskDetailUpdateList, List<DynamicObject> taskDataInfoUpdateList) {
        DynamicObject[] dataInfos;
        if (CollectionUtils.isEmpty(errorInfo)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("AttDataGenerate setRecordStateWithId errorinfo:{}", (Object)SerializationUtils.toJsonString(errorInfo));
        }
        ArrayList<Long> fids = new ArrayList<Long>(10);
        HashMap<Long, Map> allErrorMap = new HashMap<Long, Map>(16);
        ArrayList<Long> failFiles = new ArrayList<Long>(10);
        for (Map<String, Object> errorMap : errorInfo) {
            List detail = (List)errorMap.get("detail");
            for (Map detailMap : detail) {
                fids.add((Long)detailMap.get("id"));
                allErrorMap.put((Long)detailMap.get("id"), detailMap);
            }
            failFiles.add((Long)errorMap.get("attfileid"));
        }
        this.setRecordState(taskId, failFiles, AttDataIntegrateConstants.INTEGRATESTATU_THREE, taskDetailUpdateList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("AttDataGenerate setRecordStateWithId fids:{}", (Object)SerializationUtils.toJsonString(fids));
            LOGGER.info("AttDataGenerate setRecordStateWithId allErrorMap:{}", (Object)SerializationUtils.toJsonString(allErrorMap));
        }
        QFilter qFilter = new QFilter("id", "in", fids);
        String dataInfoSelect = WTCStringUtils.joinOnComma((String[])new String[]{"id", "abnreason", "integrstatus"});
        for (DynamicObject dynamicObject : dataInfos = this.ATTDATA_DATAINFO_HELPER.query(dataInfoSelect, new QFilter[]{qFilter})) {
            Map objectMap = (Map)allErrorMap.get(dynamicObject.getLong("id"));
            if (objectMap == null) continue;
            dynamicObject.set("abnreason", objectMap.get("reasonCode"));
            dynamicObject.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_THREE);
            String state = String.valueOf(objectMap.get("state"));
            if (WTCStringUtils.equals((String)state, (String)"3")) {
                dynamicObject.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_FOUR);
            }
            taskDataInfoUpdateList.add(dynamicObject);
        }
    }

    public void setIgnoredInfoRecordStateWithId(List<Map<String, Object>> ignoredInfo, Long taskId, String version, List<DynamicObject> taskDetailUpdateList, List<DynamicObject> taskDataInfoUpdateList) {
        DynamicObject[] dataInfos;
        if (CollectionUtils.isEmpty(ignoredInfo)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("AttDataGenerate setIgnoredInfoRecordStateWithId ignoredInfo:{}", (Object)SerializationUtils.toJsonString(ignoredInfo));
        }
        ArrayList<Long> fids = new ArrayList<Long>(10);
        HashMap<Long, Map> allIgnoredMap = new HashMap<Long, Map>(16);
        ArrayList<Long> successFiles = new ArrayList<Long>(10);
        for (Map<String, Object> ignoredMap : ignoredInfo) {
            List detail = (List)ignoredMap.get("detail");
            for (Map detailMap : detail) {
                fids.add((Long)detailMap.get("id"));
                allIgnoredMap.put((Long)detailMap.get("id"), detailMap);
            }
            successFiles.add((Long)ignoredMap.get("attfileid"));
        }
        this.setRecordState(taskId, successFiles, AttDataIntegrateConstants.INTEGRATESTATU_TWO, taskDetailUpdateList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("AttDataGenerate setRecordStateWithId fids:{}", (Object)SerializationUtils.toJsonString(fids));
            LOGGER.info("AttDataGenerate setRecordStateWithId allIgnoredMap:{}", (Object)SerializationUtils.toJsonString(allIgnoredMap));
        }
        QFilter qFilter = new QFilter("number", "=", (Object)version);
        QFilter attfileQFilter = new QFilter("attfilebase", "in", successFiles);
        String dataInfoSelect = WTCStringUtils.joinOnComma((String[])new String[]{"id", "abnreason", "integrstatus"});
        for (DynamicObject dynamicObject : dataInfos = this.ATTDATA_DATAINFO_HELPER.query(dataInfoSelect, new QFilter[]{qFilter, attfileQFilter})) {
            Long id = dynamicObject.getLong("id");
            Map objectMap = (Map)allIgnoredMap.get(id);
            if (fids.contains(id)) {
                if (objectMap != null) {
                    dynamicObject.set("abnreason", objectMap.get("reasonCode"));
                    dynamicObject.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_FOUR);
                }
            } else {
                dynamicObject.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_TWO);
            }
            taskDataInfoUpdateList.add(dynamicObject);
        }
    }

    private void setGlobalRecordFailStateWithId(String reasonCode, Long taskId, String version) {
        DynamicObject[] atteditiondet;
        LOGGER.info("AttDataGenerate setRecordStateWithId reasonCode:{}", (Object)reasonCode);
        this.setRecordState(taskId, AttDataIntegrateConstants.INTEGRATESTATU_THREE);
        QFilter qFilter = new QFilter("number", "=", (Object)version);
        for (DynamicObject dynamicObject : atteditiondet = this.ATTDATA_DATAINFO_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            dynamicObject.set("abnreason", (Object)reasonCode);
            dynamicObject.set("integrstatus", (Object)AttDataIntegrateConstants.INTEGRATESTATU_THREE);
        }
        this.ATTDATA_DATAINFO_HELPER.save(atteditiondet);
    }

    public List<Long> getIgnoreList(Long taskId, List<Long> fileids) {
        if (taskId == null || taskId == 0L) {
            return null;
        }
        QFilter qFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter qFilter2 = new QFilter("integrstatus", "=", (Object)AttDataIntegrateConstants.INTEGRATESTATU_FOUR);
        QFilter qFilter3 = null;
        if (!CollectionUtils.isEmpty(fileids)) {
            qFilter3 = new QFilter("attfileboid", "in", fileids);
        }
        ArrayList filters = Lists.newArrayList();
        filters.add(qFilter1);
        filters.add(qFilter2);
        filters.add(qFilter3);
        DynamicObject[] atteditiondet = this.ATTDATA_TASKDETAIL_HELPER.loadDynamicObjectArray(filters.toArray(new QFilter[0]));
        return Arrays.stream(atteditiondet).map(dynamicObject -> dynamicObject.getLong("attfileboid.id")).collect(Collectors.toList());
    }

    public void saveTaskDetail(List<DynamicObject> lists) {
        this.ATTDATA_TASKDETAIL_HELPER.update(lists.toArray(new DynamicObject[0]));
    }

    public void saveTaskDataInfo(List<DynamicObject> lists) {
        this.ATTDATA_DATAINFO_HELPER.update(lists.toArray(new DynamicObject[0]));
    }

    private static class Instance {
        private static final AttDataIntegrateHelper INSTANCE = new AttDataIntegrateHelper();

        private Instance() {
        }
    }
}

