/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.attdataintegrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.constants.SeeAttDataConstants;
import kd.wtc.wtis.enums.IntegrStatusEnum;
import kd.wtc.wtis.enums.WithDrawResultEnum;

public class SeeAttDataHelper
implements SeeAttDataConstants {
    private static final Log logger = LogFactory.getLog(SeeAttDataHelper.class);
    private static SeeAttDataHelper seeAttDataHelper = new SeeAttDataHelper();

    private SeeAttDataHelper() {
    }

    public static SeeAttDataHelper getInstance() {
        return seeAttDataHelper;
    }

    public void showAttEditionDet(IFormView view, long id, String showPageId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)id);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(showPageId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("taskDetailId", (Object)dynamicObject.getLong("id"));
        formShowParameter.setCustomParam("attfileboid", (Object)dynamicObject.getLong("attfileboid.id"));
        formShowParameter.setCustomParam("showpageid", (Object)showPageId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c47\u603b\u6570\u636e-{0}", (String)"SeeAttDataHelper_5", (String)"wtc-wtis-business", (Object[])new Object[]{dynamicObject.getString("attfile.name")}));
        formShowParameter.setCustomParam("issumdetail", (Object)"1");
        view.showForm(formShowParameter);
    }

    public void showAttEditionDet(IFormView view, String tabPageId, String showPageId) {
        BillList billList = (BillList)view.getControl(tabPageId);
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValues = currentSelectedRowInfo.getPrimaryKeyValue();
        long id = 0L;
        if (primaryKeyValues != null) {
            id = (Long)primaryKeyValues;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)id);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(showPageId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("taskDetailId", (Object)dynamicObject.getLong("id"));
        formShowParameter.setCustomParam("tabPageId", (Object)tabPageId);
        formShowParameter.setCustomParam("attfileboid", (Object)dynamicObject.getLong("attfileboid.id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u63a8\u9001\u6570\u636e-{0}", (String)"SeeAttDataHelper_6", (String)"wtc-wtis-business", (Object[])new Object[]{dynamicObject.getString("attfile.name")}));
        formShowParameter.setCustomParam("showpageid", (Object)showPageId);
        view.showForm(formShowParameter);
    }

    public DynamicObject[] getCreateAttData(List<Long> idList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter qFilter = new QFilter("id", "in", idList);
        return hrBaseServiceHelper.query("taskid,attfileboid,generstatus", new QFilter[]{qFilter});
    }

    public DynamicObject[] getTabAllAttData(IFormView view) {
        Long taskId = view.getModel().getDataEntity().getLong("attdatagenerate.id");
        Tab tab = (Tab)view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        QFilter numFilter = this.getTabFilter(taskId, currentTab);
        return this.getExportData(new QFilter[]{numFilter});
    }

    public DynamicObject[] getExportData(QFilter[] filters) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        return hrBaseServiceHelper.query("id,taskid,integrationrule", filters, "taskid desc,generstatus desc,attperson.number asc ");
    }

    public void setCreateTabNew(DynamicObject attDataGen, IFormView view) {
        String number = attDataGen.getString("number");
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject query = hrBaseServiceHelper.queryOne("totalattperson,runattperson,succeedattperson,failedattperson,notrunattperson", new QFilter[]{numFilter});
        if (query == null) {
            this.setCreateTabPageText(null, view);
            return;
        }
        Long taskId = query.getLong("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] details = helper.query("id,generstatus", new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        this.setCreateTabPageText(details, view);
    }

    private void setCreateTabPageText(DynamicObject[] details, IFormView view) {
        String kdString = String.format(ResManager.loadKDString((String)"\u6267\u884c\u6570\uff08%s\uff09", (String)"SeeAttDataHelper_0", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> Arrays.asList("0", "1").contains(task.getString("generstatus"))).count());
        TabPage executeTab = (TabPage)view.getControl("extab");
        executeTab.setText(new LocaleString(kdString));
        TabPage successTab = (TabPage)view.getControl("successtab");
        String kdString1 = String.format(ResManager.loadKDString((String)"\u6210\u529f\uff08%s\uff09", (String)"SeeAttDataHelper_1", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> "1".equals(task.getString("generstatus"))).count());
        successTab.setText(new LocaleString(kdString1));
        TabPage failTab = (TabPage)view.getControl("failtab");
        String kdString2 = String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff08%s\uff09", (String)"SeeAttDataHelper_2", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> "0".equals(task.getString("generstatus"))).count());
        failTab.setText(new LocaleString(kdString2));
        TabPage unExecuteTab = (TabPage)view.getControl("unextab");
        String kdString3 = String.format(ResManager.loadKDString((String)"\u672a\u6267\u884c\u6570\uff08%s\uff09", (String)"SeeAttDataHelper_3", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> "2".equals(task.getString("generstatus"))).count());
        unExecuteTab.setText(new LocaleString(kdString3));
    }

    public QFilter attHRAuth() {
        long currUserId = RequestContext.get().getCurrUserId();
        return HRAuthService.getInstance().getDataRule(Long.valueOf(currUserId), "wtis", "wtis_payattdatainfo", "attfile.org", "47150e89000000ac", Collections.emptyMap());
    }

    public QFilter getTabFilter(Long taskId, String showType) {
        QFilter taskFilter = new QFilter("taskid", "=", (Object)taskId);
        taskFilter.and(this.attHRAuth());
        if (HRStringUtils.isEmpty((String)showType)) {
            return taskFilter;
        }
        QFilter status = null;
        switch (showType) {
            case "extab": {
                status = new QFilter("generstatus", "in", Arrays.asList("0", "1"));
                break;
            }
            case "successtab": {
                status = new QFilter("generstatus", "=", (Object)"1");
                break;
            }
            case "failtab": {
                status = new QFilter("generstatus", "=", (Object)"0");
                break;
            }
            case "unextab": {
                status = new QFilter("generstatus", "=", (Object)"2");
                break;
            }
            case "withdrawtab": {
                status = new QFilter("withdrawresult", "in", Arrays.asList(WithDrawResultEnum.SUCCESS.getCode(), WithDrawResultEnum.FAIL.getCode()));
                break;
            }
        }
        if (status != null) {
            taskFilter.and(status);
        }
        return taskFilter;
    }

    public DynamicObject[] getIntegrAttData(IFormView view) {
        Tab tab = (Tab)view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        currentTab = "extab".equals(currentTab) ? "exbilllistap" : ("successtab".equals(currentTab) ? "sucbilllistap" : ("failtab".equals(currentTab) ? "failbilllistap" : ("withdrawtab".equals(currentTab) ? "widrbilllistap" : ("unextab".equals(currentTab) ? "unexbilllistap" : "exbilllistap"))));
        BillList BillList2 = (BillList)view.getControl(currentTab);
        ListSelectedRowCollection listSelectedData = BillList2.getSelectedRows();
        if (HRStringUtils.equals((String)currentTab, (String)"widrbilllistap")) {
            String pageId = view.getPageCache().get("withdrawtab");
            Iterator withDrawVies = (IListView)view.getView(pageId);
            if (withDrawVies == null) {
                return new DynamicObject[0];
            }
            listSelectedData = withDrawVies.getSelectedRows();
        }
        ArrayList<Long> idList = new ArrayList<Long>(listSelectedData.size());
        for (ListSelectedRow selectedRow : listSelectedData) {
            Long billTypeID = Long.parseLong(selectedRow.getPrimaryKeyValue().toString());
            idList.add(billTypeID);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter qFilter = new QFilter("id", "in", idList);
        return hrBaseServiceHelper.query("taskid,attfileboid,integrstatus,attfile", new QFilter[]{qFilter});
    }

    public List<String> getVersionByTaskId(List<Long> taskIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject[] taskDyns = helper.query("version", new QFilter[]{new QFilter("id", "in", taskIds)});
        return Arrays.stream(taskDyns).map(dyn -> dyn.getString("version")).collect(Collectors.toList());
    }

    public Map<Long, String> getId2VersionByTaskId(List<Long> taskIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject[] taskDyns = helper.query("version", new QFilter[]{new QFilter("id", "in", taskIds)});
        return Arrays.stream(taskDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getString("version") : null)));
    }

    public Long getTaskIdByVersion(String version) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject taskDyns = helper.queryOriginalOne("id", new QFilter[]{new QFilter("version", "=", (Object)version)});
        return taskDyns.getLong("id");
    }

    public DynamicObject[] getAttDataDetInfo(List<Long> attFileIdList, List<Long> perAttList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter qFilter = new QFilter("id", "in", attFileIdList);
        qFilter.and(new QFilter("attfileboid.id", "in", perAttList));
        DynamicObject[] queryDynObj = hrBaseServiceHelper.query("taskid,attfileboid,integrstatus,attfile", new QFilter[]{qFilter});
        return queryDynObj;
    }

    public DynamicObject[] getAttFileInfo(List<Long> errAttFileIdList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
        QFilter qFilter = new QFilter("id", "in", errAttFileIdList);
        DynamicObject[] queryDynObj = hrBaseServiceHelper.query("number", new QFilter[]{qFilter});
        return queryDynObj;
    }

    public void setIntegrTab(DynamicObject attDataGen, IFormView view) {
        Long taskid = attDataGen.getLong("taskid");
        QFilter taskIdFilter = new QFilter("taskid", "=", (Object)taskid);
        HRBaseServiceHelper exBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject query = exBaseServiceHelper.queryOne("integratestatus,allinexnum,inexnum,insuccessnum,infailnum,inwithdrawnum,inconsumetime", new QFilter[]{taskIdFilter});
        if (query == null) {
            this.setIntegrTabText(view, taskIdFilter, null);
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = HRAuthService.getInstance().getDataRule(Long.valueOf(currUserId), "wtis", "wtis_payattdatainfo", "attfile.org", "47150e89000000ac", Collections.emptyMap());
        logger.info("SeeAttDataHelper.setIntegrTab.dataQFilter:{}", (Object)dataQFilter);
        taskIdFilter.and(dataQFilter);
        Long taskId = query.getLong("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] details = helper.query("id" + "," + "integrstatus" + "," + "withdrawresult", new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        this.setIntegrTabText(view, taskIdFilter, details);
    }

    private void setIntegrTabText(IFormView view, QFilter taskIdFilter, DynamicObject[] details) {
        BillList exBillList = (BillList)view.getControl("exbilllistap");
        BillList sucBillList = (BillList)view.getControl("sucbilllistap");
        BillList unExBillList = (BillList)view.getControl("widrbilllistap");
        BillList failBillList = (BillList)view.getControl("failbilllistap");
        BillList nonBilllList = (BillList)view.getControl("unexbilllistap");
        QFilter exFilter = new QFilter("integrstatus", "in", Arrays.asList("2", "3", "4"));
        exBillList.setClientQueryFilterParameter(new FilterParameter((List)(details == null || details.length == 0 ? Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}) : Arrays.asList(taskIdFilter, exFilter)), null));
        TabPage executeTab = (TabPage)view.getControl("extab");
        String kdString = String.format(ResManager.loadKDString((String)"\u6267\u884c\u6570\uff08%s\uff09", (String)"SeeAttDataHelper_0", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> Arrays.asList("2", "3", "4").contains(task.getString("integrstatus"))).count());
        executeTab.setText(new LocaleString(kdString));
        TabPage successTab = (TabPage)view.getControl("successtab");
        QFilter sucFilter = new QFilter("integrstatus", "in", Arrays.asList("2", "4"));
        sucBillList.setClientQueryFilterParameter(new FilterParameter((List)(details == null || details.length == 0 ? Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}) : Arrays.asList(taskIdFilter, sucFilter)), null));
        String kdString1 = String.format(ResManager.loadKDString((String)"\u6210\u529f\uff08%s\uff09", (String)"SeeAttDataHelper_1", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> Arrays.asList("2", "4").contains(task.getString("integrstatus"))).count());
        successTab.setText(new LocaleString(kdString1));
        QFilter failFilter = new QFilter("integrstatus", "=", (Object)"3");
        TabPage failTab = (TabPage)view.getControl("failtab");
        failBillList.setClientQueryFilterParameter(new FilterParameter((List)(details == null || details.length == 0 ? Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}) : Arrays.asList(taskIdFilter, failFilter)), null));
        String kdString2 = String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff08%s\uff09", (String)"SeeAttDataHelper_2", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> "3".equals(task.getString("integrstatus"))).count());
        failTab.setText(new LocaleString(kdString2));
        TabPage unExecuteTab = (TabPage)view.getControl("withdrawtab");
        String kdString3 = String.format(ResManager.loadKDString((String)"\u64a4\u56de\u6570\uff08%s\uff09", (String)"SeeAttDataHelper_4", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> WithDrawResultEnum.SUCCESS.getCode().equals(task.getString("withdrawresult")) || WithDrawResultEnum.FAIL.getCode().equals(task.getString("withdrawresult"))).count());
        unExecuteTab.setText(new LocaleString(kdString3));
        QFilter nonFilter = new QFilter("integrstatus", "=", (Object)IntegrStatusEnum.NON.getCode());
        TabPage nonTab = (TabPage)view.getControl("unextab");
        nonBilllList.setClientQueryFilterParameter(new FilterParameter((List)(details == null || details.length == 0 ? Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}) : Arrays.asList(taskIdFilter, nonFilter)), null));
        String kdString7 = String.format(ResManager.loadKDString((String)"\u672a\u6267\u884c\u6570\uff08%s\uff09", (String)"SeeAttDataHelper_7", (String)"wtc-wtis-business", (Object[])new Object[0]), details == null || details.length == 0 ? 0L : Arrays.stream(details).filter(task -> IntegrStatusEnum.NON.getCode().equals(task.getString("integrstatus"))).count());
        nonTab.setText(new LocaleString(kdString7));
    }

    public DynamicObject[] getDrawResult(List<String> taskNumberList, List<Long> attFileIdList) {
        List taskId = taskNumberList.stream().map(taskIdStr -> Long.parseLong(taskIdStr)).collect(Collectors.toList());
        QFilter number = new QFilter("taskid", "in", taskId);
        number.and(this.attHRAuth());
        QFilter attFile = new QFilter("attfileboid", "in", attFileIdList);
        number.and(attFile);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        return hrBaseServiceHelper.query("id,attfileboid,taskid", new QFilter[]{number}, "taskid desc,attfileboid.attperson.number asc  ");
    }

    public Map<Long, List<Long>> getDetailIdsByTaskIds(List<Long> taskIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] taskDetails = helper.query("id,taskid", new QFilter[]{new QFilter("taskid", "in", taskIds)});
        Map<Long, List<Long>> taskId2DetailIds = Arrays.stream(taskDetails).collect(Collectors.groupingBy(dyn -> dyn.getLong("taskid"), Collectors.mapping(dyn -> dyn.getLong("id"), Collectors.toList())));
        return taskId2DetailIds;
    }

    public List<Long> getDetailIdsByVersion(String version) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttask");
        DynamicObject taskDyn = helper.queryOne(new QFilter[]{new QFilter("version", "=", (Object)version)});
        HRBaseServiceHelper helperOfDetail = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] query = helperOfDetail.query("id", new QFilter[]{new QFilter("taskid", "=", (Object)taskDyn.getLong("id"))});
        List<Long> ids = Arrays.stream(query).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        return ids;
    }

    public DynamicObject getTaskDynByTaskId(Long taskid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttask");
        return helper.loadSingle((Object)taskid);
    }

    public void setTimeCostOfField(DynamicObjectCollection collection, String timeField, String timeStrField, boolean isIntegrate) {
        DynamicSimpleProperty columnProp = new DynamicSimpleProperty();
        columnProp.setName(timeStrField);
        ((DynamicObject)collection.get(0)).getDataEntityType().getProperties().add((Object)columnProp);
        Object needDealColl = isIntegrate ? collection.stream().filter(dyn -> AttDataIntegrateConstants.INTEGRATESTATU_C.equals(dyn.getString("integratestatus"))).collect(Collectors.toList()) : collection;
        needDealColl.forEach(row -> {
            long diff = row.getLong(timeField);
            if (diff > 0L) {
                String secondDesc;
                long sTime = diff / 1000L;
                long mTime = sTime / 60L;
                long hTime = mTime / 60L;
                long dTime = hTime / 24L;
                long wrapperHours = hTime % 24L;
                StringBuilder timeStr = new StringBuilder();
                if ((wrapperHours += dTime * 24L) > 0L) {
                    String hourDesc = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"AttDataListProvider_0", (String)"wtc-wtis-business", (Object[])new Object[0]);
                    timeStr.append(wrapperHours).append(hourDesc);
                }
                if (mTime % 60L > 0L) {
                    String minuteDesc = ResManager.loadKDString((String)"\u5206\u949f", (String)"AttDataListProvider_1", (String)"wtc-wtis-business", (Object[])new Object[0]);
                    timeStr.append(mTime % 60L).append(minuteDesc);
                }
                if (sTime % 60L > 0L) {
                    secondDesc = ResManager.loadKDString((String)"\u79d2", (String)"AttDataListProvider_2", (String)"wtc-wtis-business", (Object[])new Object[0]);
                    timeStr.append(sTime % 60L).append(secondDesc);
                } else {
                    secondDesc = ResManager.loadKDString((String)"\u79d2", (String)"AttDataListProvider_2", (String)"wtc-wtis-business", (Object[])new Object[0]);
                    timeStr.append(1).append(secondDesc);
                }
                row.set(timeStrField, (Object)timeStr.toString());
            } else {
                row.set(timeStrField, (Object)"");
            }
        });
    }

    public String getStatusByNums(int successNum, int failNum, int noExcuteNum) {
        String status = " ";
        int countNum = successNum + failNum + noExcuteNum;
        if (countNum == successNum) {
            status = AttDataIntegrateConstants.SUCCESS;
        } else if (countNum == noExcuteNum) {
            status = AttDataIntegrateConstants.NOTEXECUTE;
        } else if (successNum == 0 && failNum > 0) {
            status = AttDataIntegrateConstants.ERROR;
        } else if (successNum > 0 && successNum < countNum) {
            status = AttDataIntegrateConstants.HALF;
        }
        return status;
    }
}

