/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.salary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtis.business.attdata.DoSetExtFieldEvent;
import kd.sdk.wtc.wtis.business.attdata.PayAttDataInfoExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.helper.AttdataGenerateHelper;
import kd.wtc.wtis.business.web.helper.AtteditiondetHelper;
import kd.wtc.wtis.business.web.helper.AttitemHelper;
import kd.wtc.wtis.business.web.helper.AttperiodHelper;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;

public class SalaryInterfaceBusiness {
    private static final Log logger = LogFactory.getLog(SalaryInterfaceBusiness.class);
    private static final List<String> dataindexList = new ArrayList<String>();

    public SalaryInterfaceBusiness() {
        dataindexList.clear();
        dataindexList.add("id");
        dataindexList.add("tagnumber");
        dataindexList.add("version");
        dataindexList.add("attfileid");
        dataindexList.add("depempid");
        dataindexList.add("employeeid");
        dataindexList.add("startdate");
        dataindexList.add("enddate");
        dataindexList.add("attitemid");
        dataindexList.add("value");
        dataindexList.add("attperiodid");
        dataindexList.add("datastartdate");
        dataindexList.add("dataenddate");
        dataindexList.add("personid");
    }

    public List<Long> pullAttfile(String version, int start, int end) {
        HRBaseServiceHelper serviceHelper;
        DataSet dataSet;
        QFilter integerStatusQFilter;
        QFilter qFilterCand1;
        QFilter qFilterCand;
        logger.info("SalaryInterfaceConstants.pullAttfile version: {}  start: {} end: {} ", new Object[]{version, start, end});
        QFilter[] qFilters = new QFilter[3];
        Long taskId = SeeAttDataHelper.getInstance().getTaskIdByVersion(version);
        qFilters[0] = qFilterCand = new QFilter("taskid", "=", (Object)taskId);
        qFilters[1] = qFilterCand1 = new QFilter("generstatus", "=", (Object)Character.valueOf('1'));
        qFilters[2] = integerStatusQFilter = new QFilter(AttDataIntegrateConstants.INTEGR_DOWN, "=", (Object)Boolean.TRUE);
        if (logger.isDebugEnabled()) {
            logger.debug("SalaryInterfaceConstants.pullAttfile qFilter0: {} qFilter1 {} qFilter2 {} ", new Object[]{qFilters[0], qFilters[1], qFilters[2]});
        }
        if (null == (dataSet = (serviceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail")).queryDataSet(SalaryInterfaceBusiness.class.getName() + "pullAttfile", "attfileboid", qFilters, "id")) || dataSet.isEmpty()) {
            logger.info("SalaryInterfaceConstants.pullAttfile dataSet emp: returnList_0");
            return Collections.emptyList();
        }
        CachedDataSet cache = dataSet.cache(new CacheHint());
        List rows = cache.getList(start, end - start + 1);
        List<Long> returnList = rows.stream().map(row -> row.getLong("attfileboid")).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.info("SalaryInterfaceConstants.pullAttfile returnList: {}", returnList);
        }
        logger.info("SalaryInterfaceConstants.pullAttfile returnList.sze: {}", (Object)returnList.size());
        return returnList;
    }

    public Map<String, Object> pullAttRecord(String version, List<Long> attfileid) {
        logger.info("SalaryInterfaceConstants.pullAttRecord version: {}  attfileid: {} ", (Object)version, (Object)attfileid.size());
        if (logger.isDebugEnabled()) {
            logger.info("SalaryInterfaceConstants.pullAttRecord version: {}  attfileid: {} ", (Object)version, attfileid);
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)3);
        QFilter qFilterCand = new QFilter("number", "=", (Object)version);
        QFilter qFilter = new QFilter("attfilebase", "in", attfileid);
        QFilter[] qFilters = new QFilter[]{qFilterCand, qFilter};
        if (logger.isDebugEnabled()) {
            logger.debug("SalaryInterfaceConstants.pullAttRecord qFilter0: {} qFilter1 {}", (Object)qFilters[0], (Object)qFilters[1]);
        }
        DynamicObject[] dynamicObjects = AtteditiondetHelper.getInstance().loadDynamicObjectArray(qFilters);
        DynamicObject[] generates = AttdataGenerateHelper.getInstance().loadDynamicObjectArray(new QFilter[]{new QFilter("version", "=", (Object)version)});
        if (generates == null || generates.length == 0) {
            return returnMap;
        }
        DynamicObject attperiodentry = generates[0].getDynamicObject("attperiodentry");
        ArrayList<String> fields = new ArrayList<String>(dataindexList);
        WTCPluginProxy<PayAttDataInfoExtPlugin> extPlugin = this.getExtPlugin();
        List<String> extFields = this.getPayAttDataInfoExtField(extPlugin);
        if (WTCCollections.isNotEmpty(extFields)) {
            fields.addAll(extFields);
        }
        returnMap.put("total", dynamicObjects.length);
        returnMap.put("dataindex", fields);
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ArrayList dataOneList = Lists.newArrayListWithExpectedSize((int)fields.size());
            dataOneList.add(dynamicObject.getLong("id"));
            dataOneList.add(dynamicObject.getString("idcode"));
            dataOneList.add(version);
            dataOneList.add(dynamicObject.getLong("attfilebase.id"));
            dataOneList.add(dynamicObject.getLong("attfile.depemp.id"));
            dataOneList.add(dynamicObject.getLong("attfile.employee.id"));
            dataOneList.add(attperiodentry.getDate("begindate").getTime());
            dataOneList.add(attperiodentry.getDate("enddate").getTime());
            dataOneList.add(dynamicObject.getLong("attitem.id"));
            dataOneList.add(dynamicObject.getBigDecimal("valuestr"));
            dataOneList.add(attperiodentry.getLong("masterid.id"));
            Date perPeriodBeginDate = dynamicObject.getDate("perperiodbegindate");
            dataOneList.add(perPeriodBeginDate == null ? null : Long.valueOf(perPeriodBeginDate.getTime()));
            Date perPeriodEndDate = dynamicObject.getDate("perperiodenddate");
            dataOneList.add(perPeriodEndDate == null ? null : Long.valueOf(perPeriodEndDate.getTime()));
            dataOneList.add(dynamicObject.getLong("attfile.attperson.id"));
            this.processPayAttDataInfoAddField(extPlugin, new DoSetExtFieldEvent(dynamicObject, (List)dataOneList));
            dataList.add(dataOneList);
        }
        returnMap.put("data", dataList);
        if (logger.isDebugEnabled()) {
            logger.info("SalaryInterfaceConstants.pullAttRecord returnMap: {} ", (Object)returnMap);
        }
        logger.info("SalaryInterfaceConstants.pullAttRecord version : {} returnMap: {}", (Object)version, (Object)returnMap.size());
        return returnMap;
    }

    public DynamicObject[] getAttperiod(QFilter[] filters, int start, int limit) {
        DynamicObject[] returnObjects = BusinessDataServiceHelper.load((String)"wtp_attperiod", (String)"number,name,looptype,periodnumber,description,status,enable", (QFilter[])filters, null, (int)(start / limit), (int)limit);
        return returnObjects;
    }

    public int getAttperiodCount(QFilter[] filters) {
        DynamicObject[] dynamicObjects = AttperiodHelper.getInstance().loadDynamicObjectArray(filters);
        return dynamicObjects.length;
    }

    public DynamicObject[] getAttitem(QFilter[] filters, int start, int limit) {
        DynamicObject[] returnObjects = BusinessDataServiceHelper.load((String)"wtbd_attitem", (String)"number,name,datatype,unit,itemtype,dataaccuracy,status,enable", (QFilter[])filters, null, (int)(start / limit), (int)limit);
        return returnObjects;
    }

    public int getAttitemCount(QFilter[] filters) {
        DynamicObject[] dynamicObjects = AttitemHelper.getInstance().loadDynamicObjectArray(filters);
        return dynamicObjects.length;
    }

    private WTCPluginProxy<PayAttDataInfoExtPlugin> getExtPlugin() {
        return WTCPluginProxyFactory.create(PayAttDataInfoExtPlugin.class, (String)AttDataIntegrateConstants.ATT_DATA_EX);
    }

    private List<String> getPayAttDataInfoExtField(WTCPluginProxy<PayAttDataInfoExtPlugin> pluginProxy) {
        return (List)pluginProxy.invokeReplaceAndGetLast(PayAttDataInfoExtPlugin::beforePayAttDataInfoAddExtField);
    }

    private void processPayAttDataInfoAddField(WTCPluginProxy<PayAttDataInfoExtPlugin> pluginProxy, DoSetExtFieldEvent event) {
        pluginProxy.invokeReplace(instance -> instance.doSetExtFieldValue(event));
    }
}

