/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.schedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtis.business.attdata.BeforeSavePayAttDataInfoEvent;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.attdata.impl.AttDataGenServiceImpl;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.common.model.AttFileGroupDto;

public class AttDataGenerateJobDisTask
extends WTCShardingAbleTask {
    private static final Log logger = LogFactory.getLog(AttDataGenerateJobDisTask.class);
    private static HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("wtis_payatttask");
    private static HRBaseServiceHelper subTaskHelper = new HRBaseServiceHelper("wtis_payattsubtask");

    public void execute(RequestContext requestContext, WTCTaskParam taskParams) {
        Date startDate = new Date();
        long mainTaskId = taskParams.getMainTaskId();
        long taskId = taskParams.getTaskId();
        long orgId = (Long)taskParams.getParam("orgid");
        List attfiles = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtis_payatt", (long)mainTaskId, (long)taskId, null);
        Map<Long, Long> attFileBoId2DetailId = attfiles.stream().collect(Collectors.groupingBy(WTCCalTaskDetailEntity::getAttFileBoId, Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((WTCCalTaskDetailEntity)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getId() : 0L)));
        List<Long> attFileIdList = attfiles.stream().map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toList());
        DynamicObject numberDyn = taskHelper.loadSingle((Object)mainTaskId);
        DynamicObject subTaskDyn = subTaskHelper.loadSingle((Object)taskId);
        WTCCalSubTaskEntity subTask = this.getWtcCalSubTaskEntity(startDate, mainTaskId, taskId);
        HashMap<String, Long> result = new HashMap<String, Long>(5);
        result.put("mainTaskId", mainTaskId);
        String version = numberDyn.getString("version");
        logger.info("AttDataGenerate number : {} attFileIds : {}", (Object)version, attFileIdList);
        TaskDesc taskDesc = new TaskDesc("wtis_payatt", version, mainTaskId, taskId, 0L, taskParams.getShardingIndex(), requestContext.getCurrUserId());
        try (TaskTracer taskTracer = TaskTracer.makeTracer((TaskDesc)taskDesc);
             Span rootSpan = TaskTracer.newRootSpan();
             Span initSpan = TaskTracer.newSpan((String)IntegrationKDString.spanAttDataGen());){
            initSpan.info(IntegrationKDString.spanPeronNum(), (Object)attFileIdList.size());
            initSpan.info(IntegrationKDString.spanMainTask(), (Object)mainTaskId);
            initSpan.info(IntegrationKDString.spaSubTask(), (Object)taskId);
            logger.info("AttDataGenerate number begin : {}", (Object)version);
            String attPeriodName = numberDyn.getString("attperiodentry.name");
            DynamicObject rule = numberDyn.getDynamicObject("integrationrule");
            BeforeSavePayAttDataInfoEvent event = new BeforeSavePayAttDataInfoEvent(version, mainTaskId, taskId, rule, numberDyn.getDynamicObject("attperiodentry"));
            if (WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)taskParams.getTaskId())) {
                this.stop();
            }
            logger.info("AttDataGenerate getAttDataForPay number begin : {}", (Object)version);
            AttDataGenServiceImpl attDateGenService = new AttDataGenServiceImpl(numberDyn, attFileIdList);
            List<AttFileGroupDto> attFileGroups = attDateGenService.getAttDataList();
            logger.info("AttDataGenerate getAttDataForPay number end : {}", (Object)version);
            List<DynamicObject> detailDyns = AttDataGenerateHelper.generateAttDetailDataNew(numberDyn, attFileGroups, event, attFileBoId2DetailId, taskId, orgId, attPeriodName);
            logger.info("AttDataGenerate updateAttDataStatus Success");
            Date endDate = new Date();
            subTask.setEndDate(endDate);
            subTask.setRefreshTime(endDate);
            AttDataGenerateHelper.updateAllAttDataGenerates(detailDyns, subTaskDyn, subTask);
            logger.info("AttDataGenerate updateAllAttDataGenerates Success");
            WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)taskParams.getTaskId(), (int)100, (String)WTCSerializationUtils.serializeToBase64(result));
            logger.info("AttDataGenerate Success Number : {}", (Object)version);
        }
        catch (Exception e) {
            this.updateSubTaskError(subTaskDyn, e.getMessage(), subTask);
            WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)taskParams.getTaskId(), (int)100, (String)WTCSerializationUtils.serializeToBase64(result));
            logger.warn("AttDataGenerate Fail Numbers : {} ,{}", (Object)version, (Object)e);
            throw e;
        }
    }

    private void updateSubTaskError(DynamicObject subTaskDyn, String errorMessage, WTCCalSubTaskEntity subTask) {
        HRBaseServiceHelper taskDetailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        long subTaskId = subTaskDyn.getLong("id");
        DynamicObject[] taskDetails = taskDetailHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("subtaskid", "=", (Object)subTaskId)});
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)taskDetails.length);
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)taskDetails.length);
        for (DynamicObject taskDetail : taskDetails) {
            taskDetail.set("generstatus", (Object)"0");
            taskDetail.set("taskdetailstate", (Object)WTCTaskDetailStatus.FAIL.getCode());
            taskDetail.set("exinfo", (Object)errorMessage);
            personIds.add(taskDetail.getLong("attperson.id"));
            attFileBoIds.add(taskDetail.getLong("attfileboid.id"));
        }
        int allGenExNum = subTaskDyn.getInt("totalattperson");
        subTaskDyn.set("runattperson", (Object)allGenExNum);
        subTaskDyn.set("succeedattperson", (Object)0);
        subTaskDyn.set("failedattperson", (Object)allGenExNum);
        subTaskDyn.set("notrunattperson", (Object)0);
        subTask.setSucceedAttPerson(0);
        subTask.setFailedAttPerson(allGenExNum);
        subTask.setRunAttPerson(allGenExNum);
        subTask.setNotRunAttPerson(0);
        int attFileNum = subTaskDyn.getInt("totalattfile");
        subTask.setSucceedAttFile(0);
        subTask.setFailedAttFile(attFileNum);
        subTask.setRunAttFile(attFileNum);
        subTask.setNotRunAttFile(0);
        taskDetailHelper.update(taskDetails);
        WTCTaskStateTransfer.transferToSpecialStateSub((Long)subTask.getId(), (Long)subTask.getTaskId(), (WTCSubTaskEntity)subTask, (String)"wtis_payatt");
    }

    private WTCCalSubTaskEntity getWtcCalSubTaskEntity(Date startDate, long mainTaskId, long taskId) {
        WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
        subTask.setId(taskId);
        subTask.setTaskId(mainTaskId);
        subTask.setSubTaskStatus(WTCSubTaskStatus.FINISHED);
        subTask.setStartDate(startDate);
        return subTask;
    }

    protected List<Object> doGetShardingDetailList(long mainTaskId, long subTaskId, String category) {
        return new ArrayList<Object>(16);
    }
}

