/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.common.constants.SeeAttDataConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;

public class AttJobTaskHelper
implements SeeAttDataConstants {
    private static final Log logger = LogFactory.getLog(AttJobTaskHelper.class);
    private static AttJobTaskHelper attJobTaskHelper = new AttJobTaskHelper();

    private AttJobTaskHelper() {
    }

    public static AttJobTaskHelper getInstance() {
        return attJobTaskHelper;
    }

    public void dispatchJob(Map<String, Object> params, IFormPlugin plugin, IFormView view) {
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        Long taskid = (Long)params.get("taskid");
        if (taskid != null && taskid != 0L) {
            DynamicObject taskDyn = SeeAttDataHelper.getInstance().getTaskDynByTaskId(taskid);
            params.put("attgenerateruleId", taskDyn.getLong("integrationrule.id"));
            params.put("attperiodId", taskDyn.getLong("attperiodentry.id"));
            params.put("orgid", taskDyn.getLong("org.id"));
            params.put("desc", IntegrationKDString.reCalDesc((String)taskDyn.getString("version")));
            request.setDesc((String)params.get("desc"));
        }
        Date now = new Date();
        request.setStartDate(now);
        request.setEndDate(now);
        request.setTaskId(IDService.get().genLongId());
        request.setTrial(false);
        request.setSource(WTCSource.MANUAL.code);
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setDetail(Collections.emptyList());
        request.setCategory("wtis_payatt");
        request.setAppId("wtis");
        request.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "taskcloseback");
        WTCTaskForm taskForm = new WTCTaskForm();
        String taskVersion = AttJobTaskHelper.getTaskVersion();
        params.put("version", taskVersion);
        taskForm.setCaption(IntegrationKDString.processGenerateTask() + taskVersion);
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanBackground(true);
        taskForm.setCanStop(true);
        taskForm.setTaskRequest((WTCTaskRequest)request);
        taskForm.setClickClassName("kd.wtc.wtis.business.web.schedule.AttDataGenerateJobTaskClick");
        logger.info("AttJobTaskHelper_dispatchJob_taskForm_{}", (Object)taskForm);
        WTCDistributeTaskHelper.showProgress((IFormView)view, (CloseCallBack)closeCallBack, (String)(IntegrationKDString.processGenerateTask() + taskVersion), (String)"wtis_payatt", (Object)taskForm);
    }

    public static String getTaskVersion() {
        return CodeRuleServiceHelper.getNumber((String)"wtis_payatttask", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtis_payatttask"), null);
    }

    public static JSONObject showFormMsg(Object returnData, IFormView view) {
        TaskInfo taskInfo;
        Map result;
        String taskInfoStr;
        if (returnData == null) {
            return null;
        }
        if (returnData instanceof Map && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject obj = (JSONObject)JSONObject.parse((String)data);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wtis_generateproresult");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("result", (Object)obj);
            view.showForm(showParameter);
        }
        return null;
    }

    public void recalculation(Long taskId, IFormView view, IFormPlugin plugin, QFilter qFilter) {
        DynamicObject[] attFiles = AttDataGenerateHelper.getAttFileIdByFilter(taskId, qFilter);
        if (null == attFiles || attFiles.length == 0) {
            view.showErrorNotification(IntegrationKDString.notPerError());
            return;
        }
        List<Long> attFileIdList = Arrays.stream(attFiles).map(dyn -> dyn.getLong("attfileboid.id")).collect(Collectors.toList());
        List<Long> hasAuthBoIdList = AttDataGenerateHelper.checkPermission(attFileIdList);
        if (hasAuthBoIdList.isEmpty()) {
            view.showErrorNotification(IntegrationKDString.notPerError());
            return;
        }
        HashSet<Long> hasAuthBoIds = new HashSet<Long>(hasAuthBoIdList);
        List attFileIds = Arrays.stream(attFiles).filter(dyn -> hasAuthBoIds.contains(dyn.getLong("attfileboid.id"))).map(dyn -> dyn.getLong("attfile.id")).collect(Collectors.toList());
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("taskid", taskId);
        params.put("attDatas", attFileIds);
        params.put("opType", "rerun");
        this.dispatchJob(params, plugin, view);
    }
}

