/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.business.web.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttDataServiceImpl {
    private AttDataServiceImpl() {
    }

    public static AttDataServiceImpl getInstance() {
        return AttDataServiceImplInstance.singleton;
    }

    public static List<Long> getSubAdminOrg(List<Long> adminOrgList) {
        List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        List<Long> subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
        subOrgIdList.addAll(adminOrgList);
        return subOrgIdList;
    }

    public Object showAttFileInfoDetails(DynamicObject dynamicObject) {
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet excludeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList<Long> includeAttFileBoIds = new ArrayList<Long>(0);
        this.getSelectAdminOrgAndExcludeAttFile(dynamicObject, adminOrgIds, excludeAttFileBoIds, includeAttFileBoIds);
        if (CollectionUtils.isEmpty((Collection)adminOrgIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u3002", (String)"AttDataServiceImpl_0", (String)"wtc-wtis-business", (Object[])new Object[0]);
        }
        Page<DynamicObject> dynamicObjectPage = this.queryAttFileF7(adminOrgIds, excludeAttFileBoIds);
        return this.getListShowParameter(dynamicObjectPage);
    }

    protected ListShowParameter getListShowParameter(Page<DynamicObject> dynamicObjectPage) {
        List listRecords = dynamicObjectPage.getListRecords();
        List ids = listRecords.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("ids", ids);
        parameter.setBillFormId("wtp_settlefilequerylist");
        parameter.setHasRight(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1000");
        styleCss.setHeight("600");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        return parameter;
    }

    protected Page<DynamicObject> queryAttFileF7(Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds) {
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam(false);
        attFileF7QueryParam.setProperties("id");
        attFileF7QueryParam.setAffiliateAdminOrgSetIds(adminOrgIds);
        attFileF7QueryParam.setBoDelSetIds(excludeAttFileBoIds);
        attFileF7QueryParam.setFormId("wtis_payattdatainfo");
        attFileF7QueryParam.setAppId("wtis");
        attFileF7QueryParam.setPermField("attfile");
        attFileF7QueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        return AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 1000000);
    }

    protected void getSelectAdminOrgAndExcludeAttFile(DynamicObject dataEntity, Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds, List<Long> includeAttFileBoIds) {
        DynamicObjectCollection orgColl = dataEntity.getDynamicObjectCollection("orgentity");
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return;
        }
        for (DynamicObject entryOrgDy : orgColl) {
            DynamicObjectCollection excludePersonColl;
            if (!"haos_adminorghr".equals(entryOrgDy.getString("orgtype"))) continue;
            Long orgId = entryOrgDy.getLong("org.id");
            if (orgId != null && !orgId.equals(0L)) {
                adminOrgIds.add(entryOrgDy.getLong("org.id"));
            }
            if (CollectionUtils.isEmpty((Collection)(excludePersonColl = entryOrgDy.getDynamicObjectCollection("excludeattperson")))) continue;
            excludePersonColl.forEach(excludePersonDy -> {
                long attFileBoId;
                DynamicObject dynamicObject = excludePersonDy.getDynamicObject("fbasedataid");
                if (dynamicObject != null && !includeAttFileBoIds.contains(attFileBoId = dynamicObject.getLong("boid"))) {
                    excludeAttFileBoIds.add(attFileBoId);
                }
            });
        }
        if (!CollectionUtils.isEmpty(adminOrgIds)) {
            List<Long> subOrgIdList = AttDataServiceImpl.getSubAdminOrg(Lists.newArrayList(adminOrgIds));
            adminOrgIds.addAll(subOrgIdList);
        }
    }

    private static class AttDataServiceImplInstance {
        private static final AttDataServiceImpl singleton = new AttDataServiceImpl();

        private AttDataServiceImplInstance() {
        }
    }
}

