/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataIntegrateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.salary.SalaryInterfaceBusiness;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.mservice.api.ISalaryIntegrationService;

public class SalaryIntegrationService
implements ISalaryIntegrationService {
    private static final Log logger = LogFactory.getLog(SalaryIntegrationService.class);
    private static SalaryInterfaceBusiness salaryInterfaceBusiness = new SalaryInterfaceBusiness();

    public Boolean setAttRecordState(Map<String, Object> recordState) {
        if (recordState == null) {
            logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState recordState is null");
            return Boolean.TRUE;
        }
        String version = (String)recordState.get("version");
        long begin = System.currentTimeMillis();
        logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState version:{}", (Object)version);
        if (logger.isDebugEnabled()) {
            logger.debug("AttDataGenerate SalaryIntegrationService setAttRecordState recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        }
        int attFileNum = 0;
        if (null != version) {
            Long taskId = SeeAttDataHelper.getInstance().getTaskIdByVersion(version);
            ArrayList taskDetailUpdateList = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList taskDataInfoUpdateList = Lists.newArrayListWithExpectedSize((int)16);
            List successFileId = (List)recordState.get("successfileid");
            if (WTCCollections.isNotEmpty((Collection)successFileId)) {
                logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState successFileId:{}", (Object)successFileId.size());
                attFileNum += successFileId.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("AttDataGenerate SalaryIntegrationService setAttRecordState successFileId:{}", (Object)successFileId);
            }
            AttDataIntegrateHelper instance = AttDataIntegrateHelper.getInstance();
            instance.setRecordState(taskId, successFileId, AttDataIntegrateConstants.INTEGRATESTATU_TWO, (List)taskDetailUpdateList);
            instance.setRecordStateEditiondet(version, successFileId, AttDataIntegrateConstants.INTEGRATESTATU_TWO, (List)taskDataInfoUpdateList);
            List ignoredFileId = (List)recordState.get("ignoredfileid");
            if (WTCCollections.isNotEmpty((Collection)ignoredFileId)) {
                logger.debug("AttDataGenerate SalaryIntegrationService setAttRecordState ignoredFileId:{}", (Object)ignoredFileId.size());
                attFileNum += ignoredFileId.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("AttDataGenerate SalaryIntegrationService setAttRecordState ignoredFileId:{}", (Object)ignoredFileId);
            }
            instance.setRecordState(taskId, ignoredFileId, AttDataIntegrateConstants.INTEGRATESTATU_FOUR, (List)taskDetailUpdateList);
            instance.setRecordStateEditiondet(version, ignoredFileId, AttDataIntegrateConstants.INTEGRATESTATU_FOUR, (List)taskDataInfoUpdateList);
            List errorInfo = (List)recordState.get("errorinfo");
            if (WTCCollections.isNotEmpty((Collection)errorInfo)) {
                logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState errorInfo:{}", (Object)errorInfo.size());
                attFileNum += errorInfo.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("AttDataGenerate SalaryIntegrationService setAttRecordState errorInfo:{}", (Object)errorInfo);
            }
            instance.setRecordStateWithId(errorInfo, taskId, (List)taskDetailUpdateList, (List)taskDataInfoUpdateList);
            List ignoredInfo = (List)recordState.get("ignoredinfo");
            if (WTCCollections.isNotEmpty((Collection)ignoredInfo)) {
                attFileNum += ignoredInfo.size();
                logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState ignoredInfo version:{} ,ignoredInfo:{}", (Object)version, (Object)SerializationUtils.toJsonString((Object)ignoredInfo));
            }
            instance.setIgnoredInfoRecordStateWithId(ignoredInfo, taskId, version, (List)taskDetailUpdateList, (List)taskDataInfoUpdateList);
            try (TXHandle required = TX.requiresNew();){
                try {
                    instance.saveTaskDetail((List)taskDetailUpdateList);
                    instance.saveTaskDataInfo((List)taskDataInfoUpdateList);
                }
                catch (Exception io) {
                    String msg = "AttRecordBaseHisUpgrade_exception_" + io.getMessage();
                    logger.warn(msg, (Throwable)io);
                    required.markRollback();
                    Boolean bl = Boolean.FALSE;
                    if (required != null) {
                        if (var15_15 != null) {
                            try {
                                required.close();
                            }
                            catch (Throwable throwable) {
                                var15_15.addSuppressed(throwable);
                            }
                        } else {
                            required.close();
                        }
                    }
                    return bl;
                }
            }
            AttDataGenerateHelper.updateAttDataIntegrate((Long)taskId);
            logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState version:{} ,attFileNum:{}", (Object)version, (Object)attFileNum);
        }
        long end = System.currentTimeMillis();
        logger.info("AttDataGenerate SalaryIntegrationService setAttRecordState version:{}_{}", (Object)version, (Object)((end - begin) / 1000L));
        return Boolean.TRUE;
    }

    public List<Long> pullAttfile(Map<String, Object> recordState) {
        String version = (String)recordState.get("version");
        logger.info("SalaryIntegrationService pullAttfile version:{}", (Object)version);
        if (logger.isDebugEnabled()) {
            logger.debug("SalaryIntegrationService pullAttfile recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        }
        int start = Integer.parseInt(recordState.get("start").toString());
        int end = Integer.parseInt(recordState.get("end").toString());
        return salaryInterfaceBusiness.pullAttfile(version, start, end);
    }

    public Map<String, Object> pullAttRecord(Map<String, Object> recordState) {
        if (logger.isDebugEnabled()) {
            logger.debug("SalaryIntegrationService pullAttRecord recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        }
        String version = (String)recordState.get("version");
        List successfileid = (List)recordState.get("successfileid");
        return salaryInterfaceBusiness.pullAttRecord(version, successfileid);
    }

    public DynamicObject[] getAttperiod(Map<String, Object> recordState) {
        logger.info("SalaryIntegrationService getAttperiod recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        QFilter[] filters = (QFilter[])recordState.get("filters");
        int start = Integer.parseInt(recordState.get("start").toString());
        int end = Integer.parseInt(recordState.get("end").toString());
        return salaryInterfaceBusiness.getAttperiod(filters, start, end);
    }

    public int getAttperiodCount(Map<String, Object> recordState) {
        logger.info("SalaryIntegrationService getAttperiodCount recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        QFilter[] filters = (QFilter[])recordState.get("filters");
        return salaryInterfaceBusiness.getAttperiodCount(filters);
    }

    public DynamicObject[] getAttitem(Map<String, Object> recordState) {
        logger.info("SalaryIntegrationService getAttitem recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        QFilter[] filters = (QFilter[])recordState.get("filters");
        int start = Integer.parseInt(recordState.get("start").toString());
        int end = Integer.parseInt(recordState.get("end").toString());
        return salaryInterfaceBusiness.getAttitem(filters, start, end);
    }

    public int getAttitemCount(Map<String, Object> recordState) {
        logger.info("SalaryIntegrationService getAttitemCount recordState:{}", (Object)SerializationUtils.toJsonString(recordState));
        QFilter[] filters = (QFilter[])recordState.get("filters");
        return salaryInterfaceBusiness.getAttitemCount(filters);
    }

    public Map<Long, Boolean> queryExistSalaryIntegrationService(Set<Long> attFileBoIds) {
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter qFilter = new QFilter("attfileboid", "in", attFileBoIds);
        qFilter.and("integrstatus", "=", (Object)AttDataIntegrateConstants.INTEGRATESTATU_TWO);
        DynamicObject[] detailDys = detailHelper.queryOriginalArray("attfileboid", qFilter.toArray());
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)attFileBoIds.size());
        for (DynamicObject detailDy : detailDys) {
            retMap.put(detailDy.getLong("attfileboid"), Boolean.TRUE);
        }
        return retMap;
    }

    public boolean queryExistSalaryIntegrationService(long attFileBoId, long attPeriodId) {
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        HRBaseServiceHelper pushTaskHelper = new HRBaseServiceHelper("wtis_payattpushtask");
        QFilter qFilter = new QFilter("attfileboid", "=", (Object)attFileBoId);
        qFilter.and("integrstatus", "=", (Object)AttDataIntegrateConstants.INTEGRATESTATU_TWO);
        DataSet detailDataSet = detailHelper.queryDataSet("wtis_payatttaskdetail", "attfileboid,taskid", qFilter.toArray());
        QFilter pushTaskQFilter = new QFilter("attperiodentry.id", "=", (Object)attPeriodId);
        DataSet pushTaskDataSet = pushTaskHelper.queryDataSet("wtis_payattpushtask", "attperiodentry,taskid", pushTaskQFilter.toArray());
        JoinDataSet join = detailDataSet.join(pushTaskDataSet);
        join.on("taskid", "taskid");
        join.select(new String[]{"attfileboid"});
        DataSet finish = join.finish();
        return finish.hasNext();
    }
}

