/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.mservice.payattdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtbs.task.DispatchTaskResp;
import kd.sdk.wtc.wtis.business.attdata.AttDataPushReq;
import kd.sdk.wtc.wtis.business.task.AttSumTaskReq;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtis.business.attdata.impl.AttDataPushServiceImpl;
import kd.wtc.wtis.business.attdata.service.IAttDataPushService;
import kd.wtc.wtis.business.timingtask.gen.GenTaskGenerator;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.entity.AttDataPushRes;
import kd.wtc.wtis.entity.AttPushAndValidResp;
import kd.wtc.wtis.enums.IntegrStatusEnum;
import kd.wtc.wtis.mservice.api.payattdata.IPayAttDataService;

public class PayAttDataServiceImpl
implements IPayAttDataService {
    public void attFileDiscard(List<Long> attFileIdList) {
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter attFileBoIds = new QFilter("attfileboid", "in", attFileIdList);
        QFilter integerStatus = new QFilter("integrstatus", "!=", (Object)IntegrStatusEnum.SUCCESS.getCode());
        DynamicObject[] details = detailHelper.query(new QFilter[]{attFileBoIds, integerStatus});
        if (null == details || details.length == 0) {
            return;
        }
        List detailIds = Arrays.stream(details).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper infoHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
        QFilter detailIdQFilter = new QFilter("taskdetail", "in", detailIds);
        QFilter attFileBoQFilter = new QFilter("attfilebase", "in", attFileIdList);
        infoHelper.deleteByFilter(new QFilter[]{attFileBoQFilter, detailIdQFilter});
    }

    public Map<Long, List<DynamicObject>> queryPushData(List<Long> attFileIdList, String selectProperties, List<Long> attPeriodEntryIds) {
        QFilter[] qFilters;
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        QFilter attFileBoIds = new QFilter("attfileboid", "in", attFileIdList);
        QFilter integerStatus = new QFilter("integrstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{IntegrStatusEnum.SUCCESS.getCode(), IntegrStatusEnum.PUSHING.getCode()}));
        DynamicObject[] details = detailHelper.query(new QFilter[]{attFileBoIds, integerStatus});
        if (null == details || details.length == 0) {
            return Collections.emptyMap();
        }
        List detailIds = Arrays.stream(details).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper infoHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
        QFilter detailQFilter = new QFilter("taskdetail", "in", detailIds);
        ArrayList infoIntegerStatus = Lists.newArrayList((Object[])new String[]{AttDataIntegrateConstants.INTEGRATESTATU_TWO, AttDataIntegrateConstants.INTEGRATESTATU_ONE});
        QFilter integerStatusQFilter = new QFilter("integrstatus", "in", (Object)infoIntegerStatus);
        String select = "attfilebase.id";
        if (WTCStringUtils.isNotEmpty((String)selectProperties)) {
            select = select + "," + selectProperties;
        }
        if (WTCCollections.isNotEmpty(attPeriodEntryIds)) {
            QFilter attPeriodQFilter = new QFilter("attperiodentry", "in", attPeriodEntryIds);
            qFilters = new QFilter[]{detailQFilter, integerStatusQFilter, attPeriodQFilter};
        } else {
            qFilters = new QFilter[]{detailQFilter, integerStatusQFilter};
        }
        DynamicObject[] dataInfo = infoHelper.query(select, qFilters);
        if (null == dataInfo || dataInfo.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(dataInfo).collect(Collectors.groupingBy(dy -> dy.getLong("attfilebase.id")));
    }

    public DispatchTaskResp dispatchAttSumTask(AttSumTaskReq taskReq) {
        return new GenTaskGenerator().execute(taskReq);
    }

    public DispatchTaskResp genAttDataPushTask(AttDataPushReq req) {
        IAttDataPushService iAttDataPushService = (IAttDataPushService)WTCAppContextHelper.getBean(AttDataPushServiceImpl.class);
        AttPushAndValidResp validResp = iAttDataPushService.dispatch(req.getVersion(), WTCStringUtils.isEmpty((String)req.getPushType()) ? "1" : req.getPushType());
        return new AttDataPushRes(validResp.isSuccess(), validResp.getErrMsg(), validResp.getTaskId());
    }
}

