/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.coordination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.business.coordination.wrapper.TranChangeWrapper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtp.enums.coordination.TaskCreateStatusEnum;

public class CoordinationLogList
extends HRDataBaseList {
    private static final String RE_RUN = "rerun";
    private static final String RE_FRESH = "refresh";
    protected static final Log log = LogFactory.getLog(CoordinationLogList.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.setOrderBy("id desc");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (RE_RUN.equals(evt.getOperationKey())) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
            DynamicObject[] dataEntities = new HRBaseServiceHelper("wtis_coordinationlog").loadDynamicObjectArray(selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray());
            Set<Long> msgActionIdSet = Arrays.stream(dataEntities).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"msgaction")).collect(Collectors.toSet());
            this.multiMsgActionCheck(evt, msgActionIdSet);
            this.onboardAndQuitBatchOpCheck(evt, dataEntities);
            if (msgActionIdSet.contains(1210L)) {
                this.onboardPreCheck(evt, dataEntities, 1210L);
                evt.setCancel(true);
            }
            if (msgActionIdSet.contains(1110L)) {
                this.onboardPreCheck(evt, dataEntities, 1110L);
                evt.setCancel(true);
            }
        }
    }

    private void onboardPreCheck(BeforeItemClickEvent evt, DynamicObject[] dataEntities, long rollbackId) {
        if (!evt.isCancel()) {
            DynamicObject logDynamicObject = dataEntities[0];
            TranChangeWrapper tranChangeWrapper = CoordinationHelper.getInstance().initTranChangeWrapper(logDynamicObject);
            if (!TaskCreateStatusEnum.SUCCESS.getCode().equals(logDynamicObject.get("taskcreatestatus"))) {
                CoordinationHelper.getInstance().coordinationPreCreateTaskCheck(logDynamicObject, tranChangeWrapper);
                String errTipsType = tranChangeWrapper.getCreateTaskErrTipsType();
                if (errTipsType == null) {
                    errTipsType = "";
                }
                switch (errTipsType) {
                    case "0": {
                        this.getView().showErrorNotification(tranChangeWrapper.getCreateErrMsg());
                        break;
                    }
                    case "1": {
                        this.getView().showTipNotification(tranChangeWrapper.getCreateErrMsg());
                        break;
                    }
                    case "2": {
                        this.getView().showConfirm(tranChangeWrapper.getCreateErrMsg(), MessageBoxOptions.OK);
                        break;
                    }
                    default: {
                        DynamicObject attFileDy = CoordinationHelper.getInstance().initCurrentAttFile(tranChangeWrapper);
                        if (attFileDy == null) {
                            this.getView().showTipNotification(AttFileKDString.noFile());
                            return;
                        }
                        log.info("CoordinationLogListPersonid:{}", (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFileDy, (String)"person"));
                        if (1210L != rollbackId && 1110L != rollbackId) break;
                        this.getView().getPageCache().put("attfileid", String.valueOf(attFileDy.getLong("boid")));
                        List attFileList = CoordinationHelper.getInstance().getEmployeeFileDyList(tranChangeWrapper, null);
                        if (!WTCCollections.isNotEmpty((Collection)attFileList)) break;
                        List<Long> boIdList = attFileList.stream().map(dy -> dy.getLong("boid")).distinct().collect(Collectors.toList());
                        HashMap resultMsgMap = Maps.newHashMapWithExpectedSize((int)boIdList.size());
                        for (Long boId : boIdList) {
                            resultMsgMap.put(boId, new ArrayList());
                        }
                        if (1210L == rollbackId) {
                            AttFileHelper.genShowDiscardConfirmPageByBusinessData(Collections.singletonList(attFileDy), (Map)resultMsgMap, boIdList, (IFormPlugin)this, (IFormView)this.getView(), (long)rollbackId);
                            break;
                        }
                        boIdList.removeIf(e -> !e.equals(attFileDy.getLong("boid")));
                        this.getQuitRollBackWarnMsg(Collections.singletonList(attFileDy), boIdList, resultMsgMap);
                        AttFileHelper.genShowDiscardConfirmPageByBusinessData(Collections.singletonList(attFileDy), (Map)resultMsgMap, boIdList, (IFormPlugin)this, (IFormView)this.getView(), (long)rollbackId);
                    }
                }
            }
        }
    }

    private void getQuitRollBackWarnMsg(List<DynamicObject> dataEntities, List<Long> boIdList, Map<Long, List<String>> resultMsgMap) {
        List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList<Long>(boIdList));
        Map<Long, Date> checkBoIdLockDateMap = attStateInfoBOS.stream().filter(i -> i.getLockTo() != null).collect(Collectors.toMap(AttStateInfoBO::getFileBoid, AttStateInfoBO::getLockTo));
        HashSet<Long> boIdSet = new HashSet<Long>(boIdList);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setSetBoIds(boIdSet);
        attFileQueryParam.setProperties("boid,enddate,number");
        List checkFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map checkFileMap = checkFileList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity(), (a, b) -> a));
        List dates = checkFileList.stream().map(dy -> dy.getDate("enddate")).collect(Collectors.toList());
        Date minEndDate = WTCDateUtils.getZeroDate((Date)dates.stream().min(Date::compareTo).orElseGet(WTCHisServiceHelper::getMinEndDate));
        Date maxEndDate = WTCDateUtils.getZeroDate((Date)dates.stream().max(Date::compareTo).orElseGet(WTCHisServiceHelper::getMaxEndDate));
        PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
        perAttPeriodQueryParam.setAttFileBoIdSet(boIdSet);
        perAttPeriodQueryParam.setStartDate(minEndDate);
        perAttPeriodQueryParam.setEndDate(maxEndDate);
        List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(perAttPeriodQueryParam);
        Map<Long, List<PerAttPeriod>> checkPerAttPeriodMap = perAttPeriodList.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        HashMap attPushFileBoIdMap = Maps.newHashMapWithExpectedSize((int)boIdList.size());
        for (Long fileBoId2 : boIdSet) {
            List<PerAttPeriod> checkPerAttPeriodList;
            if (CollectionUtils.isEmpty(dataEntities)) break;
            if (!fileBoId2.equals(dataEntities.get(0).getLong("boid")) || !WTCCollections.isNotEmpty(checkPerAttPeriodList = checkPerAttPeriodMap.get(fileBoId2))) continue;
            DynamicObject checkFile = (DynamicObject)checkFileMap.get(fileBoId2);
            Date endDate = checkFile.getDate("enddate");
            Optional<PerAttPeriod> any = checkPerAttPeriodList.stream().filter(d -> d.getPerAttBeginDate().compareTo(endDate) <= 0 && d.getPerAttEndDate().compareTo(endDate) >= 0).findAny();
            if (!any.isPresent()) continue;
            PerAttPeriod perAttPeriod2 = any.get();
            Date perAttBeginDate = perAttPeriod2.getPerAttBeginDate();
            Date lackDate = checkBoIdLockDateMap.get(fileBoId2);
            if (lackDate != null && lackDate.compareTo(perAttBeginDate) >= 0) {
                this.addResultMsg(resultMsgMap, fileBoId2, AttFileKDString.pleaseNotice());
                this.addResultMsg(resultMsgMap, fileBoId2, "\n");
                this.addResultMsg(resultMsgMap, fileBoId2, AttFileKDString.rollbackAttPeriodLockCoordination((String)perAttPeriod2.getPerAttPeriodName()));
                this.addResultMsg(resultMsgMap, fileBoId2, "\n");
            }
            attPushFileBoIdMap.put(fileBoId2, perAttPeriod2);
        }
        if (WTCCollections.isNotEmpty((Map)attPushFileBoIdMap)) {
            Map attPushData = (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"IPayAttDataService", (String)"queryPushData", (Object[])new Object[]{new ArrayList(attPushFileBoIdMap.keySet()), "id", attPushFileBoIdMap.values().stream().map(PerAttPeriod::getAttPeriodId).collect(Collectors.toList())});
            if (log.isInfoEnabled()) {
                log.info("queryPushData:{},{},attPushData:{}", new Object[]{attPushFileBoIdMap.keySet(), attPushFileBoIdMap.values(), attPushData});
            }
            if (WTCCollections.isNotEmpty((Map)attPushData)) {
                attPushFileBoIdMap.forEach((fileBoId, perAttPeriod) -> {
                    if (attPushData.get(fileBoId) != null) {
                        if (((List)resultMsgMap.get(fileBoId)).contains(AttFileKDString.pleaseNotice())) {
                            this.addResultMsg(resultMsgMap, (Long)fileBoId, AttFileKDString.discardAttPushCoordinationMsg((String)perAttPeriod.getPerAttPeriodName()));
                        } else {
                            this.addResultMsg(resultMsgMap, (Long)fileBoId, AttFileKDString.pleaseNotice());
                            this.addResultMsg(resultMsgMap, (Long)fileBoId, "\n");
                            this.addResultMsg(resultMsgMap, (Long)fileBoId, AttFileKDString.discardAttPushCoordinationMsg((String)perAttPeriod.getPerAttPeriodName()));
                        }
                    }
                });
            }
        }
    }

    private void addResultMsg(Map<Long, List<String>> resultMsgSet, Long boid, String msg) {
        List<String> msgSet = resultMsgSet.get(boid);
        msgSet.add(msg);
        resultMsgSet.put(boid, msgSet);
    }

    private void onboardAndQuitBatchOpCheck(BeforeItemClickEvent evt, DynamicObject[] dataEntities) {
        if (!evt.isCancel()) {
            long onboardRollBackCount = Arrays.stream(dataEntities).filter(dy -> 1210L == WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"msgaction")).count();
            long quitRollBackCount = Arrays.stream(dataEntities).filter(dy -> 1110L == WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"msgaction")).count();
            if (onboardRollBackCount > 1L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64a4\u56de\u5165\u804c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CoordinationLogReCreateValidator_4", (String)"wtc-wtis-opplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (quitRollBackCount > 1L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64a4\u56de\u79bb\u804c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CoordinationLogReCreateValidator_5", (String)"wtc-wtis-opplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void multiMsgActionCheck(BeforeItemClickEvent evt, Set<Long> msgActionIdSet) {
        if (msgActionIdSet.size() > 1) {
            if (msgActionIdSet.contains(1210L)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5305\u542b\u591a\u79cd\u4e1a\u52a1\u64cd\u4f5c\u7c7b\u578b\uff0c\u8bf7\u5355\u72ec\u64cd\u4f5c\u201c\u64a4\u56de\u5165\u804c\u201d\u7c7b\u578b\u7684\u4e1a\u52a1\u65e5\u5fd7\u3002", (String)"CoordinationLogReCreateValidator_0", (String)"wtc-wtis-opplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (msgActionIdSet.contains(1110L)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u5305\u542b\u591a\u79cd\u4e1a\u52a1\u64cd\u4f5c\u7c7b\u578b\uff0c\u8bf7\u5355\u72ec\u64cd\u4f5c\u201c\u64a4\u56de\u79bb\u804c\u201d\u7c7b\u578b\u7684\u4e1a\u52a1\u65e5\u5fd7\u3002", (String)"CoordinationLogReCreateValidator_1", (String)"wtc-wtis-opplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(RE_RUN)) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
                String msgTip = (String)source.getOption().getVariables().get("rollbackFileOnly");
                if (WTCStringUtils.isNotEmpty((String)msgTip)) {
                    this.getView().showConfirm(msgTip, MessageBoxOptions.OK, new ConfirmCallBackListener("rollbackFileOnly", (IFormPlugin)this));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f", (String)"CoordinationLogList_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation(RE_FRESH);
                }
            } else {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (RE_RUN.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation(RE_RUN);
        }
        if ("rollbackFileOnly".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().invokeOperation(RE_FRESH);
        } else if ("wtp_discardconfirms".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getView().getPageCache().put("discard", "btnok");
            this.getView().invokeOperation(RE_RUN);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("discard".equals(actionId) && "success".equals(returnData = closedCallBackEvent.getReturnData())) {
            this.getView().getPageCache().put("discard", "btnok");
            this.getView().invokeOperation(RE_RUN);
        }
    }
}

