/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.coordination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIReviseLogServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtis.enums.ReviseLogEnum;
import kd.wtc.wtis.enums.ReviseLogTypeEnum;

public class PersonReviseLogDetailPlugin
extends HRDataBaseEdit {
    private static Map<String, List<String>> FileMap = new HashMap<String, List<String>>();
    private static List<String> hrPiTrialPeriodList = new ArrayList<String>();
    private static List<String> hrPiEmpEntrelList = new ArrayList<String>();
    private static List<String> hrPiEmpposorgrelList = new ArrayList<String>();

    public void preOpenForm(PreOpenFormEventArgs evt) {
        String reviseNumber;
        super.preOpenForm(evt);
        Long reviseLogId = (Long)evt.getFormShowParameter().getCustomParam("reviseLogId");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtis_personreviselog");
        DynamicObject dynamicObject = serviceHelper.loadSingle((Object)reviseLogId);
        switch (reviseNumber = dynamicObject.getString("revisenumber")) {
            case "hrpi_empposorgrel": {
                evt.getFormShowParameter().setCaption(ReviseLogTypeEnum.HRPI_EMPPOSORGREL.getDesc());
                break;
            }
            case "hrpi_empentrel": {
                evt.getFormShowParameter().setCaption(ReviseLogTypeEnum.HRPI_EMPENTREL.getDesc());
                break;
            }
            case "hrpi_trialperiod": {
                evt.getFormShowParameter().setCaption(ReviseLogTypeEnum.HRPI_TRIALPERIOD.getDesc());
                break;
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        Long reviseLogId = (Long)this.getView().getFormShowParameter().getCustomParam("reviseLogId");
        String logEntityName = (String)this.getView().getFormShowParameter().getCustomParam("logEntityName");
        DynamicObject reviseLogDetailDyn = HRPIReviseLogServiceHelper.generateLogDetailDyn((String)logEntityName, (Long)reviseLogId);
        e.setDataEntity((Object)reviseLogDetailDyn);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long reviseLogId = (Long)this.getView().getFormShowParameter().getCustomParam("reviseLogId");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtis_personreviselog");
        DynamicObject dynamicObject = serviceHelper.loadSingle((Object)reviseLogId);
        if (null == dynamicObject) {
            return;
        }
        String msgContentStr = dynamicObject.getString("msgcontent");
        if (!WTCStringUtils.isEmpty((String)msgContentStr)) {
            Map mapParam = (Map)SerializationUtils.deSerializeFromBase64((String)msgContentStr);
            if (WTCCollections.isEmpty((Map)mapParam)) {
                return;
            }
            String entityNumber = (String)mapParam.get("entityNumber");
            this.fillReviseType(dynamicObject, entityNumber);
            List reviserecordList = (List)mapParam.get("reviserecordList");
            Map resultMap = (Map)WTCServiceHelper.invokeHRService((String)"hspm", (String)"IReviseRecordService", (String)"queryAndCompareReviseLog", (Object[])new Object[]{entityNumber, reviserecordList});
            if (WTCCollections.isEmpty((Map)resultMap)) {
                return;
            }
            Map entityLogDataMap = (Map)resultMap.get("data");
            if (WTCCollections.isEmpty((Map)entityLogDataMap)) {
                return;
            }
            this.fillReviseReasonDesc(dynamicObject, entityLogDataMap);
        }
    }

    private void fillReviseReasonDesc(DynamicObject dynamicObject, Map<String, Object> entityLogDataMap) {
        ArrayList<String> reviseReasonList = new ArrayList<String>();
        ArrayList<String> reviseDescList = new ArrayList<String>();
        Long reviseBoFromDB = dynamicObject.getLong("reviseBo");
        List reviseBoList = (List)entityLogDataMap.get("reviseBoList");
        for (Map reviseBoMap : reviseBoList) {
            Long reviseBoFromHpi = (Long)reviseBoMap.get("reviseBo");
            if (reviseBoFromDB.equals(reviseBoFromHpi)) {
                ArrayList reviseLogList = (ArrayList)reviseBoMap.get("reviseLogList");
                if (WTCCollections.isEmpty((Collection)reviseLogList)) continue;
                int reviseReasonStrLength = 0;
                int reviseDescStrLength = 0;
                for (Object o : reviseLogList) {
                    Map map = (Map)o;
                    ArrayList reviseReason = (ArrayList)map.get("reviseReason");
                    if (WTCCollections.isNotEmpty((Collection)reviseReason)) {
                        for (Map reviseReasonMap : reviseReason) {
                            Object nameObj = reviseReasonMap.get("name");
                            String name = nameObj == null ? "" : nameObj.toString();
                            if ((reviseReasonStrLength += name.length()) >= 500) continue;
                            reviseReasonList.add(name);
                        }
                    }
                    ArrayList reviseDescTempList = (ArrayList)map.get("reviseDesc");
                    for (String resDesc : reviseDescTempList) {
                        if (WTCStringUtils.isEmpty((String)resDesc) || (reviseDescStrLength += resDesc.length()) >= 500) continue;
                        reviseDescList.add(resDesc);
                    }
                }
            }
            if (WTCCollections.isNotEmpty(reviseReasonList)) {
                String reviseReasonText = String.join((CharSequence)";", reviseReasonList);
                this.setLabText("labtext2", String.join((CharSequence)";", reviseReasonText));
            }
            if (!WTCCollections.isNotEmpty(reviseDescList)) continue;
            String reviseDescText = String.join((CharSequence)";", reviseDescList);
            this.setLabText("labtext3", reviseDescText);
        }
    }

    private void fillReviseType(DynamicObject dynamicObject, String entityNumber) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (null == dataEntity) {
            return;
        }
        DynamicObjectCollection reviselogdetail = dataEntity.getDynamicObjectCollection("reviselogdetail");
        switch (entityNumber) {
            case "hrpi_empposorgrel": {
                this.setFlex1(true);
                String reviseType = dynamicObject.getString("revisetype");
                String desc = ReviseLogEnum.getDesc((String)reviseType);
                this.setLabText("labtext1", desc);
                this.filter(reviselogdetail, FileMap.get(entityNumber));
                break;
            }
            case "hrpi_empentrel": 
            case "hrpi_trialperiod": {
                this.setFlex1(false);
                this.filter(reviselogdetail, FileMap.get(entityNumber));
                break;
            }
        }
    }

    private synchronized void filter(DynamicObjectCollection reviselogdetail, List<String> data) {
        Iterator iter = reviselogdetail.iterator();
        while (iter.hasNext()) {
            DynamicObject dy = (DynamicObject)iter.next();
            if (data.contains(dy.getString("revisefield"))) continue;
            iter.remove();
        }
    }

    private void setFlex1(boolean bool) {
        this.getView().setVisible(Boolean.valueOf(bool), new String[]{"flexpanelap1"});
    }

    private void setLabText(String labStr, String labText) {
        Label unitLab = (Label)this.getView().getControl(labStr);
        if (unitLab != null) {
            unitLab.setText(labText);
        }
    }

    static {
        hrPiTrialPeriodList.add("entrydate");
        hrPiTrialPeriodList.add("preregulardate");
        hrPiTrialPeriodList.add("realregulardate");
        FileMap.put("hrpi_trialperiod", hrPiTrialPeriodList);
        hrPiEmpEntrelList.add("enterprise");
        hrPiEmpEntrelList.add("startdate");
        hrPiEmpEntrelList.add("enddate");
        hrPiEmpEntrelList.add("lastworkdate");
        hrPiEmpEntrelList.add("laborreltype");
        hrPiEmpEntrelList.add("laborrelstatus");
        FileMap.put("hrpi_empentrel", hrPiEmpEntrelList);
        hrPiEmpposorgrelList.add("number");
        hrPiEmpposorgrelList.add("isprimary");
        hrPiEmpposorgrelList.add("postype");
        hrPiEmpposorgrelList.add("posstatus");
        hrPiEmpposorgrelList.add("startdate");
        hrPiEmpposorgrelList.add("enddate");
        hrPiEmpposorgrelList.add("company");
        hrPiEmpposorgrelList.add("adminorg");
        hrPiEmpposorgrelList.add("position");
        hrPiEmpposorgrelList.add("job");
        hrPiEmpposorgrelList.add("lastworkdate");
        FileMap.put("hrpi_empposorgrel", hrPiEmpposorgrelList);
    }
}

