/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.web.WTCInvokeServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataAddHelper;
import kd.wtc.wtis.business.web.service.AttDataServiceImpl;
import kd.wtc.wtis.common.constants.AttDataAddConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;

public class AttDataAddPlugin
extends HRDynamicFormBasePlugin
implements AttDataAddConstants,
BeforeF7SelectListener,
AfterF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object fromNumber = formShowParameter.getCustomParam("customHREntityNumber");
        if (fromNumber == null || WTCStringUtils.isEmpty((String)String.valueOf(fromNumber))) {
            formShowParameter.setCustomParam("customHREntityNumber", (Object)"wtis_payattdatainfo");
            formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfile.affiliateadminorg");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit personEdit = (BasedataEdit)this.getView().getControl("excludeattperson");
        personEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getView().getControl("attgeneraterule");
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ruleEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("attperiod");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        periodEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit attFileBaseF7 = (BasedataEdit)this.getControl("attfilebasef7");
        attFileBaseF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit multAdminOrgEdit = (MulBasedataEdit)this.getView().getControl("multadminorg");
        multAdminOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        Boolean newValue;
        String name = ee.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"useorg")) {
            Boolean bl = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])ee.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])ee.getChangeSet(), (int)0).get()).getNewValue() : Boolean.valueOf(false);
            if (!newValue.booleanValue()) {
                this.getModel().deleteEntryData("orgentity");
            } else {
                this.getModel().createNewEntryRow("orgentity");
            }
        }
        if (HRStringUtils.equals((String)name, (String)"useattperson")) {
            Boolean bl = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])ee.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])ee.getChangeSet(), (int)0).get()).getNewValue() : Boolean.valueOf(false);
            if (!newValue.booleanValue()) {
                this.getModel().deleteEntryData("personentity");
            }
        }
        if (HRStringUtils.equals((String)name, (String)"orgid")) {
            DynamicObject oldValue = (DynamicObject)(WTCCollectionIndexUtil.getEleFromArr((Object[])ee.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])ee.getChangeSet(), (int)0).get()).getOldValue() : null);
            if (Objects.isNull(oldValue)) {
                return;
            }
            Long orgId = (Long)oldValue.getPkValue();
            String cancelchangeorg = this.getView().getPageCache().get("cancelchangeorg");
            if (cancelchangeorg != null) {
                this.getView().getPageCache().remove("cancelchangeorg");
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("orgid", (IFormPlugin)this);
                this.getView().showConfirm(IntegrationKDString.confirmSure(), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener, null, orgId.toString());
            }
        }
        if ("multadminorg".equals(name)) {
            Set<Long> ids = this.getAdminOrg();
            this.addEntry(ids);
        }
    }

    private void addEntry(Set<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            int count = ids.size();
            DynamicObjectCollection adminOrgs = this.getModel().getEntryEntity("orgentity");
            int curNum = adminOrgs.size();
            this.getModel().batchCreateNewEntryRow("orgentity", count);
            for (Long id : ids) {
                this.getModel().setValue("orgtype", (Object)"haos_adminorghr", curNum);
                this.getModel().setValue("org", (Object)id, curNum);
                ++curNum;
            }
            this.getModel().endInit();
            this.getModel().setValue("multadminorg", null);
            this.getView().updateView("orgentity");
        }
    }

    private Set<Long> getAdminOrg() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        DynamicObjectCollection adminOrgs = dynamicObject.getDynamicObjectCollection("multadminorg");
        if (!CollectionUtils.isEmpty((Collection)adminOrgs)) {
            return adminOrgs.stream().map(ob -> ob.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"orgid")) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            Long oldOrg = Long.parseLong(customVaule);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("datainfoentity");
            } else {
                this.getView().getPageCache().put("cancelchangeorg", "true");
                this.getModel().setValue("orgid", (Object)oldOrg);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)"addattperson", (String)operateKey)) {
            BasedataEdit attFileF7 = (BasedataEdit)this.getControl("attfilebasef7");
            attFileF7.click();
        }
        if (HRStringUtils.equals((String)"btnjobdispatch", (String)operateKey)) {
            this.dispatch();
        }
        if (HRStringUtils.equals((String)"queryperson", (String)operateKey)) {
            this.showAttFileInfoDetails();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)"addbatch", (String)operateKey)) {
            MulBasedataEdit basedataEdit = (MulBasedataEdit)this.getView().getControl("multadminorg");
            basedataEdit.click();
            return;
        }
        if (HRStringUtils.equals((String)"btnjobdispatch", (String)operateKey)) {
            boolean checkResult;
            boolean bl = checkResult = this.checkUseOrg() && this.checkUseAttPerson() && this.checkDataInfo();
            if (!checkResult) {
                args.setCancel(true);
                return;
            }
        }
        if (HRStringUtils.equals((String)"newentry", (String)operateKey)) {
            this.beforeDoOperationOfNewEntry(args);
        }
    }

    private boolean checkUseOrg() {
        boolean useOrg = this.getModel().getDataEntity().getBoolean("useorg");
        if (useOrg) {
            DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
            if (CollectionUtils.isEmpty((Collection)orgEntity)) {
                this.getView().showTipNotification(IntegrationKDString.missPerson());
                return false;
            }
            for (DynamicObject entity : orgEntity) {
                DynamicObject org = (DynamicObject)entity.get("org");
                if (!HRObjectUtils.isEmpty((Object)org)) continue;
                this.getView().showTipNotification(IntegrationKDString.missPerson());
                return false;
            }
        }
        return true;
    }

    private boolean checkUseAttPerson() {
        DynamicObjectCollection personEntity;
        boolean useAttPerson = this.getModel().getDataEntity().getBoolean("useattperson");
        if (useAttPerson && CollectionUtils.isEmpty((Collection)(personEntity = this.getModel().getEntryEntity("personentity")))) {
            this.getView().showTipNotification(IntegrationKDString.missPerson());
            return false;
        }
        return true;
    }

    private boolean checkDataInfo() {
        DynamicObjectCollection dataInfoEntity = this.getModel().getEntryEntity("datainfoentity");
        if (CollectionUtils.isEmpty((Collection)dataInfoEntity)) {
            this.getView().showTipNotification(IntegrationKDString.pushMsg());
            return false;
        }
        for (DynamicObject entity : dataInfoEntity) {
            DynamicObject rule = (DynamicObject)entity.get("attgeneraterule");
            DynamicObject period = (DynamicObject)entity.get("attperiod");
            if (HRObjectUtils.isEmpty((Object)rule)) {
                this.getView().showTipNotification(IntegrationKDString.attDataRule());
                return false;
            }
            if (!HRObjectUtils.isEmpty((Object)period)) continue;
            this.getView().showTipNotification(IntegrationKDString.attDataPeriod());
            return false;
        }
        return true;
    }

    private void beforeDoOperationOfNewEntry(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        if (this.getModel().getEntryEntity("datainfoentity").size() >= 10) {
            this.getView().showTipNotification(IntegrationKDString.attDataRuleMax());
            return;
        }
        if (Objects.isNull(this.getModel().getDataEntity().getDynamicObject("orgid"))) {
            this.getView().showTipNotification(IntegrationKDString.chooseOrg());
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("orgid");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setUseOrgId(((Long)org.getPkValue()).longValue());
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("580px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        listShowParameter.setOpenStyle(style);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setBillFormId("wtis_integrationrulequery");
        listShowParameter.setFormId("bos_listf7");
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")));
        listShowParameter.setLookUp(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showAttFileInfoDetails() {
        Object object = AttDataServiceImpl.getInstance().showAttFileInfoDetails(this.getView().getModel().getDataEntity());
        if (object instanceof String) {
            this.getView().showErrorNotification(String.valueOf(object));
        } else if (object instanceof ListShowParameter) {
            this.getView().showForm((FormShowParameter)((ListShowParameter)object));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("addattfile")) {
            this.closedCallBackOfAddAttFile(closedCallBackEvent);
        } else if (closedCallBackEvent.getActionId().equals("newentry")) {
            int currentEntrySize;
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("datainfoentity");
            int n = currentEntrySize = CollectionUtils.isNotEmpty((Collection)entryEntity) ? entryEntity.size() : 0;
            if (CollectionUtils.isNotEmpty((Collection)returnData)) {
                if (returnData.size() + currentEntrySize > 10) {
                    this.getView().showTipNotification(IntegrationKDString.attDataRuleMax());
                    return;
                }
                for (ListSelectedRow selectedRow : returnData) {
                    Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
                    int newEntryRow = this.getModel().createNewEntryRow("datainfoentity");
                    this.getModel().setValue("attgeneraterule", (Object)primaryKeyValue, newEntryRow);
                }
            }
        }
    }

    private void closedCallBackOfAddAttFile(ClosedCallBackEvent closedCallBackEvent) {
        if (null == closedCallBackEvent.getReturnData()) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        List dataList = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_managescope");
        dataModel.beginInit();
        TableValueSetter table = new TableValueSetter(new String[0]);
        HashSet<Long> ids = new HashSet<Long>();
        dataModel.getEntityEntity("personentity").forEach(data -> ids.add(data.getLong("attfile.id")));
        QFilter qFilter = new QFilter("id", "in", dataList);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setqFilter(qFilter);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties("id,empposorgrel.id,attperson.id,boid,atttag.attendstatus,number");
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        List selectedFiles = Lists.newArrayListWithExpectedSize((int)ids.size());
        if (!CollectionUtils.isEmpty(ids)) {
            selectedFiles = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(WTCStringUtils.joinOnComma((String[])new String[]{"boid", "id"}), new ArrayList(ids));
        }
        Map<Long, Long> boid2Fid = selectedFiles.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("boid"), Collectors.collectingAndThen(Collectors.toList(), value -> WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)value, (int)0).get()).getLong("id") : 0L)));
        int[] ints = new int[]{0};
        if (null != attFiles && attFiles.size() > 0) {
            List collect = attFiles.stream().map(attFile -> attFile.getLong("attperson.id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("attperson", "in", collect)});
            Map<Long, Object> map = Arrays.stream(dynamicObjects).collect(Collectors.toMap(ee -> ee.getLong("attperson.id"), DataEntityBase::getPkValue, (item1, item2) -> item1));
            ArrayList errNumberList = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject attFile2 : attFiles) {
                long attFileId = attFile2.getLong("id");
                String attendStatus = attFile2.getString("atttag.attendstatus");
                if (!HRStringUtils.equals((String)AttStatusEnum.ATT_NORMAL.getCode(), (String)attendStatus)) {
                    errNumberList.add(attFile2.getString("number"));
                    continue;
                }
                if (0L == attFileId || !ids.add(attFileId)) continue;
                this.replaceSelect(attFile2.getLong("boid"), boid2Fid, dataModel);
                TableValueSetter tableValueSetter = table.addRow(new Object[0]);
                tableValueSetter.set("attfile", attFile2.get("id"), ints[0]);
                tableValueSetter.set("empposorgrel", attFile2.get("empposorgrel.id"), ints[0]);
                tableValueSetter.set("attperson", attFile2.get("attperson.id"), ints[0]);
                tableValueSetter.set("basedatapropfield", map.get(attFile2.get("attperson.id")), ints[0]);
                ints[0] = ints[0] + 1;
            }
            if (WTCCollections.isNotEmpty((Collection)errNumberList)) {
                if (errNumberList.size() > 3) {
                    ArrayList newErrNumberList = Lists.newArrayList((Object[])new String[]{(String)errNumberList.get(0), (String)errNumberList.get(1), (String)errNumberList.get(3), "..."});
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u4ee5\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u505c\u6b62\u8003\u52e4\u201d\u7684\u8003\u52e4\u6863\u6848\uff0c\u5df2\u81ea\u52a8\u9690\u85cf{0}\u3002", (String)"AttDataAddPlugin_0", (String)"wtc-wtis-fromplugin", (Object[])new Object[]{String.join((CharSequence)"\uff0c", newErrNumberList)}));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u4ee5\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u505c\u6b62\u8003\u52e4\u201d\u7684\u8003\u52e4\u6863\u6848\uff0c\u5df2\u81ea\u52a8\u9690\u85cf{0}\u3002", (String)"AttDataAddPlugin_0", (String)"wtc-wtis-fromplugin", (Object[])new Object[]{String.join((CharSequence)"\uff0c", errNumberList)}));
                }
            }
        }
        dataModel.batchCreateNewEntryRow("personentity", table);
        dataModel.endInit();
        this.getView().updateView("personentity");
    }

    private void replaceSelect(long boid, Map<Long, Long> boid2Fid, AbstractFormDataModel dataModel) {
        Long fid = boid2Fid.get(boid);
        if (fid != null) {
            DynamicObjectCollection entityEntity = dataModel.getEntityEntity("personentity");
            int needRemove = -1;
            for (int i = 0; i < entityEntity.size(); ++i) {
                if (((DynamicObject)entityEntity.get(i)).getLong("attfile.id") != fid.longValue()) continue;
                needRemove = i;
                break;
            }
            if (needRemove != -1) {
                dataModel.deleteEntryRow("personentity", needRemove);
            }
        }
    }

    public void afterCreateNewData(EventObject ee) {
        super.afterCreateNewData(ee);
        long orgId = HRAuthService.getInstance().getUserHasPerOrgId("wtis_attdata_add", "wtis");
        this.getView().getModel().setValue("orgid", (Object)orgId);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (HRStringUtils.equals((String)"org", (String)name)) {
            this.beforeF7SelectOfOrg(event);
        } else if (HRStringUtils.equals((String)"excludeattperson", (String)name)) {
            QFilter qFilter;
            int index = event.getRow();
            DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentity");
            DynamicObject orgDy = (DynamicObject)orgEntity.get(index);
            DynamicObject org = (DynamicObject)orgDy.get("org");
            String orgType = orgDy.getString("orgtype");
            ArrayList orgIdList = Lists.newArrayList((Object[])new Long[]{org.getLong("id")});
            if (HRStringUtils.equals((String)orgType, (String)"bos_org")) {
                qFilter = new QFilter("org", "in", (Object)org.getLong("id"));
            } else {
                List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg((List)orgIdList, new Date());
                List subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
                subOrgIdList.add(org.getLong("id"));
                qFilter = new QFilter("affiliateadminorg.id", "in", subOrgIdList);
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                listShowParameter.setMultiSelect(true);
                listShowParameter.setCustomParam("orgAppId", (Object)"wtis");
                listShowParameter.setCustomParam("orgEntityId", (Object)"wtis_payattdatainfo");
                listShowParameter.setCustomParam("orgField", (Object)"attfile.affiliateadminorg");
                AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)listShowParameter, "wtis_payattdatainfo", "wtis");
                this.addAuth(event);
            }
            event.getCustomQFilters().add(qFilter);
        } else if (HRStringUtils.equals((String)name, (String)"attperiod")) {
            DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
            DynamicObjectCollection personEntity = this.getModel().getEntryEntity("personentity");
            if (CollectionUtils.isEmpty((Collection)orgEntity) && CollectionUtils.isEmpty((Collection)personEntity)) {
                this.getView().showTipNotification(IntegrationKDString.chooseAtPerson());
                event.setCancel(true);
                return;
            }
            if (((DynamicObject)this.getModel().getEntryEntity("datainfoentity").get(event.getRow())).get("attgeneraterule") == null) {
                this.getView().showTipNotification(IntegrationKDString.chooseRule());
                event.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("orgid");
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.setCustomParam("useorg", org.getPkValue());
        } else if ("attfilebasef7".equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.setMultiSelect(true);
            listShowParameter.setCustomParam("orgAppId", (Object)"wtis");
            listShowParameter.setCustomParam("orgEntityId", (Object)"wtis_payattdatainfo");
            listShowParameter.setCustomParam("orgField", (Object)"attfile.affiliateadminorg");
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)listShowParameter, "wtis_payattdatainfo", "wtis");
            this.addAuth(event);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addattfile"));
        } else if ("multadminorg".equals(name)) {
            List customQFilters = event.getCustomQFilters();
            customQFilters.add(new QFilter("id", "not in", this.getEntryAdminOrg()));
        }
    }

    private Set<Long> getEntryAdminOrg() {
        DynamicObjectCollection adminOrgs = this.getModel().getEntryEntity("orgentity");
        if (!CollectionUtils.isEmpty((Collection)adminOrgs)) {
            return adminOrgs.stream().map(ob -> ob.getLong("org.id")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private void beforeF7SelectOfOrg(BeforeF7SelectEvent event) {
        int index = event.getRow();
        DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentity");
        DynamicObject orgDy = (DynamicObject)orgEntity.get(index);
        String orgType = orgDy.getString("orgtype");
        Set sameOrgIds = orgEntity.stream().filter(entity -> HRStringUtils.equals((String)entity.getString("orgtype"), (String)orgType) && !HRObjectUtils.isEmpty((Object)entity.get("org"))).map(org -> org.getLong("org.id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sameOrgIds) && !CollectionUtils.isEmpty(sameOrgIds)) {
            QFilter qFilter = new QFilter("id", "not in", sameOrgIds);
            event.getCustomQFilters().add(qFilter);
        }
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        listShowParameter.setAppId("wtis");
        AuthorizedOrgResult authorizedAdminOrgSet = WTCInvokeServiceHelper.getAuthorizedAdminOrgSet((String)"wtis", (String)"wtis_payattdatainfo", (String)"47150e89000000ac", (String)"attfile.affiliateadminorg");
        boolean hasAllOrgPerm = authorizedAdminOrgSet.isHasAllOrgPerm();
        List hasPermOrgs = authorizedAdminOrgSet.getHasPermOrgs();
        if (!hasAllOrgPerm) {
            QFilter filter = !WTCCollections.isEmpty((Collection)hasPermOrgs) ? new QFilter("id", "in", (Object)hasPermOrgs) : new QFilter("id", "=", (Object)0L);
            event.getCustomQFilters().add(filter);
        }
        if (HRStringUtils.equals((String)orgType, (String)"bos_org")) {
            event.getFormShowParameter().setCustomParam("orgFuncId", (Object)"26");
            event.getFormShowParameter().setCustomParam("showAdminOrgViewType", (Object)Boolean.FALSE);
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldKey = basedataEdit.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"attgeneraterule") || HRStringUtils.equals((String)fieldKey, (String)"attperiod")) {
            this.afterF7SelectOfAttInfo();
        }
    }

    private void afterF7SelectOfAttInfo() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("datainfoentity");
        HashMap<Long, ArrayList<Long>> dataInfoMap = new HashMap<Long, ArrayList<Long>>(16);
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(index);
            DynamicObject rule = dynamicObject.getDynamicObject("attgeneraterule");
            DynamicObject attPeriod = dynamicObject.getDynamicObject("attperiod");
            if (attPeriod == null || rule == null) continue;
            Long ruleId = rule.getLong("id");
            Long periodId = attPeriod.getLong("id");
            ArrayList<Long> attPeriodList = (ArrayList<Long>)dataInfoMap.get(ruleId);
            if (null != attPeriodList) {
                if (attPeriodList.contains(periodId)) {
                    String ruleName = ((DynamicObject)collection.get(index)).getString("attgeneraterule.name");
                    String periodName = ((DynamicObject)collection.get(index)).getString("attperiod.name");
                    this.getView().showTipNotification(IntegrationKDString.chooseSame((String)ruleName, (String)periodName));
                    this.getModel().setValue("attperiod", null, index);
                    return;
                }
                attPeriodList.add(periodId);
                dataInfoMap.put(ruleId, attPeriodList);
                continue;
            }
            attPeriodList = new ArrayList<Long>(10);
            attPeriodList.add(periodId);
            dataInfoMap.put(ruleId, attPeriodList);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void dispatch() {
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
        ArrayList excludeIdList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList adminOrgList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject entity : orgEntity) {
            excludeIdList.addAll(entity.getDynamicObjectCollection("excludeattperson").stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList()));
            String orgType = entity.getString("orgtype");
            DynamicObject org = (DynamicObject)entity.get("org");
            if (org == null) continue;
            if (HRStringUtils.equals((String)orgType, (String)"bos_org")) {
                orgList.add(org.getLong("id"));
                continue;
            }
            adminOrgList.add(org.getLong("id"));
        }
        DynamicObjectCollection data = this.getModel().getEntryEntity("personentity");
        List attFileIds = data.stream().map(attFile -> attFile.getLong("attfile.id")).collect(Collectors.toList());
        DynamicObjectCollection dataInfoEntity = this.getModel().getEntryEntity("datainfoentity");
        ArrayList dataInfoEntryList = Lists.newArrayListWithExpectedSize((int)dataInfoEntity.size());
        long orgId = this.getModel().getDataEntity().getLong("orgid.id");
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("personentity", attFileIds);
        params.put("orgid", orgId);
        params.put("ORG_ID_LIST", orgList);
        params.put("ADMIN_ORG_ID_LIST", adminOrgList);
        params.put("EXCLUDE_FILE_LIST", excludeIdList);
        HashMap checkAttFileParam = Maps.newHashMapWithExpectedSize((int)10);
        checkAttFileParam.putAll(params);
        for (DynamicObject dyn : dataInfoEntity) {
            HashMap entryMap = Maps.newHashMapWithExpectedSize((int)2);
            entryMap.put("attperiodId", dyn.getLong("attperiod.id"));
            entryMap.put("attgenerateruleId", dyn.getLong("attgeneraterule.id"));
            checkAttFileParam.putAll(entryMap);
            List attFileList = AttDataAddHelper.getAttDataAddFiles((Map)checkAttFileParam, attFileIds, new ArrayList());
            Set useAbelAttFileBoIds = attFileList.stream().filter(attFile -> WTCStringUtils.equals((String)attFile.getString("usablestatus"), (String)"0")).map(attFile -> attFile.getLong("boid")).collect(Collectors.toSet());
            if (WTCCollections.isEmpty(useAbelAttFileBoIds)) {
                String periodName = dyn.getString("attperiod.name");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4{0}\u5185\u672a\u627e\u5230\u6743\u9650\u4e0b\u7684\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4eba\u5458\u3002", (String)"AttDataAddPlugin_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[]{periodName}));
                return;
            }
            dataInfoEntryList.add(entryMap);
        }
        params.put("datainfoentity", dataInfoEntryList);
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    private void addAuth(BeforeF7SelectEvent event) {
        QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtis", "wtis_payattdatainfo", "attfile", "47150e89000000ac", new HashMap());
        if (null != dataRuleForBdProp) {
            event.getCustomQFilters().add(dataRuleForBdProp);
        }
    }
}

