/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.integration;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.attdata.impl.AttRecordPushPrintServiceImpl;
import kd.wtc.wtis.business.attdata.impl.AttRecordSummaryPrintServiceImpl;
import kd.wtc.wtis.business.attdata.service.IAttRecordPrintService;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.helper.BizDataFailStatusEnum;
import kd.wtc.wtis.common.constants.SeeAttDataConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.enums.AttFileBaseStatusEnum;
import kd.wtc.wtis.enums.IntegrStatusEnum;

public class AttDataDetailList
extends HRCoreBaseList
implements SeeAttDataConstants {
    private static final List<IAttRecordPrintService> ATT_RECORD_PRINT_SERVICES = Lists.newArrayListWithExpectedSize((int)16);
    private static final String OPERATE = "operate";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String showType = (String)showParameter.getCustomParam("showtype");
        HashSet fixCol = Sets.newHashSetWithExpectedSize((int)4);
        HashSet removeCol = Sets.newHashSetWithExpectedSize((int)4);
        if (HRStringUtils.isEmpty((String)showType)) {
            return;
        }
        switch (showType) {
            case "extab": {
                fixCol.add(OPERATE);
                fixCol.add("generstatus");
                fixCol.add("attfilebase.attperson.name");
                fixCol.add("attfilebase.attperson.number");
                fixCol.add("exinfo");
                removeCol.add("withdrawresult");
                removeCol.add("withdrawexinfo");
                removeCol.add("attfileboid.name");
                break;
            }
            case "successtab": {
                fixCol.add(OPERATE);
                fixCol.add("attfilebase.attperson.name");
                fixCol.add("attfilebase.attperson.number");
                removeCol.add("generstatus");
                removeCol.add("exinfo");
                removeCol.add("withdrawresult");
                removeCol.add("withdrawexinfo");
                removeCol.add("attfileboid.name");
                break;
            }
            case "failtab": 
            case "unextab": {
                fixCol.add("attfilebase.attperson.name");
                fixCol.add("attfilebase.attperson.number");
                fixCol.add("exinfo");
                removeCol.add(OPERATE);
                removeCol.add("generstatus");
                removeCol.add("withdrawresult");
                removeCol.add("withdrawexinfo");
                removeCol.add("attfileboid.name");
                IListColumn number = args.getListColumn("exinfo");
                number.setForeColor("#FB2323");
                break;
            }
            case "withdrawtab": {
                fixCol.add("withdrawresult");
                fixCol.add("withdrawexinfo");
                fixCol.add("attfileboid.name");
                removeCol.add("generstatus");
                removeCol.add("exinfo");
                removeCol.add("attfileboid.textname");
                removeCol.add(OPERATE);
                break;
            }
        }
        List columns = args.getListColumns();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            IListColumn next = (IListColumn)iterator.next();
            if (next == null) continue;
            String listFieldKey = next.getListFieldKey();
            if (fixCol.contains(listFieldKey)) {
                next.setFixed(true);
            }
            if (!removeCol.contains(listFieldKey)) continue;
            iterator.remove();
        }
        args.setListColumns(columns);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
        final boolean ex = HRStringUtils.equals((String)"extab", (String)showType);
        final boolean success = HRStringUtils.equals((String)"successtab", (String)showType);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.getDynamicObjectType().registerProperty(AttDataDetailList.OPERATE, String.class, (Object)"", false);
                for (DynamicObject row : rows) {
                    String geNerStatus;
                    if (ex && HRStringUtils.equals((String)"1", (String)(geNerStatus = row.getString("generstatus")))) {
                        row.set(AttDataDetailList.OPERATE, (Object)IntegrationKDString.seeDetail());
                    }
                    if (success) {
                        row.set(AttDataDetailList.OPERATE, (Object)IntegrationKDString.seeDetail());
                    }
                    AttDataDetailList.this.getWithDrawExInfoByCode(row);
                }
                return rows;
            }
        });
    }

    private void getWithDrawExInfoByCode(DynamicObject row) {
        String withDrawExInfo;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String showType = (String)showParameter.getCustomParam("showtype");
        if (HRStringUtils.equals((String)"withdrawtab", (String)showType) && !WTCStringUtils.isEmpty((String)(withDrawExInfo = row.getString("withdrawexinfo")))) {
            String[] splits = WTCStringUtils.split((String)withDrawExInfo, (String)",");
            ArrayList reasonValueList = Lists.newArrayListWithExpectedSize((int)16);
            for (String str : splits) {
                reasonValueList.add(BizDataFailStatusEnum.getDesc((String)str) + WTCSymbolMultiLanguageUtil.getStopSymbol());
            }
            row.set("withdrawexinfo", (Object)WTCStringUtils.join((List)reasonValueList, (String)"\r\n"));
        }
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
        QFilter numFilter = SeeAttDataHelper.getInstance().getTabFilter(taskId, showType);
        event.addCustomQFilter(numFilter);
        if (HRStringUtils.isEmpty((String)showType)) {
            event.setOrderBy("attperson.number asc ");
        } else {
            event.setOrderBy("generstatus desc,attperson.number asc ");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowSelectAllListeners(listRowSelectAllEvent -> this.setSelectIdToPage());
        billList.addClearSelectionListener(clearSelectionListener -> this.setSelectIdToPage());
    }

    private void setSelectIdToPage() {
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        List collect = Arrays.stream(rows).map(Long.class::cast).collect(Collectors.toList());
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
            String pageKey = "selectidset" + showType;
            parentView.getPageCache().put(pageKey, JSONObject.toJSONString(collect));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long detailId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)OPERATE, (String)fieldName)) {
            String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)detailId);
            if (dynamicObject == null) {
                return;
            }
            String integrationStatus = dynamicObject.getString("integrstatus");
            String usableStatus = dynamicObject.getDynamicObject("attfileboid").getString("usablestatus");
            if (WTCStringUtils.equals((String)usableStatus, (String)AttFileBaseStatusEnum.ABANDON.getCode()) && (WTCStringUtils.equals((String)integrationStatus, (String)IntegrStatusEnum.FAIL.getCode()) || WTCStringUtils.equals((String)integrationStatus, (String)IntegrStatusEnum.NON.getCode()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AttDataDetailList_20", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
                return;
            }
            switch (showType) {
                case "extab": 
                case "successtab": {
                    SeeAttDataHelper.getInstance().showAttEditionDet(this.getView(), detailId.longValue(), "wtis_atteditiondetview");
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)"attfileboid.attperson.name", (String)fieldName) || HRStringUtils.equals((String)"attfilebase_attperson_name", (String)fieldName)) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttask");
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)detailId);
            if (dynamicObject.getDynamicObject("attfilebase") == null) {
                return;
            }
            AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, null, (Object)dynamicObject.getLong("attfilebase.id"));
        }
        this.showAttFileDetailView(fieldName, detailId);
    }

    private void showAttFileDetailView(String fieldName, Long detailId) {
        if (HRStringUtils.equals((String)"attfileboid_name", (String)fieldName)) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)detailId);
            if (dynamicObject.getDynamicObject("attfileboid") == null) {
                return;
            }
            AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, null, (Object)dynamicObject.getLong("attfileboid.id"));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.setSelectIdToPage();
    }

    public void beforeExportFile(BeforeExportFileEvent env) {
        super.beforeExportFile(env);
        String isPushTaskPrint = this.getView().getPageCache().get("isPushTaskPrint");
        String taskNumber = (String)this.getView().getFormShowParameter().getCustomParam("tasknumber");
        for (IAttRecordPrintService attRecordPrintService : ATT_RECORD_PRINT_SERVICES) {
            if (!attRecordPrintService.suppose(isPushTaskPrint)) continue;
            attRecordPrintService.setFileName(env, taskNumber);
        }
    }

    public void afterExportFile(ExportFileEvent ee) {
        String isPushTaskPrint = this.getView().getPageCache().get("isPushTaskPrint");
        super.afterExportFile(ee);
        File file = ee.getFile();
        ArrayList<Long> attItemIds = new ArrayList<Long>();
        List<String> names = this.getAttFileItemName(attItemIds);
        for (IAttRecordPrintService attRecordPrintService : ATT_RECORD_PRINT_SERVICES) {
            if (!attRecordPrintService.suppose(isPushTaskPrint)) continue;
            attRecordPrintService.print(file, names, attItemIds, this.getView());
        }
    }

    private List<String> getAttFileItemName(List<Long> attItemIds) {
        ArrayList<String> names = new ArrayList<String>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object ruleObject = formShowParameter.getCustomParam("ruleId");
        Long ruleId = ruleObject instanceof Integer ? Long.valueOf(((Integer)ruleObject).longValue()) : (Long)ruleObject;
        HRBaseServiceHelper helperOfRule = new HRBaseServiceHelper("wtis_integrationrule");
        DynamicObject ruleDyn = helperOfRule.queryOne((Object)ruleId);
        DynamicObjectCollection entryentity = ruleDyn.getDynamicObjectCollection("entryentity");
        entryentity.forEach(entity -> {
            names.add(entity.getLocaleString("attitemld.name").getLocaleValue());
            attItemIds.add(entity.getLong("attitemld.id"));
        });
        return names;
    }

    static {
        ATT_RECORD_PRINT_SERVICES.add((IAttRecordPrintService)new AttRecordSummaryPrintServiceImpl());
        ATT_RECORD_PRINT_SERVICES.add((IAttRecordPrintService)new AttRecordPushPrintServiceImpl());
    }
}

