/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.integration;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtis.business.web.attdataintegrate.AttDataGenerateHelper;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.schedule.AttJobTaskHelper;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.fromplugin.web.integration.AttDataListProvider;

public class AttDataGenerateList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(AttDataGenerateList.class);
    private static HRBaseServiceHelper attDataGenerateServiceHelper = new HRBaseServiceHelper("wtis_payatttask");
    private static HRBaseServiceHelper subTaskHelper = new HRBaseServiceHelper("wtis_payattsubtask");
    private static HRBaseServiceHelper taskDetailHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
    private static HRBaseServiceHelper taskDetaiDatalHelper = new HRBaseServiceHelper("wtis_payattdatainfo");

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("createtime desc,modifytime desc");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        IListView listView = (IListView)this.getView();
        ListSelectedRow baseDataListRow = listView.getCurrentSelectedRowInfo();
        Object primaryKeyValue = baseDataListRow.getPrimaryKeyValue();
        DynamicObject attDataGenerate = new HRBaseServiceHelper("wtis_payatttask").loadDynamicObject(new QFilter("id", "=", primaryKeyValue));
        if (attDataGenerate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AttDataGenerateList_7", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        String status = attDataGenerate.getString("taskstatus");
        if (!WTCTaskStatus.ALL_FINISHED.getCode().equals(status)) {
            this.getView().showTipNotification(IntegrationKDString.generateComStatus());
            return;
        }
        HashMap<String, Object> paramHashMap = new HashMap<String, Object>(16);
        paramHashMap.put("version", attDataGenerate.getString("version"));
        String cacheString = SerializationUtils.serializeToBase64((Object)attDataGenerate);
        paramHashMap.put("attDataGenerate", cacheString);
        if ("version".equals(fieldName)) {
            paramHashMap.put("whichTab", "executetab");
        } else if ("runattperson".equals(fieldName)) {
            paramHashMap.put("whichTab", "executetab");
        } else if ("succeedattperson".equals(fieldName)) {
            paramHashMap.put("whichTab", "successtab");
        } else if ("failedattperson".equals(fieldName)) {
            paramHashMap.put("whichTab", "failtab");
        } else if ("notrunattperson".equals(fieldName)) {
            paramHashMap.put("whichTab", "unexecutetab");
        }
        paramHashMap.put("id", primaryKeyValue);
        AttDataGenerateHelper.showDetailPage(paramHashMap, (String)"wtis_seeattcreatedata", (IFormView)this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRow baseDataListRow = listView.getCurrentSelectedRowInfo();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if ("addnew".equals(operateKey)) {
            this.addNewOp();
        } else if ("tootherpage".equals(operateKey)) {
            this.toOtherPageOp();
        } else if ("rerun".equals(operateKey)) {
            this.reRunOp(baseDataListRow, selectedRows);
        } else if ("stop".equals(operateKey)) {
            this.stopOp(baseDataListRow, selectedRows);
        } else if ("del".equals(operateKey)) {
            this.deleteOp(selectedRows);
        }
    }

    public void toOtherPageOp() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("wtis_payattpushtask");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(this.getView().getPageId() + "wtis_payattpushtask");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addNewOp() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtis_attdata_add");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newAttDataGenerate"));
        this.getView().showForm(showParameter);
    }

    private boolean checkDelete(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 0) {
            return false;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u5355\u6761\u6570\u636e\u5220\u9664\u3002", (String)"AttDataGenerateList_15", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> numberList = new ArrayList<String>(10);
        for (ListSelectedRow selectedRow : selectedRows) {
            numberList.add(selectedRow.getNumber());
        }
        QFilter filter = new QFilter("number", "in", numberList);
        DynamicObject[] attSelectDatas = attDataGenerateServiceHelper.loadDynamicObjectArray(filter.toArray());
        if (attSelectDatas.length == 0) {
            return false;
        }
        String id = "creator.id";
        for (DynamicObject attSelectData : attSelectDatas) {
            long creatorId = attSelectData.getLong(id);
            if (creatorId != UserServiceHelper.getCurrentUserId()) {
                this.getView().showErrorNotification(IntegrationKDString.delMySelfTask());
                return false;
            }
            String taskStatus = attSelectData.getString("taskstatus");
            if (!WTCTaskStatus.TERMINATING.getCode().equals(taskStatus) && !WTCTaskStatus.RUNNING.getCode().equals(taskStatus)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u4e2d\u6216\u8fd0\u884c\u4e2d\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"AttDataGenerateList_14", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter canDeleteFilter = new QFilter("integratestatus", "=", (Object)"A");
        canDeleteFilter.or(new QFilter("integratestatus", "=", (Object)"C").and(new QFilter("insuccessnum", "=", (Object)0)).and(new QFilter("infailnum", "=", (Object)0)));
        filter.and(canDeleteFilter);
        DynamicObject[] attDatas = attDataGenerateServiceHelper.loadDynamicObjectArray(filter.toArray());
        if (attDatas.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u52e4\u6570\u636e\u4f7f\u7528\u4e2d\u6216\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AttDataGenerateList_0", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void deleteOp(ListSelectedRowCollection selectedRows) {
        if (this.checkDelete(selectedRows)) {
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c", (String)"AttDataGenerateList_8", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"AttDataGenerateList_9", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]), selectedRows.size());
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("confirm", (IFormPlugin)this);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteData(ListSelectedRowCollection selectedRows) {
        try (TXHandle txHandle = null;){
            List taskIds = selectedRows.stream().map(selectedRow -> Long.parseLong(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            txHandle = TX.required((String)"deleteAttData");
            QFilter deleteFilterTask = new QFilter("id", "in", taskIds);
            attDataGenerateServiceHelper.deleteByFilter(deleteFilterTask.toArray());
            QFilter deleteFilterSubTask = new QFilter("taskid", "in", taskIds);
            subTaskHelper.deleteByFilter(deleteFilterSubTask.toArray());
            Map detailIdsByTaskIds = SeeAttDataHelper.getInstance().getDetailIdsByTaskIds(taskIds);
            Set detailIds = detailIdsByTaskIds.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            QFilter deleteFilterTaskDetailData = new QFilter("taskdetail", "in", detailIds);
            taskDetaiDatalHelper.deleteByFilter(deleteFilterTaskDetailData.toArray());
            QFilter deleteFilterTaskDetail = new QFilter("taskid", "in", taskIds);
            taskDetailHelper.deleteByFilter(deleteFilterTaskDetail.toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AttDataGenerateList_6", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
        }
    }

    public void stopOp(ListSelectedRow baseDataListRow, ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u53ea\u5141\u8bb8\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"AttDataGenerateList_2", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        if (baseDataListRow == null) {
            return;
        }
        String number = baseDataListRow.getNumber();
        Long primaryKeyValue = (Long)baseDataListRow.getPrimaryKeyValue();
        DynamicObject attData = attDataGenerateServiceHelper.loadDynamicObject(new QFilter("number", "=", (Object)number));
        if (attData.getLong("creator.id") != UserServiceHelper.getCurrentUserId()) {
            this.getView().showErrorNotification(IntegrationKDString.stopMySelfTask());
            return;
        }
        if (!WTCTaskStatus.RUNNING.getCode().equals(attData.getString("taskstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u72b6\u6001\u4e3a\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"AttDataGenerateList_5", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> numberList = new ArrayList<String>(10);
        numberList.add(number);
        AttDataGenerateHelper.updateAttDataStatus(numberList, (String)"C");
        this.stopTaskJob(primaryKeyValue);
        this.getView().updateView();
    }

    public void reRunOp(ListSelectedRow baseDataListRow, ListSelectedRowCollection selectedRows) {
        int genUnExNum;
        String genStatus;
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u53ea\u5141\u8bb8\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"AttDataGenerateList_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        if (baseDataListRow == null) {
            return;
        }
        Object taskId = baseDataListRow.getPrimaryKeyValue();
        DynamicObject attData = attDataGenerateServiceHelper.loadDynamicObject(new QFilter("id", "=", taskId));
        if (attData == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AttDataGenerateList_7", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        HashSet status = Sets.newHashSet((Object[])new String[]{AttDataIntegrateConstants.NOTEXECUTE, AttDataIntegrateConstants.ERROR, AttDataIntegrateConstants.HALF});
        if (!status.contains(genStatus = attData.getString("genstatus"))) {
            this.getView().showErrorNotification(IntegrationKDString.reCalculationError());
            return;
        }
        if (attData.getLong("creator.id") != UserServiceHelper.getCurrentUserId()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u65b0\u751f\u6210\u81ea\u5df1\u521b\u5efa\u7684\u63a8\u9001\u6570\u636e\u751f\u6210\u4efb\u52a1\u3002", (String)"AttDataGenerateList_4", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        int genFailNum = attData.getInt("failedattperson");
        if (genFailNum + (genUnExNum = attData.getInt("notrunattperson")) == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6c47\u603b\u6570\u636e\u3002", (String)"AttDataGenerateList_3", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("generstatus", "!=", (Object)AttDataIntegrateConstants.GENSTATU_ONE);
        AttJobTaskHelper.getInstance().recalculation((Long)taskId, this.getView(), (IFormPlugin)this, qFilter);
        this.getView().updateView();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("newAttDataGenerate".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            HashMap params = Maps.newHashMapWithExpectedSize((int)returnData.size());
            params.put("opType", "addnew");
            params.put("personentity", returnData.get("personentity"));
            params.put("orgid", returnData.get("orgid"));
            params.put("ORG_ID_LIST", returnData.get("ORG_ID_LIST"));
            params.put("ADMIN_ORG_ID_LIST", returnData.get("ADMIN_ORG_ID_LIST"));
            params.put("EXCLUDE_FILE_LIST", returnData.get("EXCLUDE_FILE_LIST"));
            this.dispatchJobs(returnData, params);
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void dispatchJobs(Map<String, Object> returnData, Map<String, Object> params) {
        List infoEntryList = (List)returnData.get("datainfoentity");
        if (infoEntryList.size() == 1) {
            params.putAll((Map)infoEntryList.get(0));
            AttJobTaskHelper.getInstance().dispatchJob(params, (IFormPlugin)this, this.getView());
        } else {
            ArrayList coll = Lists.newArrayListWithCapacity((int)infoEntryList.size());
            for (Map entryInfo : infoEntryList) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.putAll(entryInfo);
                map.put("version", AttJobTaskHelper.getTaskVersion());
                map.putAll(params);
                coll.add(map);
            }
            WTCDistributeTaskHelper.batchRunTaskBackground((IFormView)this.getView(), (String)"wtis_payatt", (Collection)coll);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new AttDataListProvider());
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        Map result;
        String taskInfoStr;
        logger.info("AttDataGenerate taskCallBack : {}", returnData);
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject obj = (JSONObject)JSONObject.parse((String)data);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wtis_generateproresult");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("result", (Object)obj);
            this.getView().showForm(showParameter);
        }
    }

    public void stopTaskJob(Long primaryKeyValue) {
        WTCDistributeTaskHelper.terminateTask((long)primaryKeyValue, (String)"wtis_payatt");
        this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"AttDataIntegrateList_18", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        ListSelectedRowCollection list;
        if (WTCStringUtils.equals((String)event.getCallBackId(), (String)"confirm") && MessageBoxResult.Yes == event.getResult() && this.checkDelete(list = ((IListView)this.getView()).getSelectedRows())) {
            this.deleteData(list);
            list.clear();
            ((IListView)this.getView()).refresh();
        }
    }
}

