/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.integration;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;

public class PushProcessResultPlugin
extends HRDynamicFormBasePlugin {
    private static final String SEEDETAIL = "seedetail";
    private static final String TASK = "task";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button detail = (Button)this.getControl(SEEDETAIL);
        if (detail != null) {
            detail.addClickListener((ClickListener)this);
        }
        Button btnok = (Button)this.getControl("btnok");
        btnok.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(SEEDETAIL)) {
            String number = (String)this.getModel().getValue(TASK);
            if (HRStringUtils.isEmpty((String)number)) {
                return;
            }
            DynamicObject attDataGenerate = new HRBaseServiceHelper("wtis_payatttask").loadDynamicObject(new QFilter("version", "=", (Object)number));
            if (attDataGenerate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AttDataGenerateList_7", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
                return;
            }
            String integrateStatus = attDataGenerate.getString("integratestatus");
            if ("A".equals(integrateStatus)) {
                this.getView().showTipNotification(IntegrationKDString.integrateBusStatusA());
                return;
            }
            if ("B".equals(integrateStatus)) {
                this.getView().showTipNotification(IntegrationKDString.integrateBusStatusB());
                return;
            }
            HashMap<String, String> paramHashMap = new HashMap<String, String>(16);
            String cacheString = SerializationUtils.serializeToBase64((Object)attDataGenerate);
            paramHashMap.put("attDataGenerate", cacheString);
            paramHashMap.put("whichTab", "executetab");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wtis_seeattintegrdata");
            showParameter.setCaption(IntegrationKDString.seeIntDate((String)number));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParams(paramHashMap);
            this.getView().showForm(showParameter);
        } else if (key.startsWith("btnok")) {
            if (this.getView().getParentView() instanceof IListView) {
                ((IListView)this.getView().getParentView()).refresh();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String data = (String)showParameter.getCustomParam("data");
        if (!HRStringUtils.isEmpty((String)data)) {
            Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            int successCount = (Integer)dataMap.get("successAttfileBidSize");
            Label successCountLabel = (Label)this.getControl("oknum");
            successCountLabel.setText(String.valueOf(successCount));
            int failCount = (Integer)dataMap.get("errorAttfileBidSize");
            Label failCountLabel = (Label)this.getControl("failnum");
            failCountLabel.setText(String.valueOf(failCount));
            String version = (String)dataMap.get("version");
            Label taskName = (Label)this.getControl("taskname");
            taskName.setText(IntegrationKDString.taskName() + version);
            this.getModel().setValue(TASK, (Object)version);
        }
    }
}

