/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.integration;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.schedule.AttJobTaskHelper;
import kd.wtc.wtis.common.constants.AttDataIntegrateConstants;
import kd.wtc.wtis.common.constants.SeeAttDataConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;

public class SeeAttCreateDataEdit
extends HRDynamicFormBasePlugin
implements SeeAttDataConstants,
TabSelectListener {
    private static final int MAX_PRINT_DATA = 1000000;

    public void beforeBindData(EventObject eventObject) {
        Object busInfo;
        DynamicObject attDataGen;
        super.beforeBindData(eventObject);
        String resultStr = (String)this.getView().getFormShowParameter().getCustomParam("attDataGenerate");
        if (resultStr == null) {
            String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttask");
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            attDataGen = hrBaseServiceHelper.queryOne("id,version,creator,integrationrule,attperiodentry,org", qFilter);
        } else {
            attDataGen = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)resultStr);
        }
        if (attDataGen == null) {
            return;
        }
        this.getModel().setValue("attdatagenerate", (Object)attDataGen.getLong("id"));
        this.getModel().setValue("org", (Object)attDataGen.getLong("org.id"));
        String creator = attDataGen.getDynamicObject("creator") != null ? attDataGen.getDynamicObject("creator").get("id").toString() : null;
        this.getView().getPageCache().put("createperson", creator);
        if (attDataGen.getDynamicObject("integrationrule") != null && attDataGen.getDynamicObject("integrationrule").getDynamicObject("businessareaid") != null && (busInfo = attDataGen.getDynamicObject("integrationrule").getDynamicObject("businessareaid").get("name")) != null) {
            this.getModel().setValue("busareainfor", busInfo);
        }
        SeeAttDataHelper.getInstance().setCreateTabNew(attDataGen, this.getView());
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("whichTab");
        Tab tab = (Tab)this.getView().getControl("tabap");
        switch (customParam) {
            case "executetab": {
                tab.activeTab("extab");
                break;
            }
            case "successtab": {
                tab.activeTab("successtab");
                break;
            }
            case "failtab": {
                tab.activeTab("failtab");
                break;
            }
            case "unexecutetab": {
                tab.activeTab("unextab");
                break;
            }
        }
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        this.addClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.showPageList(tabKey);
    }

    private String getCurTabViewPageId(String curTab) {
        return this.getView().getPageCache().get("tab_view_pageId_" + curTab);
    }

    private void showPageList(String targetKey) {
        DynamicObject attDataGen = this.getModel().getDataEntity().getDynamicObject("attdatagenerate");
        if (attDataGen == null) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"SeeAttCreateDataEdit_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            return;
        }
        Long taskId = attDataGen.getLong("id");
        String version = attDataGen.getString("version");
        this.getView().getPageCache().put("tab_cur_key_", targetKey);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.setCustomParam("taskid", (Object)taskId);
        listShowParameter.setCustomParam("showtype", (Object)targetKey);
        listShowParameter.setCustomParam("tasknumber", (Object)version);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject[] details = helper.query("id", new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        List detailIds = Arrays.stream(details).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        listShowParameter.setCustomParam("detailIds", detailIds);
        Long ruleId = this.getModel().getDataEntity().getLong("attdatagenerate.integrationrule.id");
        listShowParameter.setCustomParam("tabap", (Object)targetKey);
        listShowParameter.setCustomParam("ruleId", (Object)ruleId);
        listShowParameter.setShowTitle(false);
        listShowParameter.setBillFormId("wtis_payatttaskdetail");
        listShowParameter.setFormId("wtbs_rimlesslist");
        this.getView().getPageCache().put("tab_view_pageId_" + targetKey, listShowParameter.getPageId());
        this.getView().showForm((FormShowParameter)listShowParameter);
        this.getView().updateView(targetKey);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"refresh", (String)source.getKey())) {
            this.refreshPage();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"recalculation", (String)operateKey)) {
            this.reCalculationOp();
        } else if (HRStringUtils.equals((String)"export", (String)operateKey)) {
            List collect;
            String curTabKey = this.getView().getPageCache().get("tab_cur_key_");
            String pageId = this.getCurTabViewPageId(curTabKey);
            IFormView tabView = this.getView().getView(pageId);
            if (tabView == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = ((ListView)tabView).getSelectedRows();
            if (selectedRows.isEmpty()) {
                DynamicObject[] tabAllAttData = SeeAttDataHelper.getInstance().getTabAllAttData(this.getView());
                collect = Arrays.stream(tabAllAttData).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            } else {
                collect = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            }
            if (collect.size() > 1000000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8d85\u8fc7100\u4e07\u4ee5\u4e0a\u7684\u6570\u636e\uff0c\u8bf7\u5206\u6279\u6b21\u5bfc\u51fa\u3002", (String)"SeeAttIntegrDataEdit_0", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
                return;
            }
            tabView.getPageCache().put("exportidlist", JSONObject.toJSONString(collect));
            tabView.invokeOperation("exportlist_expt");
            this.getView().sendFormAction(tabView);
        } else if (HRStringUtils.equals((String)"refresh", (String)operateKey)) {
            this.refreshPage();
        } else if (HRStringUtils.equals((String)"exportdetails", (String)operateKey)) {
            String curTabKey = this.getView().getPageCache().get("tab_cur_key_");
            String pageId = this.getCurTabViewPageId(curTabKey);
            IFormView tabView = this.getView().getView(pageId);
            tabView.invokeOperation("exportdetails");
            this.getView().sendFormAction(tabView);
        }
    }

    private void reCalculationOp() {
        DynamicObject[] queryDynObj;
        String showType = this.getView().getPageCache().get("tab_cur_key_");
        String pageKey = "selectidset" + showType;
        List idList = (List)new HRPageCache(this.getPageCache()).get(pageKey, List.class);
        if (idList == null || idList.isEmpty()) {
            this.getView().showTipNotification(IntegrationKDString.emptyData());
            return;
        }
        for (DynamicObject dynObj : queryDynObj = SeeAttDataHelper.getInstance().getCreateAttData(idList)) {
            if (dynObj.get("generstatus") != null && !"1".equals(dynObj.get("generstatus").toString())) continue;
            this.getView().showErrorNotification(IntegrationKDString.reCalculationError());
            return;
        }
        String creator = this.getView().getPageCache().get("createperson");
        Long userId = UserServiceHelper.getCurrentUserId();
        if (creator == null || !creator.equals(userId.toString())) {
            this.getView().showErrorNotification(IntegrationKDString.creatorError());
            return;
        }
        List attDataIdList = Arrays.stream(queryDynObj).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", attDataIdList);
        qFilter.and(new QFilter("generstatus", "!=", (Object)AttDataIntegrateConstants.GENSTATU_ONE));
        Long taskId = queryDynObj[0].getLong("taskid");
        AttJobTaskHelper.getInstance().recalculation(taskId, this.getView(), (IFormPlugin)this, qFilter);
        this.refreshPage();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void refreshPage() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        this.showPageList(currentTab);
        tab.activeTab(currentTab);
    }

    private void taskCallBack(Object returnData) {
        AttJobTaskHelper.showFormMsg((Object)returnData, (IFormView)this.getView());
    }
}

