/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.integration;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtis.business.attdata.impl.AttDataWithDrawServiceImpl;
import kd.wtc.wtis.business.attdata.service.IAttDataPushService;
import kd.wtc.wtis.business.web.attdataintegrate.SeeAttDataHelper;
import kd.wtc.wtis.business.web.schedule.AttJobTaskHelper;
import kd.wtc.wtis.common.constants.SeeAttDataConstants;
import kd.wtc.wtis.common.kdstring.IntegrationKDString;
import kd.wtc.wtis.enums.AttFileBaseStatusEnum;
import kd.wtc.wtis.enums.IntegrStatusEnum;
import kd.wtc.wtis.enums.WithDrawResultEnum;

public class SeeAttIntegrDataEdit
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener,
SeeAttDataConstants,
TabSelectListener {
    private static final int MAX_PRINT_DATA = 1000000;
    private static final String CREATEPERSON = "createperson";
    private static final AfterBindDataListener AFTER_BIND_DATA_LISTENER = evt -> {
        BillList source = (BillList)evt.getSource();
        source.clearSelection();
    };

    public void registerListener(EventObject eo) {
        BillList exBillList = (BillList)this.getView().getControl("exbilllistap");
        exBillList.addHyperClickListener((HyperLinkClickListener)this);
        exBillList.addAfterBindDataListener(AFTER_BIND_DATA_LISTENER);
        BillList sucBillList = (BillList)this.getView().getControl("sucbilllistap");
        sucBillList.addHyperClickListener((HyperLinkClickListener)this);
        sucBillList.addAfterBindDataListener(AFTER_BIND_DATA_LISTENER);
        BillList failBillList = (BillList)this.getView().getControl("failbilllistap");
        failBillList.addHyperClickListener((HyperLinkClickListener)this);
        failBillList.addAfterBindDataListener(AFTER_BIND_DATA_LISTENER);
        BillList wiDrBillList = (BillList)this.getView().getControl("widrbilllistap");
        wiDrBillList.addHyperClickListener((HyperLinkClickListener)this);
        wiDrBillList.addAfterBindDataListener(AFTER_BIND_DATA_LISTENER);
        BillList unBillList = (BillList)this.getView().getControl("unexbilllistap");
        unBillList.addHyperClickListener((HyperLinkClickListener)this);
        unBillList.addAfterBindDataListener(AFTER_BIND_DATA_LISTENER);
        this.addClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (HRStringUtils.equals((String)"attfileboid_name", (String)arg0.getFieldName())) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
            BillList billList = (BillList)arg0.getSource();
            String rowsBill = billList.getCurrentSelectedRowInfo().toString().replace("[", "").replace("]", "").replaceAll("\"", "");
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)Long.valueOf(rowsBill));
            if (dynamicObject.getDynamicObject("attfileboid") == null) {
                return;
            }
            AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, null, (Object)dynamicObject.getLong("attfileboid.id"));
        }
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("exbilllistap");
        billList.addPackageDataListener(pkEvent -> {
            Object str = pkEvent.getRowData().get("integrstatus");
            if (pkEvent.getSource() instanceof ListOperationColumnDesc) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!"creviewdetails".equalsIgnoreCase(operationColItem.getOperationKey()) || str.toString().equals("3") || str.toString().equals("2") || str.toString().equals("4")) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    public void beforeBindData(EventObject eventObject) {
        Object busInfo;
        super.beforeBindData(eventObject);
        String resultStr = (String)this.getView().getFormShowParameter().getCustomParam("attDataGenerate");
        DynamicObject attDataGen = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)resultStr);
        if (attDataGen == null) {
            return;
        }
        this.getModel().setValue("attdatagenerate", (Object)attDataGen.getLong("id"));
        this.getModel().setValue("org", (Object)attDataGen.getLong("org.id"));
        String creator = attDataGen.getDynamicObject("creator") != null ? attDataGen.getDynamicObject("creator").get("id").toString() : null;
        this.getView().getPageCache().put(CREATEPERSON, creator);
        if (attDataGen.getDynamicObject("integrationrule") != null && attDataGen.getDynamicObject("integrationrule").getDynamicObject("businessareaid") != null && (busInfo = attDataGen.getDynamicObject("integrationrule").getDynamicObject("businessareaid").get("name")) != null) {
            this.getModel().setValue("busareainfor", busInfo);
        }
        SeeAttDataHelper.getInstance().setIntegrTab(attDataGen, this.getView());
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("whichTab");
        if (HRStringUtils.isEmpty((String)customParam)) {
            customParam = "successtab";
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        switch (customParam) {
            case "executetab": {
                tab.activeTab("extab");
                break;
            }
            case "successtab": {
                tab.activeTab("successtab");
                break;
            }
            case "failtab": {
                tab.activeTab("failtab");
                break;
            }
            case "withdrawtab": {
                tab.activeTab("withdrawtab");
                break;
            }
            case "unextab": {
                tab.activeTab("unextab");
                break;
            }
        }
        this.showPage("extabprint");
        this.showPage("withdrawtab");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getView().updateView(tabKey);
    }

    private boolean valiteAttDataGenerate() {
        DynamicObject attDataGen = this.getModel().getDataEntity().getDynamicObject("attdatagenerate");
        if (attDataGen == null) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"SeeAttCreateDataEdit_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            return false;
        }
        return true;
    }

    private void showPage(String targetKey) {
        DynamicObject attDataGen = this.getModel().getDataEntity().getDynamicObject("attdatagenerate");
        if (!this.valiteAttDataGenerate()) {
            return;
        }
        Long taskId = attDataGen.getLong("id");
        String version = attDataGen.getString("version");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.setCustomParam("taskid", (Object)taskId);
        listShowParameter.setCustomParam("tasknumber", (Object)version);
        Long ruleId = this.getModel().getDataEntity().getLong("attdatagenerate.integrationrule.id");
        listShowParameter.setCustomParam("ruleId", (Object)ruleId);
        listShowParameter.setShowTitle(false);
        listShowParameter.setBillFormId("wtis_payatttaskdetail");
        listShowParameter.setFormId("wtbs_rimlesslist");
        if (HRStringUtils.equals((String)"withdrawtab", (String)targetKey)) {
            listShowParameter.setCustomParam("showtype", (Object)targetKey);
            this.getView().getPageCache().put("withdrawtab", listShowParameter.getPageId());
        } else {
            this.getView().getPageCache().put("tab_view_pageId_", listShowParameter.getPageId());
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
        this.getView().updateView(targetKey);
    }

    private DynamicObject getDetailDynamicObject(BillList billList) {
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValues = currentSelectedRowInfo.getPrimaryKeyValue();
        long id = 0L;
        if (primaryKeyValues != null) {
            id = (Long)primaryKeyValues;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payatttaskdetail");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)id);
        return dynamicObject;
    }

    private boolean validateStatus(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return false;
        }
        String integrStatus = dynamicObject.getString("integrstatus");
        String usableStatus = dynamicObject.getDynamicObject("attfileboid").getString("usablestatus");
        if (WTCStringUtils.equals((String)usableStatus, (String)AttFileBaseStatusEnum.ABANDON.getCode()) && (WTCStringUtils.equals((String)integrStatus, (String)IntegrStatusEnum.FAIL.getCode()) || WTCStringUtils.equals((String)integrStatus, (String)IntegrStatusEnum.NON.getCode()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AttDataDetailList_20", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"creviewdetails", (String)operateKey)) {
            BillList billList = (BillList)this.getView().getControl("exbilllistap");
            DynamicObject dynamicObject2 = this.getDetailDynamicObject(billList);
            if (!this.validateStatus(dynamicObject2)) {
                return;
            }
            SeeAttDataHelper.getInstance().showAttEditionDet(this.getView(), "exbilllistap", HRStringUtils.equals((String)dynamicObject2.getString("integrstatus"), (String)"3") || HRStringUtils.equals((String)dynamicObject2.getString("integrstatus"), (String)"4") ? "wtis_attediintdetview" : "wtis_atteditiondetview");
        } else if (HRStringUtils.equals((String)"cresucviewdetails", (String)operateKey)) {
            BillList billList = (BillList)this.getView().getControl("failbilllistap");
            DynamicObject dynamicObject3 = this.getDetailDynamicObject(billList);
            if (!this.validateStatus(dynamicObject3)) {
                return;
            }
            SeeAttDataHelper.getInstance().showAttEditionDet(this.getView(), "failbilllistap", "wtis_attediintdetview");
        } else if (HRStringUtils.equals((String)"recalculation", (String)operateKey)) {
            DynamicObject[] queryDynObj = SeeAttDataHelper.getInstance().getIntegrAttData(this.getView());
            if (!this.checkGenerate(queryDynObj)) {
                return;
            }
            Long taskId = queryDynObj[0].getLong("taskid");
            List attDataIdList = Arrays.stream(queryDynObj).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", attDataIdList);
            AttJobTaskHelper.getInstance().recalculation(taskId, this.getView(), (IFormPlugin)this, qFilter);
            this.refreshPage();
        } else if (HRStringUtils.equals((String)"withdraw", (String)operateKey)) {
            if (!this.setWithdraw()) {
                return;
            }
        } else if (HRStringUtils.equals((String)"refresh", (String)operateKey)) {
            this.refreshPage();
        } else if (HRStringUtils.equals((String)"export", (String)operateKey)) {
            String pageId = this.getView().getPageCache().get("tab_view_pageId_");
            IFormView tabView = this.getView().getView(pageId);
            if (tabView == null) {
                return;
            }
            this.printPkList(tabView);
        } else if (HRStringUtils.equals((String)"exportdetails", (String)operateKey)) {
            String pageId = this.getView().getPageCache().get("tab_view_pageId_");
            IFormView tabView = this.getView().getView(pageId);
            tabView.invokeOperation("exportdetails");
            this.getView().sendFormAction(tabView);
        }
    }

    private boolean printPkList(IFormView tabView) {
        List<Long> collect;
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        BillList billList = (BillList)this.getView().getControl("exbilllistap");
        QFilter filter = new QFilter("integrstatus", "in", Arrays.asList("2", "3", "4"));
        ListSelectedRowCollection listSelectedRowCollection = null;
        switch (currentTab) {
            case "successtab": {
                filter = new QFilter("integrstatus", "in", Arrays.asList("2", "4"));
                billList = (BillList)this.getView().getControl("sucbilllistap");
                break;
            }
            case "failtab": {
                filter = new QFilter("integrstatus", "=", (Object)"3");
                billList = (BillList)this.getView().getControl("failbilllistap");
                break;
            }
            case "withdrawtab": {
                filter = new QFilter("withdrawresult", "in", Arrays.asList(WithDrawResultEnum.SUCCESS.getCode(), WithDrawResultEnum.FAIL.getCode()));
                String pageId = this.getView().getPageCache().get("withdrawtab");
                IListView withDrawVies = (IListView)this.getView().getView(pageId);
                if (withDrawVies == null) break;
                listSelectedRowCollection = withDrawVies.getSelectedRows();
                billList = (BillList)this.getView().getControl("widrbilllistap");
                break;
            }
            case "unextab": {
                filter = new QFilter("integrstatus", "=", (Object)IntegrStatusEnum.NON.getCode());
                billList = (BillList)this.getView().getControl("unexbilllistap");
                break;
            }
        }
        if (listSelectedRowCollection == null) {
            listSelectedRowCollection = billList.getSelectedRows();
        }
        if (WTCCollections.isEmpty(collect = listSelectedRowCollection.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList())) && WTCCollections.isEmpty(collect = this.getTabAllPkList(this.getView(), filter))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"WTCTipsFormService_6", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            return false;
        }
        if (!this.valitePrintCount(collect)) {
            return false;
        }
        ListShowParameter listShowParameter = (ListShowParameter)tabView.getFormShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("id", "in", collect));
        listShowParameter.setListFilterParameter(listFilterParameter);
        tabView.updateView();
        tabView.getPageCache().put("isPushTaskPrint", "1");
        tabView.getPageCache().put("exportidlist", JSON.toJSONString(collect));
        tabView.invokeOperation("exportlist_expt");
        this.getView().sendFormAction(tabView);
        return true;
    }

    private boolean valitePrintCount(List<Long> collect) {
        QFilter qFilter = new QFilter("taskdetail", "in", collect);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter dataQFilter = HRAuthService.getInstance().getDataRule(Long.valueOf(currUserId), "wtis", "wtis_payattdatainfo", "attfile.org", "47150e89000000ac", Collections.emptyMap());
        qFilter.and(dataQFilter);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtis_payattdatainfo");
        int count = hrBaseServiceHelper.count("wtis_payattdatainfo", new QFilter[]{qFilter});
        if (count > 1000000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8d85\u8fc7100\u4e07\u4ee5\u4e0a\u7684\u6570\u636e\uff0c\u8bf7\u5206\u6279\u6b21\u5bfc\u51fa\u3002", (String)"SeeAttIntegrDataEdit_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getTabAllPkList(IFormView view, QFilter tabQfilter) {
        DynamicObject[] dynamicObjects;
        Long taskId = view.getModel().getDataEntity().getLong("attdatagenerate.id");
        QFilter taskFilter = new QFilter("taskid", "=", (Object)taskId);
        SeeAttDataHelper seeAttDataHelper = SeeAttDataHelper.getInstance();
        taskFilter.and(seeAttDataHelper.attHRAuth());
        if (tabQfilter != null) {
            taskFilter.and(tabQfilter);
        }
        if ((dynamicObjects = seeAttDataHelper.getExportData(new QFilter[]{taskFilter})) == null || dynamicObjects.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private boolean checkGenerate(DynamicObject[] queryDynObj) {
        if (queryDynObj.length == 0) {
            this.getView().showTipNotification(IntegrationKDString.atLeast());
            return false;
        }
        for (DynamicObject dynObj : queryDynObj) {
            if (dynObj.get("integrstatus") != null && ("3".equals(dynObj.get("integrstatus").toString()) || "5".equals(dynObj.get("integrstatus").toString()) || "6".equals(dynObj.get("integrstatus").toString()))) continue;
            this.getView().showErrorNotification(IntegrationKDString.reCalError());
            return false;
        }
        String creator = this.getView().getPageCache().get(CREATEPERSON);
        long userId = UserServiceHelper.getCurrentUserId();
        if (creator == null || !creator.equals(String.valueOf(userId))) {
            this.getView().showErrorNotification(IntegrationKDString.reCalMyself());
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
            return;
        }
        IAttDataPushService attDataWithDrawServiceImpl = (IAttDataPushService)WTCAppContextHelper.getBean(AttDataWithDrawServiceImpl.class);
        attDataWithDrawServiceImpl.closeBack((AbstractFormPlugin)this, closedCallBackEvent);
    }

    private boolean setWithdraw() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (dynamicObject == null) {
            return false;
        }
        Long taskId = dynamicObject.getLong("attdatagenerate.id");
        HRBaseServiceHelper attDataGenerateServiceHelper = new HRBaseServiceHelper("wtis_payattpushtask");
        DynamicObject[] attDatas = attDataGenerateServiceHelper.loadDynamicObjectArray(new QFilter("id", "=", (Object)taskId).toArray());
        DynamicObject[] queryDynObj = SeeAttDataHelper.getInstance().getIntegrAttData(this.getView());
        ArrayList<Long> attFile = new ArrayList<Long>(queryDynObj.length);
        if (queryDynObj != null && queryDynObj.length != 0) {
            for (DynamicObject dynObj : queryDynObj) {
                attFile.add(dynObj.getLong("attfileboid.id"));
            }
        }
        IAttDataPushService iAttDataPushService = (IAttDataPushService)WTCAppContextHelper.getBean(AttDataWithDrawServiceImpl.class);
        iAttDataPushService.dispatch((AbstractFormPlugin)this, attDatas, attFile);
        return true;
    }

    private void refreshPage() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        this.getView().updateView();
        tab.activeTab(currentTab);
    }

    private void taskCallBack(Object returnData) {
        AttJobTaskHelper.showFormMsg((Object)returnData, (IFormView)this.getView());
    }
}

