/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.fromplugin.web.punchcarddata;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataHelper;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataService;

public class PunchCardDataList
extends HRDataBaseList {
    private static final String KEY_MANUALSYN = "manualsyn";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate != null && operate.getOperateKey().equals(KEY_MANUALSYN)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            List idList = listSelectedData.stream().map(lr -> (Long)lr.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] dataDyArr = PunchCardDataHelper.getDataByIdList(idList);
            if (dataDyArr.length > 10000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71\u4e07\u6761\u3002", (String)"PunchCardDataList_1", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean isExitSuccess = Arrays.stream(dataDyArr).anyMatch(dy -> dy.getString("status").equals("2"));
            if (isExitSuccess) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u7684\u6570\u636e\u4e0d\u53ef\u518d\u540c\u6b65\u3002", (String)"PunchCardDataList_0", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            PunchCardDataService.dealWithData((DynamicObject[])dataDyArr);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u52a8\u540c\u6b65\u6210\u529f\u3002", (String)"PunchCardDataList_2", (String)"wtc-wtis-fromplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

