/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtis.webapi.punchcard;

import java.io.Serializable;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.custom.validation.ValidatorUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataHelper;
import kd.wtc.wtis.business.punchcarddata.PunchCardDataService;
import kd.wtc.wtis.constants.punchcarddata.PunchCardDataConstants;
import kd.wtc.wtis.webapi.punchcard.PunchCardSyncSupport;
import kd.wtc.wtis.webapi.punchcard.enums.RecordErrorCode;
import kd.wtc.wtis.webapi.punchcard.model.PunchCardReqMode;
import kd.wtc.wtis.webapi.punchcard.model.PunchCardRespModel;
import kd.wtc.wtis.webapi.punchcard.model.PunchErrorRespMode;
import kd.wtc.wtis.webapi.punchcard.validate.ListValidator;

@ApiController(desc="punchCardData sync api", value="punchCardData sync api")
@ApiMapping(value="/punchCard")
public class PunchCardApi
implements Serializable,
PunchCardDataConstants {
    private static final long serialVersionUID = 51164900357787652L;
    private static final Log logger = LogFactory.getLog(PunchCardApi.class);
    public static final String DATE_FORMAT = "yyyyMMddHHmmsss";
    public static final DecimalFormat df = new DecimalFormat("0000");
    private static HRBaseServiceHelper PUNCH_CARD_HELPER = new HRBaseServiceHelper("wtis_punchcarddata");
    private static HRBaseServiceHelper PAGE_TIMEZONE_HELPER = new HRBaseServiceHelper("inte_timezone");
    private static String PUNCH_CARD_PROPERTIES = WTCStringUtils.joinOnComma((String[])new String[]{"dataid", "equipnumber"});
    private static String TIMEZONE_PROPERTIES = WTCStringUtils.joinOnComma((String[])new String[]{"name", "number"});

    @ApiPostMapping(desc="punchcard data sync", value="/syncCardRecords")
    public CustomApiResult<PunchCardRespModel> syncCardRecordService(@ApiParam(value="records,count cannot exceed 1000") @ApiParam(value="records,count cannot exceed 1000") ListValidator<PunchCardReqMode> records) {
        try {
            long l1 = System.currentTimeMillis();
            logger.info("PunchCardApi_accept");
            CustomApiResult customApiResult = new CustomApiResult();
            if (CollectionUtils.isEmpty(records)) {
                customApiResult.setStatus(false);
                customApiResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6253\u5361\u8bb0\u5f55\u201d\u3002", (String)"PunchCardApi_1", (String)"wtc-wtis-webapi", (Object[])new Object[0]));
                return customApiResult;
            }
            if (records.size() > this.getRecordSize()) {
                customApiResult.setStatus(false);
                customApiResult.setMessage(ResManager.loadKDString((String)"\u6253\u5361\u8bb0\u5f55\u6761\u6570\u4e0d\u80fd\u8d85\u8fc71000\u6761\u3002", (String)"PunchCardApi_2", (String)"wtc-wtis-webapi", (Object[])new Object[0]));
                return customApiResult;
            }
            long l2 = System.currentTimeMillis();
            logger.info("PunchCardApi_count_{}", (Object)(l2 - l1));
            Set validate = ValidatorUtil.validate(records, (Class[])new Class[]{PunchCardReqMode.Save.class});
            long l3 = System.currentTimeMillis();
            logger.info("PunchCardApi_bos_{}", (Object)(l3 - l2));
            if (!CollectionUtils.isEmpty((Collection)validate)) {
                for (ConstraintViolation val : validate) {
                    PunchCardReqMode valFail = (PunchCardReqMode)val.getLeafBean();
                    String errorCode = RecordErrorCode.getErrorCode(val.getMessage());
                    String errorMsg = RecordErrorCode.getErrorMsg(val.getMessage(), errorCode);
                    this.setErrorMsg(valFail, errorCode, errorMsg);
                }
            }
            this.checkParam(records);
            List<PunchCardReqMode> successList = records.stream().filter(PunchCardReqMode::isValFlag).collect(Collectors.toList());
            PunchCardRespModel punchCardRespModel = new PunchCardRespModel();
            punchCardRespModel.setSuccessNum(successList.size());
            punchCardRespModel.setErrorRecords(this.buildErrorRecords(records));
            long l4 = System.currentTimeMillis();
            logger.info("PunchCardApi_param_{}", (Object)(l4 - l3));
            this.saveRecords(successList);
            long l5 = System.currentTimeMillis();
            logger.info("PunchCardApi_save_{}", (Object)(l5 - l4));
            customApiResult.setStatus(true);
            customApiResult.setData((Object)punchCardRespModel);
            long l6 = System.currentTimeMillis();
            logger.info("PunchCardApi_total_{}", (Object)(l6 - l1));
            return customApiResult;
        }
        catch (Exception e) {
            logger.warn("punch_card_error", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        catch (Throwable thr) {
            logger.warn("thr_punch_card_error", thr);
            throw new KDBizException(thr, new ErrorCode("", thr.getMessage()), new Object[0]);
        }
    }

    private void saveRecords(List<PunchCardReqMode> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        String batchNumber = this.getBatchNumber();
        Date currDate = new Date();
        List<DynamicObject> saveList = records.stream().map(data -> this.punchCardModelToDy((PunchCardReqMode)data, batchNumber, currDate)).collect(Collectors.toList());
        PUNCH_CARD_HELPER.save(saveList.toArray(new DynamicObject[0]));
        try {
            long l1 = System.currentTimeMillis();
            PunchCardSyncSupport.execute(() -> this.syncCardRecord(batchNumber));
            long l2 = System.currentTimeMillis();
            logger.info("PunchCardApi_sync_cardData_{}", (Object)(l2 - l1));
        }
        catch (Exception e) {
            logger.warn("PunchCardApi_sync_cardData_error ", (Throwable)e);
        }
    }

    private void syncCardRecord(String batchNumber) {
        try {
            long l1 = System.currentTimeMillis();
            DynamicObject[] date = PunchCardDataHelper.getDataByBatchNumber((String)batchNumber);
            PunchCardDataService.dealWithData((DynamicObject[])date);
            long l2 = System.currentTimeMillis();
            logger.info("PunchCardApi_sync_cardData\uff1a{}", (Object)(l2 - l1));
        }
        catch (Exception e) {
            logger.warn("PunchCardApi_sync_cardData_error", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        catch (Throwable thr) {
            logger.warn("PunchCardApi_sync_cardData_thr", thr);
            throw new KDBizException(thr, new ErrorCode("", thr.getMessage()), new Object[0]);
        }
    }

    private DynamicObject punchCardModelToDy(PunchCardReqMode mode, String batchNumber, Date currDate) {
        Long uid = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = PUNCH_CARD_HELPER.generateEmptyDynamicObject();
        dynamicObject.set("number", (Object)mode.getNumber());
        dynamicObject.set("card", (Object)mode.getCard());
        dynamicObject.set("punchcarddate", (Object)mode.getCardDate());
        dynamicObject.set("punchcardtime", (Object)mode.getPunchCardTime());
        dynamicObject.set("timezone", (Object)mode.getTimeZoneId());
        dynamicObject.set("accesstag", (Object)mode.getInout());
        dynamicObject.set("signsourcename", (Object)mode.getSignSource());
        dynamicObject.set("place", (Object)mode.getPlace());
        dynamicObject.set("equipment", (Object)mode.getEquipment());
        dynamicObject.set("equipnumber", (Object)mode.getEquipNumber());
        dynamicObject.set("status", (Object)"0");
        dynamicObject.set("times", (Object)0);
        dynamicObject.set("dataid", (Object)mode.getDataId());
        dynamicObject.set("batchnumber", (Object)batchNumber);
        dynamicObject.set("creator", (Object)uid);
        dynamicObject.set("modifier", (Object)uid);
        dynamicObject.set("createtime", (Object)currDate);
        dynamicObject.set("modifytime", (Object)batchNumber);
        dynamicObject.set("presetbiz1", (Object)mode.getPresetBiz1());
        dynamicObject.set("presetbiz2", (Object)mode.getPresetBiz2());
        return dynamicObject;
    }

    public void checkParam(List<PunchCardReqMode> records) {
        Map<String, Long> timeZoneMap = this.getTimeZoneMap(records);
        Set<String> keySet = timeZoneMap.keySet();
        for (PunchCardReqMode mode : records) {
            if (!mode.isValFlag()) continue;
            this.nullCheck(mode);
            if (!mode.isValFlag()) continue;
            this.checkCardDate(mode);
            if (!mode.isValFlag()) continue;
            this.checkTimeZone(mode, keySet, timeZoneMap);
            if (mode.isValFlag()) continue;
        }
        this.checkRepeat(records);
    }

    private void checkRepeat(List<PunchCardReqMode> records) {
        List successList = records.stream().filter(PunchCardReqMode::isValFlag).collect(Collectors.toList());
        Map<String, Long> keyCountMap = successList.stream().collect(Collectors.groupingBy(this::getGroupKey, Collectors.counting()));
        List<String> dateIds = successList.stream().map(PunchCardReqMode::getDataId).collect(Collectors.toList());
        List<String> equipNumbers = successList.stream().map(PunchCardReqMode::getEquipNumber).collect(Collectors.toList());
        List<String> dbKey = this.getDbDateKey(dateIds, equipNumbers);
        for (PunchCardReqMode data : successList) {
            String repeatKey = this.getGroupKey(data);
            Long num = keyCountMap.get(repeatKey);
            if (null != num && 1L < num) {
                this.setErrorMsg(data, RecordErrorCode.ERROR_CODE_003, RecordErrorCode.ERROR_CODE_003.getDesc());
                num = num - 1L;
                keyCountMap.put(this.getGroupKey(data), num);
                continue;
            }
            if (!dbKey.contains(repeatKey)) continue;
            this.setErrorMsg(data, RecordErrorCode.ERROR_CODE_003, RecordErrorCode.ERROR_CODE_003.getDesc());
        }
    }

    private Map<String, Long> getTimeZoneMap(List<PunchCardReqMode> list) {
        List<String> timeZoneList = list.stream().filter(data -> WTCStringUtils.isNotEmpty((String)data.getTimeZone())).map(PunchCardReqMode::getTimeZone).collect(Collectors.toList());
        return this.getDbTimeZoneKey(timeZoneList);
    }

    private Map<String, Long> getDbTimeZoneKey(List<String> timeZoneNumberList) {
        DynamicObject[] query;
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(timeZoneNumberList)) {
            return resMap;
        }
        for (DynamicObject dyn : query = PAGE_TIMEZONE_HELPER.query(TIMEZONE_PROPERTIES, new QFilter[]{new QFilter("number", "in", timeZoneNumberList)})) {
            resMap.put(dyn.getString("number"), dyn.getLong("id"));
        }
        return resMap;
    }

    private void nullCheck(PunchCardReqMode mode) {
        if (HRStringUtils.isEmpty((String)mode.getNumber()) && HRStringUtils.isEmpty((String)mode.getCard())) {
            String msg = ResManager.loadKDString((String)"\u5de5\u53f7\u548c\u8003\u52e4\u5361\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff1b", (String)"PunchCardApi_3", (String)"wtc-wtis-webapi", (Object[])new Object[0]);
            String errorMsg = mode.getErrorMsg() + msg;
            this.setErrorMsg(mode, RecordErrorCode.ERROR_CODE_001, errorMsg);
        }
    }

    private void checkCardDate(PunchCardReqMode mode) {
        String dateErrorMsg = ResManager.loadKDString((String)"\u6253\u5361\u65e5\u671f:punchCardDate,\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"PunchCardApi_4", (String)"wtc-wtis-webapi", (Object[])new Object[0]);
        try {
            String date = mode.getPunchCardDate();
            Date cardDate = WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd");
            if (null == cardDate) {
                this.setErrorMsg(mode, RecordErrorCode.ERROR_CODE_002, dateErrorMsg);
                return;
            }
        }
        catch (Exception e) {
            this.setErrorMsg(mode, RecordErrorCode.ERROR_CODE_002, dateErrorMsg);
            return;
        }
        String dateTimeErrorMsg = ResManager.loadKDString((String)"\u6253\u5361\u65f6\u95f4\u70b9:punchCardTime,\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"PunchCardApi_5", (String)"wtc-wtis-webapi", (Object[])new Object[0]);
        try {
            String time = mode.getPunchCardTime();
            Date cardTime = WTCDateUtils.str2Date((String)(mode.getPunchCardDate() + " " + time), (String)"yyyy-MM-dd HH:mm:ss");
            if (null == cardTime) {
                this.setErrorMsg(mode, RecordErrorCode.ERROR_CODE_002, dateTimeErrorMsg);
                return;
            }
            mode.setCardDate(cardTime);
        }
        catch (Exception e) {
            this.setErrorMsg(mode, RecordErrorCode.ERROR_CODE_002, dateTimeErrorMsg);
            return;
        }
    }

    private void checkTimeZone(PunchCardReqMode mode, Set<String> timeZoneKey, Map<String, Long> timeZoneMap) {
        if (HRStringUtils.isEmpty((String)mode.getTimeZone())) {
            return;
        }
        if (!timeZoneKey.contains(mode.getTimeZone())) {
            this.setErrorMsg(mode, RecordErrorCode.ERROR_CODE_002, this.getAppendErrorMsg(RecordErrorCode.ERROR_CODE_002, ResManager.loadKDString((String)"\u65f6\u533a", (String)"PunchCardApi_6", (String)"wtc-wtis-webapi", (Object[])new Object[0])));
        } else {
            mode.setTimeZoneId(timeZoneMap.get(mode.getTimeZone()));
        }
    }

    private String getAppendErrorMsg(RecordErrorCode errorCode, String errorMsg) {
        return RecordErrorCode.getAppendDesc(errorCode, errorMsg);
    }

    private void setErrorMsg(PunchCardReqMode mode, RecordErrorCode errorCode, String errorMsg) {
        mode.setValFlag(false);
        mode.setErrorMsg(errorMsg);
        mode.setErrorCode(errorCode.getCode());
    }

    private void setErrorMsg(PunchCardReqMode mode, String errorCode, String errorMsg) {
        mode.setValFlag(false);
        mode.setErrorMsg(errorMsg);
        mode.setErrorCode(errorCode);
    }

    private String getGroupKey(PunchCardReqMode mode) {
        return mode.getEquipNumber() + "_" + mode.getDataId();
    }

    private String getGroupKeyByDyn(DynamicObject dyn) {
        return dyn.getString("equipnumber") + "_" + dyn.getString("dataid");
    }

    private List<String> getDbDateKey(List<String> dateIds, List<String> equipNumbers) {
        if (CollectionUtils.isEmpty(dateIds)) {
            return Collections.emptyList();
        }
        QFilter equipNumberQf = new QFilter("equipnumber", "in", equipNumbers);
        QFilter dataIdQf = new QFilter("dataid", "in", dateIds);
        DynamicObject[] query = PUNCH_CARD_HELPER.query(PUNCH_CARD_PROPERTIES, new QFilter[]{equipNumberQf, dataIdQf});
        return Arrays.asList(query).stream().map(this::getGroupKeyByDyn).collect(Collectors.toList());
    }

    private String getBatchNumber() {
        return WTCDateUtils.date2Str((Date)new Date(), (String)DATE_FORMAT) + df.format(new SecureRandom().nextInt(10000));
    }

    public int getRecordSize() {
        return WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtis.punchcard.requestSize", PUNCH_CARD_RECORD_DEFAULT_SIZE.intValue());
    }

    private List<PunchErrorRespMode> buildErrorRecords(List<PunchCardReqMode> records) {
        return records.stream().filter(req -> !req.isValFlag()).map(this::punchCardToErrorRespMode).collect(Collectors.toList());
    }

    private PunchErrorRespMode punchCardToErrorRespMode(PunchCardReqMode mode) {
        return new PunchErrorRespMode(mode.getDataId(), mode.getErrorCode(), mode.getErrorMsg());
    }
}

