/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.EffectiveEntityVo;
import kd.wtc.wtbs.business.model.PersonHasBillVo;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtom.common.rpc.OtDutyDateStartEndTime;
import kd.wtc.wtom.business.rpc.OTApplyRPCHelper;
import kd.wtc.wtom.mservice.api.IOverTimeApplyBillService;

public class OverTimeApplyBillServiceImpl
implements IOverTimeApplyBillService {
    public List<EffectiveEntityVo> getOverTimeApplyBill(Long fileId, Date sDate, Date eDate) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        QFilter filter = new QFilter("attfile.id", "=", (Object)fileId).and("billstatus", "=", (Object)"C").and("iscancel", "=", (Object)Boolean.FALSE);
        HasPermOrgResult allPermOrgs = WTCPermUtils.getAllPermOrgs((String)"wtam", (String)"wtom_overtimeapplybill");
        if (!allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs() != null) {
            filter.and("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        QFilter timeFilter = new QFilter("scentry.dutydate", ">=", (Object)sDate).and("scentry.dutydate", "<=", (Object)eDate);
        QFilter ownDateFilter = new QFilter("sdentry.otdutydate", ">=", (Object)sDate).and("sdentry.otdutydate", "<=", (Object)eDate);
        QFilter dateTimeFilter = timeFilter.or(ownDateFilter);
        filter.and(dateTimeFilter);
        Object[] supsignDys = helper.loadDynamicObjectArray(new QFilter[]{filter});
        ArrayList<EffectiveEntityVo> effectiveEntityVos = new ArrayList<EffectiveEntityVo>();
        if (HRArrayUtils.isEmpty((Object[])supsignDys)) {
            return effectiveEntityVos;
        }
        return this.getEntityVos((DynamicObject[])supsignDys, effectiveEntityVos, sDate, eDate);
    }

    public Map<Long, Map<Date, OtDutyDateStartEndTime>> queryDutyDateMaxAndMinTime(Set<Long> attPersonIds, Date startDate, Date endDate) {
        OTApplyRPCHelper rpcHelper = new OTApplyRPCHelper();
        return rpcHelper.queryDutyDateMaxAndMinTime(attPersonIds, startDate, endDate);
    }

    public Map<Long, Boolean> hasOtBill(List<Long> attfileboIds, Date effectdate) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(4);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        QFilter filter = new QFilter("attfile.id", "in", attfileboIds).and("billstatus", "in", (Object)"C").and("iscancel", "=", (Object)Boolean.FALSE);
        QFilter timeFilter = new QFilter("scentry.dutydate", ">=", (Object)effectdate);
        QFilter ownDateFilter = new QFilter("sdentry.otdutydate", ">=", (Object)effectdate);
        QFilter dateTimeFilter = timeFilter.or(ownDateFilter);
        DynamicObject[] query = helper.query("attfile.id", new QFilter[]{filter.and(dateTimeFilter)});
        if (query != null) {
            List hasbill = Arrays.stream(query).map(e -> e.getLong("attfile.id")).collect(Collectors.toList());
            for (Long attfilebo : attfileboIds) {
                result.put(attfilebo, hasbill.contains(attfilebo));
            }
        }
        return result;
    }

    public Map<Long, Boolean> hasValidOtBill(List<Long> attfileboIds, Date effectdate) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(4);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        QFilter filter = new QFilter("attfile.id", "in", attfileboIds).and("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"C", "D"}));
        filter.and(new QFilter("iscancel", "=", (Object)Boolean.FALSE));
        QFilter timeFilter = new QFilter("scentry.dutydate", ">=", (Object)effectdate);
        QFilter ownDateFilter = new QFilter("sdentry.otdutydate", ">=", (Object)effectdate);
        QFilter dateTimeFilter = timeFilter.or(ownDateFilter);
        DynamicObject[] query = helper.query("attfile.id", new QFilter[]{filter.and(dateTimeFilter)});
        if (query != null) {
            List hasbill = Arrays.stream(query).map(e -> e.getLong("attfile.id")).collect(Collectors.toList());
            for (Long attfilebo : attfileboIds) {
                result.put(attfilebo, hasbill.contains(attfilebo));
            }
        }
        return result;
    }

    private ArrayList<EffectiveEntityVo> getEntityVos(DynamicObject[] supsignDys, ArrayList<EffectiveEntityVo> effectiveEntityVos, Date sDate, Date eDate) {
        for (DynamicObject supsignDy : supsignDys) {
            String otapplytype = supsignDy.getString("otapplytype");
            if (HRStringUtils.isEmpty((String)otapplytype)) continue;
            DynamicObjectCollection dynamicObjectCollection = otapplytype.equals(BillApplyTypeEnum.OTHER.getCode()) ? supsignDy.getDynamicObjectCollection("sdentry") : supsignDy.getDynamicObjectCollection("scentry");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String subType = null;
                Date startdate = null;
                Date endDate = null;
                Date belongDate = null;
                if ("1".equals(otapplytype)) {
                    subType = dynamicObject.getString(WTCStringUtils.joinOnDot((String[])new String[]{"sdottype", "name"}));
                    startdate = dynamicObject.getDate("otstartdate");
                    endDate = dynamicObject.getDate("otenddate");
                    belongDate = dynamicObject.getDate("otdutydate");
                } else {
                    subType = dynamicObject.getString(WTCStringUtils.joinOnDot((String[])new String[]{"scottype", "name"}));
                    startdate = dynamicObject.getDate("otdstarttime");
                    endDate = dynamicObject.getDate("otdendtime");
                    belongDate = dynamicObject.getDate("otdate");
                }
                if (startdate == null || endDate == null || !WTCDateUtils.betweenDay((Date)belongDate, (Date)sDate, (Date)eDate)) continue;
                EffectiveEntityVo effectiveEntityVo = new EffectiveEntityVo();
                String formId = OverTimeApplyBillServiceImpl.getFormId(supsignDy);
                effectiveEntityVo.setId(Long.valueOf(supsignDy.getLong("id")));
                effectiveEntityVo.setBillno(supsignDy.getString("billno"));
                effectiveEntityVo.setChildType(subType);
                effectiveEntityVo.setStartDate(startdate);
                effectiveEntityVo.setEndDate(endDate);
                effectiveEntityVo.setFormId(formId);
                effectiveEntityVos.add(effectiveEntityVo);
            }
        }
        effectiveEntityVos.sort(Comparator.comparing(EffectiveEntityVo::getStartDate));
        return effectiveEntityVos;
    }

    private static String getFormId(DynamicObject supsignDy) {
        String applytyperadio = supsignDy.getString("applytyperadio");
        String formId = HRStringUtils.equals((String)applytyperadio, (String)"0") ? "wtom_otbillself" : "wtom_overtimeapplybill";
        return formId;
    }

    public Map<Long, Boolean> personHasOtBill(List<PersonHasBillVo> personHasBillVoList) {
        Date minDate = null;
        Date maxDate = null;
        for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
            Date startDate = personHasBillVo.getStartDate();
            if (minDate == null || minDate.compareTo(startDate) > 0) {
                minDate = startDate;
            }
            Date endDate = personHasBillVo.getEndDate();
            if (maxDate != null && maxDate.compareTo(endDate) >= 0) continue;
            maxDate = endDate;
        }
        List personIdList = personHasBillVoList.stream().map(PersonHasBillVo::getAttPersonId).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        List<String> auditStatusList = Arrays.asList("D", "B", "C");
        QFilter filter = new QFilter("personid.id", "in", personIdList).and("billstatus", "in", auditStatusList);
        QFilter timeFilter = new QFilter("scentry.dutydate", ">=", (Object)minDate).and(new QFilter("scentry.dutydate", "<=", (Object)maxDate));
        QFilter ownDateFilter = new QFilter("sdentry.otdutydate", ">=", (Object)minDate).and(new QFilter("sdentry.otdutydate", "<=", (Object)maxDate));
        QFilter dateTimeFilter = timeFilter.or(ownDateFilter);
        QFilter isNotChange = new QFilter("ischange", "=", (Object)Boolean.FALSE);
        DynamicObject[] queryDys = helper.query("personid.id, scentry.dutydate, sdentry.otdutydate", new QFilter[]{filter.and(dateTimeFilter), isNotChange});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)queryDys.length);
        if (queryDys != null) {
            for (DynamicObject dy : queryDys) {
                long billPersonId = dy.getLong("personid.id");
                for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
                    Date startDate = personHasBillVo.getStartDate();
                    Date endDate = personHasBillVo.getEndDate();
                    if (personHasBillVo.getAttPersonId() != billPersonId || startDate == null || endDate == null) continue;
                    DynamicObjectCollection scentryDys = dy.getDynamicObjectCollection("scentry");
                    for (DynamicObject scentryDy : scentryDys) {
                        Date dutyDate = scentryDy.getDate("dutydate");
                        if (startDate.compareTo(dutyDate) > 0 || endDate.compareTo(dutyDate) < 0) continue;
                        resultMap.put(personHasBillVo.getId(), Boolean.TRUE);
                    }
                    DynamicObjectCollection sdentryDys = dy.getDynamicObjectCollection("sdentry");
                    for (DynamicObject sdentryDy : sdentryDys) {
                        Date otDutyDate = sdentryDy.getDate("otdutydate");
                        if (startDate.compareTo(otDutyDate) > 0 || endDate.compareTo(otDutyDate) < 0) continue;
                        resultMap.put(personHasBillVo.getId(), Boolean.TRUE);
                    }
                }
            }
        }
        return resultMap;
    }
}

