/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.mob.workover;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillScCommon;
import kd.wtc.wtom.fromplugin.web.otapplybill.OtApplyBillEdit;

public class MobCompenModePlugin
extends AbstractMobBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(OtApplyBillEdit.class);
    private Map<Integer, Boolean> compenStatus = new HashMap<Integer, Boolean>(16);

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.compenStatus = OTApplyBillCommon.updateTemporary(this.getView(), this.getModel());
        OTApplyBillCommon.updateCompensateForNull(this.getModel());
        String status = (String)this.getModel().getValue("billstatus");
        if (HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)status, (String)"G")) {
            OTApplyBillScCommon common = new OTApplyBillScCommon();
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(this.getView().getEntityId());
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{this.getModel().getDataEntity(true)}, unifyBillApplyAttr);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
            for (int i = 0; i < entryEntity.size(); ++i) {
                common.handleScTimeBucket(otBillHelper, i, this.getView(), this.getModel());
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object pkValue = this.getModel().getDataEntity(true).getPkValue();
        if (pkValue == null || (Long)pkValue == 0L) {
            int i;
            DynamicObjectCollection scEntryEntity = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
            DynamicObjectCollection sdEntryEntity = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SD.getCode());
            for (i = 0; i < scEntryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"compentype"});
            }
            for (i = 0; i < sdEntryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"compentyped"});
            }
        } else {
            String key;
            String applyType = this.getModel().getDataEntity(true).getString("otapplytype");
            String string = key = HRStringUtils.equals((String)applyType, (String)OtApplyTypeEnum.OT_SC.getNum()) ? "compentype" : "compentyped";
            if (!CollectionUtils.isEmpty(this.compenStatus)) {
                for (Map.Entry<Integer, Boolean> entry : this.compenStatus.entrySet()) {
                    this.getView().setEnable(entry.getValue(), entry.getKey().intValue(), new String[]{key});
                }
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit compentype = (BasedataEdit)this.getView().getControl("compentype");
        BasedataEdit compentyped = (BasedataEdit)this.getView().getControl("compentyped");
        compentype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        compentyped.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)"compentype") || HRStringUtils.equals((String)key, (String)"compentyped")) {
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(this.getView().getEntityId());
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{this.getModel().getDataEntity(true)}, unifyBillApplyAttr);
            int row = beforeF7SelectEvent.getRow();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            ArrayList dateRangeDtos = new ArrayList(1);
            otBillHelper.getOtApplyBillAssemblyResultService().collectMatchData(dataEntity, Integer.valueOf(row), 2, dateRangeDtos);
            List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
            Boolean compensateIsEmpChose = otBillHelper.getCompensateIsEmpChoseNew(dataEntity, Integer.valueOf(row), ruleConditionRetrievals);
            logger.info("MobCompenModePlugin.beforeF7Select compensateIsEmpChose = {}", (Object)compensateIsEmpChose);
            QFilter compenQFilter = null;
            if (compensateIsEmpChose == null || !compensateIsEmpChose.booleanValue()) {
                compenQFilter = new QFilter("id", "=", (Object)0L);
            } else {
                List compenList = otBillHelper.getCompensateTypeDefIdNew(dataEntity, Integer.valueOf(row), ruleConditionRetrievals);
                compenQFilter = new QFilter("id", "in", (Object)compenList);
            }
            beforeF7SelectEvent.addCustomQFilter(compenQFilter);
        }
    }
}

