/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.mob.workover;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtom.business.mob.MobOverworkBusiness;
import kd.wtc.wtom.common.constants.MobOTApplyConstants;

public class MobOTApplySelefDetailPlugin
extends AbstractMobFormPlugin
implements MobOTApplyConstants {
    private static final Log logger = LogFactory.getLog(MobOTApplySelefDetailPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"paneldown", "panelup", "tblmodity", "tbldelete"});
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)evt.getFormShowParameter();
        if (formShowParameter.getPkId() == null) {
            return;
        }
        long pkId = Long.parseLong(formShowParameter.getPkId().toString());
        logger.info("MobBusiTripDetailPlugin.preOpenForm.pkId:{}", (Object)pkId);
        formShowParameter.setBillStatus(BillOperationStatus.VIEW);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u52a0\u73ed\u7533\u8bf7", (String)"MobOTApplyDetailPlugin_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
        formShowParameter.setPkId((Object)pkId);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject busTripBill = this.getModel().getDataEntity();
        String billStatus = busTripBill.getString("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "buttonflex", "approvalflex", "unsubmitbuttonflex"});
        Object flagWorkFlow = this.getView().getFormShowParameter().getCustomParam("flagWorkFlow");
        if (flagWorkFlow != null) {
            boolean editable = MobileCommonServiceHelper.getInstance().isEditable(this.getModel());
            if (editable) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "buttonflex"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                if ("D".equals(billStatus) || "B".equals(billStatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"unsubmitbuttonflex"});
                }
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"approvalflex"});
        }
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "buttonflex"});
        }
        if ("A".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"approvalflex"});
        }
        if ("C".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"changeflex"});
        }
        String otApplyType = busTripBill.get("otapplytype") != null ? busTripBill.getString("otapplytype") : null;
        this.getPageCache().put("otapplytype", otApplyType);
        logger.info("MobOTApplyDetailPlugin.initialize.otApplyType {}}", (Object)otApplyType);
        this.setHarderPerInfo(busTripBill);
        this.setWorkOvertimeInfo(busTripBill, otApplyType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object pkValue = this.getModel().getDataEntity(true).getPkValue();
        if (pkValue == null || pkValue.equals(0L)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonflex", "unsubmitbuttonflex"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("change".equals(operateKey)) {
            if (!MobileCommonServiceHelper.getInstance().judgeAttFile(this.getView(), BillTypeEnum.OVERTIMEBILL.getBillName())) {
                args.setCancel(true);
                return;
            }
        } else if ("modify".equals(operateKey)) {
            this.modity();
            args.setCancel(true);
        }
        BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)source.getOption());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            logger.info("MobOTApplyDetailPlugin.afterDoOperation operateKey={}", (Object)operateKey);
            switch (operateKey) {
                case "submit": {
                    BillContainerService.getInstance().openSuccessPage(this.getView(), ResManager.loadKDString((String)"\u52a0\u73ed\u7533\u8bf7", (String)"MobOTApplyDetailPlugin_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]), "wtom_overtimeselapply", this.getModel().getDataEntity().getLong("id"));
                    break;
                }
                case "unsubmit": {
                    HashMap<String, Boolean> param = new HashMap<String, Boolean>(16);
                    param.put("flagWorkFlow", Boolean.FALSE);
                    param.put("flagFromMyBill", Boolean.TRUE);
                    BillContainerService.getInstance().openDetailPage(this.getView(), "wtom_overtimeselapply", ((Long)this.getModel().getDataEntity().getPkValue()).longValue(), param);
                    break;
                }
                case "delete": {
                    BillContainerService.getInstance().returnSource(this.getView());
                    break;
                }
                case "change": {
                    Boolean isNewBill = (Boolean)this.getModel().getValue("isnewbill");
                    if (isNewBill != null && !isNewBill.booleanValue()) {
                        this.getView().showTipNotification(BillUnifyKDStringHelper.changeRepeat((String)BillTypeEnum.OVERTIMEBILL.getBillName()));
                        return;
                    }
                    BillCommonService billCommonService = new BillCommonService();
                    BillApplyTypeEnum billApplyTypeEnum = billCommonService.billChangeOpenType(this.getView().getModel().getDataEntity(true), this.getView());
                    MobOverworkBusiness.getInstance().openChangeView(this.getView(), billApplyTypeEnum == BillApplyTypeEnum.SELF);
                    break;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String operateKey = source.getKey();
        IPageCache pageCache = this.getView().getPageCache();
        String otApplyType = pageCache.get("otapplytype");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("paneldown".equals(operateKey)) {
            this.downArea(otApplyType, dataEntity);
        } else if ("panelup".equals(operateKey)) {
            this.upArea(otApplyType, dataEntity);
        }
    }

    private void modity() {
        HRBaseServiceHelper ottypeDao = new HRBaseServiceHelper("wtom_overtimeapplybill");
        QFilter enable = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        DynamicObject query = ottypeDao.loadDynamicObject(enable);
        if (query == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u52a0\u73ed\u7533\u8bf7\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MobOTApplyDetailPlugin_1", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
        } else {
            if (!MobileCommonServiceHelper.getInstance().judgeAttFile(this.getView(), BillTypeEnum.OVERTIMEBILL.getBillName())) {
                return;
            }
            if ("F".equals(query.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u52a0\u73ed\u7533\u8bf7\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u5df2\u88ab\u5e9f\u5f03\u3002", (String)"MobOTApplyDetailPlugin_2", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
            } else {
                HashMap<String, Long> param = new HashMap<String, Long>(16);
                param.put("personid_cache", BillUnifyService.getUserId((IFormView)this.getView()));
                BillContainerService.getInstance().openEditPage(this.getView(), "wtom_otbillselef_m", this.getModel().getDataEntity().getLong("id"), param);
            }
        }
    }

    private void upArea(String otApplyType, DynamicObject dataEntity) {
        String timeStamp = this.getView().getPageCache().get("cache_uptime");
        if (StringUtils.isNotEmpty((String)timeStamp)) {
            long lastTimeStamp = Long.parseLong(timeStamp);
            if (System.currentTimeMillis() - lastTimeStamp < 2000L) {
                return;
            }
        }
        this.getView().getPageCache().put("cache_uptime", String.valueOf(System.currentTimeMillis()));
        this.getView().setVisible(Boolean.TRUE, new String[]{"paneldown"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexdownup", "panelup"});
        if ("1".equals(otApplyType)) {
            this.setEntityVisible(dataEntity, "sdentry", false, "sdcardentryflex");
        } else {
            this.setEntityVisible(dataEntity, "scentry", false, "sccardentryflex");
        }
    }

    private void downArea(String otApplyType, DynamicObject dataEntity) {
        String timeStamp = this.getView().getPageCache().get("cache_downtime");
        if (StringUtils.isNotEmpty((String)timeStamp)) {
            long lastTimeStamp = Long.parseLong(timeStamp);
            if (System.currentTimeMillis() - lastTimeStamp < 2000L) {
                return;
            }
        }
        this.getView().getPageCache().put("cache_downtime", String.valueOf(System.currentTimeMillis()));
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexdownup", "panelup"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"paneldown"});
        if ("1".equals(otApplyType)) {
            this.setEntityVisible(dataEntity, "sdentry", true, "sdcardentryflex");
        } else {
            this.setEntityVisible(dataEntity, "scentry", true, "sccardentryflex");
        }
    }

    private void setEntityVisible(DynamicObject dataEntity, String entityName, boolean flag, String visSign) {
        DynamicObjectCollection dynObjCollection = dataEntity.getDynamicObjectCollection(entityName);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entityName);
        for (int index = 0; index < dynObjCollection.size(); ++index) {
            if (index == 0) continue;
            cardEntry.setChildVisible(flag, index, new String[]{visSign});
        }
    }

    private void setHarderPerInfo(DynamicObject dynamicObject) {
        String name = null;
        if (dynamicObject != null && dynamicObject.getDynamicObject("personid") != null) {
            name = dynamicObject.getDynamicObject("personid").getString("name");
        }
        Label billHeader = (Label)this.getView().getControl("billheader");
        billHeader.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u52a0\u73ed\u7533\u8bf7\u5355", (String)"MobOTApplyDetailPlugin_3", (String)"wtc-wtom-formplugin", (Object[])new Object[0]), name));
    }

    private void setWorkOvertimeInfo(DynamicObject dynamicObject, String otApplyType) {
        DynamicObjectCollection busTripBillEntry;
        Label applyType = (Label)this.getView().getControl("otapplytype");
        if ("1".equals(otApplyType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scentry"});
            applyType.setText(ResManager.loadKDString((String)"\u6309\u65f6\u6bb5", (String)"MobOTApplyDetailPlugin_4", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
            MobOverworkBusiness.getInstance().setTotelDate(this.getView());
            busTripBillEntry = dynamicObject.getDynamicObjectCollection("sdentry");
            for (int index = 0; index < busTripBillEntry.size(); ++index) {
                this.getModel().setValue("billentryname_seg", (Object)(index + 1), index);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sdentry"});
            applyType.setText(ResManager.loadKDString((String)"\u6309\u65f6\u957f", (String)"MobOTApplyDetailPlugin_5", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
            MobOverworkBusiness.getInstance().setTotelDateLong(this.getView());
            busTripBillEntry = dynamicObject.getDynamicObjectCollection("scentry");
            for (int index = 0; index < busTripBillEntry.size(); ++index) {
                this.getModel().setValue("billentryname_long", (Object)(index + 1), index);
            }
        }
        if (busTripBillEntry.size() <= 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"panelup"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"paneldown"});
    }
}

