/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.mob.workover;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.CalendarChooseTypeEnum;
import kd.wtc.wtbs.common.enums.CustomControlInteractEnum;
import kd.wtc.wtbs.common.model.customcontrol.CalendarChooseInitModel;
import kd.wtc.wtbs.common.model.customcontrol.CustomControlInteractModel;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class OverTimeDatePlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(OverTimeDatePlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        CardEntry dateContainer = (CardEntry)this.getView().getControl("dateentity");
        dateContainer.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnsave"});
        this.addClickListeners(new String[]{"btnempty"});
    }

    public void afterCreateNewData(EventObject evt) {
        super.beforeBindData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List<String> chooseDate = (List<String>)customParams.get("chooseDate");
        if (CollectionUtils.isNotEmpty((Collection)chooseDate)) {
            chooseDate = chooseDate.stream().map(dateStr -> {
                try {
                    dateStr = WTCDateUtils.date2Str((Date)WTCInteDateUtil.getUserSimpleDateFormat().parse((String)dateStr), (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    logger.warn("OverTimeDatePlugin.afterCreateNewData.dateStr:{}", dateStr);
                }
                return dateStr;
            }).collect(Collectors.toList());
        }
        this.createEntry(chooseDate);
        CalendarChooseTypeEnum calendar = CalendarChooseTypeEnum.SEPARATE;
        if (customParams.get("calendarType") != null) {
            calendar = CalendarChooseTypeEnum.getEnumByKey((String)((String)customParams.get("calendarType")));
        }
        this.initCalendar(chooseDate, calendar);
        if (CollectionUtils.isEmpty(chooseDate)) {
            this.getModel().batchCreateNewEntryRow("dateentity", 1);
            CardEntry entryGrid = (CardEntry)this.getView().getControl("dateentity");
            entryGrid.setChildVisible(false, 0, new String[]{"datetextfield", "vectordelete"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String dateStr = this.getView().getPageCache().get("cachedate");
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return;
        }
        List dateList = (List)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("cachedate"), List.class);
        if (CollectionUtils.isEmpty((Collection)dateList) || evt.getRow() > dateList.size() - 1) {
            return;
        }
        this.getModel().deleteEntryRow("dateentity", evt.getRow());
        dateList.remove(evt.getRow());
        this.sendToCustomControl(dateList);
        this.getView().getPageCache().put("cachedate", SerializationUtils.toJsonString((Object)dateList));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)"btnempty", (String)key)) {
            String dateStr = this.getView().getPageCache().get("cachedate");
            if (StringUtils.isEmpty((CharSequence)dateStr)) {
                return;
            }
            List dateList = (List)SerializationUtils.fromJsonString((String)dateStr, List.class);
            if (!CollectionUtils.isEmpty((Collection)dateList)) {
                for (int index = dateList.size() - 1; index >= 0; --index) {
                    this.getModel().deleteEntryRow("dateentity", index);
                }
                dateList.clear();
            }
            this.sendToCustomControl(dateList);
            this.getView().getPageCache().remove("cachedate");
        } else {
            this.getView().close();
        }
    }

    public void customEvent(CustomEventArgs cea) {
        String key = cea.getKey();
        String eventName = cea.getEventName();
        if ("customcalendar".equals(key) && CustomControlInteractEnum.DATE_CHOOSE.getEvent().equals(eventName)) {
            List dateChoose = (List)SerializationUtils.fromJsonString((String)cea.getEventArgs(), List.class);
            this.createEntry(dateChoose);
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        String dateStr = this.getView().getPageCache().get("cachedate");
        List dateList = null;
        if (!StringUtils.isEmpty((CharSequence)dateStr)) {
            dateList = (List)SerializationUtils.fromJsonString((String)dateStr, List.class);
        }
        this.getView().returnDataToParent(dateList);
    }

    private void initCalendar(List<String> chooseDate, CalendarChooseTypeEnum calendarChooseType) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        CustomControlInteractModel customControlModel = new CustomControlInteractModel();
        customControlModel.setEvent(CustomControlInteractEnum.INIT.getEvent());
        CalendarChooseInitModel calendarChooseInitModel = new CalendarChooseInitModel();
        calendarChooseInitModel.setCalendarType(calendarChooseType);
        calendarChooseInitModel.setMaxChoose(10);
        calendarChooseInitModel.setDateList(chooseDate);
        if (!CollectionUtils.isEmpty(chooseDate)) {
            calendarChooseInitModel.setCurrentMonth(chooseDate.get(0));
        }
        customControlModel.setArgs((Object)calendarChooseInitModel);
        customControlModel.setTimestamp(System.currentTimeMillis());
        customcontrol.setData((Object)customControlModel);
    }

    private void createEntry(List<String> dateList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("dateentity");
        if (!CollectionUtils.isEmpty(dateList)) {
            model.batchCreateNewEntryRow("dateentity", dateList.size());
            for (int index = 0; index < dateList.size(); ++index) {
                String dateStr = dateList.get(index);
                model.setValue("datetextfield", (Object)WTCInteDateUtil.formatDateStrBySysTzAndUserFmt((String)dateStr, (String)"yyyy-MM-dd"), index);
            }
        }
        this.getView().getPageCache().put("cachedate", SerializationUtils.toJsonString(dateList));
    }

    private void sendToCustomControl(List<String> dateList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        CustomControlInteractModel customControlModel = new CustomControlInteractModel();
        customControlModel.setEvent(CustomControlInteractEnum.DATE_DATA.getEvent());
        customControlModel.setArgs(dateList);
        customControlModel.setTimestamp(System.currentTimeMillis());
        customcontrol.setData((Object)customControlModel);
    }
}

