/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.enums.ot.OtCompentEnum;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleCalEntryEnum;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.OTKdStringHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;

public class OTApplyBillCommon {
    private static final String BTR = "</b>";

    public static boolean verifyEvent(IFormView formView, IDataModel dataModel, OTBillHelper otBillHelper, Integer changeIndex, List<OTCheckTypeEnum> event) {
        for (OTCheckTypeEnum otCheckTypeEnum : event) {
            BillCheckResult shiftResult = otBillHelper.checkEntry(otCheckTypeEnum, dataModel.getDataEntity(true), changeIndex);
            if (shiftResult.isVerifyResult()) continue;
            formView.showTipNotification((String)shiftResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    public static void handlePolicy(IFormView formView, IDataModel dataModel) {
        Optional first;
        Map entryInfo = OTApplyBillAssemblyResultService.getEntryInfo((DynamicObject)dataModel.getDataEntity(true));
        DynamicObjectCollection entry = dataModel.getEntryEntity((String)entryInfo.get("ENTRY_NAME"));
        long attFileBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dataModel.getDataEntity(true), (String)"attfile");
        LinkedHashSet<Long> otTypeIds = new LinkedHashSet<Long>(16);
        for (DynamicObject entryDy : entry) {
            long otType = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entryDy, (String)((String)entryInfo.get("OT_TYPE_NAME")));
            if (otType == 0L) continue;
            otTypeIds.add(otType);
        }
        if (!OTApplyBillCommon.systemDesc() && !CollectionUtils.isEmpty(otTypeIds) && (first = otTypeIds.stream().skip(otTypeIds.size() - 1).findFirst()).isPresent()) {
            Long lastOne = (Long)first.get();
            otTypeIds.clear();
            otTypeIds.add(lastOne);
        }
        Map policyInfo = OTBillHelper.getLatestTypeAndRuleCalDy(otTypeIds, (long)attFileBoId);
        StringBuilder text = new StringBuilder();
        UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = UnifyBillEnum.OT.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
        String type = unifyRuleCalEntryEnum.getType();
        String attPolicy = unifyRuleCalEntryEnum.getAttPolicy();
        for (Long otTypeId : otTypeIds) {
            DynamicObject typeDy;
            Object otSystem;
            DynamicObject calDy = (DynamicObject)policyInfo.get(otTypeId);
            if (calDy == null || (otSystem = calDy.get("otsystem")) == null) continue;
            if (HRStringUtils.isNotEmpty((String)text.toString())) {
                text.append(BTR).append("<hr style=\"border-style: dashed;\">").append(BTR);
            }
            if ((typeDy = calDy.getDynamicObject(type)) == null) continue;
            text.append("<b style=\"line-height:40px;font-size:14px;color:#212121\">");
            text.append(typeDy.getLocaleString("name").getLocaleValue());
            text.append(":</b>");
            DynamicObject policyDy = calDy.getDynamicObject(attPolicy);
            if (policyDy == null) continue;
            String content = policyDy.getString("content");
            content = content.replace("<p>", "<p style=\"line-height:20px;font-size:12px;color:#666666\">");
            text.append(content);
        }
        String policy = text.toString();
        RichTextEditor richTextEditor = (RichTextEditor)formView.getControl("richtexteditorap");
        richTextEditor.setText(policy);
        formView.setVisible(Boolean.valueOf(HRStringUtils.isEmpty((String)policy)), new String[]{"lackpageflex"});
        formView.setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)policy)), new String[]{"richtexteditorap"});
        Container attPolicyFlex = (Container)formView.getControl("attpolicyflex");
        attPolicyFlex.setCollapse(HRStringUtils.isEmpty((String)policy));
    }

    public static Map<Integer, Boolean> judgeCompensateEdit(IFormView iFormView, IDataModel dataModel) {
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>(16);
        String status = (String)dataModel.getValue("billstatus");
        Map entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType((String)((String)dataModel.getValue("otapplytype")));
        if (HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)status, (String)"G")) {
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(iFormView.getEntityId());
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{dataModel.getDataEntity(true)}, unifyBillApplyAttr);
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity((String)entryInfoByType.get("ENTRY_NAME"));
            DynamicObject dataEntity = dataModel.getDataEntity(true);
            ArrayList dateRangeDtos = new ArrayList(1);
            for (int i = 0; i < entryEntity.size(); ++i) {
                otBillHelper.getOtApplyBillAssemblyResultService().collectMatchData(dataEntity, Integer.valueOf(i), 2, dateRangeDtos);
            }
            List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
            for (int i = 0; i < entryEntity.size(); ++i) {
                Boolean compensateIsEmpChose = otBillHelper.getCompensateIsEmpChoseNew(dataEntity, Integer.valueOf(i), ruleConditionRetrievals);
                compensateIsEmpChose = compensateIsEmpChose == null ? Boolean.FALSE : compensateIsEmpChose;
                result.put(i, compensateIsEmpChose);
            }
        }
        return result;
    }

    public static Map<Integer, Boolean> updateTemporary(IFormView iFormView, IDataModel dataModel) {
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>(16);
        String status = (String)dataModel.getValue("billstatus");
        Map entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType((String)((String)dataModel.getValue("otapplytype")));
        if (HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)status, (String)"G")) {
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(iFormView.getEntityId());
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{dataModel.getDataEntity(true)}, unifyBillApplyAttr);
            DynamicObject dataEntity = dataModel.getDataEntity(true);
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity((String)entryInfoByType.get("ENTRY_NAME"));
            ArrayList dateRangeDtos = new ArrayList(1);
            for (int i = 0; i < entryEntity.size(); ++i) {
                otBillHelper.getOtApplyBillAssemblyResultService().collectMatchData(dataEntity, Integer.valueOf(i), 2, dateRangeDtos);
            }
            List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
            for (int i = 0; i < entryEntity.size(); ++i) {
                String keyCompen = (String)entryInfoByType.get("COMPENSATE_NAME");
                long oriCompenId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)((DynamicObject)entryEntity.get(i)), (String)keyCompen);
                List compensateTypeDefList = otBillHelper.getCompensateTypeDefIdNew(dataEntity, Integer.valueOf(i), ruleConditionRetrievals);
                Boolean compensateIsEmpChose = otBillHelper.getCompensateIsEmpChoseNew(dataEntity, Integer.valueOf(i), ruleConditionRetrievals);
                Boolean bl = compensateIsEmpChose = compensateIsEmpChose == null ? Boolean.FALSE : compensateIsEmpChose;
                if (!compensateIsEmpChose.booleanValue() && CollectionUtils.isEmpty((Collection)compensateTypeDefList)) {
                    compensateTypeDefList.add(OtCompentEnum.EMPTY.getPkId());
                }
                if (!compensateIsEmpChose.booleanValue()) {
                    dataModel.setValue((String)entryInfoByType.get("COMPENSATE_NAME"), compensateTypeDefList.get(0), i);
                }
                if (compensateIsEmpChose.booleanValue() && !compensateTypeDefList.contains(oriCompenId)) {
                    dataModel.setValue((String)entryInfoByType.get("COMPENSATE_NAME"), null, i);
                }
                result.put(i, compensateIsEmpChose);
            }
        }
        return result;
    }

    public static void updateCompensateForNull(IDataModel dataModel) {
        String status = (String)dataModel.getValue("billstatus");
        if (!HRStringUtils.equals((String)status, (String)"A") && !HRStringUtils.equals((String)status, (String)"G")) {
            Map entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType((String)((String)dataModel.getValue("otapplytype")));
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity((String)entryInfoByType.get("ENTRY_NAME"));
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)entryEntity.get(i);
                Long compensateTypeId = 0L;
                DynamicObject compensateDy = entryDy.getDynamicObject((String)entryInfoByType.get("COMPENSATE_NAME"));
                if (compensateDy != null) {
                    compensateTypeId = (Long)compensateDy.getPkValue();
                }
                compensateTypeId = compensateTypeId == 0L ? OtCompentEnum.EMPTY.getPkId() : compensateTypeId;
                dataModel.setValue((String)entryInfoByType.get("COMPENSATE_NAME"), (Object)compensateTypeId, i);
            }
        }
    }

    private static boolean systemDesc() {
        return HRStringUtils.equalsIgnoreCase((String)SystemParamQueryUtil.getBillSystemParam().getSystemdes(), (String)"1");
    }

    static void openNewChange(Long pkId, IFormView formView, AbstractFormPlugin closeCallBackPlugin) {
        HRBaseServiceHelper helper;
        DynamicObject dynamicObject;
        if (formView == null) {
            return;
        }
        String entityId = formView.getEntityId();
        if (formView instanceof ListView) {
            entityId = ((ListView)formView).getEntityTypeId();
        }
        if ((dynamicObject = (helper = new HRBaseServiceHelper(entityId)).queryOne((Object)pkId)) == null) {
            return;
        }
        boolean isNewBill = dynamicObject.getBoolean("isnewbill");
        if (!isNewBill) {
            formView.showTipNotification(BillUnifyKDStringHelper.changeRepeat((String)BillTypeEnum.OVERTIMEBILL.getBillName()));
            return;
        }
        if (dynamicObject.getBoolean("ischange")) {
            formView.showTipNotification(OTKdStringHelper.onlyOne());
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if ("C".equals(billStatus)) {
            long cPersonId;
            BillShowParameter showParameter = new BillShowParameter();
            String applytype = dynamicObject.getString("applytyperadio");
            long personId = dynamicObject.getLong("personid.id");
            if (personId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8003\u52e4\u4eba\u7684\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"OTApplyBillCommon_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
            }
            Long currentPersonId = BillUnifyService.getUserId((IFormView)formView);
            long l = cPersonId = currentPersonId == null ? 0L : currentPersonId;
            if (personId == cPersonId && HRStringUtils.equals((String)applytype, (String)BillApplyTypeEnum.SELF.getCode())) {
                showParameter.setFormId("wtom_otselfbillchange");
            } else {
                showParameter.setFormId("wtom_otbillchange");
            }
            showParameter.setStatus(OperationStatus.ADDNEW);
            HashMap map = Maps.newHashMapWithExpectedSize((int)8);
            DynamicObject attFileBo = dynamicObject.getDynamicObject("attfile");
            DynamicObject attFilebase = dynamicObject.getDynamicObject("attfilebasef7");
            long attFileBoId = attFileBo != null ? (Long)attFileBo.getPkValue() : 0L;
            long attFileId = attFilebase != null ? (Long)attFilebase.getPkValue() : 0L;
            DynamicObjectCollection scEntry = dynamicObject.getDynamicObjectCollection("scentry");
            DynamicObjectCollection sdEntry = dynamicObject.getDynamicObjectCollection("sdentry");
            DynamicObject org = dynamicObject.getDynamicObject("org");
            long orgId = 0L;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            map.put("personid", personId);
            map.put("attfile", attFileBoId);
            map.put("attfilebasef7", attFileId);
            map.put("org", orgId);
            map.put("iscancel", dynamicObject.getBoolean("iscancel"));
            map.put("parent", dynamicObject.getPkValue());
            map.put("otapplytype", dynamicObject.getString("otapplytype"));
            map.put("scentry", scEntry);
            map.put("sdentry", sdEntry);
            map.put("applytyperadio", applytype);
            map.put("vatime", dynamicObject.get("vatime"));
            map.put("vatimetext", dynamicObject.get("vatimetext"));
            map.put("overworktypes", dynamicObject.get("overworktypes"));
            map.put("startdate", dynamicObject.get("startdate"));
            map.put("enddate", dynamicObject.get("enddate"));
            if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"billstyle")) {
                map.put("billstyle", dynamicObject.get("billstyle"));
            }
            showParameter.setCustomParam("ot_change_data", (Object)map);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (closeCallBackPlugin != null) {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)closeCallBackPlugin, "ot_change_close_callback"));
            }
            showParameter.setCustomParam("billopenfrom", formView.getFormShowParameter().getCustomParam("billopenfrom"));
            formView.showForm((FormShowParameter)showParameter);
        } else {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u3002", (String)"OTApplyBillCommon_1", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
        }
    }
}

