/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbd.common.enums.ot.OtCompentEnum;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;

public class OTApplyBillScCommon {
    private static final Log logger = LogFactory.getLog(OTApplyBillScCommon.class);
    private List<OTCheckTypeEnum> scCheckBeforeDutyDayEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.LARGETZERO, OTCheckTypeEnum.OVER24INONEBILL, OTCheckTypeEnum.REPEATINONEBILL, OTCheckTypeEnum.EACHDATESHIFT});
    private List<OTCheckTypeEnum> scCheckBeforeRuleEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.WORK_EXPERIENCE, OTCheckTypeEnum.DUTYAUTH, OTCheckTypeEnum.FROZEN, OTCheckTypeEnum.SUSPEND, OTCheckTypeEnum.PLANS, OTCheckTypeEnum.RULE, OTCheckTypeEnum.BASESET});
    private List<OTCheckTypeEnum> scCheckAfterRuleEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.MINOT, OTCheckTypeEnum.ADVANCE_AND_AFTER, OTCheckTypeEnum.APPLY_SPAN, OTCheckTypeEnum.MAX_LIMIT_ADVANCE});

    @Deprecated
    public OTApplyBillScCommon(String entity) {
    }

    public OTApplyBillScCommon() {
    }

    public void changeScEntryTimePairAndOtType(Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
        unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView));
        unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
        unifyBillApplyAttr.setAttFileF7AuthEntity(iFormView.getEntityId());
        OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{dataModel.getDataEntity(true)}, unifyBillApplyAttr);
        Date otDate = (Date)dataModel.getValue("otdate", changeIndex.intValue());
        DynamicObject otType = (DynamicObject)dataModel.getValue("scottype", changeIndex.intValue());
        if (dataModel.getValue("otdtime", changeIndex.intValue()) == null) {
            return;
        }
        int otTime = (Integer)dataModel.getValue("otdtime", changeIndex.intValue());
        if (otDate == null || otType == null || otTime == -1) {
            return;
        }
        boolean beforeDutyDate = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.scCheckBeforeDutyDayEvent);
        if (!beforeDutyDate) {
            return;
        }
        this.changeDutyDate(otBillHelper, changeIndex, iFormView, dataModel);
        this.getMaxAndMinDutyDateToBill(dataModel);
        boolean beforeRule = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.scCheckBeforeRuleEvent);
        if (!beforeRule) {
            return;
        }
        boolean afterRule = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.scCheckAfterRuleEvent);
        if (!afterRule) {
            return;
        }
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        otBillHelper.refreshBillDy(new DynamicObject[]{dataEntity});
        DynamicObjectCollection scEntry = dataModel.getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
        boolean indexBucketCheck = false;
        ArrayList dateRangeDtos = new ArrayList(1);
        for (int i = 0; i < scEntry.size(); ++i) {
            boolean eachBucket = this.handleScTimeBucket(otBillHelper, i, iFormView, dataModel, false);
            if (!eachBucket) continue;
            otBillHelper.getOtApplyBillAssemblyResultService().collectMatchData(dataEntity, Integer.valueOf(i), 2, dateRangeDtos);
        }
        List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
        for (int i = 0; i < scEntry.size(); ++i) {
            boolean eachBucket = this.handleScTimeBucket(otBillHelper, i, iFormView, dataModel);
            if (!eachBucket) {
                dataModel.setValue("otdtime", (Object)-1, i);
                dataModel.setValue("otdstarttime", null, i);
                dataModel.setValue("otdendtime", null, i);
                dataModel.setValue("compentype", null, i);
            } else {
                this.handleScCompensate(otBillHelper, i, iFormView, dataModel, ruleConditionRetrievals);
            }
            if (changeIndex != i) continue;
            indexBucketCheck = eachBucket;
        }
        if (indexBucketCheck) {
            logger.info("OTApplyBillScCommon.changeScEntryTimePairAndOtType pass handleScTimeBucket");
            otBillHelper.refreshBillDy(new DynamicObject[]{dataModel.getDataEntity(true)});
            if (!(this.handleScFlx(otBillHelper, changeIndex, iFormView, dataModel) && this.handleScOver24(otBillHelper, changeIndex, iFormView, dataModel) && this.handleRepeat(otBillHelper, changeIndex, iFormView, dataModel))) {
                return;
            }
            BillCheckResult baseRangeResult = otBillHelper.checkEntry(OTCheckTypeEnum.BASERANGE, dataModel.getDataEntity(true), changeIndex);
            if (!baseRangeResult.isVerifyResult()) {
                iFormView.showTipNotification((String)baseRangeResult.getMsg().get(0));
            }
        }
    }

    private void changeDutyDate(OTBillHelper otBillHelper, int changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult dutyDate = otBillHelper.getDutyDate(dataModel.getDataEntity(true), Integer.valueOf(changeIndex));
        logger.info("OTApplyBillScCommon.changeDutyDate dutyDate = {}", (Object)JSON.toJSONString((Object)dutyDate));
        if (!dutyDate.isVerifyResult()) {
            iFormView.showTipNotification((String)dutyDate.getMsg().get(0));
            return;
        }
        Date dutyDateData = (Date)dutyDate.getData();
        dataModel.setValue("dutydate", (Object)dutyDateData, changeIndex);
    }

    public boolean handleScTimeBucket(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        return this.handleScTimeBucket(otBillHelper, changeIndex, iFormView, dataModel, true);
    }

    public boolean handleScTimeBucket(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel, boolean showErrorMsg) {
        Date otDate = (Date)dataModel.getValue("otdate", changeIndex.intValue());
        int otdTime = (Integer)dataModel.getValue("otdtime", changeIndex.intValue());
        if (otDate == null || otdTime == -1) {
            return false;
        }
        BillCheckResult entryOtBucket = otBillHelper.getEntryOtBucket(dataModel.getDataEntity(true), changeIndex, true);
        logger.info("OTApplyBillScCommon.handleScTimeBucket entryOtBucket = {}", (Object)JSON.toJSONString((Object)entryOtBucket));
        if (!entryOtBucket.isVerifyResult()) {
            if (showErrorMsg) {
                iFormView.showTipNotification((String)entryOtBucket.getMsg().get(0));
            }
            return false;
        }
        OtTimeBucket otTimeBucket = (OtTimeBucket)entryOtBucket.getData();
        if (otTimeBucket == null) {
            dataModel.setValue("otdstarttime", null, changeIndex.intValue());
            dataModel.setValue("otdendtime", null, changeIndex.intValue());
            return true;
        }
        LocalDateTime startTime = otTimeBucket.getStartTime();
        LocalDateTime endTime = otTimeBucket.getEndTime();
        Date startDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)startTime);
        Date endDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)endTime);
        dataModel.setValue("otdstarttime", (Object)startDate, changeIndex.intValue());
        dataModel.setValue("otdendtime", (Object)endDate, changeIndex.intValue());
        return true;
    }

    private boolean handleScFlx(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult checkResult = otBillHelper.checkEntry(OTCheckTypeEnum.SCFLXS, dataModel.getDataEntity(true), changeIndex);
        if (!checkResult.isVerifyResult()) {
            iFormView.showTipNotification((String)checkResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    private boolean handleScOver24(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult checkResult = otBillHelper.checkEntry(OTCheckTypeEnum.OVER24, dataModel.getDataEntity(true), changeIndex);
        if (!checkResult.isVerifyResult()) {
            iFormView.showTipNotification((String)checkResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    private boolean handleRepeat(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult checkResult = otBillHelper.checkEntry(OTCheckTypeEnum.REPEAT, dataModel.getDataEntity(true), changeIndex);
        if (!checkResult.isVerifyResult()) {
            iFormView.showTipNotification((String)checkResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    private void handleScCompensate(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel, List<RuleConditionRetrieval> ruleConditionRetrievals) {
        Date duty = (Date)dataModel.getValue("dutydate", changeIndex.intValue());
        if (duty == null) {
            return;
        }
        List compensateTypeDefList = otBillHelper.getCompensateTypeDefIdNew(dataModel.getDataEntity(true), changeIndex, ruleConditionRetrievals);
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(dataModel.getDataEntity(true));
        IFormView singleView = iFormView.getView(iFormView.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID"));
        if (logger.isInfoEnabled()) {
            logger.info("OTApplyBillScCommon.handleScCompensate compensateTypeDefId = {}", (Object)JSON.toJSONString((Object)compensateTypeDefList));
        }
        if (CollectionUtils.isEmpty((Collection)compensateTypeDefList)) {
            dataModel.setValue("compentype", (Object)OtCompentEnum.EMPTY.getPkId(), changeIndex.intValue());
            iFormView.setEnable(Boolean.FALSE, changeIndex.intValue(), new String[]{"compentype"});
            if (openSingleStyle && singleView != null) {
                singleView.setEnable(Boolean.FALSE, new String[]{"compentype"});
            }
            return;
        }
        Boolean isChoseByEmp = otBillHelper.getCompensateIsEmpChoseNew(dataModel.getDataEntity(true), changeIndex, ruleConditionRetrievals);
        isChoseByEmp = isChoseByEmp == null ? Boolean.FALSE : isChoseByEmp;
        logger.info("OTApplyBillScCommon.handleScCompensate enableSelect = {}", (Object)isChoseByEmp);
        if (isChoseByEmp.booleanValue()) {
            iFormView.setEnable(Boolean.TRUE, changeIndex.intValue(), new String[]{"compentype"});
            if (openSingleStyle && singleView != null) {
                singleView.setEnable(Boolean.TRUE, new String[]{"compentype"});
            }
        } else {
            iFormView.setEnable(Boolean.FALSE, changeIndex.intValue(), new String[]{"compentype"});
            if (openSingleStyle && singleView != null) {
                singleView.setEnable(Boolean.FALSE, new String[]{"compentype"});
            }
            dataModel.setValue("compentype", compensateTypeDefList.get(0), changeIndex.intValue());
        }
    }

    public void resetScEntryVal(Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        logger.info("OTApplyBillScCommon.resetScEntryVal");
        dataModel.setValue("otdstarttime", null, changeIndex.intValue());
        dataModel.setValue("otdendtime", null, changeIndex.intValue());
        dataModel.setValue("dutydate", null, changeIndex.intValue());
        dataModel.setValue("compentype", null, changeIndex.intValue());
        iFormView.setEnable(Boolean.FALSE, changeIndex.intValue(), new String[]{"compentype"});
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(dataModel.getDataEntity(true));
        IFormView singleView = iFormView.getView(iFormView.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID"));
        if (openSingleStyle && singleView != null) {
            singleView.setEnable(Boolean.FALSE, new String[]{"compentype"});
        }
        this.getMaxAndMinDutyDateToBill(dataModel);
    }

    public int getRowIndex(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        ChangeData changeData = changeSet[0];
        return changeData.getRowIndex();
    }

    private void getMaxAndMinDutyDateToBill(IDataModel dataModel) {
        DynamicObjectCollection entry = dataModel.getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
        Date maxDate = WTCHisServiceHelper.getMinEndDate();
        Date minDate = WTCHisServiceHelper.getMaxEndDate();
        for (DynamicObject entryDy : entry) {
            Date dutyDay = entryDy.getDate("dutydate");
            if (dutyDay == null) continue;
            if (dutyDay.getTime() >= maxDate.getTime()) {
                maxDate = dutyDay;
            }
            if (dutyDay.getTime() > minDate.getTime()) continue;
            minDate = dutyDay;
        }
        dataModel.setValue("startdate", (Object)maxDate);
        dataModel.setValue("enddate", (Object)minDate);
    }
}

