/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.wtc.wtom.business.applytime.OtApplyTimeExtPlugin;
import kd.wtc.wtbd.common.enums.ot.OtCompentEnum;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.sdk.OTApplySdkHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;

public class OTApplyBillSdCommon {
    private static final Log logger = LogFactory.getLog(OTApplyBillSdCommon.class);
    private List<OTCheckTypeEnum> sdCheckTimeSelect = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.OVER24INONEBILL, OTCheckTypeEnum.REPEATINONEBILL, OTCheckTypeEnum.LARGERTIME});
    private List<OTCheckTypeEnum> sdCheckBeforeDutyDay = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.DUTYAUTH, OTCheckTypeEnum.INSHIF, OTCheckTypeEnum.EACHDATESHIFT, OTCheckTypeEnum.EXISTDUTYDATE});
    private List<OTCheckTypeEnum> sdCheckBeforeRuleDayEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.WORK_EXPERIENCE, OTCheckTypeEnum.SHIFT, OTCheckTypeEnum.SUSPEND, OTCheckTypeEnum.PLANS, OTCheckTypeEnum.RULE, OTCheckTypeEnum.BASESET});
    private List<OTCheckTypeEnum> sdCheckAfterRuleEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.ADVANCE_AND_AFTER, OTCheckTypeEnum.APPLY_SPAN, OTCheckTypeEnum.MAX_LIMIT_ADVANCE, OTCheckTypeEnum.FROZEN, OTCheckTypeEnum.MINOT, OTCheckTypeEnum.FLXS});

    @Deprecated
    public OTApplyBillSdCommon(String entity) {
    }

    public OTApplyBillSdCommon() {
    }

    public void changeSdEntryTimePairAndOtType(PropertyChangedArgs args, IFormView iFormView, IDataModel dataModel) {
        int changeIndex = this.getRowIndex(args);
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView));
        attr.setAttFileF7AuthEntity(iFormView.getEntityId());
        attr.setAttFileAuthField("attfilebasef7");
        OTBillHelper otBillHelper = new OTBillHelper(dataModel.getDataEntity(true), Integer.valueOf(changeIndex), attr);
        Date startTime = (Date)dataModel.getValue("otstartdate", changeIndex);
        Date endTime = (Date)dataModel.getValue("otenddate", changeIndex);
        DynamicObject otTypeDy = (DynamicObject)dataModel.getValue("sdottype", changeIndex);
        if (startTime == null || endTime == null) {
            iFormView.getModel().setValue("otdutydate", null, changeIndex);
            return;
        }
        Date startDate = (Date)dataModel.getValue("otstartdate", changeIndex);
        Date endDate = (Date)dataModel.getValue("otenddate", changeIndex);
        logger.info("OTApplyBillSdCommon.changeSdEntryTimePairAndOtType startDate={},endDate={}", (Object)startDate, (Object)endDate);
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        List dutyShiftsRange = otBillHelper.getDutyShiftsRange(dataEntity, Integer.valueOf(changeIndex));
        OTApplySdkHelper sdkHelper = new OTApplySdkHelper();
        WTCPluginProxy plugin = WTCPluginProxyFactory.create(OtApplyTimeExtPlugin.class, (String)"kd.sdk.wtc.wtom.business.applytime.OtApplyTimeExtPlugin");
        int applyTimeProxyResult = sdkHelper.getApplyTimeProxyResult(dataEntity, OTBillHelper.getEntryDyByBillDy((DynamicObject)dataEntity, (int)changeIndex), changeIndex, dutyShiftsRange, OTBillHelper.getIntSdTime((Date)startTime, (Date)endTime), plugin);
        dataModel.setValue("intottime", (Object)applyTimeProxyResult, changeIndex);
        String otTime = OTBillHelper.getTimeBySec((int)applyTimeProxyResult);
        dataModel.setValue("ottime", (Object)otTime, changeIndex);
        if (!this.handleEndLagerStartTime(args, dataModel, iFormView, otBillHelper)) {
            return;
        }
        boolean timeSelect = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.sdCheckTimeSelect);
        if (!timeSelect || otTypeDy == null) {
            return;
        }
        boolean beforeDutyDate = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.sdCheckBeforeDutyDay);
        if (!beforeDutyDate) {
            return;
        }
        this.changeDutyDate(otBillHelper, changeIndex, iFormView, dataModel);
        this.getMaxAndMinDutyDateToBill(dataModel);
        boolean beforeRule = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.sdCheckBeforeRuleDayEvent);
        if (!beforeRule) {
            return;
        }
        boolean afterRule = OTApplyBillCommon.verifyEvent(iFormView, dataModel, otBillHelper, changeIndex, this.sdCheckAfterRuleEvent);
        if (!afterRule) {
            return;
        }
        this.handleSdCompensate(otBillHelper, changeIndex, iFormView, dataModel);
        BillCheckResult baseRangeResult = otBillHelper.checkEntry(OTCheckTypeEnum.BASERANGE, dataModel.getDataEntity(true), Integer.valueOf(changeIndex));
        if (!baseRangeResult.isVerifyResult()) {
            iFormView.showTipNotification((String)baseRangeResult.getMsg().get(0));
            return;
        }
        OTBillHelper dutyChangeHelper = new OTBillHelper(dataModel.getDataEntity(true), Integer.valueOf(changeIndex), attr);
        if (this.handleScOver24(dutyChangeHelper, changeIndex, iFormView, dataModel)) {
            this.handleRepeat(dutyChangeHelper, changeIndex, iFormView, dataModel);
        }
    }

    private boolean handleEndLagerStartTime(PropertyChangedArgs args, IDataModel dataModel, IFormView iFormView, OTBillHelper otBillHelper) {
        String changeName = args.getProperty().getName();
        int changeIndex = this.getRowIndex(args);
        BillCheckResult shiftResult = otBillHelper.checkEntry(OTCheckTypeEnum.LARGERTIME, dataModel.getDataEntity(true), Integer.valueOf(changeIndex));
        if (!shiftResult.isVerifyResult()) {
            iFormView.showTipNotification((String)shiftResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    private void changeDutyDate(OTBillHelper otBillHelper, int changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult dutyDate = otBillHelper.getDutyDate(dataModel.getDataEntity(true), Integer.valueOf(changeIndex));
        logger.info("OTApplyBillSdCommon.changeDutyDate dutyDate = {}", (Object)JSON.toJSONString((Object)dutyDate));
        if (!dutyDate.isVerifyResult()) {
            iFormView.showTipNotification((String)dutyDate.getMsg().get(0));
            return;
        }
        Date dutyDateData = (Date)dutyDate.getData();
        dataModel.setValue("otdutydate", (Object)dutyDateData, changeIndex);
    }

    private boolean handleScOver24(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult checkResult = otBillHelper.checkEntry(OTCheckTypeEnum.OVER24, dataModel.getDataEntity(true), changeIndex);
        if (!checkResult.isVerifyResult()) {
            iFormView.showTipNotification((String)checkResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    private boolean handleRepeat(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        BillCheckResult checkResult = otBillHelper.checkEntry(OTCheckTypeEnum.REPEAT, dataModel.getDataEntity(true), changeIndex);
        if (!checkResult.isVerifyResult()) {
            iFormView.showTipNotification((String)checkResult.getMsg().get(0));
            return false;
        }
        return true;
    }

    private void handleSdCompensate(OTBillHelper otBillHelper, Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        Date duty = (Date)dataModel.getValue("otdutydate", changeIndex.intValue());
        if (duty == null) {
            return;
        }
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        ArrayList dateRangeDtos = new ArrayList(1);
        otBillHelper.getOtApplyBillAssemblyResultService().collectMatchData(dataEntity, changeIndex, 2, dateRangeDtos);
        List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
        List compensateTypeList = otBillHelper.getCompensateTypeDefIdNew(dataEntity, changeIndex, ruleConditionRetrievals);
        Boolean isChoseByEmp = otBillHelper.getCompensateIsEmpChoseNew(dataEntity, changeIndex, ruleConditionRetrievals);
        this.handleSdComValAndEdit(changeIndex, iFormView, dataModel, isChoseByEmp, compensateTypeList);
    }

    @Deprecated
    public void handleOtTime(Integer changeIndex, IDataModel dataModel) {
        Date startDate = (Date)dataModel.getValue("otstartdate", changeIndex.intValue());
        Date endDate = (Date)dataModel.getValue("otenddate", changeIndex.intValue());
        logger.info("OTApplyBillSdCommon.handleOtTime startDate={},endDate={}", (Object)startDate, (Object)endDate);
        String otTime = OTBillHelper.getTimeStr((Date)startDate, (Date)endDate);
        dataModel.setValue("ottime", (Object)otTime, changeIndex.intValue());
    }

    public void resetSdEntryVal(Integer changeIndex, IFormView iFormView, IDataModel dataModel) {
        dataModel.setValue("ottime", null, changeIndex.intValue());
        dataModel.setValue("compentyped", null, changeIndex.intValue());
        dataModel.setValue("intottime", null, changeIndex.intValue());
        iFormView.setEnable(Boolean.FALSE, changeIndex.intValue(), new String[]{"compentyped"});
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(dataModel.getDataEntity(true));
        IFormView singleView = iFormView.getView(iFormView.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID"));
        if (openSingleStyle && singleView != null) {
            singleView.setEnable(Boolean.FALSE, new String[]{"compentyped"});
        }
        this.getMaxAndMinDutyDateToBill(dataModel);
    }

    public int getRowIndex(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        ChangeData changeData = changeSet[0];
        return changeData.getRowIndex();
    }

    @Deprecated
    public void handleIntToTime(Integer changeIndex, IDataModel dataModel) {
        Date startTime = (Date)dataModel.getValue("otstartdate", changeIndex.intValue());
        Date endTime = (Date)dataModel.getValue("otenddate", changeIndex.intValue());
        dataModel.setValue("intottime", (Object)OTBillHelper.getIntSdTime((Date)startTime, (Date)endTime), changeIndex.intValue());
    }

    private void getMaxAndMinDutyDateToBill(IDataModel dataModel) {
        DynamicObjectCollection entry = dataModel.getEntryEntity(OtApplyTypeEnum.OT_SD.getCode());
        Date maxDate = WTCHisServiceHelper.getMinEndDate();
        Date minDate = WTCHisServiceHelper.getMaxEndDate();
        for (DynamicObject entryDy : entry) {
            Date dutyDay = entryDy.getDate("otdutydate");
            if (dutyDay == null) continue;
            if (dutyDay.getTime() >= maxDate.getTime()) {
                maxDate = dutyDay;
            }
            if (dutyDay.getTime() > minDate.getTime()) continue;
            minDate = dutyDay;
        }
        dataModel.setValue("startdate", (Object)maxDate);
        dataModel.setValue("enddate", (Object)minDate);
    }

    private void handleSdComValAndEdit(Integer changeIndex, IFormView iFormView, IDataModel dataModel, Boolean isEmpChoice, List<Long> compensateTypeList) {
        logger.info("OtApplyScBillEdit.handleScCompensate compensateTypeDefId = {}", (Object)JSON.toJSONString(compensateTypeList));
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(dataModel.getDataEntity(true));
        IFormView singleView = iFormView.getView(iFormView.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID"));
        if (CollectionUtils.isEmpty(compensateTypeList)) {
            dataModel.setValue("compentyped", (Object)OtCompentEnum.EMPTY.getPkId(), changeIndex.intValue());
            iFormView.setEnable(Boolean.FALSE, changeIndex.intValue(), new String[]{"compentyped"});
            if (openSingleStyle && singleView != null) {
                singleView.setEnable(Boolean.FALSE, new String[]{"compentyped"});
            }
            return;
        }
        logger.info("OtApplyScBillEdit.handleScCompensate isEmpChoice = {}", (Object)isEmpChoice);
        Boolean bl = isEmpChoice = isEmpChoice == null ? Boolean.FALSE : isEmpChoice;
        if (isEmpChoice.booleanValue()) {
            iFormView.setEnable(Boolean.TRUE, changeIndex.intValue(), new String[]{"compentyped"});
            if (openSingleStyle && singleView != null) {
                singleView.setEnable(Boolean.TRUE, new String[]{"compentyped"});
            }
        } else {
            iFormView.setEnable(Boolean.FALSE, changeIndex.intValue(), new String[]{"compentyped"});
            dataModel.setValue("compentyped", (Object)compensateTypeList.get(0), changeIndex.intValue());
            if (openSingleStyle && singleView != null) {
                singleView.setEnable(Boolean.FALSE, new String[]{"compentyped"});
            }
        }
    }
}

