/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.enums.ot.OtCompentEnum;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;
import kd.wtc.wtom.business.web.OTApplyBillCommonService;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;

public class OtApplyBillChangeEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(OtApplyBillChangeEdit.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtom_otbillchange");

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        BillShowParameter billShowParameter = (BillShowParameter)evt.getFormShowParameter();
        Map map = (Map)billShowParameter.getCustomParam("ot_change_data");
        if (map != null) {
            Long parentId = (Long)map.get("parent");
            StringBuilder errMsg = new StringBuilder();
            boolean require = WTCBillViewUtils.requireMutex((String)String.valueOf(parentId), (String)"wtom_overtimeapplybill", (String)"change", (StringBuilder)errMsg);
            if (!require) {
                evt.setCancel(true);
                evt.setCancelMessage(errMsg.toString());
            }
        }
        OTApplyBillCommonService.getInstance().preOpenFormOfSetCaption(billShowParameter);
    }

    private void copyAttachment(Long parentId, String applyType) {
        Long pkValue = DB.genGlobalLongId();
        this.getModel().getDataEntity().set("id", (Object)pkValue);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "=", (Object)parentId.toString());
        DynamicObject[] originalAttachments = helper.loadDynamicObjectArray(new QFilter[]{filter});
        if (originalAttachments == null || originalAttachments.length == 0) {
            return;
        }
        DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
        for (int i = 0; i < originalAttachments.length; ++i) {
            DynamicObject attachment = originalAttachments[i];
            DynamicObject newAttachment = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
            newAttachment.set("fbilltype", (Object)this.getView().getFormShowParameter().getFormId());
            newAttachment.set("finterid", (Object)pkValue);
            attachments[i] = newAttachment;
        }
        helper.save(attachments);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("ot_change_data");
        if (map != null) {
            this.getModel().setValue("attfilebasef7", map.get("attfilebasef7"));
            Long parentId = (Long)map.get("parent");
            String applyType = (String)map.get("applytyperadio");
            this.copyAttachment(parentId, applyType);
        }
        this.setReturnValue();
        this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanel"});
        BillCommonService billCommonService = new BillCommonService();
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr(billCommonService.getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId(), "attfilebasef7");
        billCommonService.showAttFileChangeInfoAndUpdate(this.getView(), this.getView().getModel(), unifyBillApplyAttr);
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("ot_change_data");
        if (map == null) {
            IDataModel model = this.getModel();
            model.beginInit();
            OTApplyBillCommonService instance = OTApplyBillCommonService.getInstance();
            instance.setComType(model, "scentry", "compentype");
            instance.setComType(model, "sdentry", "compentyped");
            model.endInit();
            model.setDataChanged(false);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("ot_change_data");
        if (map == null) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection scEntity = dataEntity.getDynamicObjectCollection("scentry");
            this.getView().setVisible(Boolean.valueOf(scEntity != null && !scEntity.isEmpty()), new String[]{"advconap1"});
            DynamicObjectCollection sdEntity = dataEntity.getDynamicObjectCollection("sdentry");
            this.getView().setVisible(Boolean.valueOf(sdEntity != null && !sdEntity.isEmpty()), new String[]{"advconap2"});
            this.getModel().setValue("treatmethodgroup", (Object)"1");
        }
        this.loadOtHis();
        OTApplyBillCommon.handlePolicy(this.getView(), this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "submit": 
            case "submiteffect": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                dataEntity.set("submitter", (Object)RequestContext.get().getCurrUserId());
                dataEntity.set("submitdate", (Object)new Date());
                BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)operate.getOption());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if ("change".equals(operateKey)) {
                DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
                long id = dataEntity.getLong("id");
                OTApplyBillCommon.openNewChange(id, this.getView(), null);
            }
            if ("discard".equals(operateKey) || "save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey) || "unsubmit".equals(operateKey)) {
                this.loadOtHis();
            }
        }
    }

    private void loadOtHis() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Map map = (Map)formShowParameter.getCustomParam("ot_change_data");
        long parrntId = OperationStatus.ADDNEW == status && map != null ? ((Long)map.get("parent")).longValue() : this.getView().getModel().getDataEntity().getLong("parent");
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        ArrayList<Long> list = new ArrayList<Long>();
        list.add((Long)this.getModel().getDataEntity().getPkValue());
        this.getIdList(list, parrntId);
        QFilter filter = new QFilter("id", "in", list);
        fParameter.setFilter(filter);
        lsp.setListFilterParameter(fParameter);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setBillFormId(formShowParameter.getFormId());
        lsp.setCustomParam("billno", (Object)this.getModel().getDataEntity().getString("billno"));
        lsp.setCustomParam("wtcbill_hasright", formShowParameter.getCustomParam("wtcbill_hasright"));
        lsp.setHasRight(true);
        lsp.setFormId("wtbs_rimlesslist");
        lsp.getOpenStyle().setTargetKey("otflex");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, null));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void getIdList(List<Long> list, Long parentId) {
        if (parentId == null || parentId == 0L) {
            return;
        }
        DynamicObject parentDynamicObject = this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        list.add(parentId);
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getIdList(list, id);
        }
    }

    private void setReturnValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("ot_change_data");
        if (map != null) {
            JSONArray scEntry;
            int index;
            JSONArray types;
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue("personid", map.get("personid.id"));
            model.setValue("attfile", map.get("attfile"));
            model.setValue("attfilebasef7", map.get("attfilebasef7"));
            model.setValue("parent", map.get("parent"));
            model.setValue("org", map.get("org"));
            model.setValue("iscancel", (Object)"1");
            String applyType = HRStringUtils.equals((String)"wtom_otbillchange", (String)formShowParameter.getFormId()) ? "1" : "0";
            model.setValue("applytyperadio", (Object)applyType);
            model.setValue("otapplytype", map.get("otapplytype"));
            OTApplyBillCommonService instance = OTApplyBillCommonService.getInstance();
            String str = instance.noEffStr();
            model.setValue("vatimetext", (Object)str);
            model.setValue("vatime", (Object)0);
            model.setValue("startdate", map.get("startdate"));
            model.setValue("enddate", map.get("enddate"));
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            HashSet<String> propertiesSet = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                propertiesSet.add(property.getName());
            }
            if (propertiesSet.contains("billstyle")) {
                LOG.info("OtApplyBillChangeEdit_setReturnValue propertiesSet contains singleStyle,val = {}", map.get("billstyle"));
                model.setValue("billstyle", map.get("billstyle"));
            }
            if ((types = (JSONArray)map.get("overworktypes")) != null && !types.isEmpty()) {
                Object[] typeArr = new Object[types.size()];
                for (index = 0; index < types.size(); ++index) {
                    JSONObject type = types.getJSONObject(index);
                    JSONObject baseData = type.getJSONObject("fbasedataid");
                    if (baseData == null) continue;
                    typeArr[index] = baseData.getLong("id");
                }
                model.setValue("overworktypes", (Object)typeArr);
            }
            if ((scEntry = (JSONArray)map.get("scentry")) != null && !scEntry.isEmpty()) {
                for (index = 0; index < scEntry.size(); ++index) {
                    JSONObject jsonObject = scEntry.getJSONObject(index);
                    model.createNewEntryRow("scentry");
                    model.setValue("scottype", (Object)jsonObject.getJSONObject("scottype").getLong("id"), index);
                    model.setValue("otdate", (Object)jsonObject.getDate("otdate"), index);
                    model.setValue("otdtime", (Object)0, index);
                    model.setValue("otdstarttime", (Object)jsonObject.getDate("otdstarttime"), index);
                    model.setValue("otdendtime", (Object)jsonObject.getDate("otdendtime"), index);
                    model.setValue("derson", (Object)jsonObject.getJSONObject("derson").getLong("id"), index);
                    model.setValue("dutydate", (Object)jsonObject.getDate("dutydate"), index);
                    JSONObject comType = jsonObject.getJSONObject("compentype");
                    model.setValue("compentype", (Object)(comType != null ? comType.getLong("id") : OtCompentEnum.EMPTY.getPkId()), index);
                    model.setValue("otreson", (Object)jsonObject.getString("otreson"), index);
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"scottype", "otdate", "otdtime", "otdstarttime", "otdendtime", "derson", "dutydate", "compentype", "otreson"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
            }
            JSONArray sdEntry = (JSONArray)map.get("sdentry");
            if (sdEntry != null && !sdEntry.isEmpty()) {
                for (int index2 = 0; index2 < sdEntry.size(); ++index2) {
                    JSONObject jsonObject = sdEntry.getJSONObject(index2);
                    model.createNewEntryRow("sdentry");
                    model.setValue("sdottype", (Object)jsonObject.getJSONObject("sdottype").getLong("id"), index2);
                    model.setValue("otstartdate", (Object)jsonObject.getDate("otstartdate"), index2);
                    model.setValue("otenddate", (Object)jsonObject.getDate("otenddate"), index2);
                    model.setValue("otdutydate", (Object)jsonObject.getDate("otdutydate"), index2);
                    JSONObject comTypeD = jsonObject.getJSONObject("compentyped");
                    model.setValue("compentyped", (Object)(comTypeD != null ? comTypeD.getLong("id") : OtCompentEnum.EMPTY.getPkId()), index2);
                    model.setValue("dperson", (Object)jsonObject.getJSONObject("dperson").getLong("id"), index2);
                    model.setValue("intottime", (Object)0, index2);
                    model.setValue("ottime", (Object)instance.noEffStr(), index2);
                    model.setValue("otresond", (Object)jsonObject.getString("otresond"), index2);
                    this.getView().setEnable(Boolean.FALSE, index2, new String[]{"sdottype", "otstartdate", "otenddate", "otdutydate", "compentyped", "dperson", "intottime", "ottime", "otresond"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"advconap2"});
            }
            model.endInit();
            this.getModel().updateCache();
            this.getView().updateView("scentry");
            this.getView().updateView("sdentry");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        ArrayList propList = Lists.newArrayList((Object[])new String[]{"startdate", "enddate", "submitter", "submitdate", "treatmethodgroup"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null) {
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (String prop : propList) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
                if (iDataEntityProperty == null) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
            IDataEntityProperty person = (IDataEntityProperty)properties.get((Object)"personid_id");
            if (person != null) {
                dataEntityState.setBizChanged(person.getOrdinal(), false);
            }
        }
    }

    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("ot_change_data");
        if (map != null) {
            DataMutex dataMutex = DataMutex.create();
            Long parentId = (Long)map.get("parent");
            dataMutex.release(parentId.toString(), "wtom_overtimeapplybill", "change");
        }
    }
}

