/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.web.WTCBaseBillCommon;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.OTKdStringHelper;
import kd.wtc.wtom.business.web.OTApplyBillCommonService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;

public class OtApplyBillEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(OtApplyBillEdit.class);
    private static final String BILL_STATUS_ADD_NEW = "ADDNEW";
    private static final Set<String> VERIFY_OP_LIST = Sets.newHashSet((Object[])new String[]{"save", "submit", "submiteffect"});

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        BillShowParameter billShowParameter = (BillShowParameter)evt.getFormShowParameter();
        OTApplyBillCommonService.getInstance().preOpenFormOfSetCaption(billShowParameter);
    }

    public void afterLoadData(EventObject event) {
        this.handlePolicy();
    }

    public void afterBindData(EventObject e) {
        BillShowParameter showParameter;
        BillOperationStatus billStatus;
        Object attFileBoId;
        super.afterBindData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (billShowParameter.getBillStatus().equals((Object)BillOperationStatus.ADDNEW) && (attFileBoId = this.getModel().getValue("attfile")) != null) {
            this.handleChangeAttFile();
            this.getModel().setDataChanged(false);
        }
        if (HRStringUtils.equals((String)BILL_STATUS_ADD_NEW, (String)(billStatus = (showParameter = (BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()).name()) || billStatus.getValue() == 0) {
            Map entryInfo = OTApplyBillAssemblyResultService.getEntryInfo((DynamicObject)this.getModel().getDataEntity(true));
            String entry = (String)entryInfo.get("ENTRY_NAME");
            String compend = (String)entryInfo.get("COMPENSATE_NAME");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{compend});
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        if (args.getChangeSet() == null && args.getChangeSet().length <= 0) {
            return;
        }
        switch (name = args.getProperty().getName()) {
            case "attfile": {
                this.handleChangeAttFile();
                this.handlePolicy();
                break;
            }
            case "otapplytype": {
                this.handlePolicy();
                this.deleteEntry(args);
                this.setEntryMustInput();
                break;
            }
            case "scottype": 
            case "sdottype": {
                this.handlePolicy();
            }
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit scOtType = (BasedataEdit)this.getView().getControl("scottype");
        BasedataEdit sdOtType = (BasedataEdit)this.getView().getControl("sdottype");
        scOtType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        sdOtType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit compentype = (BasedataEdit)this.getView().getControl("compentype");
        BasedataEdit compentyped = (BasedataEdit)this.getView().getControl("compentyped");
        compentype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        compentyped.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void deleteEntry(PropertyChangedArgs args) {
        Object newValue = args.getChangeSet()[0].getNewValue();
        this.handleEntryChange((String)newValue);
    }

    private void handleEntryChange(String otApplyType) {
        this.getModel().deleteEntryData(OtApplyTypeEnum.OT_SC.getCode());
        this.getModel().deleteEntryData(OtApplyTypeEnum.OT_SD.getCode());
        if (OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)) {
            this.getModel().createNewEntryRow(OtApplyTypeEnum.OT_SD.getCode());
            this.getModel().setValue("avoidsddelete", (Object)"avoidsddelete", 0);
        } else {
            this.getModel().createNewEntryRow(OtApplyTypeEnum.OT_SC.getCode());
            this.getModel().setValue("avoidscdelete", (Object)"avoidscdelete", 0);
        }
    }

    private void handlePolicy() {
        OTApplyBillCommon.handlePolicy(this.getView(), this.getModel());
    }

    private void handleChangeAttFile() {
        this.handleEntryChange((String)this.getModel().getValue("otapplytype"));
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
        unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
        unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
        unifyBillApplyAttr.setAttFileF7AuthEntity(this.getView().getEntityId());
        OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{this.getModel().getDataEntity(true)}, unifyBillApplyAttr);
        BillCheckResult billCheckResult = otBillHelper.checkHaveAttFileHavePlan(this.getModel().getDataEntity(true));
        boolean verifyResult = billCheckResult.isVerifyResult();
        if (!verifyResult) {
            this.getView().showTipNotification((String)billCheckResult.getMsg().get(0));
        }
        if ("wtom_overtimeapplybill".equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.valueOf(verifyResult), new String[]{"flexpanelap11", "personsum"});
            this.getView().setVisible(Boolean.valueOf(!verifyResult), new String[]{"flexpanelap12"});
        }
    }

    private void setEntryMustInput() {
        boolean scFieldMustInput = OtApplyTypeEnum.OT_SC.getNum().equals(this.getModel().getValue("otapplytype"));
        ((FieldEdit)this.getView().getControl("scottype")).setMustInput(scFieldMustInput);
        ((FieldEdit)this.getView().getControl("otdate")).setMustInput(scFieldMustInput);
        ((FieldEdit)this.getView().getControl("otdtime")).setMustInput(scFieldMustInput);
        ((FieldEdit)this.getView().getControl("sdottype")).setMustInput(!scFieldMustInput);
        ((FieldEdit)this.getView().getControl("otstartdate")).setMustInput(!scFieldMustInput);
        ((FieldEdit)this.getView().getControl("otenddate")).setMustInput(!scFieldMustInput);
        ((FieldEdit)this.getView().getControl("otdutydate")).setMustInput(!scFieldMustInput);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long orgId;
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
        unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
        unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
        unifyBillApplyAttr.setAttFileF7AuthEntity(this.getView().getEntityId());
        DynamicObject attFileIdDy = (DynamicObject)this.getModel().getValue("attfile");
        long attFileId = attFileIdDy == null ? 0L : attFileIdDy.getLong("id");
        DynamicObject orgDy = (DynamicObject)this.getView().getModel().getValue("org");
        long l = orgId = orgDy == null ? 0L : orgDy.getLong("id");
        if (HRStringUtils.equals((String)key, (String)"scottype") || HRStringUtils.equals((String)key, (String)"sdottype")) {
            int row = beforeF7SelectEvent.getRow();
            LocalDate selectDate = OTApplyBillCommonService.getInstance().selectedEntryTime(this.getModel().getDataEntity(true), row);
            if (selectDate != null) {
                List otMatchRule = OTApplyBillCommonService.getInstance().getOtMatchRule(this.getModel().getDataEntity(true), row, (Set)Sets.newHashSet((Object[])new LocalDate[]{selectDate}), attFileId);
                QFilter qFilter = OTApplyBillCommonService.getInstance().selectOtTypeByDate(otMatchRule, orgId);
                logger.info("OtApplyBillEdit.beforeF7Select selectDates = {},qFilter = {}", (Object)selectDate, (Object)qFilter);
                beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qFilter));
                return;
            }
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{this.getModel().getDataEntity(true)}, unifyBillApplyAttr);
            Set allOTType = otBillHelper.getAllOTType(this.getModel().getDataEntity(true));
            logger.info("OtApplyBillEdit.beforeF7Select allOTType = {}", (Object)JSON.toJSONString((Object)allOTType));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(new QFilter("id", "in", (Object)allOTType)));
        } else if (HRStringUtils.equals((String)key, (String)"compentype") || HRStringUtils.equals((String)key, (String)"compentyped")) {
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{this.getModel().getDataEntity(true)}, unifyBillApplyAttr);
            int row = beforeF7SelectEvent.getRow();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            ArrayList dateRangeDtos = new ArrayList(1);
            otBillHelper.getOtApplyBillAssemblyResultService().collectMatchData(dataEntity, Integer.valueOf(row), 2, dateRangeDtos);
            List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
            Boolean compensateIsEmpChose = otBillHelper.getCompensateIsEmpChoseNew(dataEntity, Integer.valueOf(row), ruleConditionRetrievals);
            logger.info("OtApplyBillEdit.beforeF7Select compensateIsEmpChose = {}", (Object)compensateIsEmpChose);
            QFilter compenQFilter = null;
            if (compensateIsEmpChose == null || !compensateIsEmpChose.booleanValue()) {
                compenQFilter = new QFilter("id", "=", (Object)0L);
            } else {
                List compenList = otBillHelper.getCompensateTypeDefIdNew(dataEntity, Integer.valueOf(row), ruleConditionRetrievals);
                compenQFilter = new QFilter("id", "in", (Object)compenList);
            }
            beforeF7SelectEvent.addCustomQFilter(compenQFilter);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs args) {
        int[] rowIndexs = args.getRowIndexs();
        String entryName = args.getEntryProp().getName();
        if (!HRStringUtils.equals((String)OtApplyTypeEnum.OT_SC.getCode(), (String)entryName) && !HRStringUtils.equals((String)OtApplyTypeEnum.OT_SD.getCode(), (String)entryName)) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity(entryName);
        String applyType = (String)this.getModel().getValue("otapplytype");
        String choseType = "";
        choseType = applyType.equals(OtApplyTypeEnum.OT_SC.getNum()) ? OtApplyTypeEnum.OT_SC.getNum() : choseType;
        String string = choseType = applyType.equals(OtApplyTypeEnum.OT_SD.getNum()) ? OtApplyTypeEnum.OT_SD.getNum() : choseType;
        if (HRStringUtils.equals((String)choseType, (String)applyType) && entry.size() == rowIndexs.length) {
            this.getView().showTipNotification(OTKdStringHelper.keepAtLeastOne());
            args.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs event) {
        event.getEntryProp().getDefaultRows();
        if (event.getRowDataEntities() == null || event.getRowDataEntities().length <= 0) {
            return;
        }
        if (OtApplyTypeEnum.OT_SC.getCode().equals(event.getEntryProp().getName())) {
            this.getView().setEnable(Boolean.FALSE, event.getRowDataEntities()[0].getRowIndex(), new String[]{"compentype"});
        } else if (OtApplyTypeEnum.OT_SD.getCode().equals(event.getEntryProp().getName())) {
            this.getView().setEnable(Boolean.FALSE, event.getRowDataEntities()[0].getRowIndex(), new String[]{"compentyped"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs event) {
        this.handlePolicy();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!WTCBaseBillCommon.verifyAttFileExist((BeforeDoOperationEventArgs)args, (IFormView)this.getView())) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (VERIFY_OP_LIST.contains(operateKey) && !BillStyleService.getInstance().isOpenSingleStyle(this.getModel().getDataEntity(true))) {
            DynamicObjectCollection entryColl;
            String otApplyType = (String)this.getModel().getValue("otapplytype");
            if (OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)) {
                DynamicObjectCollection entryColl2 = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SD.getCode());
                if (!CollectionUtils.isEmpty((Collection)entryColl2) && entryColl2.size() == 1 && ((DynamicObject)entryColl2.get(0)).get("sdottype") == null && ((DynamicObject)entryColl2.get(0)).get("otstartdate") == null && ((DynamicObject)entryColl2.get(0)).get("otenddate") == null) {
                    String tip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6309\u65f6\u6bb5\u7533\u8bf7\u4fe1\u606f\u3002", (String)"OtApplyBillEdit_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tip);
                    args.setCancel(true);
                }
            } else if (OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType) && !CollectionUtils.isEmpty((Collection)(entryColl = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SC.getCode()))) && entryColl.size() == 1 && ((DynamicObject)entryColl.get(0)).get("scottype") == null && ((DynamicObject)entryColl.get(0)).get("otdate") == null && (((DynamicObject)entryColl.get(0)).get("otdtime") == null || ((DynamicObject)entryColl.get(0)).getInt("otdtime") == -1)) {
                String tip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6309\u65f6\u957f\u7533\u8bf7\u4fe1\u606f\u3002", (String)"OtApplyBillEdit_1", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        }
        BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)source.getOption());
    }

    public void beforeClosed(BeforeClosedEvent event) {
        HashSet unNotify = Sets.newHashSet((Object[])new String[]{"avoidscdelete", "avoidsddelete", "scmobileentryfield", "billentryname_long", "sdmobileentryfield", "billentryname_seg", "derson", "dutydate", "dperson", "intottime", "ottime", "otdstarttime", "otdendtime", "otdutydate", "overworktypes", "startdate", "enddate", "vatime", "overworktypes", "vatimetext"});
        DynamicObject billDy = this.getModel().getDataEntity(true);
        DataEntityState mainDataEntityState = billDy.getDataEntityState();
        DataEntityPropertyCollection mainProperties = billDy.getDataEntityType().getProperties();
        for (int i = 0; i < mainProperties.size(); ++i) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)mainProperties.get(i);
            String name = iDataEntityProperty.getName();
            if (!unNotify.contains(name)) continue;
            mainDataEntityState.setBizChanged(i, false);
        }
        DynamicObjectCollection sdEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
        for (DynamicObject sdEntry : sdEntries) {
            DataEntityState dataEntityState = sdEntry.getDataEntityState();
            DataEntityPropertyCollection properties = sdEntry.getDataEntityType().getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
                String name = iDataEntityProperty.getName();
                if (!unNotify.contains(name)) continue;
                dataEntityState.setBizChanged(i, false);
            }
        }
        super.beforeClosed(event);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "change".equals(operateKey)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            long id = dataEntity.getLong("id");
            OTApplyBillCommon.openNewChange(id, this.getView(), null);
        }
    }
}

