/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class OtApplyBillImportEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OtApplyBillImportEdit.class);
    private Map<String, DynamicObject> numberAndTop1 = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberAndPersonDy = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> numberAndAttFileBoDy = new HashMap<String, DynamicObject>(16);

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs eventArgs) {
        super.queryImportBasedata(eventArgs);
        Map searchResult = eventArgs.getSearchResult();
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyBillImportEdit_queryImportBasedata searchResult.size = {}", (Object)searchResult.size());
        }
        for (Map.Entry entry : searchResult.entrySet()) {
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            if (basedataItem == null || !"attfilebasef7".equals(basedataItem.getFieldKey())) continue;
            String attFileNum = basedataItem.getSearchValue();
            DynamicObject attFileVersion = this.numberAndTop1.get(attFileNum);
            if (attFileVersion != null) {
                entry.setValue(Lists.newArrayList((Object[])new Object[]{attFileVersion.getLong("id")}));
                continue;
            }
            logger.info("OtApplyBillImportEdit_queryImportBasedata cant not find attfileVersion, attFileNum = {},numberAndTop1.size = {}", (Object)attFileNum, (Object)this.numberAndTop1.size());
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        if (CollectionUtils.isEmpty((Collection)sourceDataList)) {
            return;
        }
        BillCommonService commonService = new BillCommonService();
        commonService.initBillImportData(this.getView(), sourceDataList, this.numberAndTop1, this.numberAndPersonDy, this.numberAndAttFileBoDy);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        BillModel billModel = (BillModel)e.getSource();
        DynamicObject dataEntity = billModel.getDataEntity(true);
        DynamicObject attFileF7Dy = dataEntity.getDynamicObject("attfilebasef7");
        if (attFileF7Dy != null) {
            String number = attFileF7Dy.getString("number");
            if (HRStringUtils.isEmpty((String)number)) {
                return;
            }
            DynamicObject attFile = this.numberAndAttFileBoDy.get(number);
            String attFileError = BillCommonService.getInstance().judgeAttFile(attFile, BillTypeEnum.OVERTIMEBILL.getBillName());
            if (HRStringUtils.isNotEmpty((String)attFileError)) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), attFileError);
                e.setCancel(true);
                return;
            }
            dataEntity.set("attfile", (Object)attFile);
            dataEntity.set("personid", (Object)this.numberAndPersonDy.get(number));
            dataEntity.set("attfilebasef7", (Object)this.numberAndTop1.get(number));
        }
    }
}

