/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;
import kd.wtc.wtom.business.OTKdStringHelper;
import kd.wtc.wtom.business.OtBillOriginalUpgradeHelper;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;
import kd.wtc.wtom.fromplugin.web.otapplybill.OtApplyListProvider;

public class OtApplyBillList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(OtApplyBillList.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtom_overtimeapplybill");
    private final List<Date> dateList = new ArrayList<Date>(2);
    private String exportSelectFields;
    private final Set<CompareTypeEnum> compareTypeEnums = Sets.newHashSet((Object[])new CompareTypeEnum[]{CompareTypeEnum.TODAY, CompareTypeEnum.YESTERDAY, CompareTypeEnum.THISWEEK, CompareTypeEnum.LASTWEEK, CompareTypeEnum.THISMONTH, CompareTypeEnum.LASTMONTH, CompareTypeEnum.LASTONEMONTH, CompareTypeEnum.LASTTHREEMONTH, CompareTypeEnum.THISQUARTER, CompareTypeEnum.LASTQUARTER, CompareTypeEnum.THISYEAR, CompareTypeEnum.LASTYEAR, CompareTypeEnum.TOMORROW, CompareTypeEnum.NEXTWEEK, CompareTypeEnum.NEXTMONTH, CompareTypeEnum.FUTUREONEMONTH, CompareTypeEnum.FUTURETHREEMONTH, CompareTypeEnum.NEXTYEAR, CompareTypeEnum.NEXTQUARTER, CompareTypeEnum.BETWEEN});

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new OtApplyListProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        option.setVariableValue("LIST_OP", "LIST_OP_TRUE");
        BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)operate.getOption());
    }

    private void updateList() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            billlistap.clearSelection();
            billlistap.refresh();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean success = false;
        if (operationResult != null) {
            success = operationResult.isSuccess();
        }
        if (success && "change".equals(operateKey)) {
            this.showChangeView(afterDoOperationEventArgs);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"ot_change_close_callback", (String)actionId)) {
            this.updateList();
        }
    }

    private void showChangeView(AfterDoOperationEventArgs args) {
        HashSet ps = new HashSet();
        Donothing operator = (Donothing)args.getSource();
        ListSelectedRowCollection listSelectedDatas = operator.getListSelectedData();
        listSelectedDatas.forEach(row -> {
            long id = (Long)row.getPrimaryKeyValue();
            ps.add(row);
        });
        ListSelectedRow row2 = (ListSelectedRow)ps.iterator().next();
        long id = (Long)row2.getPrimaryKeyValue();
        OTApplyBillCommon.openNewChange(id, this.getView(), (AbstractFormPlugin)this);
    }

    public void setFilter(SetFilterEvent env) {
        super.setFilter(env);
        env.addCustomQFilter(new QFilter("isnewbill", "=", (Object)Boolean.TRUE));
        env.setOrderBy("createtime desc,modifytime desc");
        this.setBtDateQFilter(env);
    }

    private void setBtDateQFilter(SetFilterEvent event) {
        ArrayList qFilters = new ArrayList(event.getQFilters());
        this.setBtbillFilter(event);
        qFilters.addAll(event.getQFilters().stream().map(qFilter -> qFilter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList()));
        if (this.dateList.isEmpty()) {
            for (QFilter qFilter2 : qFilters) {
                if (!StringUtils.equals((CharSequence)"entryotdate", (CharSequence)qFilter2.getProperty())) continue;
                Object value = qFilter2.getValue();
                if (value instanceof Date) {
                    this.dateList.add((Date)qFilter2.getValue());
                } else if (value instanceof QEmptyValue) {
                    this.dateList.add(WTCDateUtils.getMaxEndDate());
                    this.dateList.add(WTCDateUtils.getMaxEndDate());
                }
                qFilter2.__setProperty("1");
                qFilter2.__setCP("=");
                qFilter2.__setValue((Object)1);
            }
        }
    }

    private QFilter otFilter(QFilter filter) {
        Object value = filter.getValue();
        if (value instanceof QEmptyValue) {
            return new QFilter("1", "!=", (Object)1);
        }
        QFilter qFilter1 = filter.copy();
        if (qFilter1.getNests(false).size() > 0) {
            QFilter qFilter2 = ((QFilter.QFilterNest)qFilter1.getNests(false).get(0)).getFilter().copy();
            qFilter1.clearNests();
            qFilter1.__setProperty("enddate");
            qFilter2.__setProperty("enddate");
            QFilter qFilter3 = qFilter1.copy();
            QFilter qFilter4 = qFilter2.copy();
            qFilter3.__setProperty("startdate");
            qFilter4.__setProperty("startdate");
            QFilter qFilter5 = qFilter1.copy();
            QFilter qFilter6 = qFilter2.copy();
            qFilter6.__setValue(qFilter5.getValue());
            qFilter6.__setProperty("startdate");
            qFilter5.and(qFilter6);
            qFilter1.and(qFilter2);
            qFilter3.and(qFilter4);
            qFilter1.or(qFilter3).or(qFilter5);
            return qFilter1;
        }
        return null;
    }

    private void setBtbillFilter(SetFilterEvent event) {
        if (this.dateList.size() != 2) {
            this.dateList.clear();
        }
        if (!CollectionUtils.isEmpty(this.dateList)) {
            Date startDate = this.dateList.get(0);
            Date endDate = this.dateList.get(1);
            QFilter qFilter = new QFilter("enddate", ">=", (Object)startDate);
            qFilter.and(new QFilter("startdate", "<", (Object)endDate));
            event.getQFilters().add(qFilter);
        } else {
            for (QFilter filter : event.getQFilters()) {
                QFilter timeFilter;
                if (filter.getProperty().equals("entryotdate") && (timeFilter = this.otFilter(filter)) != null) {
                    event.getQFilters().add(timeFilter);
                    return;
                }
                List nests = filter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter qFilter1;
                    if (!nest.getFilter().getProperty().equals("entryotdate") || (qFilter1 = nest.getFilter().copy()).getNests(false).size() <= 0) continue;
                    QFilter qFilter2 = ((QFilter.QFilterNest)qFilter1.getNests(false).get(0)).getFilter().copy();
                    qFilter1.clearNests();
                    qFilter1.__setProperty("enddate");
                    qFilter2.__setProperty("startdate");
                    event.getQFilters().add(qFilter1.and(qFilter2));
                    return;
                }
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter;
        super.filterContainerSearchClick(args);
        Map filterValues = args.getFilterValues();
        List schemeFilters = (List)filterValues.get("schemefilter");
        if (CollectionUtils.isNotEmpty((Collection)schemeFilters)) {
            for (Map schemeFilter : schemeFilters) {
                String compare;
                CompareTypeEnum compareTypeEnum;
                List fieldName = (List)schemeFilter.get("FieldName");
                List compares = (List)schemeFilter.get("Compare");
                if (CollectionUtils.isEmpty((Collection)fieldName) || CollectionUtils.isEmpty((Collection)compares)) {
                    LOG.warn("\u83b7\u53d6\u7684\u65b9\u6848\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38, schemeFilters:{}", (Object)JSON.toJSONString((Object)schemeFilters));
                    continue;
                }
                if (!fieldName.contains("entryotdate") || this.compareTypeEnums.contains(compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)(compare = (String)compares.get(0))))) continue;
                String tip = ResManager.loadKDString((String)"{0}\u65e5\u671f\u5b57\u6bb5\u4ec5\u652f\u6301\u4eca\u5929\u3001\u6628\u5929\u3001\u672c\u5468\u3001\u4e0a\u5468\u3001\u672c\u6708\u3001\u4e0a\u6708\u3001\u8fc7\u53bb\u4e00\u4e2a\u6708\u3001\u8fc7\u53bb\u4e09\u4e2a\u6708\u3001\u672c\u5b63\u5ea6\u3001\u4e0a\u5b63\u5ea6\u3001\u4eca\u5e74\u3001\u53bb\u5e74\u3001\u660e\u5929\u3001\u4e0b\u5468\u3001\u4e0b\u4e2a\u6708\u3001\u672a\u6765\u4e00\u4e2a\u6708\u3001\u672a\u6765\u4e09\u4e2a\u6708\u3001\u4e0b\u5b63\u5ea6\u3001\u660e\u5e74\u3001\u4ece...\u5230...\u7684\u6761\u4ef6\u67e5\u8be2\u3002", (String)"OtApplyBillList_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
                String format = MessageFormat.format(tip, BillTypeEnum.OVERTIMEBILL.getBillName());
                throw new KDBizException(format);
            }
        }
        if (MapUtils.isEmpty((Map)(currentCommonFilter = args.getCurrentCommonFilter()))) {
            LOG.info("\u65e0commonFilter");
            return;
        }
        if (!MapUtils.isEmpty((Map)currentCommonFilter)) {
            for (List fieldName : (List)currentCommonFilter.get("FieldName")) {
                if (!"entryotdate".equals(fieldName)) continue;
                this.handleBTDateFilter(args, currentCommonFilter);
            }
        }
    }

    private void handleBTDateFilter(FilterContainerSearchClickArgs args, Map<String, List<Object>> currentCommonFilter) {
        Tuple result;
        BillSystemParamRange range;
        List<Object> values;
        Date startDate = null;
        Date endDate = null;
        List qFilters = args.getFilterModel().getFilterObject().getFilterResult().getQFilters();
        for (QFilter qFilter : qFilters) {
            if (!StringUtils.equals((CharSequence)"entryotdate", (CharSequence)qFilter.getProperty())) continue;
            startDate = (Date)qFilter.getValue();
            for (QFilter.QFilterNest nest : qFilter.getNests(true)) {
                endDate = (Date)nest.getFilter().getValue();
            }
        }
        if ((values = currentCommonFilter.get("Value")) != null && values.size() > 1 && Objects.nonNull(range = SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.OT)) && !((Boolean)(result = WTCBillViewUtils.dateCheckSuccess((BillSystemParamRange)range, (Date)startDate, endDate)).getKey()).booleanValue()) {
            this.getView().showTipNotification((String)result.getValue());
            values.clear();
            values.add("63");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = clickEvent.getFieldName();
        BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object primaryKeyValue = billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        if (fieldName.equals("barcode")) {
            String formId;
            DynamicObject dynamicObject = this.serviceHelper.queryOne(primaryKeyValue);
            args.setCancel(true);
            Long parentId = dynamicObject.getLong("parent");
            ArrayList<Long> list = new ArrayList<Long>();
            list.add((Long)dynamicObject.getPkValue());
            this.getIdList(list, parentId);
            ListShowParameter lsp = new ListShowParameter();
            ListFilterParameter fParameter = new ListFilterParameter();
            QFilter filter = new QFilter("id", "in", list);
            fParameter.setFilter(filter);
            lsp.setListFilterParameter(fParameter);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            if ("0".equals(dynamicObject.getString("applytyperadio"))) {
                formId = "wtom_otselfbillchange";
            } else {
                formId = "wtom_otbillchange";
                ListView listView = (ListView)this.getView();
                if (HRStringUtils.equals((String)"wtom_otbillself", (String)listView.getBillFormId())) {
                    lsp.setCustomParam("wtcbill_hasright", (Object)"1");
                }
            }
            lsp.setBillFormId(formId);
            OpenStyle openStyle = lsp.getOpenStyle();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1050px");
            styleCss.setHeight("400px");
            openStyle.setInlineStyleCss(styleCss);
            lsp.setHasRight(true);
            lsp.setCaption(OTKdStringHelper.otHis());
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
    }

    private void getIdList(List<Long> list, Long parentId) {
        DynamicObject parentDynamicObject = this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        list.add(parentId);
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getIdList(list, id);
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent ee) {
        super.beforeQueryOfExport(ee);
        String selectFields = ee.getSelectFields();
        String fields = String.join((CharSequence)",", selectFields, "originalid", "ischange", "parent");
        ee.setSelectFields(fields);
        this.exportSelectFields = ee.getSelectFields();
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent ee) {
        super.afterQueryOfExport(ee);
        DynamicObject[] dataArr = ee.getQueryValues();
        if (dataArr != null && dataArr.length > 0) {
            this.checkTripBillUpgrade(dataArr);
            LinkedHashMap<Long, Long> leafBillIdMap = new LinkedHashMap<Long, Long>(dataArr.length);
            Arrays.stream(dataArr).forEach(dy -> leafBillIdMap.put(dy.getLong("id"), dy.getLong("originalid")));
            DynamicObject[] resultDys = this.serviceHelper.query(this.exportSelectFields, new QFilter("originalid", "in", leafBillIdMap.values()).toArray(), "id desc");
            ArrayList result = new ArrayList(resultDys.length);
            Map<Long, List<DynamicObject>> dyMapByOriginalId = Arrays.stream(resultDys).collect(Collectors.groupingBy(dy -> dy.getLong("originalid")));
            leafBillIdMap.forEach((leafId, originalId) -> {
                List dys = (List)dyMapByOriginalId.get(originalId);
                if (WTCCollections.isNotEmpty((Collection)dys)) {
                    if (dys.size() > 1) {
                        dys = BillCommonService.getInstance().leafFilter(leafId, dys, WTCBillChangeEnum.OTAPPLY);
                    }
                    int changeNum = dys.size() - 1;
                    for (DynamicObject dy : dys) {
                        if (!dy.containsProperty("changenum")) continue;
                        String changeNumStr = changeNum > 0 ? ResManager.loadKDString((String)"\u7b2c{0}\u6b21\u53d8\u66f4", (String)"OtApplyBillList_2", (String)"wtc-wtom-formplugin", (Object[])new Object[]{changeNum--}) : ResManager.loadKDString((String)"\u539f\u5355", (String)"OtApplyBillList_3", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
                        dy.set("changenum", (Object)changeNumStr);
                    }
                    result.addAll(dys);
                }
            });
            ee.setCustomOrder(true);
            ee.setQueryValues(result.toArray(new DynamicObject[result.size()]));
        }
    }

    private void checkTripBillUpgrade(DynamicObject[] dataArr) {
        List notHaveOriginalBills = Arrays.stream(dataArr).filter(dy -> dy.getLong("originalid") == 0L).collect(Collectors.toList());
        if (notHaveOriginalBills.size() > 0) {
            OtBillOriginalUpgradeHelper.getInstance().upgradeOriginalId(notHaveOriginalBills, this.exportSelectFields);
        }
    }
}

