/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtom.business.OTBillStyleService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OtApplyBillSelfEdit
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(OtApplyBillSelfEdit.class);
    private static final Set<String> VERIFY_OP_LIST = Sets.newHashSet((Object[])new String[]{"save", "submit", "submiteffect"});

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        if (BillApplyTypeEnum.SELF.getCode().equals(this.getModel().getValue("applytyperadio")) && BillStyleService.getInstance().sysSingleStyle(BillTypeEnum.OVERTIMEBILL)) {
            this.getModel().setValue("billstyle", (Object)BillOpenStyleEnum.SINGLE.getCode());
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        OTBillStyleService.getInstance().handleSingleStyle(this.getView(), "wtom_singleflex");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (VERIFY_OP_LIST.contains(operateKey)) {
            boolean checkMustInput = this.checkMustInputForSingle();
            if (!checkMustInput) {
                args.setCancel(true);
                return;
            }
            BillStyleService singleTypeService = BillStyleService.getInstance();
            boolean openSingleStyle = singleTypeService.isOpenSingleStyle(this.getModel().getDataEntity(true));
            String singlePageId = this.getView().getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
            IFormView singleView = this.getView().getView(singlePageId);
            if (openSingleStyle && singleView == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7c7b\u578b\u9875\u9762\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"OtApplyBillSelfEdit_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
            }
            if (openSingleStyle) {
                Map param = singleTypeService.convertValToMap(singleView.getModel().getDataEntity(true));
                DynamicObjectCollection otEntryColl = OTBillStyleService.getInstance().getOTEntryColl(this.getView());
                if (otEntryColl == null || otEntryColl.size() != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u73ed\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OtApplyBillSelfEdit_1", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
                }
                DynamicObject entryDy = (DynamicObject)otEntryColl.get(0);
                HashSet<String> keys = new HashSet<String>(16);
                for (IDataEntityProperty property : entryDy.getDataEntityType().getProperties()) {
                    keys.add(property.getName());
                }
                for (Map.Entry nameAndVal : param.entrySet()) {
                    String key = (String)nameAndVal.getKey();
                    Object value = nameAndVal.getValue();
                    if (!keys.contains(key)) continue;
                    this.getModel().setValue(key, value, 0);
                }
            }
        }
        BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)source.getOption());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OTBillStyleService.getInstance().changeSingleFlexStatus(this.getView(), afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        Object newValue = args.getChangeSet()[0].getNewValue();
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(this.getModel().getDataEntity(true));
        String singlePageId = this.getView().getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
        IFormView singleView = this.getView().getView(singlePageId);
        if ("otapplytype".equals(name) && openSingleStyle && singleView != null) {
            singleView.getModel().setValue("otapplytype", newValue);
            this.getView().sendFormAction(singleView);
        }
        if ("attfile".equals(name) && openSingleStyle && singleView != null) {
            IDataModel model = this.getView().getModel();
            singleView.getModel().setValue("org", model.getValue("org"));
            singleView.getModel().setValue("attfile", model.getValue("attfile"));
            singleView.getModel().setValue("attfilebasef7", model.getValue("attfilebasef7"));
            this.getView().sendFormAction(singleView);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        String forceClose = this.getPageCache().get("FORCE_CLOSE");
        if (HRStringUtils.isNotEmpty((String)forceClose)) {
            return;
        }
        OTBillStyleService.getInstance().singleBeforeCloseEvent(this.getView(), event, (AbstractBillPlugIn)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"continue_close") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("FORCE_CLOSE", "FORCE_CLOSE");
            this.getView().getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private boolean checkMustInputForSingle() {
        HashSet sdFieldType = Sets.newHashSet((Object[])new String[]{"sdottype", "otstartdate", "otenddate"});
        HashSet scFieldType = Sets.newHashSet((Object[])new String[]{"scottype", "otdate", "otdtime"});
        String singlePageId = this.getView().getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
        IFormView singleView = this.getView().getView(singlePageId);
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(this.getModel().getDataEntity(true));
        ArrayList<String> unPassKey = new ArrayList<String>(10);
        if (openSingleStyle && singleView != null) {
            IDataModel model = this.getView().getModel();
            String applyType = (String)model.getValue("otapplytype");
            if (OtApplyTypeEnum.OT_SD.getNum().equals(applyType)) {
                for (String field : sdFieldType) {
                    boolean passResult = this.showError(singleView, field);
                    if (passResult) continue;
                    unPassKey.add(field);
                }
            } else if (OtApplyTypeEnum.OT_SC.getNum().equals(applyType)) {
                for (String field : scFieldType) {
                    boolean passResult = this.showError(singleView, field);
                    if (passResult) continue;
                    unPassKey.add(field);
                }
            }
        }
        if (WTCCollections.isNotEmpty(unPassKey)) {
            String singleEmpty = OTBillStyleService.getInstance().getSingleEmpty(unPassKey.toArray(new String[0]));
            this.getView().showTipNotification(singleEmpty);
            return false;
        }
        return true;
    }

    private boolean showError(IFormView showFormView, String fieldKey) {
        Object value = this.getView().getModel().getValue(fieldKey);
        String tip = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"OtApplyBillSelfEdit_2", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
        if (value == null || "otdtime".equals(fieldKey) && (Integer)value == -1) {
            showFormView.showFieldTip(WTCFormUtils.newFieldTip((String)fieldKey, (String)tip));
            this.getView().sendFormAction(showFormView);
            return false;
        }
        return true;
    }
}

