/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.enums.ot.OtCompentEnum;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.web.OTApplyBillCommonService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillCommon;
import kd.wtc.wtom.fromplugin.web.otapplybill.OTApplyBillScCommon;

public class OtApplyScBillEdit
extends HRDataBaseEdit {
    private Map<Integer, Boolean> compenStatus = new HashMap<Integer, Boolean>(16);

    public void afterLoadData(EventObject event) {
        this.compenStatus = OTApplyBillCommon.updateTemporary(this.getView(), this.getModel());
        OTApplyBillCommon.updateCompensateForNull(this.getModel());
        String status = (String)this.getModel().getValue("billstatus");
        if (HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)status, (String)"G")) {
            OTApplyBillScCommon common = new OTApplyBillScCommon();
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(this.getView().getEntityId());
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{this.getModel().getDataEntity(true)}, unifyBillApplyAttr);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
            for (int i = 0; i < entryEntity.size(); ++i) {
                common.handleScTimeBucket(otBillHelper, i, this.getView(), this.getModel());
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setCompenEnable();
    }

    private void setCompenEnable() {
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(this.getModel().getDataEntity(true));
        String singlePageId = this.getView().getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
        IFormView singleView = this.getView().getView(singlePageId);
        if (!CollectionUtils.isEmpty(this.compenStatus)) {
            for (Map.Entry<Integer, Boolean> entry : this.compenStatus.entrySet()) {
                this.getView().setEnable(entry.getValue(), entry.getKey().intValue(), new String[]{"compentype"});
                if (!openSingleStyle || singleView == null) continue;
                singleView.setEnable(entry.getValue(), new String[]{"compentype"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": 
            case "unsubmit": {
                this.updateCompensate(args, operateKey);
                break;
            }
            case "submit": 
            case "submiteffect": {
                this.updateCompensate(args, operateKey);
                this.getView().updateView(OtApplyTypeEnum.OT_SC.getCode());
                break;
            }
        }
    }

    private void updateCompensate(AfterDoOperationEventArgs args, String operateKey) {
        this.compenStatus = OTApplyBillCommon.judgeCompensateEdit(this.getView(), this.getModel());
        this.setCompenEnable();
        if (args.getOperationResult().isSuccess() && operateKey.equals("save")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (((DynamicObject)entryEntity.get(i)).getDynamicObject("compentype") != null) continue;
                this.getModel().setValue("compentype", (Object)OtCompentEnum.EMPTY.getPkId(), i);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        OTApplyBillScCommon common = new OTApplyBillScCommon();
        Integer changeIndex = common.getRowIndex(args);
        switch (name) {
            case "otdate": {
                this.getModel().beginInit();
                OTApplyBillCommonService.getInstance().setTypeAfterChoseDate(this.getView(), changeIndex);
                common.resetScEntryVal(changeIndex, this.getView(), this.getModel());
                common.changeScEntryTimePairAndOtType(changeIndex, this.getView(), this.getModel());
                this.getModel().endInit();
                this.getView().updateView(OtApplyTypeEnum.OT_SC.getCode());
                OTApplyBillCommon.handlePolicy(this.getView(), this.getModel());
                this.getView().updateView("richtexteditorap");
                break;
            }
            case "scottype": 
            case "otdtime": {
                if (changeIndex == -1) {
                    return;
                }
                common.resetScEntryVal(changeIndex, this.getView(), this.getModel());
                common.changeScEntryTimePairAndOtType(changeIndex, this.getView(), this.getModel());
                break;
            }
            case "dutydate": {
                break;
            }
            case "otdstarttime": 
            case "otdendtime": {
                break;
            }
        }
    }
}

