/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.OTBillStyleService;
import kd.wtc.wtom.business.web.OTApplyBillCommonService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.fromplugin.web.otapplybill.OtApplyBillSelfEdit;

public class OtApplySingleFlexEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(OtApplyBillSelfEdit.class);
    private static final String FLEX_SCFLEX = "scflex";
    private static final String FLEX_SDFLEX = "sdflex";
    private static final String BILL_STATUS_ADD_NEW = "ADDNEW";

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BillStyleService singleTypeService = BillStyleService.getInstance();
        singleTypeService.setModelVal(this.getView(), formShowParameter.getCustomParams(), Collections.emptySet(), -1);
    }

    public void afterBindData(EventObject eventObject) {
        BillShowParameter showParameter;
        BillOperationStatus billStatus;
        super.afterBindData(eventObject);
        String otApplyType = (String)this.getModel().getValue("otapplytype");
        this.getView().setVisible(Boolean.valueOf(OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)), new String[]{FLEX_SCFLEX});
        this.getView().setVisible(Boolean.valueOf(OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)), new String[]{FLEX_SDFLEX});
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (HRStringUtils.equals((String)BILL_STATUS_ADD_NEW, (String)(billStatus = (showParameter = (BillShowParameter)parentView.getFormShowParameter()).getBillStatus()).name()) || billStatus.getValue() == 0)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"compentype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"compentyped"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        Object newValue = args.getChangeSet()[0].getNewValue();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            if ("otapplytype".equals(name)) {
                this.getModel().beginInit();
                OTBillStyleService.getInstance().setParentViewValToSingleModel(parentView, this.getView());
                this.getModel().endInit();
                String otApplyType = (String)this.getModel().getValue("otapplytype");
                this.getView().setVisible(Boolean.valueOf(OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)), new String[]{FLEX_SCFLEX});
                this.getView().setVisible(Boolean.valueOf(OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)), new String[]{FLEX_SDFLEX});
                this.getView().updateView();
                return;
            }
            this.getModel().beginInit();
            DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
            Map entryInfo = OTApplyBillAssemblyResultService.getEntryInfo((DynamicObject)dataEntity);
            String entry = (String)entryInfo.get("ENTRY_NAME");
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(entry);
            if (dynamicObjectCollection == null || dynamicObjectCollection.size() != 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"OtApplySingleFlexEdit_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
            }
            DataEntityPropertyCollection properties = ((DynamicObject)dynamicObjectCollection.get(0)).getDataEntityType().getProperties();
            HashSet<String> keys = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                keys.add(property.getName());
            }
            if (keys.contains(name)) {
                parentView.getModel().setValue(name, newValue, 0);
            }
            this.getView().sendFormAction(parentView);
            OTBillStyleService.getInstance().setParentViewValToSingleModel(parentView, this.getView());
            this.getModel().endInit();
            for (String key : keys) {
                this.getView().updateView(key);
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit scOtType = (BasedataEdit)this.getView().getControl("scottype");
        BasedataEdit sdOtType = (BasedataEdit)this.getView().getControl("sdottype");
        scOtType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        sdOtType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit compentype = (BasedataEdit)this.getView().getControl("compentype");
        BasedataEdit compentyped = (BasedataEdit)this.getView().getControl("compentyped");
        compentype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        compentyped.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel model = parentView.getModel();
            String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(parentView));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(parentView.getEntityId());
            if (HRStringUtils.equals((String)key, (String)"scottype") || HRStringUtils.equals((String)key, (String)"sdottype")) {
                DynamicObject attFileIdDy = (DynamicObject)this.getModel().getValue("attfile");
                long attFileId = attFileIdDy == null ? 0L : attFileIdDy.getLong("id");
                DynamicObject orgDy = (DynamicObject)this.getView().getModel().getValue("org");
                long orgId = orgDy == null ? 0L : orgDy.getLong("id");
                int row = beforeF7SelectEvent.getRow();
                LocalDate selectDate = OTApplyBillCommonService.getInstance().selectedEntryTime(parentView.getModel().getDataEntity(true), row);
                if (selectDate != null) {
                    List otMatchRule = OTApplyBillCommonService.getInstance().getOtMatchRule(model.getDataEntity(true), 0, (Set)Sets.newHashSet((Object[])new LocalDate[]{selectDate}), attFileId);
                    QFilter qFilter = OTApplyBillCommonService.getInstance().selectOtTypeByDate(otMatchRule, orgId);
                    logger.info("OtApplyBillEdit.beforeF7Select selectDates = {},qFilter = {}", (Object)selectDate, (Object)qFilter);
                    beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qFilter));
                    return;
                }
                OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{model.getDataEntity(true)}, unifyBillApplyAttr);
                Set allOTType = otBillHelper.getAllOTType(model.getDataEntity(true));
                logger.info("OtApplyBillEdit.beforeF7Select allOTType = {}", (Object)JSON.toJSONString((Object)allOTType));
                beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(new QFilter("id", "in", (Object)allOTType)));
            } else if (HRStringUtils.equals((String)key, (String)"compentype") || HRStringUtils.equals((String)key, (String)"compentyped")) {
                OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{model.getDataEntity(true)}, unifyBillApplyAttr);
                int row = beforeF7SelectEvent.getRow();
                Boolean compensateIsEmpChose = otBillHelper.getCompensateIsEmpChose(model.getDataEntity(true), Integer.valueOf(row));
                logger.info("OtApplyBillEdit.beforeF7Select compensateIsEmpChose = {}", (Object)compensateIsEmpChose);
                QFilter compenQFilter = null;
                if (compensateIsEmpChose == null || !compensateIsEmpChose.booleanValue()) {
                    compenQFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    List compenList = otBillHelper.getCompensateTypeDefId(model.getDataEntity(true), Integer.valueOf(row));
                    compenQFilter = new QFilter("id", "in", (Object)compenList);
                }
                beforeF7SelectEvent.addCustomQFilter(compenQFilter);
            }
        }
    }
}

